/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.BaseFrm;
import jkcemu.base.EmuUtil;
import jkcemu.base.HelpFrm;
import jkcemu.base.ScreenFrm;
import jkcemu.print.PrintData;
import jkcemu.print.PrintDataScanner;
import jkcemu.print.PrintMngr;
import jkcemu.print.PrintOptionsDlg;
import jkcemu.print.PrintUtil;
import jkcemu.tools.hexedit.HexEditFrm;

public class PrintListFrm
extends BaseFrm
implements ListSelectionListener {
    private static final String HELP_PAGE = "/help/print.htm";
    private static PrintListFrm instance = null;
    private ScreenFrm screenFrm;
    private PrintMngr printMngr;
    private JMenuItem mnuFileFinish;
    private JMenuItem mnuFilePrintOptions;
    private JMenuItem mnuFilePrint;
    private JMenuItem mnuFileOpenText;
    private JMenuItem mnuFileOpenHex;
    private JMenuItem mnuFileSave;
    private JMenuItem mnuFileDelete;
    private JMenuItem mnuFileClose;
    private JMenuItem mnuHelpContent;
    private JPopupMenu mnuPopup;
    private JMenuItem mnuPopupFinish;
    private JMenuItem mnuPopupPrint;
    private JMenuItem mnuPopupOpenText;
    private JMenuItem mnuPopupOpenHex;
    private JMenuItem mnuPopupSave;
    private JMenuItem mnuPopupDelete;
    private JButton btnPrint;
    private JButton btnOpenText;
    private JButton btnSave;
    private JButton btnDelete;
    private JTable table;
    private JScrollPane scrollPane;

    public static void open(ScreenFrm screenFrm) {
        if (instance != null) {
            if (instance.getExtendedState() == 1) {
                instance.setExtendedState(0);
            }
        } else {
            instance = new PrintListFrm(screenFrm);
        }
        instance.toFront();
        instance.setVisible(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updActionButtons();
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject != null) {
            Object object = eventObject.getSource();
            if (object == this.mnuFileFinish || object == this.mnuPopupFinish) {
                bl = true;
                this.doFinish();
            } else if (object == this.mnuFilePrintOptions) {
                bl = true;
                PrintOptionsDlg.showPrintOptionsDlg(this, true, false);
            } else if (object == this.mnuFilePrint || object == this.mnuPopupPrint || object == this.btnPrint) {
                bl = true;
                this.doPrint();
            } else if (object == this.mnuFileOpenText || object == this.mnuPopupOpenText || object == this.btnOpenText) {
                bl = true;
                this.doOpenText();
            } else if (object == this.mnuFileOpenHex || object == this.mnuPopupOpenHex) {
                bl = true;
                this.doOpenHex();
            } else if (object == this.mnuFileSave || object == this.mnuPopupSave || object == this.btnSave) {
                bl = true;
                this.doSave();
            } else if (object == this.mnuFileDelete || object == this.mnuPopupDelete || object == this.btnDelete) {
                bl = true;
                this.doDelete();
            } else if (object == this.mnuFileClose) {
                bl = true;
                this.doClose();
            } else if (object == this.mnuHelpContent) {
                bl = true;
                HelpFrm.open(HELP_PAGE);
            }
        }
        return bl;
    }

    @Override
    public void lookAndFeelChanged() {
        if (this.mnuPopup != null) {
            SwingUtilities.updateComponentTreeUI(this.mnuPopup);
        }
        this.updBgColor();
    }

    @Override
    protected boolean showPopup(MouseEvent mouseEvent) {
        boolean bl = false;
        Component component = mouseEvent.getComponent();
        if (component != null) {
            this.mnuPopup.show(component, mouseEvent.getX(), mouseEvent.getY());
            bl = true;
        }
        return bl;
    }

    private void doFinish() {
        PrintData printData;
        int n;
        int n2;
        int[] nArray = this.table.getSelectedRows();
        if (nArray != null && nArray.length == 1 && (n2 = this.table.convertRowIndexToModel(nArray[0])) >= 0 && (n = this.table.convertRowIndexToModel(n2)) >= 0 && (printData = this.printMngr.getPrintData(n)) != null) {
            if (this.isActivePrintData(printData)) {
                if (BaseDlg.showYesNoDlg(this, "M\u00f6chten Sie den Druckauftrag abschlie\u00dfen?")) {
                    this.printMngr.deactivatePrintData(printData);
                    this.fireUpdActionButtons();
                }
            } else {
                BaseDlg.showInfoDlg(this, "Der Druckauftrag ist bereits abgeschlossen.");
            }
        }
    }

    private void doPrint() {
        PrintData printData = this.getSelectedPrintData();
        if (printData != null) {
            PrintUtil.doPrint(this, printData, String.format("JKCEMU Druckauftrag %d", printData.getEntryNum()));
        }
    }

    private void doOpenText() {
        PrintData printData = this.getSelectedPrintData();
        if (printData != null) {
            StringBuilder stringBuilder = new StringBuilder(printData.size());
            byte[] byArray = printData.getBytes();
            if (byArray != null) {
                PrintDataScanner printDataScanner = new PrintDataScanner(byArray);
                while (!printDataScanner.endReached()) {
                    String string = printDataScanner.readLine();
                    while (string != null) {
                        stringBuilder.append(string);
                        stringBuilder.append('\n');
                        string = printDataScanner.readLine();
                    }
                    if (printDataScanner.skipFormFeed()) continue;
                    break;
                }
            }
            this.screenFrm.openText(stringBuilder.toString());
        }
    }

    private void doOpenHex() {
        byte[] byArray;
        PrintData printData = this.getSelectedPrintData();
        if (printData != null && (byArray = printData.getBytes()) != null) {
            HexEditFrm.open(byArray);
        }
    }

    private void doSave() {
        try {
            File file;
            PrintData printData = this.getSelectedPrintData();
            if (printData != null && (file = EmuUtil.showFileSaveDlg(this, "Druckauftrag speichern", Main.getLastDirFile("print"), EmuUtil.getTextFileFilter())) != null) {
                printData.saveToFile(file);
                this.printMngr.fireTableDataChanged();
                Main.setLastFile(file, "print");
            }
        }
        catch (IOException iOException) {
            BaseDlg.showErrorDlg((Component)this, "Der Druckauftrag kann nicht gespeichert werden." + iOException.getMessage());
        }
    }

    private void doDelete() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray != null) {
            if (nArray.length == 1) {
                if (!BaseDlg.showYesNoDlg(this, "M\u00f6chten Sie den Druckauftrag l\u00f6schen?")) {
                    nArray = null;
                }
            } else if (nArray.length > 1) {
                if (!BaseDlg.showYesNoDlg(this, "M\u00f6chten Sie die ausgew\u00e4hlten Druckauftr\u00e4ge l\u00f6schen?")) {
                    nArray = null;
                }
            } else {
                nArray = null;
            }
        }
        if (nArray != null) {
            int n;
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = this.table.convertRowIndexToModel(nArray[n]);
            }
            Arrays.sort(nArray);
            for (n = nArray.length - 1; n >= 0; --n) {
                int n2 = nArray[n];
                if (n2 < 0) continue;
                this.printMngr.removeRow(n2);
            }
            this.fireUpdActionButtons();
        }
    }

    private PrintListFrm(ScreenFrm screenFrm) {
        this.screenFrm = screenFrm;
        this.printMngr = screenFrm.getEmuThread().getPrintMngr();
        this.setTitle("JKCEMU Druckauftr\u00e4ge");
        Main.updIcon(this);
        JMenu jMenu = new JMenu("Datei");
        jMenu.setMnemonic(68);
        this.mnuFileFinish = this.createJMenuItem("Abschlie\u00dfen");
        jMenu.add(this.mnuFileFinish);
        jMenu.addSeparator();
        this.mnuFilePrintOptions = this.createJMenuItem("Druckoptionen...");
        jMenu.add(this.mnuFilePrintOptions);
        this.mnuFilePrint = this.createJMenuItem("Drucken...", KeyStroke.getKeyStroke(80, 2));
        jMenu.add(this.mnuFilePrint);
        jMenu.addSeparator();
        this.mnuFileOpenText = this.createJMenuItem("Im Texteditor \u00f6ffnen...");
        jMenu.add(this.mnuFileOpenText);
        this.mnuFileOpenHex = this.createJMenuItem("Im Hex-Editor \u00f6ffnen...");
        jMenu.add(this.mnuFileOpenHex);
        this.mnuFileSave = this.createJMenuItem("Speichern unter...");
        jMenu.add(this.mnuFileSave);
        jMenu.addSeparator();
        this.mnuFileDelete = this.createJMenuItem("L\u00f6schen", KeyStroke.getKeyStroke(127, 0));
        jMenu.add(this.mnuFileDelete);
        jMenu.addSeparator();
        this.mnuFileClose = this.createJMenuItem("Schlie\u00dfen");
        jMenu.add(this.mnuFileClose);
        JMenu jMenu2 = new JMenu("?");
        this.mnuHelpContent = this.createJMenuItem("Hilfe...");
        jMenu2.add(this.mnuHelpContent);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
        this.mnuPopup = new JPopupMenu();
        this.mnuPopupFinish = this.createJMenuItem("Abschlie\u00dfen");
        this.mnuPopup.add(this.mnuPopupFinish);
        this.mnuPopup.addSeparator();
        this.mnuPopupPrint = this.createJMenuItem("Drucken...");
        this.mnuPopup.add(this.mnuPopupPrint);
        this.mnuPopupOpenText = this.createJMenuItem("Im Texteditor \u00f6ffnen...");
        this.mnuPopup.add(this.mnuPopupOpenText);
        this.mnuPopupOpenHex = this.createJMenuItem("Im Hex-Editor \u00f6ffnen...");
        this.mnuPopup.add(this.mnuPopupOpenHex);
        this.mnuPopupSave = this.createJMenuItem("Speichern unter...");
        this.mnuPopup.add(this.mnuPopupSave);
        this.mnuPopup.addSeparator();
        this.mnuPopupDelete = this.createJMenuItem("L\u00f6schen");
        this.mnuPopup.add(this.mnuPopupDelete);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        jToolBar.setOrientation(0);
        jToolBar.setRollover(true);
        this.btnPrint = this.createImageButton("/images/file/print.png", "Drucken...");
        jToolBar.add(this.btnPrint);
        this.btnOpenText = this.createImageButton("/images/file/edit.png", "Im Texteditor \u00f6ffnen");
        jToolBar.add(this.btnOpenText);
        this.btnSave = this.createImageButton("/images/file/save_as.png", "Speichern unter");
        jToolBar.add(this.btnSave);
        jToolBar.addSeparator();
        this.btnDelete = this.createImageButton("/images/file/delete.png", "L\u00f6schen");
        jToolBar.add(this.btnDelete);
        this.add((Component)jToolBar, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        ++gridBagConstraints.gridy;
        this.table = new JTable(this.printMngr);
        this.table.setAutoResizeMode(0);
        this.table.setColumnSelectionAllowed(false);
        this.table.setPreferredScrollableViewportSize(new Dimension(340, 200));
        this.table.setRowSelectionAllowed(true);
        this.table.setShowGrid(false);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.setSelectionMode(2);
        this.table.addMouseListener(this);
        EmuUtil.setTableColWidths(this.table, 70, 70, 200);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        if (listSelectionModel != null) {
            listSelectionModel.addListSelectionListener(this);
            this.updActionButtons();
        }
        this.scrollPane = new JScrollPane(this.table, 20, 32);
        this.scrollPane.addMouseListener(this);
        this.add((Component)this.scrollPane, gridBagConstraints);
        if (!this.applySettings(Main.getProperties(), true)) {
            this.pack();
            this.setScreenCentered();
        }
        this.setResizable(true);
        this.updActionButtons();
        this.updBgColor();
    }

    private void fireUpdActionButtons() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PrintListFrm.this.updActionButtons();
            }
        });
    }

    private PrintData getSelectedPrintData() {
        int n;
        PrintData printData = null;
        int[] nArray = this.table.getSelectedRows();
        if (nArray != null && nArray.length == 1 && (n = this.table.convertRowIndexToModel(nArray[0])) >= 0 && (printData = this.printMngr.getPrintData(n)) != null && this.isActivePrintData(printData) && BaseDlg.showYesNoDlg(this, "Der Druckauftrag ist noch nicht abgeschlossen.\nM\u00f6chten Sie ihn jetzt abschlie\u00dfen?")) {
            this.printMngr.deactivatePrintData(printData);
            this.updFinishButtons();
        }
        return printData;
    }

    private boolean isActivePrintData(PrintData printData) {
        PrintData printData2;
        boolean bl = false;
        if (printData != null && (printData2 = this.printMngr.getActivePrintData()) != null && printData2 == printData) {
            bl = true;
        }
        return bl;
    }

    private void updFinishButtons() {
        int n;
        boolean bl = false;
        int[] nArray = this.table.getSelectedRows();
        if (nArray != null && nArray.length == 1 && (n = this.table.convertRowIndexToModel(nArray[0])) >= 0 && this.isActivePrintData(this.printMngr.getPrintData(n))) {
            bl = true;
        }
        this.mnuFileFinish.setEnabled(bl);
        this.mnuPopupFinish.setEnabled(bl);
    }

    private void updActionButtons() {
        int n = this.table.getSelectedRowCount();
        boolean bl = n == 1;
        this.mnuFilePrint.setEnabled(bl);
        this.mnuFileOpenText.setEnabled(bl);
        this.mnuFileOpenHex.setEnabled(bl);
        this.mnuFileSave.setEnabled(bl);
        this.mnuFileDelete.setEnabled(n > 0);
        this.mnuPopupPrint.setEnabled(bl);
        this.mnuPopupOpenText.setEnabled(bl);
        this.mnuPopupOpenHex.setEnabled(bl);
        this.mnuPopupSave.setEnabled(bl);
        this.mnuPopupDelete.setEnabled(n > 0);
        this.btnPrint.setEnabled(bl);
        this.btnOpenText.setEnabled(bl);
        this.btnSave.setEnabled(bl);
        this.btnDelete.setEnabled(n > 0);
        this.updFinishButtons();
    }

    private void updBgColor() {
        Color color = this.table.getBackground();
        JViewport jViewport = this.scrollPane.getViewport();
        if (color != null && jViewport != null) {
            jViewport.setBackground(color);
        }
    }
}

