/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.net;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import jkcemu.Main;
import jkcemu.base.EmuUtil;
import jkcemu.net.DhcpServer;
import jkcemu.net.EmuDatagramSocket;
import jkcemu.net.KCNet;
import jkcemu.net.NetConfig;
import jkcemu.net.Ping;

public class W5100 {
    private static final int DEBUG_MASK_MSG = 16;
    private static final int DEBUG_MASK_STATUS = 32;
    private static final int DEBUG_MASK_READ = 64;
    private static final int DEBUG_MASK_WRITE = 128;
    private static final int ADDR_MR = 0;
    private static final int ADDR_GWR = 1;
    private static final int ADDR_SUBR = 5;
    private static final int ADDR_SHAR = 9;
    private static final int ADDR_SIPR = 15;
    private static final int ADDR_IR = 21;
    private static final int ADDR_RTR = 23;
    private static final int ADDR_RCR = 25;
    private static final int ADDR_RMSR = 26;
    private static final int ADDR_TMSR = 27;
    private static final int ADDR_PTIMER = 40;
    private byte[] localIpAddr = null;
    private byte[] mem = new byte[32768];
    private Object loggingLockObj;
    private SocketData[] sockets;
    private List<Ping> pings;
    private List<EmuDatagramSocket> reservedDatagramSockets;
    private ServerSocketFactory serverSocketFactory;
    private SocketFactory socketFactory;
    private DhcpServer dhcpServer;
    private NetConfig netConfig;
    private boolean threadsEnabled;
    private int debugMask;

    public W5100() {
        Arrays.fill(this.mem, (byte)0);
        this.sockets = new SocketData[4];
        for (int i = 0; i < 4; ++i) {
            this.sockets[i] = new SocketData(i, 1024 + i * 256);
        }
        this.loggingLockObj = new Object();
        this.serverSocketFactory = ServerSocketFactory.getDefault();
        this.socketFactory = SocketFactory.getDefault();
        this.dhcpServer = new DhcpServer(this);
        this.reservedDatagramSockets = new ArrayList<EmuDatagramSocket>();
        this.pings = new ArrayList<Ping>();
        this.netConfig = null;
        this.threadsEnabled = true;
        this.debugMask = 0;
        String string = System.getProperty("jkcemu.debug.net");
        if (string != null) {
            try {
                this.debugMask = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPing(Ping ping) {
        List<Ping> list = this.pings;
        synchronized (list) {
            this.pings.add(ping);
        }
    }

    public void die() {
        this.threadsEnabled = false;
        for (SocketData socketData : this.sockets) {
            socketData.die();
        }
    }

    public DhcpServer getDhcpServer() {
        return this.dhcpServer;
    }

    public synchronized NetConfig getNetConfig() {
        return this.netConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readMemByte(int n) {
        int n2 = 0;
        if ((this.getDebugMask() & 0x40) != 0) {
            Object object = this.getLoggingLockObj();
            synchronized (object) {
                n2 = this.readMemByteInternal(n);
                System.out.printf("W5100: read: addr=%04X value=%02X\n", n, n2);
            }
        } else {
            n2 = this.readMemByteInternal(n);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reservePort() {
        int n = -1;
        List<EmuDatagramSocket> list = this.reservedDatagramSockets;
        synchronized (list) {
            try {
                EmuDatagramSocket emuDatagramSocket = EmuDatagramSocket.createDatagramSocket();
                n = emuDatagramSocket.getLocalPort();
                this.reservedDatagramSockets.add(emuDatagramSocket);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(boolean bl) {
        for (int i = 0; i < this.sockets.length; ++i) {
            this.sockets[i].closeSocket();
        }
        this.wakeUpThreads();
        this.wakeUpThreads();
        if (bl) {
            Arrays.fill(this.mem, (byte)0);
            Object object = this;
            synchronized (object) {
                this.netConfig = NetConfig.readNetConfig();
            }
            if (this.netConfig != null) {
                Object object2;
                int n;
                int n2;
                byte[] byArray;
                object = this.netConfig.getHardwareAddr();
                if (object != null && ((Object)object).length == 6) {
                    int n22 = 9;
                    for (int n3 : object) {
                        this.mem[n22++] = n3;
                    }
                }
                if ((byArray = this.netConfig.getManualIpAddr()) != null && byArray.length == 4) {
                    int n4 = 1;
                    for (byte n5 : byArray) {
                        this.mem[n4++] = n5;
                    }
                }
                this.localIpAddr = this.netConfig.getIpAddr();
                Object object22 = this.localIpAddr;
                if (object22 == null) {
                    object22 = new byte[]{127, 0, 0, 1};
                }
                byte[] byArray2 = this.netConfig.getSubnetMask();
                if (!KCNet.getAutoConfig()) {
                    object22 = this.netConfig.getManualIpAddr();
                    byArray2 = this.netConfig.getManualSubnetMask();
                }
                if (object22 != null && ((Object)object22).length == 4) {
                    n2 = 15;
                    Object object3 = object22;
                    int n3 = ((Object)object3).length;
                    for (n = 0; n < n3; ++n) {
                        object2 = object3[n];
                        this.mem[n2++] = (byte)object2;
                    }
                }
                if (byArray2 != null && byArray2.length == 4) {
                    n2 = 5;
                    byte[] byArray3 = byArray2;
                    int n4 = byArray3.length;
                    for (n = 0; n < n4; ++n) {
                        object2 = byArray3[n];
                        this.mem[n2++] = (byte)object2;
                    }
                }
            }
        } else {
            Arrays.fill(this.mem, 19, this.mem.length, (byte)0);
        }
        this.mem[23] = 7;
        this.mem[24] = -48;
        this.mem[25] = 8;
        this.mem[26] = 85;
        this.mem[27] = 85;
        this.mem[40] = 40;
        for (int i = 0; i < this.sockets.length; ++i) {
            this.sockets[i].initialize();
        }
    }

    public void writeMemByte(int n, int n2) {
        n &= 0xFFFF;
        n2 &= 0xFF;
        if ((this.getDebugMask() & 0x80) != 0) {
            System.out.printf("W5100: write: addr=%04X value=%02X\n", n, n2);
        }
        if (n == 0 && (n2 & 0x80) != 0) {
            this.reset(true);
        }
        if (n >= 0 && n < this.mem.length) {
            if (n == 0) {
                this.mem[n] = (byte)(n2 & 0x74);
            } else if (n == 21) {
                int n3 = n;
                this.mem[n3] = (byte)(this.mem[n3] & ~n2);
            } else if (n >= 1024 && n < 2048) {
                this.sockets[n >> 8 & 3].writeMemByte(n, n2);
            } else if (n < 9 || n > 14) {
                this.mem[n] = (byte)n2;
            }
        }
    }

    private static void checkPermissionDenied(Exception exception) {
        String string;
        if (exception != null && exception instanceof BindException && (string = exception.getMessage()) != null && ((string = string.toLowerCase()).indexOf("permission") >= 0 || string.indexOf("recht") >= 0)) {
            EmuUtil.fireShowError(Main.getScreenFrm(), "Das Betriebssystem, auf dem JKCEMU l\u00e4uft,\ngestattet Ihnen die gew\u00fcnschte Netzwerkoperation nicht.", exception);
        }
    }

    private static int computeChecksum(byte[] byArray, int n, int n2) {
        long l = 0L;
        while (n < byArray.length && n2 > 0) {
            int n3 = byArray[n++] << 8 & 0xFF00;
            if (n < byArray.length && --n2 > 0) {
                n3 |= byArray[n++] & 0xFF;
                --n2;
            }
            l += (long)n3;
        }
        return (int)(-1L - (l + (l >> 16)));
    }

    private InetAddress createInetAddrByMem(int n) {
        InetAddress inetAddress;
        block4: {
            inetAddress = null;
            if (n + 3 < this.mem.length) {
                try {
                    byte[] byArray = new byte[4];
                    for (int i = 0; i < byArray.length; ++i) {
                        byArray[i] = this.mem[n++];
                    }
                    inetAddress = InetAddress.getByAddress(byArray);
                }
                catch (Exception exception) {
                    if ((this.getDebugMask() & 0x10) == 0) break block4;
                    exception.printStackTrace(System.out);
                }
            }
        }
        return inetAddress;
    }

    private Socket createSocket() throws IOException {
        Socket socket = null;
        socket = this.socketFactory != null ? this.socketFactory.createSocket() : new Socket();
        return socket;
    }

    private ServerSocket createServerSocket(int n, int n2) throws IOException {
        ServerSocket serverSocket = null;
        serverSocket = this.serverSocketFactory != null ? this.serverSocketFactory.createServerSocket(n, n2) : new ServerSocket(n, n2);
        return serverSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EmuDatagramSocket fetchReservedDatagramSocket(int n) {
        EmuDatagramSocket emuDatagramSocket = null;
        List<EmuDatagramSocket> list = this.reservedDatagramSockets;
        synchronized (list) {
            int n2 = this.reservedDatagramSockets.size();
            for (int i = 0; i < n2; ++i) {
                EmuDatagramSocket emuDatagramSocket2 = this.reservedDatagramSockets.get(i);
                if (emuDatagramSocket2.getLocalPort() != n) continue;
                emuDatagramSocket = emuDatagramSocket2;
                break;
            }
        }
        return emuDatagramSocket;
    }

    private int getBufSize(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getMemByte(n2);
        do {
            switch (n5 & 3) {
                case 0: {
                    n3 = 1024;
                    break;
                }
                case 1: {
                    n3 = 2048;
                    break;
                }
                case 2: {
                    n3 = 4096;
                    break;
                }
                case 3: {
                    n3 = 8192;
                }
            }
            n4 += n3;
            n5 >>= 2;
        } while (--n >= 0);
        if (n4 > 8192) {
            n3 = 0;
        }
        return n3;
    }

    private int getDebugMask() {
        return this.debugMask;
    }

    private Object getLoggingLockObj() {
        return this.loggingLockObj;
    }

    private int getMemByte(int n) {
        int n2 = 0;
        if (n >= 0 && n < this.mem.length) {
            n2 = this.mem[n] & 0xFF;
        }
        return n2;
    }

    private int getMemWord(int n) {
        int n2 = 0;
        if (n >= 0 && n + 1 < this.mem.length) {
            n2 = this.mem[n] << 8 & 0xFF00 | this.mem[n + 1] & 0xFF;
        }
        return n2;
    }

    private List<Ping> getPings() {
        return this.pings;
    }

    private int getRxBufAddr(int n) {
        int n2 = 24576;
        int n3 = this.getMemByte(26);
        while (n > 0) {
            switch (n3 & 3) {
                case 0: {
                    n2 += 1024;
                    break;
                }
                case 1: {
                    n2 += 2048;
                    break;
                }
                case 2: {
                    n2 += 4096;
                    break;
                }
                case 3: {
                    n2 += 8192;
                }
            }
            n3 >>= 2;
            --n;
        }
        return n2;
    }

    private int getRxBufSize(int n) {
        return this.getBufSize(n, 26);
    }

    private int getTxBufAddr(int n) {
        int n2 = 16384;
        int n3 = this.getMemByte(27);
        while (n > 0) {
            switch (n3 & 3) {
                case 0: {
                    n2 += 1024;
                    break;
                }
                case 1: {
                    n2 += 2048;
                    break;
                }
                case 2: {
                    n2 += 4096;
                    break;
                }
                case 3: {
                    n2 += 8192;
                }
            }
            n3 >>= 2;
            --n;
        }
        return n2;
    }

    private int getTxBufSize(int n) {
        return this.getBufSize(n, 27);
    }

    private W5100 getW5100() {
        return this;
    }

    private synchronized boolean isIpAddrConflict(int n) {
        boolean bl = false;
        if (this.localIpAddr != null) {
            bl = !EmuUtil.equalsRegion(this.localIpAddr, 0, this.mem, 15, 4) && EmuUtil.equalsRegion(this.localIpAddr, 0, this.mem, n, 4);
        }
        return bl;
    }

    private int readMemByteInternal(int n) {
        int n2 = 0;
        if (n >= 1024 && n < 2048) {
            n2 = this.sockets[n >> 8 & 3].readMemByte(n);
        } else if (n >= 0 && n < this.mem.length) {
            n2 = this.mem[n] & 0xFF;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseReservedDatagramSockets() {
        List<EmuDatagramSocket> list = this.reservedDatagramSockets;
        synchronized (list) {
            for (EmuDatagramSocket emuDatagramSocket : this.reservedDatagramSockets) {
                emuDatagramSocket.close();
            }
            this.reservedDatagramSockets.clear();
        }
    }

    private void setMemByte(int n, int n2) {
        if (n >= 0 && n < this.mem.length) {
            this.mem[n] = (byte)n2;
        }
    }

    private boolean setMemIpAddr(int n, InetAddress inetAddress) {
        boolean bl = false;
        if (inetAddress != null) {
            byte[] byArray = inetAddress.getAddress();
            if (byArray != null && byArray.length == 4) {
                for (int i = 0; i < byArray.length; ++i) {
                    this.setMemByte(n + i, byArray[i]);
                }
                bl = true;
            }
            if (!bl && inetAddress.isLoopbackAddress()) {
                this.setMemByte(n, 127);
                this.setMemByte(n + 1, 0);
                this.setMemByte(n + 2, 0);
                this.setMemByte(n + 3, 1);
                bl = true;
            }
        }
        if (!bl) {
            for (int i = 0; i < 4; ++i) {
                this.setMemByte(n + i, 0);
            }
        }
        return bl;
    }

    private void setMemWord(int n, int n2) {
        if (n >= 0 && n < this.mem.length) {
            this.mem[n++] = (byte)(n2 >> 8);
            if (n < this.mem.length) {
                this.mem[n] = (byte)n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void wakeUpThread(Thread thread, boolean bl) {
        if (thread != null) {
            if (bl) {
                thread.interrupt();
            }
            Thread thread2 = thread;
            synchronized (thread2) {
                try {
                    thread.notify();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    // empty catch block
                }
            }
        }
    }

    private void wakeUpThreads() {
        for (SocketData socketData : this.sockets) {
            W5100.wakeUpThread(socketData.cmdThread, true);
            W5100.wakeUpThread(socketData.recvThread, true);
        }
    }

    public class SocketData {
        private static final int CMD_NONE = 0;
        private static final int CMD_OPEN = 1;
        private static final int CMD_LISTEN = 2;
        private static final int CMD_CONNECT = 4;
        private static final int CMD_DISCON = 8;
        private static final int CMD_CLOSE = 16;
        private static final int CMD_SEND = 32;
        private static final int CMD_SEND_MAC = 33;
        private static final int CMD_SEND_KEEP = 34;
        private static final int CMD_RECV = 64;
        private static final byte SOCK_CLOSED = 0;
        private static final byte SOCK_INIT = 19;
        private static final byte SOCK_LISTEN = 20;
        private static final byte SOCK_ESTABLISHED = 23;
        private static final byte SOCK_UDP = 34;
        private static final byte SOCK_CLOSING = 26;
        private static final byte SOCK_CLOSE_WAIT = 28;
        private static final byte SOCK_IPRAW = 50;
        private static final byte SOCK_MACRAW = 66;
        private static final byte SOCK_PPPOE = 95;
        private static final int Sn_CR = 1;
        private static final int Sn_IR = 2;
        private static final int Sn_SR = 3;
        private static final int Sn_PORT = 4;
        private static final int Sn_DHAR = 6;
        private static final int Sn_DIPR = 12;
        private static final int Sn_DPORT = 16;
        private static final int Sn_PROTO = 20;
        private static final int Sn_TTL = 22;
        private static final int Sn_TX_FSR = 32;
        private static final int Sn_TX_RR = 34;
        private static final int Sn_TX_WR = 36;
        private static final int Sn_RX_RSR = 38;
        private static final int Sn_RX_RD = 40;
        private static final int Sn_RX_WR = 42;
        private static final int INT_CON_MASK = 1;
        private static final int INT_DISCON_MASK = 2;
        private static final int INT_RECV_MASK = 4;
        private static final int INT_TIMEOUT_MASK = 8;
        private static final int INT_SEND_OK_MASK = 16;
        private int socketNum;
        private int baseAddr;
        private int lastStatus;
        private int rxReadReg;
        private int rxWriteReg;
        private int txReadReg;
        private int txWriteReg;
        private boolean rxFilled;
        private boolean nonIPv4MsgShown;
        private boolean recvEnabled;
        private volatile boolean threadsEnabled;
        private volatile boolean cmdThreadNoWait;
        private byte[] recvBuf;
        private byte[] sendBuf;
        private Thread cmdThread;
        private Thread recvThread;
        private EmuDatagramSocket datagramSocket;
        private ServerSocket serverSocket;
        private Socket socket;
        private InputStream recvStream;
        private OutputStream sendStream;

        private SocketData(int n, int n2) {
            this.socketNum = n;
            this.baseAddr = n2;
            this.lastStatus = 0;
            this.threadsEnabled = true;
            this.cmdThreadNoWait = false;
            this.recvBuf = null;
            this.sendBuf = null;
            this.cmdThread = null;
            this.recvThread = null;
            this.datagramSocket = null;
            this.serverSocket = null;
            this.socket = null;
            this.recvStream = null;
            this.sendStream = null;
            this.initialize();
        }

        private void checkShowNonIPv4Msg(InetAddress inetAddress) {
            if (!this.nonIPv4MsgShown) {
                String string = null;
                if (inetAddress != null) {
                    string = inetAddress.toString();
                }
                if (string != null && string.isEmpty()) {
                    string = null;
                }
                StringBuilder stringBuilder = new StringBuilder(512);
                stringBuilder.append("Es wurden Daten von");
                if (string != null) {
                    stringBuilder.append(" der IP-Adresse ");
                    stringBuilder.append(string);
                } else {
                    stringBuilder.append(" einer IP-Adresse");
                }
                stringBuilder.append(" empfangen,\nderen Format von KCNet nicht unterst\u00fctzt wird.\n");
                if (inetAddress != null && inetAddress instanceof Inet6Address) {
                    stringBuilder.append("Die Gegenstelle benutzt IPv6, KCNet beherrscht aber nur IPv4.\n");
                }
                stringBuilder.append("Aus diesem Grund kann JKCEMU die IP-Adresse nicht\nin das emulierte KCNet eintragen,\nwodurch das im Emulator laufende Nertwerkprogramm\neine Gegenstelle ohne g\u00fcltige IP-Adresse sieht.");
                EmuUtil.fireShowInfo(Main.getScreenFrm(), stringBuilder.toString());
                this.nonIPv4MsgShown = true;
            }
        }

        private synchronized void closeSocket() {
            EmuDatagramSocket emuDatagramSocket = this.datagramSocket;
            if (emuDatagramSocket != null) {
                emuDatagramSocket.close();
            }
            EmuUtil.closeSilent(this.sendStream);
            EmuUtil.closeSilent(this.recvStream);
            EmuUtil.closeSilent(this.socket);
            EmuUtil.closeSilent(this.serverSocket);
            this.sendStream = null;
            this.recvStream = null;
            this.socket = null;
            this.serverSocket = null;
            this.datagramSocket = null;
            this.rxReadReg = 0;
            this.rxWriteReg = 0;
            this.txReadReg = 0;
            this.txWriteReg = 0;
            this.rxFilled = false;
            this.nonIPv4MsgShown = false;
            this.setSR(0);
        }

        private EmuDatagramSocket createDatagramSocket(boolean bl) throws IOException {
            EmuDatagramSocket emuDatagramSocket = null;
            boolean bl2 = (W5100.this.getMemByte(this.baseAddr) & 0x80) != 0;
            int n = W5100.this.getMemWord(this.baseAddr + (bl2 ? 16 : 4));
            if (n != 0) {
                emuDatagramSocket = W5100.this.fetchReservedDatagramSocket(n);
            }
            if (bl2) {
                if (emuDatagramSocket != null) {
                    emuDatagramSocket.close();
                    emuDatagramSocket = null;
                }
                if (n != 0) {
                    emuDatagramSocket = EmuDatagramSocket.createMulticastSocket(n);
                } else if (bl) {
                    emuDatagramSocket = EmuDatagramSocket.createMulticastSocket();
                }
                if (emuDatagramSocket != null) {
                    try {
                        emuDatagramSocket.setTimeToLive(W5100.this.getMemByte(this.baseAddr + 22));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    InetAddress inetAddress = W5100.this.createInetAddrByMem(this.baseAddr + 12);
                    if (inetAddress != null) {
                        emuDatagramSocket.joinGroup(inetAddress);
                    }
                }
            } else if (emuDatagramSocket == null) {
                if (n != 0) {
                    emuDatagramSocket = EmuDatagramSocket.createDatagramSocket(n);
                } else if (bl) {
                    emuDatagramSocket = EmuDatagramSocket.createDatagramSocket();
                }
            }
            return emuDatagramSocket;
        }

        private void die() {
            this.threadsEnabled = false;
            W5100.wakeUpThread(this.cmdThread, true);
            W5100.wakeUpThread(this.recvThread, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doSocketConnect() {
            if (this.getSR() == 19) {
                Object object;
                boolean bl = false;
                int n = 0;
                Object object2 = null;
                Exception exception = null;
                if (!W5100.this.isIpAddrConflict(this.baseAddr + 12)) {
                    object = null;
                    try {
                        object2 = new InetSocketAddress(W5100.this.createInetAddrByMem(this.baseAddr + 12), W5100.this.getMemWord(this.baseAddr + 16));
                        n = this.getTimeoutMillis();
                        object = W5100.this.createSocket();
                        ((Socket)object).connect((SocketAddress)object2, n);
                        int n2 = W5100.this.getTxBufSize(this.socketNum);
                        this.sendStream = n2 > 0 ? new BufferedOutputStream(((Socket)object).getOutputStream(), n2) : new BufferedOutputStream(((Socket)object).getOutputStream());
                        this.recvStream = ((Socket)object).getInputStream();
                        this.socket = object;
                        SocketData socketData = this;
                        synchronized (socketData) {
                            this.setSR(23);
                            this.setSnIRBits(1);
                            this.recvEnabled = true;
                        }
                        this.fireRunRecvThread();
                        bl = true;
                        if ((W5100.this.getDebugMask() & 0x10) != 0) {
                            System.out.printf("W5100 Socket %d: connected to %s\n", this.socketNum, object2.toString());
                        }
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                    }
                }
                if (!bl) {
                    if ((W5100.this.getDebugMask() & 0x10) != 0) {
                        object = null;
                        if (object2 != null) {
                            object = object2.toString();
                        }
                        System.out.printf("connect: %s, timeout=%dms\n", object2, n);
                        if (exception != null) {
                            exception.printStackTrace(System.out);
                        }
                    }
                    EmuUtil.closeSilent(this.socket);
                    this.closeSocket();
                    this.setSnIRBits(8);
                }
            }
            this.setCR(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doSocketListen() {
            if (this.getSR() == 20) {
                try {
                    ServerSocket serverSocket = this.serverSocket;
                    if (serverSocket == null) {
                        this.serverSocket = serverSocket = W5100.this.createServerSocket(W5100.this.getMemWord(this.baseAddr + 4), 1);
                        if (serverSocket != null && (W5100.this.getDebugMask() & 0x10) != 0) {
                            System.out.printf("W5100 Socket %d: tcp server socket bound at port %d\n", this.socketNum, serverSocket.getLocalPort());
                        }
                    }
                    Socket socket = serverSocket.accept();
                    this.sendStream = socket.getOutputStream();
                    this.recvStream = socket.getInputStream();
                    this.socket = socket;
                    if (!W5100.this.setMemIpAddr(this.baseAddr + 12, socket.getInetAddress())) {
                        this.checkShowNonIPv4Msg(socket.getInetAddress());
                    }
                    W5100.this.setMemWord(this.baseAddr + 16, socket.getPort());
                    SocketData socketData = this;
                    synchronized (socketData) {
                        this.setSR(23);
                        this.setSnIRBits(1);
                        this.recvEnabled = true;
                    }
                    this.fireRunRecvThread();
                }
                catch (Exception exception) {
                    if (this.getCR() == 2) {
                        W5100.checkPermissionDenied(exception);
                        if ((W5100.this.getDebugMask() & 0x10) != 0) {
                            exception.printStackTrace(System.out);
                        }
                    }
                    EmuUtil.closeSilent(this.socket);
                }
            }
            switch (this.getCR()) {
                case 8: 
                case 16: {
                    this.closeSocket();
                    break;
                }
                case 2: {
                    this.setCR(0);
                }
            }
        }

        private byte[] getRecvBuf(int n) {
            byte[] byArray = this.recvBuf;
            if (byArray != null && byArray.length < n) {
                byArray = null;
            }
            if (byArray == null) {
                this.recvBuf = byArray = new byte[n];
            }
            return byArray;
        }

        private byte[] getSendBuf(int n) {
            byte[] byArray = this.sendBuf;
            if (byArray != null && byArray.length < n) {
                byArray = null;
            }
            if (byArray == null) {
                this.sendBuf = byArray = new byte[n];
            }
            return byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void fireRunCmdThread() {
            if (this.cmdThread != null) {
                Thread thread = this.cmdThread;
                synchronized (thread) {
                    try {
                        this.cmdThread.notify();
                    }
                    catch (IllegalMonitorStateException illegalMonitorStateException) {
                        this.cmdThreadNoWait = true;
                    }
                }
            }
            if (this.threadsEnabled) {
                Thread thread = new Thread(Main.getThreadGroup(), new Runnable(){

                    @Override
                    public void run() {
                        SocketData.this.runCmdThread();
                    }
                }, String.format("JKCEMU KCNET socket %d send", this.socketNum));
                thread.start();
                Thread.State state = thread.getState();
                while (state == Thread.State.NEW) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    state = thread.getState();
                }
                this.cmdThread = thread;
            }
        }

        private synchronized void fireRunRecvThread() {
            if (this.recvThread == null) {
                if (this.threadsEnabled) {
                    this.recvThread = new Thread(Main.getThreadGroup(), new Runnable(){

                        @Override
                        public void run() {
                            SocketData.this.runRecvThread();
                        }
                    }, String.format("JKCEMU KCNET socket %d receive", this.socketNum));
                    this.recvThread.start();
                }
            } else {
                W5100.wakeUpThread(this.recvThread, false);
            }
        }

        private int getCR() {
            return W5100.this.getMemByte(this.baseAddr + 1);
        }

        private int getSR() {
            return W5100.this.getMemByte(this.baseAddr + 3);
        }

        private int getTimeoutMillis() {
            return W5100.this.getMemWord(23) * W5100.this.getMemByte(25) / 10;
        }

        private void initialize() {
            W5100.this.setMemByte(this.baseAddr + 6, 255);
            W5100.this.setMemByte(this.baseAddr + 6 + 1, 255);
            W5100.this.setMemByte(this.baseAddr + 6 + 2, 255);
            W5100.this.setMemByte(this.baseAddr + 6 + 3, 255);
            W5100.this.setMemByte(this.baseAddr + 6 + 4, 255);
            W5100.this.setMemByte(this.baseAddr + 6 + 5, 255);
            W5100.this.setMemByte(this.baseAddr + 22, 128);
            W5100.this.setMemByte(this.baseAddr + 32, 8);
            this.rxReadReg = 0;
            this.rxWriteReg = 0;
            this.txReadReg = 0;
            this.txWriteReg = 0;
            this.rxFilled = false;
            this.recvEnabled = false;
            this.cmdThreadNoWait = false;
            this.nonIPv4MsgShown = false;
        }

        private void logDatagramSocketBound() {
            EmuDatagramSocket emuDatagramSocket = this.datagramSocket;
            if (emuDatagramSocket != null) {
                System.out.printf("W5100 Socket %d: %s socket bound at port %d\n", this.socketNum, emuDatagramSocket.isMulticastSocket() ? "multicast" : "datagram", emuDatagramSocket.getLocalPort());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int readMemByte(int n) {
            switch (n & 0xFF) {
                case 32: {
                    int n2;
                    SocketData socketData = this;
                    synchronized (socketData) {
                        n2 = 0;
                        int n3 = W5100.this.getTxBufSize(this.socketNum);
                        if (n3 > 0) {
                            int n4 = n3 - 1;
                            int n5 = this.txWriteReg & n4;
                            int n6 = this.txReadReg & n4;
                            if (n5 == n6) {
                                n2 = n3;
                            } else {
                                if (n6 < n5) {
                                    n6 += n3;
                                }
                                n2 = n6 - n5 & n4;
                            }
                        }
                        W5100.this.setMemWord(n, n2);
                        break;
                    }
                }
                case 34: {
                    SocketData socketData = this;
                    synchronized (socketData) {
                        W5100.this.setMemWord(n, this.txReadReg);
                        break;
                    }
                }
                case 36: {
                    SocketData socketData = this;
                    synchronized (socketData) {
                        W5100.this.setMemWord(n, this.txWriteReg);
                        break;
                    }
                }
                case 38: {
                    int n2;
                    SocketData socketData = this;
                    synchronized (socketData) {
                        int n7;
                        n2 = 0;
                        if (this.rxFilled && (n7 = W5100.this.getRxBufSize(this.socketNum)) > 0) {
                            int n8 = n7 - 1;
                            int n9 = this.rxWriteReg & n8;
                            int n10 = this.rxReadReg & n8;
                            if (n9 == n10) {
                                n2 = n7;
                            } else {
                                if (n9 < n10) {
                                    n9 += n7;
                                }
                                n2 = n9 - n10 & n8;
                            }
                        }
                        W5100.this.setMemWord(n, n2);
                        break;
                    }
                }
                case 40: {
                    SocketData socketData = this;
                    synchronized (socketData) {
                        W5100.this.setMemWord(n, this.rxReadReg);
                        break;
                    }
                }
                case 42: {
                    SocketData socketData = this;
                    synchronized (socketData) {
                        W5100.this.setMemWord(n, this.rxWriteReg);
                        break;
                    }
                }
            }
            int n11 = 0;
            if ((W5100.this.getDebugMask() & 0x20) != 0 && n == this.baseAddr + 3) {
                Object object = W5100.this.getLoggingLockObj();
                synchronized (object) {
                    n11 = W5100.this.getMemByte(n);
                    if (n11 != this.lastStatus) {
                        this.lastStatus = n11;
                        System.out.printf("W5100 read: status of socket %d has changed to %02X\n", this.socketNum, n11);
                    }
                }
            } else {
                n11 = W5100.this.getMemByte(n);
            }
            return n11;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void receiveIPRAW() {
            boolean bl = false;
            while (!bl && this.getSR() == 50) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                Object object = this;
                synchronized (object) {
                    n = W5100.this.getRxBufAddr(this.socketNum);
                    n2 = W5100.this.getRxBufSize(this.socketNum);
                    n3 = this.rxReadReg;
                    n4 = this.rxWriteReg;
                }
                if (n2 > 0 && W5100.this.getMemByte(this.baseAddr + 20) == 1) {
                    int n5;
                    object = null;
                    List list = W5100.this.getPings();
                    Object object2 = list;
                    synchronized (object2) {
                        n5 = 0;
                        while (object == null && n5 < list.size()) {
                            Ping ping = (Ping)list.get(n5);
                            if (ping.checkError()) {
                                object = ping;
                                list.remove(n5);
                                continue;
                            }
                            Boolean bl2 = ping.getReachable();
                            if (bl2 != null) {
                                if (bl2.booleanValue()) {
                                    object = ping;
                                }
                                list.remove(n5);
                                continue;
                            }
                            ++n5;
                        }
                    }
                    if (object != null && (object2 = (Object)((Ping)object).getPackageData()) != null) {
                        n5 = n2;
                        int n6 = n2 - 1;
                        if ((n4 &= n6) != (n3 &= n6)) {
                            if (n4 < n3) {
                                n4 += n2;
                            }
                            n5 = n4 - n3 & n6;
                        }
                        if (((Object)object2).length >= 4 && ((Object)object2).length + 6 < n5) {
                            W5100.this.setMemIpAddr(n + (n4 & n6), ((Ping)object).getInetAddress());
                            W5100.this.setMemWord(n + ((n4 += 4) & n6), ((Object)object2).length);
                            n4 += 2;
                            object2[0] = (byte)(((Ping)object).checkError() ? 3 : 0);
                            object2[1] = false;
                            object2[2] = false;
                            object2[3] = false;
                            long l = W5100.computeChecksum((byte[])object2, 0, ((Object)object2).length);
                            object2[2] = (byte)(l >> 8 & 0xFFL);
                            object2[3] = (byte)(l & 0xFFL);
                            for (int i = 0; i < ((Object)object2).length; ++i) {
                                W5100.this.setMemByte(n + (n4 & n6), (int)object2[i]);
                                ++n4;
                            }
                            SocketData socketData = this;
                            synchronized (socketData) {
                                this.recvEnabled = false;
                                this.rxFilled = true;
                                this.rxWriteReg = n4 & n6;
                                this.setSnIRBits(4);
                            }
                            bl = true;
                        }
                    }
                }
                if (bl) continue;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void receiveTCP() {
            block15: {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                Object object = this;
                synchronized (object) {
                    n = W5100.this.getRxBufAddr(this.socketNum);
                    n2 = W5100.this.getRxBufSize(this.socketNum);
                    n3 = this.rxReadReg;
                    n4 = this.rxWriteReg;
                }
                if (n2 > 0) {
                    try {
                        object = this.recvStream;
                        if (object == null) break block15;
                        int n5 = n2 - 1;
                        if (this.rxFilled && (n4 &= n5) == (n3 &= n5)) break block15;
                        int n6 = ((InputStream)object).read();
                        if (n6 >= 0) {
                            int n7 = 1;
                            W5100.this.setMemByte(n + (n4 & n5), n6);
                            n4 = n4 + 1 & n5;
                            int n8 = ((InputStream)object).available();
                            while (n8 > 0 && n4 != n3 && (n6 = ((InputStream)object).read()) >= 0) {
                                ++n7;
                                W5100.this.setMemByte(n + (n4 & n5), n6);
                                n4 = n4 + 1 & n5;
                                if (--n8 != 0) continue;
                                n8 = ((InputStream)object).available();
                            }
                            SocketData socketData = this;
                            synchronized (socketData) {
                                this.recvEnabled = false;
                                this.rxFilled = true;
                                this.rxWriteReg = n4;
                                this.setSnIRBits(4);
                            }
                            if (n7 > 0 && (W5100.this.getDebugMask() & 0x10) != 0) {
                                System.out.printf("W5100 Socket %d: %d bytes received\n", this.socketNum, n7);
                            }
                        }
                        if (n6 < 0) {
                            if ((W5100.this.getDebugMask() & 0x10) != 0) {
                                System.out.printf("W5100 Socket %d: tcp connection closed by remote host\n", this.socketNum);
                            }
                            this.setCR(0);
                            this.setSR(28);
                            Socket socket = this.socket;
                            if (socket != null) {
                                EmuUtil.closeSilent(socket);
                                this.recvStream = null;
                                this.sendStream = null;
                                this.socket = null;
                            }
                            this.setSR(0);
                            this.fireRunCmdThread();
                        }
                    }
                    catch (IOException iOException) {
                        EmuUtil.closeSilent(this.recvStream);
                        this.recvStream = null;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void receiveUDP() {
            boolean bl;
            block23: {
                bl = false;
                EmuDatagramSocket emuDatagramSocket = this.datagramSocket;
                if (emuDatagramSocket != null) {
                    int n = 0;
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = 0;
                    SocketData socketData = this;
                    synchronized (socketData) {
                        n = W5100.this.getRxBufAddr(this.socketNum);
                        n2 = W5100.this.getRxBufSize(this.socketNum);
                        n3 = this.rxReadReg;
                        n4 = this.rxWriteReg;
                    }
                    if (n2 > 0) {
                        int n5 = n2;
                        int n6 = n2 - 1;
                        if ((n4 &= n6) != (n3 &= n6)) {
                            if (n4 < n3) {
                                n4 += n2;
                            }
                            n5 = n4 - n3 & n6;
                        }
                        if (n5 > 8) {
                            try {
                                int n7;
                                byte[] byArray = this.getRecvBuf(n2);
                                DatagramPacket datagramPacket = new DatagramPacket(byArray, n5 - 8);
                                if (!emuDatagramSocket.receive(W5100.this.getW5100(), datagramPacket) || (n7 = datagramPacket.getLength()) <= 0) break block23;
                                String string = "";
                                if (n7 <= n2 && n7 <= n5 - 8) {
                                    if (!W5100.this.setMemIpAddr(n + (n4 & n6), datagramPacket.getAddress())) {
                                        this.checkShowNonIPv4Msg(datagramPacket.getAddress());
                                    }
                                    W5100.this.setMemWord(n + ((n4 += 4) & n6), datagramPacket.getPort());
                                    W5100.this.setMemWord(n + ((n4 += 2) & n6), n7);
                                    n4 += 2;
                                    byte[] byArray2 = datagramPacket.getData();
                                    if (byArray2 != null) {
                                        int n8 = datagramPacket.getOffset();
                                        for (int i = 0; i < n7; ++i) {
                                            int n9 = 0;
                                            if (n8 >= 0 && n8 < byArray2.length) {
                                                n9 = byArray2[n8] & 0xFF;
                                            }
                                            W5100.this.setMemByte(n + (n4 & n6), n9);
                                            ++n8;
                                            ++n4;
                                        }
                                    }
                                    SocketData socketData2 = this;
                                    synchronized (socketData2) {
                                        this.recvEnabled = false;
                                        this.rxFilled = true;
                                        this.rxWriteReg = n4 & n6;
                                        this.setSnIRBits(4);
                                    }
                                    bl = true;
                                } else {
                                    string = " but ignored due limited buffer size";
                                }
                                if ((W5100.this.getDebugMask() & 0x10) != 0) {
                                    System.out.printf("W5100 Socket %d: %d bytes received%s\n", this.socketNum, n7, string);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            if (!bl) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runCmdThread() {
            while (this.threadsEnabled) {
                int n = this.getSR();
                block4 : switch (this.getCR()) {
                    case 1: {
                        if (n != 34 || this.datagramSocket != null) break;
                        try {
                            this.datagramSocket = this.createDatagramSocket(false);
                            if ((W5100.this.getDebugMask() & 0x20) != 0) {
                                this.logDatagramSocketBound();
                            }
                        }
                        catch (IOException iOException) {
                            W5100.checkPermissionDenied(iOException);
                            if ((W5100.this.getDebugMask() & 0x10) != 0) {
                                iOException.printStackTrace(System.out);
                            }
                            this.closeSocket();
                        }
                        if (this.datagramSocket == null) break;
                        this.recvEnabled = true;
                        this.fireRunRecvThread();
                        break;
                    }
                    case 2: {
                        this.doSocketListen();
                        break;
                    }
                    case 4: {
                        this.doSocketConnect();
                        break;
                    }
                    case 8: {
                        boolean bl = this.socket != null;
                        this.closeSocket();
                        if (!bl) break;
                        this.setSnIRBits(2);
                        break;
                    }
                    case 16: {
                        this.closeSocket();
                        break;
                    }
                    case 32: {
                        switch (n) {
                            case 50: {
                                this.sendIPRAW();
                                break block4;
                            }
                            case 23: {
                                this.sendTCP();
                                break block4;
                            }
                            case 34: {
                                this.sendUDP();
                                break block4;
                            }
                        }
                        this.txReadReg = this.txWriteReg;
                        this.setSnIRBits(16);
                        break;
                    }
                    case 64: {
                        if (n != 23 && n != 34 && n != 50) break;
                        this.recvEnabled = true;
                        this.fireRunRecvThread();
                    }
                }
                this.setCR(0);
                if (this.getSR() == 0) {
                    this.closeSocket();
                }
                if (this.cmdThreadNoWait) {
                    this.cmdThreadNoWait = false;
                    continue;
                }
                Thread thread = this.cmdThread;
                if (thread == null) continue;
                Thread thread2 = thread;
                synchronized (thread2) {
                    try {
                        thread.wait();
                    }
                    catch (IllegalMonitorStateException illegalMonitorStateException) {
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.closeSocket();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runRecvThread() {
            while (this.threadsEnabled) {
                Thread thread;
                if (this.recvEnabled) {
                    switch (this.getSR()) {
                        case 23: {
                            this.receiveTCP();
                            break;
                        }
                        case 34: {
                            this.receiveUDP();
                            break;
                        }
                        case 50: {
                            this.receiveIPRAW();
                        }
                    }
                }
                if ((thread = this.recvThread) == null) continue;
                Thread thread2 = thread;
                synchronized (thread2) {
                    try {
                        thread.wait(30L);
                    }
                    catch (IllegalMonitorStateException illegalMonitorStateException) {
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendIPRAW() {
            boolean bl = false;
            if (W5100.this.getMemByte(this.baseAddr + 20) == 1) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                SocketData socketData = this;
                synchronized (socketData) {
                    n = W5100.this.getTxBufAddr(this.socketNum);
                    n2 = W5100.this.getTxBufSize(this.socketNum);
                    n3 = this.txReadReg;
                    n4 = this.txWriteReg;
                }
                int n5 = n2 - 1;
                if (n2 > 0 && W5100.this.getMemByte(n + (this.txReadReg & n5)) == 8) {
                    int n6 = (n4 &= n5) - (n3 &= n5);
                    if (n6 < 0) {
                        n6 = n4 + n2 - n3;
                    }
                    if (n6 >= 4) {
                        InetAddress inetAddress = W5100.this.createInetAddrByMem(15);
                        InetAddress inetAddress2 = W5100.this.createInetAddrByMem(this.baseAddr + 12);
                        if (inetAddress != null && inetAddress2 != null) {
                            byte[] byArray = null;
                            if (!inetAddress2.equals(inetAddress) || (W5100.this.getMemByte(0) & 0x10) == 0) {
                                byArray = new byte[n6];
                                for (int i = 0; i < byArray.length; ++i) {
                                    byArray[i] = (byte)W5100.this.getMemByte(n + (n3 + i & n5));
                                }
                            }
                            this.txReadReg = n4;
                            this.setSnIRBits(16);
                            bl = true;
                            if (byArray != null) {
                                Ping ping = new Ping(inetAddress2, byArray);
                                ping.start();
                                W5100.this.addPing(ping);
                            }
                        }
                    }
                }
            }
            if (!bl) {
                SocketData socketData = this;
                synchronized (socketData) {
                    this.txReadReg = this.txWriteReg;
                    this.setSnIRBits(8);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendTCP() {
            block14: {
                try {
                    boolean bl = false;
                    OutputStream outputStream = this.sendStream;
                    if (outputStream != null) {
                        int n = 0;
                        int n2 = 0;
                        int n3 = 0;
                        int n4 = 0;
                        SocketData socketData = this;
                        synchronized (socketData) {
                            n = W5100.this.getTxBufSize(this.socketNum);
                            n2 = W5100.this.getTxBufAddr(this.socketNum);
                            n3 = this.txReadReg;
                            n4 = this.txWriteReg;
                        }
                        if (n > 0) {
                            int n5 = 0;
                            int n6 = n - 1;
                            n3 &= n6;
                            n4 &= n6;
                            do {
                                outputStream.write(W5100.this.getMemByte(n2 + n3));
                                ++n5;
                            } while ((n3 = n3 + 1 & n6) != n4);
                            outputStream.flush();
                            this.txReadReg = n4;
                            this.setSnIRBits(16);
                            bl = true;
                            if (n5 > 0 && (W5100.this.getDebugMask() & 0x10) != 0) {
                                System.out.printf("W5100 Socket %d: %d bytes sent\n", this.socketNum, n5);
                            }
                        }
                    }
                    if (bl) break block14;
                    SocketData socketData = this;
                    synchronized (socketData) {
                        this.txReadReg = this.txWriteReg;
                        this.setSnIRBits(8);
                    }
                }
                catch (IOException iOException) {
                    if ((W5100.this.getDebugMask() & 0x10) != 0) {
                        iOException.printStackTrace(System.out);
                    }
                    this.setCR(0);
                    this.setSR(28);
                    Socket socket = this.socket;
                    if (socket != null) {
                        EmuUtil.closeSilent(socket);
                        this.recvStream = null;
                        this.sendStream = null;
                        this.socket = null;
                    }
                    this.setSR(0);
                    this.fireRunCmdThread();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendUDP() {
            boolean bl;
            block17: {
                bl = false;
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                SocketData socketData = this;
                synchronized (socketData) {
                    n = W5100.this.getTxBufSize(this.socketNum);
                    n2 = W5100.this.getTxBufAddr(this.socketNum);
                    n3 = this.txReadReg;
                    n4 = this.txWriteReg;
                }
                if (n > 0) {
                    int n5 = n;
                    int n6 = n - 1;
                    if ((n4 &= n6) != (n3 &= n6) && (n5 = n4 - n3) < 0) {
                        n5 += n;
                    }
                    InetAddress inetAddress = W5100.this.createInetAddrByMem(15);
                    InetAddress inetAddress2 = W5100.this.createInetAddrByMem(this.baseAddr + 12);
                    if (n5 > 0 && inetAddress != null && inetAddress2 != null) {
                        try {
                            EmuDatagramSocket emuDatagramSocket = this.datagramSocket;
                            if (emuDatagramSocket == null) {
                                this.datagramSocket = emuDatagramSocket = this.createDatagramSocket(true);
                                if ((W5100.this.getDebugMask() & 0x20) != 0) {
                                    this.logDatagramSocketBound();
                                }
                                this.recvEnabled = true;
                                this.fireRunRecvThread();
                            }
                            if (!W5100.this.isIpAddrConflict(this.baseAddr + 12)) {
                                int n7;
                                byte[] byArray = this.getSendBuf(n);
                                for (n7 = 0; n7 < n5; ++n7) {
                                    byArray[n7] = (byte)W5100.this.getMemByte(n2 + (n3 + n7 & n6));
                                }
                                n7 = W5100.this.getMemWord(this.baseAddr + 16);
                                DatagramPacket datagramPacket = new DatagramPacket(byArray, n5, inetAddress2, n7);
                                emuDatagramSocket.send(W5100.this.getW5100(), datagramPacket);
                                this.txReadReg = n4;
                                this.setSnIRBits(16);
                                bl = true;
                                if (n5 > 0 && (W5100.this.getDebugMask() & 0x10) != 0) {
                                    System.out.printf("W5100 Socket %d: %d bytes sent to %s:%d\n", this.socketNum, n5, inetAddress2.toString(), n7);
                                }
                            }
                        }
                        catch (IOException iOException) {
                            W5100.checkPermissionDenied(iOException);
                            if ((W5100.this.getDebugMask() & 0x10) == 0) break block17;
                            iOException.printStackTrace(System.out);
                        }
                    }
                }
            }
            if (!bl) {
                SocketData socketData = this;
                synchronized (socketData) {
                    this.txReadReg = this.txWriteReg;
                    this.setSnIRBits(8);
                }
            }
        }

        private void setSnIRBits(int n) {
            this.setSnIRValue(W5100.this.getMemByte(this.baseAddr + 2) | n);
        }

        private void setSnIRValue(int n) {
            W5100.this.setMemByte(this.baseAddr + 2, n &= 0xFF);
            int n2 = W5100.this.getMemByte(21);
            if (n == 0) {
                switch (this.socketNum) {
                    case 0: {
                        n2 &= 0xFE;
                        break;
                    }
                    case 1: {
                        n2 &= 0xFD;
                        break;
                    }
                    case 2: {
                        n2 &= 0xFB;
                        break;
                    }
                    case 3: {
                        n2 &= 0xF7;
                    }
                }
            } else {
                switch (this.socketNum) {
                    case 0: {
                        n2 |= 1;
                        break;
                    }
                    case 1: {
                        n2 |= 2;
                        break;
                    }
                    case 2: {
                        n2 |= 4;
                        break;
                    }
                    case 3: {
                        n2 |= 8;
                    }
                }
            }
            W5100.this.setMemByte(21, n2);
        }

        private void setCR(int n) {
            W5100.this.setMemByte(this.baseAddr + 1, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setSR(int n) {
            if ((W5100.this.getDebugMask() & 0x20) != 0) {
                Object object = W5100.this.getLoggingLockObj();
                synchronized (object) {
                    int n2 = this.baseAddr + 3;
                    int n3 = W5100.this.getMemByte(n2);
                    W5100.this.setMemByte(n2, n);
                    if (n != n3) {
                        String string = null;
                        switch (n) {
                            case 0: {
                                string = "CLOSED";
                                break;
                            }
                            case 19: {
                                string = "INIT";
                                break;
                            }
                            case 20: {
                                string = "LISTEN";
                                break;
                            }
                            case 23: {
                                string = "ESTABLISHED";
                                break;
                            }
                            case 34: {
                                string = "UDP";
                                break;
                            }
                            case 26: {
                                string = "CLOSING";
                                break;
                            }
                            case 28: {
                                string = "CLOSE_WAIT";
                                break;
                            }
                            case 50: {
                                string = "IPRAW";
                                break;
                            }
                            case 66: {
                                string = "MACRAW (not emulated -> socket closed)";
                                break;
                            }
                            case 95: {
                                string = "PPPOE (not emulated -> socket closed)";
                            }
                        }
                        if (string != null) {
                            System.out.printf("W5100 Socket %d: status=%s\n", this.socketNum, string);
                        } else {
                            System.out.printf("W5100 Socket %d: status=%02X\n", this.socketNum, string, n);
                        }
                    }
                }
            } else {
                W5100.this.setMemByte(this.baseAddr + 3, n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeCommand(int n, int n2) {
            Object object;
            if ((W5100.this.getDebugMask() & 0x10) != 0) {
                object = null;
                switch (n2) {
                    case 1: {
                        object = "OPEN";
                        break;
                    }
                    case 2: {
                        object = "LISTEN";
                        break;
                    }
                    case 4: {
                        object = "CONNECT";
                        break;
                    }
                    case 8: {
                        object = "DISCON";
                        break;
                    }
                    case 16: {
                        object = "CLOSE";
                        break;
                    }
                    case 32: {
                        object = "SEND";
                        break;
                    }
                    case 33: {
                        object = "SEND_MAC";
                        break;
                    }
                    case 64: {
                        object = "RECV";
                    }
                }
                if (object != null) {
                    System.out.printf("W5100 Socket %d: command=%s\n", this.socketNum, object);
                } else {
                    System.out.printf("W5100 Socket %d: command=%02X\n", this.socketNum, n2);
                }
            }
            block13 : switch (n2) {
                case 1: {
                    if (this.getSR() == 0) {
                        object = this;
                        synchronized (object) {
                            int n3;
                            int n4 = W5100.this.getRxBufSize(this.socketNum);
                            if (n4 > 0) {
                                n3 = n4 - 1;
                                this.rxReadReg &= n3;
                                this.rxWriteReg &= n3;
                            } else {
                                this.rxReadReg = 0;
                                this.rxWriteReg = 0;
                            }
                            n4 = W5100.this.getTxBufSize(this.socketNum);
                            if (n4 > 0) {
                                n3 = n4 - 1;
                                this.txReadReg &= n3;
                                this.txWriteReg &= n3;
                            } else {
                                this.txReadReg = 0;
                                this.txWriteReg = 0;
                            }
                        }
                        switch (W5100.this.getMemByte(this.baseAddr) & 0xF) {
                            case 1: {
                                this.setSR(19);
                                this.setCR(0);
                                break block13;
                            }
                            case 2: {
                                this.setSR(34);
                                W5100.this.setMemByte(n, n2);
                                this.fireRunCmdThread();
                                break block13;
                            }
                            case 3: {
                                this.setSR(50);
                                this.setCR(0);
                                this.recvEnabled = true;
                                this.fireRunRecvThread();
                                break block13;
                            }
                        }
                        this.setCR(0);
                        break;
                    }
                    this.setSR(0);
                    this.setCR(0);
                    break;
                }
                case 2: {
                    W5100.this.setMemByte(n, n2);
                    this.setSR(20);
                    this.fireRunCmdThread();
                    break;
                }
                case 4: 
                case 32: 
                case 64: {
                    W5100.this.setMemByte(n, n2);
                    this.fireRunCmdThread();
                    break;
                }
                case 8: 
                case 16: {
                    W5100.this.setMemByte(n, n2);
                    if (this.getSR() == 28 && this.socket != null) {
                        this.setSR(26);
                    }
                    if (this.cmdThread != null) {
                        object = this.serverSocket;
                        if (object != null) {
                            try {
                                ((ServerSocket)object).close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        W5100.wakeUpThread(this.cmdThread, false);
                    } else {
                        this.closeSocket();
                    }
                    W5100.this.releaseReservedDatagramSockets();
                    break;
                }
                case 33: {
                    if (this.getSR() == 34) {
                        this.txReadReg = this.txWriteReg;
                        this.setSnIRBits(16);
                    }
                    W5100.this.setMemByte(n, 0);
                    break;
                }
                case 34: {
                    if (this.socket == null || this.recvStream == null || this.sendStream == null) {
                        this.setSnIRBits(8);
                    }
                    W5100.this.setMemByte(n, 0);
                    break;
                }
                default: {
                    W5100.this.setMemByte(n, 0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeMemByte(int n, int n2) {
            switch (n & 0xFF) {
                case 3: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 38: 
                case 39: 
                case 42: 
                case 43: {
                    break;
                }
                case 2: {
                    this.setSnIRValue(W5100.this.getMemByte(n) & ~n2);
                    break;
                }
                case 1: {
                    this.writeCommand(n, n2);
                    break;
                }
                case 37: {
                    W5100.this.setMemByte(n, n2);
                    SocketData socketData = this;
                    synchronized (socketData) {
                        this.txWriteReg = W5100.this.getMemWord(n - 1);
                        break;
                    }
                }
                case 41: {
                    W5100.this.setMemByte(n, n2);
                    SocketData socketData = this;
                    synchronized (socketData) {
                        int n3 = W5100.this.getRxBufSize(this.socketNum) - 1;
                        this.rxReadReg = W5100.this.getMemWord(n - 1) & n3;
                        if ((this.rxReadReg & n3) == (this.rxWriteReg & n3)) {
                            this.rxFilled = false;
                        }
                        break;
                    }
                }
                default: {
                    W5100.this.setMemByte(n, n2);
                }
            }
        }
    }
}

