/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.net;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Hashtable;
import java.util.regex.PatternSyntaxException;
import javax.naming.directory.InitialDirContext;
import jkcemu.Main;
import jkcemu.base.EmuUtil;

public class NetConfig {
    private static final int DEBUG_MASK_MSG = 256;
    private byte[] hwAddr;
    private byte[] ipAddr;
    private byte[] subnetMask;
    private byte[] dnsServerIpAddr;
    private byte[] manualIpAddr;
    private byte[] manualSubnetMask;
    private byte[] manualGatewayIpAddr;
    private byte[] manualDnsServerIpAddr;

    public byte[] getDnsServerIpAddr() {
        return this.dnsServerIpAddr;
    }

    public byte[] getHardwareAddr() {
        return this.hwAddr;
    }

    public byte[] getIpAddr() {
        return this.ipAddr;
    }

    public byte[] getSubnetMask() {
        return this.subnetMask;
    }

    public byte[] getManualDnsServerIpAddr() {
        return this.manualDnsServerIpAddr;
    }

    public byte[] getManualGatewayIpAddr() {
        return this.manualGatewayIpAddr;
    }

    public byte[] getManualIpAddr() {
        return this.manualIpAddr;
    }

    public byte[] getManualSubnetMask() {
        return this.manualSubnetMask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetConfig readNetConfig() {
        byte[] byArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        Object object5;
        Object object6;
        Object object7;
        block34: {
            Object var0 = null;
            int n2 = 0;
            String string = System.getProperty("jkcemu.debug.net");
            if (string != null) {
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            object7 = null;
            object6 = null;
            object5 = null;
            n = 0;
            try {
                object4 = NetworkInterface.getNetworkInterfaces();
                while (object4.hasMoreElements() && object7 == null) {
                    Object object8;
                    NetworkInterface networkInterface = object4.nextElement();
                    if (networkInterface.isVirtual()) continue;
                    boolean bl = networkInterface.isUp();
                    if (bl && (object8 = networkInterface.getInterfaceAddresses()) != null) {
                        object3 = object8.iterator();
                        while (object3.hasNext()) {
                            byte[] objectArray;
                            object2 = object3.next();
                            InetAddress inetAddress = object2.getAddress();
                            if (inetAddress == null || (objectArray = inetAddress.getAddress()) == null || objectArray.length != 4) continue;
                            object5 = objectArray;
                            n = object2.getNetworkPrefixLength();
                            byte[] byArray2 = networkInterface.getHardwareAddress();
                            if (byArray2 == null || byArray2.length != 6) continue;
                            object7 = byArray2;
                            break;
                        }
                    }
                    if (object7 != null || !bl && object6 != null || (object8 = (Object)networkInterface.getHardwareAddress()) == null || ((Object)object8).length != 6) continue;
                    object6 = object8;
                }
            }
            catch (IOException iOException) {
                if ((n2 & 0x100) == 0) break block34;
                iOException.printStackTrace(System.out);
            }
        }
        if (object7 == null) {
            object7 = object6;
        }
        object4 = new byte[4];
        if (n >= 16 && n < 32) {
            long l = -4294967296L >>> n;
            for (int i = 3; i >= 0; --i) {
                object4[i] = (byte)(l & 0xFFL);
                l >>= 8;
            }
        } else {
            object4[0] = -1;
            object4[1] = -1;
            object4[2] = -1;
            object4[3] = false;
        }
        Object[] objectArray = null;
        try {
            object = new Hashtable<String, String>();
            ((Hashtable)object).put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            Object obj = new InitialDirContext((Hashtable<?, ?>)object).getEnvironment().get("java.naming.provider.url");
            if (obj != null && (object3 = obj.toString()) != null && (object2 = ((String)object3).split("\\s")) != null) {
                int n3 = 0;
                for (String string : object2) {
                    byte[] byArray3;
                    if (string.length() <= 6 || !string.startsWith("dns://") || (byArray3 = NetConfig.getIpAddr(string.substring(6))) == null) continue;
                    if (object5 != null) {
                        int n2 = 0;
                        int n4 = Math.min(byArray3.length, ((Object)object5).length);
                        for (int i = 0; i < n4 && byArray3[i] == object5[i]; ++i) {
                            ++n2;
                        }
                        if (n3 != 0 && n2 <= n3) continue;
                        objectArray = byArray3;
                        n3 = n2;
                        continue;
                    }
                    objectArray = byArray3;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (objectArray == null && Main.isUnixLikeOS()) {
            object = null;
            try {
                object = new BufferedReader(new FileReader("/etc/resolv.conf"));
                String string = ((BufferedReader)object).readLine();
                while (objectArray == null && string != null) {
                    int n6 = (string = string.trim().toLowerCase()).indexOf(35);
                    if (n6 != 0) {
                        if (n6 > 0) {
                            string = string.substring(0, n6);
                        }
                        if (string.startsWith("nameserver") && (object2 = string.split("\\s")) != null) {
                            for (int i = 1; i < ((String[])object2).length && (objectArray = (Object[])NetConfig.getIpAddr(object2[i])) == null; ++i) {
                            }
                        }
                    }
                    string = ((BufferedReader)object).readLine();
                }
            }
            catch (IOException iOException) {
            }
            catch (PatternSyntaxException patternSyntaxException) {
            }
            finally {
                EmuUtil.closeSilent((Closeable)object);
            }
        }
        if ((object = (Object)NetConfig.getIpAddrByProp("jkcemu.kcnet.ip_address")) != null) {
            object5 = object;
        }
        if ((byArray = NetConfig.getIpAddrByProp("jkcemu.kcnet.subnet_mask")) != null) {
            object4 = byArray;
        }
        byte[] byArray4 = NetConfig.getIpAddrByProp("jkcemu.kcnet.gateway");
        object2 = NetConfig.getIpAddrByProp("jkcemu.kcnet.dns_server");
        if (object2 != null) {
            objectArray = object2;
        }
        return new NetConfig((byte[])object7, (byte[])object5, (byte[])object4, (byte[])objectArray, (byte[])object, byArray, byArray4, (byte[])object2);
    }

    public static byte[] getIpAddr(String string) {
        byte[] byArray;
        block6: {
            byArray = null;
            if (string != null && !(string = string.trim()).isEmpty()) {
                try {
                    String[] stringArray = string.split("\\.", 5);
                    if (stringArray == null || stringArray.length != 4) break block6;
                    byArray = new byte[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        int n = Integer.parseInt(stringArray[i]);
                        if (n < 0 || n > 255) {
                            byArray = null;
                            break;
                        }
                        byArray[i] = (byte)n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
        }
        return byArray;
    }

    private NetConfig(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, byte[] byArray7, byte[] byArray8) {
        this.hwAddr = byArray;
        this.ipAddr = byArray2;
        this.subnetMask = byArray3;
        this.dnsServerIpAddr = byArray4;
        this.manualIpAddr = byArray5;
        this.manualSubnetMask = byArray6;
        this.manualGatewayIpAddr = byArray7;
        this.manualDnsServerIpAddr = byArray8;
    }

    private static byte[] getIpAddrByProp(String string) {
        String string2 = Main.getProperty(string);
        return string2 != null ? NetConfig.getIpAddr(string2) : null;
    }
}

