/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.net;

import java.util.Arrays;
import jkcemu.Main;
import jkcemu.net.NetConfig;
import jkcemu.net.W5100;
import z80emu.Z80CPU;
import z80emu.Z80InterruptSource;
import z80emu.Z80MaxSpeedListener;
import z80emu.Z80PIO;
import z80emu.Z80PIOPortListener;
import z80emu.Z80TStatesListener;

public class KCNet
implements Z80InterruptSource,
Z80MaxSpeedListener,
Z80PIOPortListener,
Z80TStatesListener {
    public static final String PROP_PREFIX = "jkcemu.kcnet.";
    public static final String PROP_AUTOCONFIG = "auto_config";
    public static final String PROP_IP_ADDR = "ip_address";
    public static final String PROP_SUBNET_MASK = "subnet_mask";
    public static final String PROP_GATEWAY = "gateway";
    public static final String PROP_DNS_SERVER = "dns_server";
    public static final String SYSPROP_DEBUG = "jkcemu.debug.net";
    public static final boolean DEFAULT_AUTOCONFIG = true;
    private static final int HW_VERSION = 258;
    private static final int SW_VERSION = 258;
    private static final int PORT_NUM_MIN = 49152;
    private static final int PORT_NUM_MAX = 65535;
    private static final String ID_TEXT = "###     KCNET     ### \r\n WIZnet TCP/IP-Stack  \r\n###   by JKCEMU   ### \r\n";
    private static final int DEBUG_MASK_MSG = 1;
    private static final int DEBUG_MASK_CMD = 2;
    private static final int DEBUG_MASK_READ = 4;
    private static final int DEBUG_MASK_WRITE = 8;
    private static Command[] commands = new Command[]{Command.WRITE_BYTES, Command.READ_BYTES, Command.WRITE_ADDR, Command.READ_TIMER, Command.WRITE_BYTE, Command.READ_BYTE, Command.WRITE_IP_ADDR, Command.READ_IP_ADDR, Command.READ_NEXT_PORT_NUM, Command.READ_SW_VERSION, Command.READ_HW_VERSION, Command.READ_LINK_STATUS, Command.READ_ID, Command.READ_ERROR_CNT};
    private static byte[] idBytes = null;
    private String title;
    private Command cmd;
    private int debugMask;
    private int[] args;
    private int argIdx;
    private int curAddr;
    private int byteCnt;
    private int errorCnt;
    private int portSeqNum;
    private int tStatesPerMilli;
    private long tStatesCounterValue;
    private long tStatesCounterWrap;
    private long tStatesToTimeout;
    private int resultPos;
    private byte[] resultBytes;
    private byte[] doubleByteBuf;
    private byte[] emptyIpAddr;
    private byte[][] ipAddrMem;
    private W5100 w5100;
    private Z80PIO pio;

    public KCNet(String string) {
        this.title = string;
        this.debugMask = 0;
        this.portSeqNum = 49152;
        this.args = new int[5];
        this.doubleByteBuf = new byte[2];
        this.emptyIpAddr = new byte[4];
        Arrays.fill(this.emptyIpAddr, (byte)0);
        this.ipAddrMem = new byte[8][];
        for (int i = 0; i < this.ipAddrMem.length; ++i) {
            this.ipAddrMem[i] = new byte[4];
        }
        this.w5100 = new W5100();
        this.pio = new Z80PIO(string);
        this.pio.addPIOPortListener((Z80PIOPortListener)this, Z80PIO.PortInfo.A);
        String string2 = System.getProperty(SYSPROP_DEBUG);
        if (string2 != null) {
            try {
                this.debugMask = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void die() {
        this.pio.removePIOPortListener((Z80PIOPortListener)this, Z80PIO.PortInfo.A);
        this.w5100.die();
    }

    public static boolean getAutoConfig() {
        return Main.getBooleanProperty("jkcemu.kcnet.auto_config", true);
    }

    public int read(int n) {
        int n2 = -1;
        switch (n & 3) {
            case 0: {
                n2 = this.pio.readDataA();
                if ((this.debugMask & 4) == 0) break;
                System.out.printf("KCNet read: %02X\n", n2);
                break;
            }
            case 1: {
                n2 = this.pio.readDataB();
                break;
            }
            case 2: {
                n2 = this.pio.readControlA();
                break;
            }
            case 3: {
                n2 = this.pio.readControlB();
            }
        }
        return n2;
    }

    public void write(int n, int n2) {
        switch (n & 3) {
            case 0: {
                if ((this.debugMask & 8) != 0) {
                    System.out.printf("KCNet write: %02X\n", n2);
                }
                this.pio.writeDataA(n2);
                break;
            }
            case 1: {
                this.pio.writeDataB(n2);
                break;
            }
            case 2: {
                this.pio.writeControlA(n2);
                break;
            }
            case 3: {
                this.pio.writeControlB(n2);
            }
        }
    }

    @Override
    public void appendInterruptStatusHTMLTo(StringBuilder stringBuilder) {
        this.pio.appendInterruptStatusHTMLTo(stringBuilder);
    }

    @Override
    public synchronized int interruptAccept() {
        return this.pio.interruptAccept();
    }

    @Override
    public synchronized void interruptFinish() {
        if (this.pio.isInterruptAccepted()) {
            this.pio.interruptFinish();
        }
    }

    @Override
    public boolean isInterruptAccepted() {
        return this.pio.isInterruptAccepted();
    }

    @Override
    public boolean isInterruptRequested() {
        return this.pio.isInterruptRequested();
    }

    @Override
    public void reset(boolean bl) {
        if ((this.debugMask & 1) != 0) {
            System.out.printf("KCNet reset: power_on=%b\n", bl);
        }
        this.pio.reset(bl);
        this.w5100.reset(bl);
        this.setIdle();
        if (bl) {
            this.curAddr = 0;
            this.errorCnt = 0;
            this.tStatesCounterValue = 0L;
            for (byte[] byArray : this.ipAddrMem) {
                Arrays.fill(byArray, (byte)0);
            }
            Object object = this.w5100.getNetConfig();
            if (object != null) {
                byte[] byArray = null;
                byArray = KCNet.getAutoConfig() ? ((NetConfig)object).getDnsServerIpAddr() : ((NetConfig)object).getManualDnsServerIpAddr();
                if (byArray != null) {
                    if (byArray.length != 4) {
                        byArray = null;
                    }
                    if (byArray != null) {
                        for (int i = 0; i < byArray.length; ++i) {
                            this.ipAddrMem[0][i] = byArray[i];
                        }
                    }
                }
            }
        }
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        this.tStatesPerMilli = z80CPU.getMaxSpeedKHz();
        this.tStatesCounterWrap = (long)this.tStatesPerMilli * 60000L;
    }

    @Override
    public synchronized void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        if (this.tStatesCounterWrap > 0L) {
            long l;
            for (l = this.tStatesCounterValue + (long)n; l > this.tStatesCounterWrap; l -= this.tStatesCounterWrap) {
            }
            this.tStatesCounterValue = l;
            if (this.tStatesToTimeout > 0L) {
                this.tStatesToTimeout -= (long)n;
                if (this.tStatesToTimeout <= 0L) {
                    if ((this.debugMask & 1) != 0) {
                        System.out.println("KCNet timeout");
                    }
                    this.errorCnt = this.errorCnt + 1 & 0xFFFF;
                    this.reset(false);
                }
            }
        }
    }

    @Override
    public void z80PIOPortStatusChanged(Z80PIO z80PIO, Z80PIO.PortInfo portInfo, Z80PIO.Status status) {
        if (z80PIO == this.pio && portInfo == Z80PIO.PortInfo.A) {
            if (status == Z80PIO.Status.OUTPUT_AVAILABLE) {
                this.stopTimeoutTimer();
                this.pio.putInValuePortB(1, 1);
                int n = this.pio.fetchOutValuePortA(true);
                this.pio.putInValuePortB(0, 1);
                this.writeByte(n);
            } else if (status == Z80PIO.Status.READY_FOR_INPUT) {
                this.stopTimeoutTimer();
                this.pio.putInValuePortB(0, 128);
                int n = this.fetchNextResultByte();
                if (n >= 0) {
                    this.setResultByte(n);
                } else if (this.cmd == Command.READ_BYTES && this.byteCnt > 0) {
                    n = this.readMemByte(this.curAddr);
                    this.incCurAddr();
                    --this.byteCnt;
                    this.setResultByte(n);
                } else {
                    this.setIdle();
                }
            }
        }
    }

    public String toString() {
        return this.title;
    }

    private void writeByte(int n) {
        n &= 0xFF;
        block0 : switch (this.cmd) {
            case NONE: {
                this.argIdx = 0;
                if (n < 0 || n >= commands.length) break;
                Command command = commands[n];
                if ((this.debugMask & 2) != 0) {
                    System.out.print("  ");
                    System.out.println((Object)command);
                }
                switch (command) {
                    case READ_TIMER: {
                        long l = 0L;
                        long l2 = this.tStatesCounterValue;
                        long l3 = this.tStatesPerMilli;
                        if (l2 > 0L && l3 > 0L) {
                            l = l2 / l3 % 60000L;
                        }
                        this.setResultInt16((int)l);
                        break block0;
                    }
                    case READ_NEXT_PORT_NUM: {
                        int n2 = this.w5100.reservePort();
                        if (n2 <= 0) {
                            n2 = this.portSeqNum++;
                            if (this.portSeqNum > 65535) {
                                this.portSeqNum = 49152;
                            }
                        }
                        this.doubleByteBuf[0] = (byte)(n2 >> 8 & 0xFF);
                        this.doubleByteBuf[1] = (byte)(n2 & 0xFF);
                        this.setResultBytes(this.doubleByteBuf);
                        break block0;
                    }
                    case READ_SW_VERSION: {
                        this.setResultInt16(258);
                        break block0;
                    }
                    case READ_HW_VERSION: {
                        this.setResultInt16(258);
                        break block0;
                    }
                    case READ_LINK_STATUS: {
                        this.setResultByte(1);
                        break block0;
                    }
                    case READ_ID: {
                        this.setResultBytes(KCNet.getIDBytes());
                        break block0;
                    }
                    case READ_ERROR_CNT: {
                        this.setResultInt16(this.errorCnt);
                        break block0;
                    }
                }
                this.cmd = command;
                this.restartTimeoutTimer();
                break;
            }
            case WRITE_BYTES: {
                if (this.argIdx == 0) {
                    this.args[this.argIdx++] = n;
                    this.restartTimeoutTimer();
                    break;
                }
                if (this.argIdx == 1) {
                    this.byteCnt = n << 8 & 0xFF00 | this.args[0] & 0xFF;
                    if (this.byteCnt > 0) {
                        ++this.argIdx;
                        break;
                    }
                    this.setIdle();
                    break;
                }
                if (this.byteCnt > 0) {
                    this.writeMemByte(this.curAddr, n);
                    this.incCurAddr();
                    --this.byteCnt;
                }
                if (this.byteCnt > 0) {
                    this.restartTimeoutTimer();
                    break;
                }
                this.setIdle();
                break;
            }
            case READ_BYTES: {
                if (this.argIdx == 0) {
                    this.args[this.argIdx++] = n;
                    break;
                }
                if (this.argIdx == 1) {
                    this.byteCnt = n << 8 & 0xFF00 | this.args[0] & 0xFF;
                    if (this.byteCnt > 0) {
                        this.setResultByte(this.readMemByte(this.curAddr));
                        this.incCurAddr();
                        --this.byteCnt;
                        break;
                    }
                    this.setIdle();
                    break;
                }
                this.setIdle();
                break;
            }
            case WRITE_ADDR: {
                if (this.argIdx == 0) {
                    this.args[this.argIdx++] = n;
                    this.restartTimeoutTimer();
                    break;
                }
                if (this.argIdx == 1) {
                    this.curAddr = n << 8 & 0xFF00 | this.args[0] & 0xFF;
                    this.setIdle();
                    break;
                }
                this.setIdle();
                break;
            }
            case WRITE_BYTE: {
                if (this.argIdx < 2) {
                    this.args[this.argIdx++] = n;
                    this.restartTimeoutTimer();
                    break;
                }
                int n3 = this.args[1] << 8 & 0xFF00 | this.args[0] & 0xFF;
                this.writeMemByte(n3, n);
                this.setIdle();
                break;
            }
            case READ_BYTE: {
                if (this.argIdx == 0) {
                    this.args[this.argIdx++] = n;
                    this.restartTimeoutTimer();
                    break;
                }
                this.setIdle();
                this.setResultByte(this.readMemByte(n << 8 & 0xFF00 | this.args[0] & 0xFF));
                break;
            }
            case WRITE_IP_ADDR: {
                if (this.argIdx < 4) {
                    this.args[this.argIdx++] = n;
                    this.restartTimeoutTimer();
                    break;
                }
                int n4 = this.args[0];
                if (n4 < this.ipAddrMem.length) {
                    this.ipAddrMem[n4][0] = (byte)this.args[1];
                    this.ipAddrMem[n4][1] = (byte)this.args[2];
                    this.ipAddrMem[n4][2] = (byte)this.args[3];
                    this.ipAddrMem[n4][3] = (byte)n;
                }
                this.setIdle();
                break;
            }
            case READ_IP_ADDR: {
                if (this.argIdx == 0) {
                    this.setIdle();
                    if (n < this.ipAddrMem.length) {
                        this.setResultBytes(this.ipAddrMem[n]);
                        break;
                    }
                    this.setResultBytes(this.emptyIpAddr);
                    break;
                }
                this.setIdle();
                break;
            }
            default: {
                this.setIdle();
            }
        }
    }

    private synchronized int fetchNextResultByte() {
        int n = -1;
        if (this.resultBytes != null) {
            if (this.resultPos >= 0 && this.resultPos < this.resultBytes.length) {
                n = this.resultBytes[this.resultPos++] & 0xFF;
                if (this.resultPos >= this.resultBytes.length) {
                    this.resultBytes = null;
                    this.resultPos = -1;
                }
            } else {
                this.resultBytes = null;
                this.resultPos = -1;
            }
        }
        return n;
    }

    private static byte[] getIDBytes() {
        if (idBytes == null) {
            int n = ID_TEXT.length();
            byte[] byArray = new byte[n + 1];
            for (int i = 0; i < n; ++i) {
                byArray[i] = (byte)(ID_TEXT.charAt(i) & 0xFF);
            }
            byArray[i] = 0;
            idBytes = byArray;
        }
        return idBytes;
    }

    private void incCurAddr() {
        this.curAddr = this.curAddr + 1 & 0xFFFF;
    }

    private int readMemByte(int n) {
        return n >= 32768 ? this.w5100.readMemByte(n & Short.MAX_VALUE) : 0;
    }

    private void restartTimeoutTimer() {
        this.tStatesToTimeout = (long)this.tStatesPerMilli * 524L;
    }

    private synchronized void setIdle() {
        this.stopTimeoutTimer();
        this.cmd = Command.NONE;
        this.argIdx = 0;
        this.byteCnt = 0;
        this.resultPos = -1;
        this.resultBytes = null;
        this.pio.putInValuePortB(0, false);
    }

    private void setResultByte(int n) {
        this.pio.putInValuePortA(n, false);
        this.pio.putInValuePortB(128, 128);
        this.pio.putInValuePortA(n, true);
        this.restartTimeoutTimer();
    }

    private synchronized void setResultBytes(byte[] byArray) {
        this.resultBytes = byArray;
        this.resultPos = 0;
        int n = this.fetchNextResultByte();
        if (n >= 0) {
            this.setResultByte(n);
        }
    }

    private void setResultInt16(int n) {
        this.doubleByteBuf[0] = (byte)(n & 0xFF);
        this.doubleByteBuf[1] = (byte)(n >> 8 & 0xFF);
        this.setResultBytes(this.doubleByteBuf);
    }

    private void stopTimeoutTimer() {
        this.tStatesToTimeout = 0L;
    }

    private void writeMemByte(int n, int n2) {
        if (n >= 32768) {
            this.w5100.writeMemByte(n & Short.MAX_VALUE, n2);
        }
    }

    private static enum Command {
        NONE,
        WRITE_BYTES,
        READ_BYTES,
        WRITE_ADDR,
        READ_TIMER,
        WRITE_BYTE,
        READ_BYTE,
        WRITE_IP_ADDR,
        READ_IP_ADDR,
        READ_NEXT_PORT_NUM,
        READ_SW_VERSION,
        READ_HW_VERSION,
        READ_LINK_STATUS,
        READ_ID,
        READ_ERROR_CNT;

    }
}

