/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import jkcemu.base.EmuUtil;
import jkcemu.net.NetConfig;
import jkcemu.net.W5100;

public class DhcpProcess {
    public static final int SERVER_PORT = 67;
    public static final int CLIENT_PORT = 68;
    private static final int MT_DISCOVER = 1;
    private static final int MT_OFFER = 2;
    private static final int MT_REQUEST = 3;
    private static final int MT_ACK = 5;
    private static final int TTL_DEFAULT = 64;
    private static final int TIMEOUT_MILLIS = 1000;
    private static final String SERVER_NAME = "jkcemu-dhcp-server";
    private byte[] clientIpAddr;
    private byte[] serverIpAddr;
    private byte[] answerBytes;
    private long begMillis;
    private boolean answerValid;
    private boolean requestReceived;
    private boolean finished;

    public static DhcpProcess checkDiscover(W5100 w5100, DatagramPacket datagramPacket) {
        DhcpProcess dhcpProcess = null;
        byte[] byArray = datagramPacket.getData();
        if (byArray != null && datagramPacket.getPort() == 67 && byArray.length > 240 && byArray[0] == 1) {
            NetConfig netConfig;
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            if (byArray[236] == 99 && byArray[237] == -126 && byArray[238] == 83 && byArray[239] == 99) {
                int n4;
                int n5 = 240;
                while (n5 < byArray.length && (n4 = byArray[n5++] & 0xFF) != 255) {
                    if (n4 == 0 || n5 >= byArray.length) continue;
                    int n6 = byArray[n5++] & 0xFF;
                    switch (n4) {
                        case 53: {
                            if (n5 >= byArray.length) break;
                            n = byArray[n5] & 0xFF;
                            break;
                        }
                        case 55: {
                            n2 = n5;
                            n3 = n6;
                        }
                    }
                    n5 += n6;
                }
            }
            if (n == 1 && (netConfig = w5100.getNetConfig()) != null) {
                byte[] byArray2 = netConfig.getIpAddr();
                byte[] byArray3 = netConfig.getSubnetMask();
                if (byArray2 != null && byArray3 != null && byArray2.length == 4 && byArray3.length == 4) {
                    byte[] byArray4 = new byte[]{byArray2[0], byArray2[1], byArray2[2], byArray2[3] == 99 ? (byte)111 : 99};
                    try {
                        int n7;
                        int n8;
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                        byteArrayOutputStream.write(2);
                        byteArrayOutputStream.write(byArray[1]);
                        byteArrayOutputStream.write(byArray[2]);
                        byteArrayOutputStream.write(0);
                        for (n8 = 4; n8 < 8; ++n8) {
                            byteArrayOutputStream.write(byArray[n8]);
                        }
                        byteArrayOutputStream.write(0);
                        byteArrayOutputStream.write(0);
                        byteArrayOutputStream.write(byArray[10]);
                        byteArrayOutputStream.write(byArray[11]);
                        for (n8 = 0; n8 < 4; ++n8) {
                            byteArrayOutputStream.write(0);
                        }
                        byteArrayOutputStream.write(byArray2);
                        byteArrayOutputStream.write(byArray4);
                        for (n8 = 24; n8 < 44; ++n8) {
                            byteArrayOutputStream.write(byArray[n8]);
                        }
                        n8 = SERVER_NAME.length();
                        for (n7 = 0; n7 < n8; ++n7) {
                            byteArrayOutputStream.write(SERVER_NAME.charAt(n7));
                        }
                        for (n7 = n8; n7 < 64; ++n7) {
                            byteArrayOutputStream.write(0);
                        }
                        for (n7 = 0; n7 < 128; ++n7) {
                            byteArrayOutputStream.write(0);
                        }
                        DhcpProcess.writeBytesTo(byteArrayOutputStream, 99, 130, 83, 99, 53, 1, 2, 54, 4);
                        byteArrayOutputStream.write(byArray4);
                        DhcpProcess.writeBytesTo(byteArrayOutputStream, 51, 4, 0, 1, 81, 128, 58, 4, 0, 0, 168, 192, 59, 4, 0, 1, 39, 80, 1, 4);
                        byteArrayOutputStream.write(byArray3);
                        byte[] byArray5 = netConfig.getDnsServerIpAddr();
                        if (byArray5 != null && byArray5.length == 4) {
                            DhcpProcess.writeBytesTo(byteArrayOutputStream, 6, 4);
                            byteArrayOutputStream.write(byArray5);
                        }
                        if (n2 > 0 && n3 > 0) {
                            int n9 = n2;
                            while (n3 > 0 && n9 < byArray.length) {
                                int n10 = byArray[n9++] & 0xFF;
                                switch (n10) {
                                    case 23: 
                                    case 37: {
                                        byteArrayOutputStream.write(n10);
                                        byteArrayOutputStream.write(1);
                                        byteArrayOutputStream.write(64);
                                    }
                                }
                                --n3;
                            }
                        }
                        byteArrayOutputStream.write(255);
                        dhcpProcess = new DhcpProcess(byArray2, byArray4, byteArrayOutputStream.toByteArray());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return dhcpProcess;
    }

    public synchronized boolean fillAnswerToClientInto(DatagramPacket datagramPacket) throws IOException {
        boolean bl = false;
        if (this.answerValid) {
            datagramPacket.setAddress(InetAddress.getByAddress(this.serverIpAddr));
            datagramPacket.setPort(67);
            datagramPacket.setData(this.answerBytes);
            this.answerValid = false;
            if (this.requestReceived) {
                this.finished = true;
            }
            bl = true;
        }
        return bl;
    }

    public boolean hasFinished() {
        return this.finished;
    }

    public boolean processRequest(DatagramPacket datagramPacket) {
        byte[] byArray = datagramPacket.getData();
        if (byArray != null && datagramPacket.getPort() == 67 && byArray.length > 240 && byArray[0] == 1) {
            int n;
            int n2 = -1;
            int n3 = 20;
            if (byArray[236] == 99 && byArray[237] == -126 && byArray[238] == 83 && byArray[239] == 99) {
                int n4;
                n = 240;
                while (n < byArray.length && (n4 = byArray[n++] & 0xFF) != 255) {
                    if (n4 == 0 || n >= byArray.length) continue;
                    int n5 = byArray[n++] & 0xFF;
                    switch (n4) {
                        case 53: {
                            if (n >= byArray.length) break;
                            n2 = byArray[n] & 0xFF;
                            break;
                        }
                        case 54: {
                            if (n + 3 >= byArray.length || n5 != 4) break;
                            boolean bl = false;
                            for (int i = 20; i < 24; ++i) {
                                if (byArray[i] == 0) continue;
                                bl = true;
                                break;
                            }
                            if (bl) break;
                            n3 = n;
                        }
                    }
                    n += n5;
                }
            }
            if (n2 == 3 && EmuUtil.equalsRegion(byArray, 4, this.answerBytes, 4, 4) && EmuUtil.equalsRegion(byArray, n3, this.answerBytes, 20, 4) && EmuUtil.equalsRegion(byArray, 28, this.answerBytes, 28, 16)) {
                for (n = 10; n < 16; ++n) {
                    this.answerBytes[n] = byArray[n];
                }
                for (n = 24; n < 28; ++n) {
                    this.answerBytes[n] = byArray[n];
                }
                this.answerBytes[242] = 5;
                this.requestReceived = true;
                this.answerValid = true;
            }
        }
        return this.requestReceived;
    }

    public boolean isTimeout() {
        return this.begMillis + 1000L < System.currentTimeMillis();
    }

    private DhcpProcess(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.clientIpAddr = byArray;
        this.serverIpAddr = byArray2;
        this.answerBytes = byArray3;
        this.answerValid = true;
        this.requestReceived = false;
        this.finished = false;
        this.begMillis = System.currentTimeMillis();
    }

    private static void writeBytesTo(OutputStream outputStream, int ... nArray) throws IOException {
        for (int n : nArray) {
            outputStream.write(n);
        }
    }
}

