/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.joystick;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import jkcemu.Main;
import jkcemu.base.BaseFrm;
import jkcemu.base.EmuThread;
import jkcemu.base.HelpFrm;
import jkcemu.joystick.JoystickActionFld;

public class JoystickFrm
extends BaseFrm {
    private static final String HELP_PAGE = "/help/joystick.htm";
    private static final String TEXT_NOT_EMULATED = "Nicht emuliert";
    private static final String TEXT_NOT_CONNECTED = "Nicht verbunden";
    private static final String TEXT_CONNECTED = "Aktiv";
    private static final String TEXT_CONNECT = "Verbinden";
    private static final String TEXT_DISCONNECT = "Trennen";
    private static JoystickFrm instance = null;
    private EmuThread emuThread;
    private JPanel panel0;
    private JPanel panel1;
    private JLabel labelStatus0;
    private JLabel labelStatus1;
    private JoystickActionFld joyFld0;
    private JoystickActionFld joyFld1;
    private JButton btnConnect0;
    private JButton btnConnect1;
    private JMenuItem mnuClose;
    private JMenuItem mnuHelpContent;

    public static void open(EmuThread emuThread) {
        if (instance != null) {
            if (instance.getExtendedState() == 1) {
                instance.setExtendedState(0);
            }
        } else {
            instance = new JoystickFrm(emuThread);
        }
        instance.toFront();
        instance.setVisible(true);
    }

    public void setJoystickAction(int n, int n2) {
        if (n == 0) {
            this.joyFld0.setJoystickAction(n2);
        } else if (n == 1) {
            this.joyFld1.setJoystickAction(n2);
        }
    }

    public void setJoystickState(int n, boolean bl, boolean bl2) {
        String string = TEXT_CONNECT;
        String string2 = TEXT_NOT_EMULATED;
        if (bl) {
            if (bl2) {
                string = TEXT_DISCONNECT;
                string2 = TEXT_CONNECTED;
            } else {
                string2 = TEXT_NOT_CONNECTED;
            }
        }
        if (n == 0) {
            this.labelStatus0.setText(string2);
            this.joyFld0.setEnabled(bl);
            this.btnConnect0.setText(string);
            this.btnConnect0.setEnabled(bl);
        } else if (n == 1) {
            this.labelStatus1.setText(string2);
            this.joyFld1.setEnabled(bl);
            this.btnConnect1.setText(string);
            this.btnConnect1.setEnabled(bl);
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject != null) {
            Object object = eventObject.getSource();
            if (object == this.btnConnect0) {
                bl = true;
                this.doConnect(0);
            } else if (object == this.btnConnect1) {
                bl = true;
                this.doConnect(1);
            } else if (object == this.mnuClose) {
                bl = true;
                this.doClose();
            } else if (object == this.mnuHelpContent) {
                bl = true;
                HelpFrm.open(HELP_PAGE);
            }
        }
        return bl;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component == this.joyFld0) {
            this.emuThread.setJoystickAction(0, this.joyFld0.getJoystickAction(mouseEvent.getX(), mouseEvent.getY()));
            mouseEvent.consume();
        } else if (component == this.joyFld1) {
            this.emuThread.setJoystickAction(1, this.joyFld1.getJoystickAction(mouseEvent.getX(), mouseEvent.getY()));
            mouseEvent.consume();
        } else {
            super.mousePressed(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component == this.joyFld0) {
            this.emuThread.setJoystickAction(0, 0);
            mouseEvent.consume();
        } else if (component == this.joyFld1) {
            this.emuThread.setJoystickAction(1, 0);
            mouseEvent.consume();
        } else {
            super.mousePressed(mouseEvent);
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this) {
            Main.setWindowActivated(2);
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this) {
            Main.setWindowDeactivated(2);
        }
    }

    private JoystickFrm(EmuThread emuThread) {
        this.emuThread = emuThread;
        this.setTitle("JKCEMU Joysticks");
        Main.updIcon(this);
        JMenu jMenu = new JMenu("Datei");
        jMenu.setMnemonic(68);
        this.mnuClose = this.createJMenuItem("Schlie\u00dfen");
        jMenu.add(this.mnuClose);
        JMenu jMenu2 = new JMenu("?");
        this.mnuHelpContent = this.createJMenuItem("Hilfe...");
        jMenu2.add(this.mnuHelpContent);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0);
        this.labelStatus0 = new JLabel(TEXT_NOT_CONNECTED);
        this.joyFld0 = new JoystickActionFld();
        this.btnConnect0 = new JButton(TEXT_CONNECT);
        this.btnConnect0.addActionListener(this);
        this.panel0 = this.createJoystickPanel(this.labelStatus0, this.joyFld0, this.btnConnect0, "Joystick 1");
        this.add((Component)this.panel0, gridBagConstraints);
        this.labelStatus1 = new JLabel(TEXT_NOT_CONNECTED);
        this.joyFld1 = new JoystickActionFld();
        this.btnConnect1 = new JButton(TEXT_CONNECT);
        this.btnConnect1.addActionListener(this);
        this.panel1 = this.createJoystickPanel(this.labelStatus1, this.joyFld1, this.btnConnect1, "Joystick 2");
        ++gridBagConstraints.gridx;
        this.add((Component)this.panel1, gridBagConstraints);
        this.pack();
        if (!this.applySettings(Main.getProperties(), false)) {
            this.setLocationByPlatform(true);
        }
        this.setResizable(false);
        Dimension dimension = this.panel0.getPreferredSize();
        if (dimension != null) {
            this.panel0.setPreferredSize(dimension);
        }
        if ((dimension = this.panel1.getPreferredSize()) != null) {
            this.panel1.setPreferredSize(dimension);
        }
        if (this.emuThread != null) {
            this.emuThread.setJoystickFrm(this);
            this.joyFld0.addMouseListener(this);
            this.joyFld1.addMouseListener(this);
        }
    }

    private JPanel createJoystickPanel(JLabel jLabel, JoystickActionFld joystickActionFld, JButton jButton, String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        jPanel.add(jLabel);
        gridBagConstraints.anchor = 10;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)joystickActionFld, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jButton, gridBagConstraints);
        return jPanel;
    }

    private void doConnect(int n) {
        if (this.emuThread != null) {
            this.emuThread.changeJoystickConnectState(n);
        }
    }
}

