/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.image.ImageFrm;

public class ScaleDlg
extends BaseDlg
implements ChangeListener {
    private static boolean lastKeepColorTab = false;
    private static boolean lastKeepRatio = true;
    private BufferedImage image;
    private Double ratio;
    private boolean rotated90Degrees;
    private BufferedImage scaledImage;
    private JSpinner spinnerWidth;
    private JSpinner spinnerHeight;
    private JSpinner lastChangeSource;
    private JCheckBox btnKeepRatio;
    private JButton btnScale;
    private JButton btnCancel;

    public static BufferedImage showDlg(ImageFrm imageFrm, BufferedImage bufferedImage) {
        ScaleDlg scaleDlg = new ScaleDlg(imageFrm, bufferedImage);
        scaleDlg.setVisible(true);
        return scaleDlg.scaledImage;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.ratio != null && this.btnKeepRatio.isSelected()) {
            this.keepRatio(changeEvent.getSource());
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object == this.btnScale) {
            bl = true;
            this.doScale();
        } else if (object == this.btnCancel) {
            bl = true;
            this.doClose();
        } else if (object == this.btnKeepRatio) {
            bl = true;
            this.doKeepRatio();
        }
        return bl;
    }

    private ScaleDlg(ImageFrm imageFrm, BufferedImage bufferedImage) {
        super((Window)imageFrm, "Skalieren");
        this.image = bufferedImage;
        this.ratio = null;
        this.scaledImage = null;
        this.lastChangeSource = null;
        this.rotated90Degrees = imageFrm.getImgFld().isRotated90Degrees();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (n > 0 && n2 > 0) {
            if (this.rotated90Degrees) {
                int n3 = n;
                n = n2;
                n2 = n3;
            }
            this.ratio = (double)n / (double)n2;
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.add((Component)new JLabel("Neue Breite:"), gridBagConstraints);
        this.spinnerWidth = new JSpinner(new SpinnerNumberModel(n > 0 ? n : 640, 1, Math.max(n, 9999), 1));
        gridBagConstraints.insets.left = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.spinnerWidth, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)new JLabel("Pixel"), gridBagConstraints);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Neue H\u00f6he:"), gridBagConstraints);
        this.spinnerHeight = new JSpinner(new SpinnerNumberModel(n2 > 0 ? n2 : 480, 1, Math.max(n, 9999), 1));
        gridBagConstraints.insets.left = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.spinnerHeight, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)new JLabel("Pixel"), gridBagConstraints);
        this.btnKeepRatio = new JCheckBox("Seitenverh\u00e4ltnis beibehalten");
        if (this.ratio != null) {
            this.btnKeepRatio.setSelected(lastKeepRatio);
        } else {
            this.btnKeepRatio.setEnabled(false);
        }
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnKeepRatio, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        this.btnScale = new JButton("Skalieren");
        jPanel.add(this.btnScale);
        this.btnCancel = new JButton("Abbrechen");
        jPanel.add(this.btnCancel);
        this.pack();
        this.setParentCentered();
        this.setResizable(false);
        if (this.btnKeepRatio.isEnabled()) {
            this.btnKeepRatio.addActionListener(this);
            this.spinnerWidth.addChangeListener(this);
            this.spinnerHeight.addChangeListener(this);
        }
        this.btnScale.addActionListener(this);
        this.btnCancel.addActionListener(this);
    }

    private void doKeepRatio() {
        if (this.ratio != null && this.btnKeepRatio.isSelected()) {
            this.keepRatio(this.lastChangeSource != null ? this.lastChangeSource : this.spinnerWidth);
        }
    }

    private void doScale() {
        int n = EmuUtil.getInt(this.spinnerWidth);
        int n2 = EmuUtil.getInt(this.spinnerHeight);
        if (n > 0 && n2 > 0) {
            int n3;
            if (this.rotated90Degrees) {
                n3 = n;
                n = n2;
                n2 = n3;
            }
            if ((n3 = this.image.getType()) != 10 && n3 != 11) {
                n3 = this.image.getTransparency() == 1 ? 5 : 2;
            }
            BufferedImage bufferedImage = new BufferedImage(n, n2, n3);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(this.image.getScaledInstance(n, n2, 4), 0, 0, this);
            graphics2D.dispose();
            this.scaledImage = bufferedImage;
            if (this.btnKeepRatio.isEnabled()) {
                lastKeepRatio = this.btnKeepRatio.isSelected();
            }
            this.doClose();
        }
    }

    private void keepRatio(Object object) {
        if (object == this.spinnerWidth) {
            this.lastChangeSource = this.spinnerWidth;
            this.spinnerHeight.removeChangeListener(this);
            EmuUtil.setValue(this.spinnerHeight, (int)Math.round((double)EmuUtil.getInt(this.spinnerWidth) / this.ratio));
            this.spinnerHeight.addChangeListener(this);
        } else if (object == this.spinnerHeight) {
            this.lastChangeSource = this.spinnerHeight;
            this.spinnerWidth.removeChangeListener(this);
            EmuUtil.setValue(this.spinnerWidth, (int)Math.round((double)EmuUtil.getInt(this.spinnerHeight) * this.ratio));
            this.spinnerWidth.addChangeListener(this);
        }
    }
}

