/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;

public class RoundCornersDlg
extends BaseDlg {
    private int numTopPixels = 0;
    private int numBottomPixels = 0;
    private JSpinner spinnerTopPixels;
    private JSpinner spinnerBottomPixels;
    private JButton btnOK;
    private JButton btnCancel;

    public RoundCornersDlg(Window window, int n, int n2) {
        super(window, "Ecken abrunden");
        if (n < 0) {
            n = 0;
        } else if (n > 9) {
            n = 9;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 9) {
            n2 = 9;
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.add((Component)new JLabel("Obere Ecken:"), gridBagConstraints);
        this.spinnerTopPixels = new JSpinner(new SpinnerNumberModel(n, 0, 9, 1));
        gridBagConstraints.insets.left = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.spinnerTopPixels, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)new JLabel("Pixel"), gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Untere Ecken:"), gridBagConstraints);
        this.spinnerBottomPixels = new JSpinner(new SpinnerNumberModel(n2, 0, 9, 1));
        gridBagConstraints.insets.left = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.spinnerBottomPixels, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)new JLabel("Pixel"), gridBagConstraints);
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        this.btnOK = new JButton("OK");
        this.btnOK.addActionListener(this);
        jPanel.add(this.btnOK);
        this.btnCancel = new JButton("Abbrechen");
        this.btnCancel.addActionListener(this);
        jPanel.add(this.btnCancel);
        this.pack();
        this.setParentCentered();
        this.setResizable(false);
    }

    public int getNumTopPixels() {
        return this.numTopPixels;
    }

    public int getNumBottomPixels() {
        return this.numBottomPixels;
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        Object object;
        boolean bl = false;
        if (eventObject != null && (object = eventObject.getSource()) != null) {
            if (object == this.btnOK) {
                bl = true;
                this.doApply();
            } else if (object == this.btnCancel) {
                bl = true;
                this.doClose();
            }
        }
        return bl;
    }

    private void doApply() {
        this.numTopPixels = EmuUtil.getInt(this.spinnerTopPixels);
        this.numBottomPixels = EmuUtil.getInt(this.spinnerBottomPixels);
        this.doClose();
    }
}

