/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.filechooser.FileFilter;
import jkcemu.base.EmuUtil;
import jkcemu.emusys.KC85;
import jkcemu.image.IFFFile;
import jkcemu.image.ImgEntry;
import jkcemu.image.ImgFld;
import jkcemu.image.ImgUtil;
import jkcemu.image.KC85ImgUnpacker;
import jkcemu.text.TextUtil;

public class ImgLoader {
    private static final String[] kc85ImgFileSuffixes = new String[]{"hip", "pic", "pip"};
    private static String[] iioFileSuffixes = null;

    public static boolean accept(File file) {
        String string;
        boolean bl = false;
        if (file != null && (string = file.getName()) != null && !(bl = TextUtil.endsWith(string = string.toLowerCase(), ImgLoader.getIIOLowerFileSuffixes()))) {
            if (string.endsWith(".iff") || string.endsWith(".ilbm") || string.endsWith(".lbm")) {
                bl = true;
            } else if (file.length() == 16384L && string.endsWith(".pix")) {
                bl = true;
            } else if (file.length() > 7L && string.endsWith(".scr")) {
                bl = true;
            } else if (file.length() > 128L) {
                for (String string2 : kc85ImgFileSuffixes) {
                    if (!string.endsWith("." + string2)) continue;
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static FileFilter createFileFilter() {
        return ImgUtil.createFileFilter("Unterst\u00fctzte Bilddateien", ImageIO.getReaderFileSuffixes(), IFFFile.getFileSuffixes(), kc85ImgFileSuffixes, {"pix", "scr"});
    }

    public static ImgEntry load(File file) throws IOException {
        BufferedImage bufferedImage;
        ImgEntry.Mode mode;
        block36: {
            int n;
            block37: {
                mode = ImgEntry.Mode.UNSPECIFIED;
                bufferedImage = null;
                if (file == null) break block36;
                if (!IFFFile.accept(file)) break block37;
                bufferedImage = IFFFile.readImage(file);
                mode = ImgEntry.probeMode(bufferedImage);
                break block36;
            }
            long l = file.length();
            String string = null;
            String string2 = file.getName();
            if (string2 != null && (n = string2.lastIndexOf(46)) >= 0 && n + 1 < string2.length()) {
                string = string2.substring(n + 1).toLowerCase();
            }
            if (string != null) {
                if (string.equals("pic")) {
                    byte[] byArray = ImgLoader.readKC85IRMFile(file, true);
                    if (byArray != null) {
                        if (byArray.length > 0 && byArray.length <= 10240) {
                            mode = ImgEntry.Mode.MONOCHROME;
                        }
                        bufferedImage = ImgLoader.createImageByKC852IRM(byArray);
                    }
                } else if (string.equals("pif")) {
                    bufferedImage = ImgLoader.createImageByKC854IRM(ImgLoader.readKC85IRMFile(ImgLoader.replaceExt(file, "pip"), true), ImgLoader.readKC85IRMFile(file, true), false);
                } else if (string.equals("pip")) {
                    byte[] byArray = null;
                    File file2 = ImgLoader.replaceExt(file, "pif");
                    if (file2.exists()) {
                        byArray = ImgLoader.readKC85IRMFile(file2, true);
                    } else {
                        mode = ImgEntry.Mode.MONOCHROME;
                    }
                    bufferedImage = ImgLoader.createImageByKC854IRM(ImgLoader.readKC85IRMFile(file, true), byArray, false);
                } else if (string.equals("hif")) {
                    mode = ImgEntry.Mode.KC854_HIRES;
                    bufferedImage = ImgLoader.createImageByKC854IRM(ImgLoader.readKC85IRMFile(ImgLoader.replaceExt(file, "hip"), false), ImgLoader.readKC85IRMFile(file, false), true);
                } else if (string.equals("hip")) {
                    mode = ImgEntry.Mode.KC854_HIRES;
                    bufferedImage = ImgLoader.createImageByKC854IRM(ImgLoader.readKC85IRMFile(file, false), ImgLoader.readKC85IRMFile(ImgLoader.replaceExt(file, "hif"), false), true);
                }
            }
            if (bufferedImage == null) {
                BufferedInputStream bufferedInputStream;
                block35: {
                    bufferedInputStream = null;
                    try {
                        bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                        if (string != null) {
                            byte[] byArray;
                            int n2;
                            int n3;
                            int n4;
                            int n5;
                            if (bufferedImage == null && l == 16384L && string.equals("pix")) {
                                mode = ImgEntry.Mode.MONOCHROME;
                                bufferedImage = new BufferedImage(512, 256, 12, ImgUtil.getColorModelBW());
                                ImgUtil.fillBlack(bufferedImage);
                                n5 = ((InputStream)bufferedInputStream).read();
                                for (int i = 0; n5 >= 0 && i < 16384; ++i) {
                                    n4 = i & 0x3F;
                                    int n6 = n4 << 3;
                                    n3 = i >> 11 & 7 | i >> 3 & 0xF8;
                                    for (n2 = 0; n2 < 8; ++n2) {
                                        if ((n5 & 0x80) != 0) {
                                            bufferedImage.setRGB(n6, n3, -1);
                                        }
                                        n5 <<= 1;
                                        ++n6;
                                    }
                                    n5 = ((InputStream)bufferedInputStream).read();
                                }
                            }
                            if (bufferedImage == null && l > 7L && string.equals("scr") && ((InputStream)bufferedInputStream).read(byArray = new byte[7]) == byArray.length) {
                                n5 = EmuUtil.getWord(byArray, 1);
                                n4 = EmuUtil.getWord(byArray, 3);
                                if ((byArray[0] & 0xFF) == 253 && n5 >= 16384 && n5 < n4 && (n5 & 0x3FFF) % 80 == 0) {
                                    IndexColorModel indexColorModel = ImgUtil.getColorModelA5105();
                                    n3 = (n4 - n5 + 80) / 80;
                                    if (n3 > 200) {
                                        n3 = 200;
                                    }
                                    mode = ImgEntry.Mode.A5105;
                                    bufferedImage = new BufferedImage(320, n3, 12, indexColorModel);
                                    n2 = 0;
                                    int n7 = 0;
                                    int n8 = ((InputStream)bufferedInputStream).read();
                                    int n9 = ((InputStream)bufferedInputStream).read();
                                    while (n5 < n4 && n7 < n3 && n8 >= 0 && n9 >= 0) {
                                        int n10 = 1;
                                        int n11 = 16;
                                        for (int i = 0; i < 4; ++i) {
                                            int n12 = 0;
                                            if ((n8 & n10) != 0) {
                                                n12 |= 1;
                                            }
                                            if ((n8 & n11) != 0) {
                                                n12 |= 2;
                                            }
                                            if ((n9 & n10) != 0) {
                                                n12 |= 4;
                                            }
                                            if ((n9 & n11) != 0) {
                                                n12 |= 8;
                                            }
                                            bufferedImage.setRGB(n2, n7, indexColorModel.getRGB(n12));
                                            n10 <<= 1;
                                            n11 <<= 1;
                                            ++n2;
                                        }
                                        if (n2 >= 320) {
                                            n2 = 0;
                                            ++n7;
                                        }
                                        ++n5;
                                        n8 = ((InputStream)bufferedInputStream).read();
                                        n9 = ((InputStream)bufferedInputStream).read();
                                    }
                                }
                            }
                        }
                        if (bufferedImage != null) break block35;
                        bufferedImage = ImageIO.read(bufferedInputStream);
                        mode = ImgEntry.probeMode(bufferedImage);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        try {
                            System.gc();
                            throw new IOException("Es steht nicht gen\u00fcgend Speicher zur Verf\u00fcgung.");
                        }
                        catch (Throwable throwable) {
                            EmuUtil.closeSilent(bufferedInputStream);
                            throw throwable;
                        }
                    }
                }
                EmuUtil.closeSilent(bufferedInputStream);
            }
        }
        return bufferedImage != null ? new ImgEntry(bufferedImage, mode, ImgFld.Rotation.NONE, null, file, null) : null;
    }

    private static BufferedImage createBlackKC85BWImage() {
        BufferedImage bufferedImage = new BufferedImage(320, 256, 12, ImgUtil.getColorModelBW());
        ImgUtil.fillBlack(bufferedImage);
        return bufferedImage;
    }

    private static BufferedImage createBlackKC85LowresImage() {
        int n = KC85.getRawColorCount();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        for (int i = 0; i < n; ++i) {
            int n2 = KC85.getRawRGB(i);
            byArray[i] = (byte)(n2 >> 16);
            byArray2[i] = (byte)(n2 >> 8);
            byArray3[i] = (byte)n2;
        }
        BufferedImage bufferedImage = new BufferedImage(320, 256, 13, new IndexColorModel(8, n, byArray, byArray2, byArray3));
        ImgUtil.fillBlack(bufferedImage);
        return bufferedImage;
    }

    private static BufferedImage createImageByKC852IRM(byte[] byArray) {
        BufferedImage bufferedImage = null;
        if (byArray != null) {
            bufferedImage = byArray.length > 10240 ? ImgLoader.createBlackKC85LowresImage() : ImgLoader.createBlackKC85BWImage();
            for (int i = 0; i < 256; ++i) {
                for (int j = 0; j < 320; ++j) {
                    boolean bl;
                    int n = j / 8;
                    int n2 = -1;
                    int n3 = -1;
                    if (n < 32) {
                        n2 = i << 5 & 0x1E00 | i << 7 & 0x180 | i << 3 & 0x60 | n & 0x1F;
                        n3 = 0x2800 | i << 3 & 0x7E0 | n & 0x1F;
                    } else {
                        n2 = 0x2000 | i << 3 & 0x600 | i << 7 & 0x180 | i << 3 & 0x60 | i >> 1 & 0x18 | n & 7;
                        n3 = 0x3000 | i << 1 & 0x180 | i << 3 & 0x60 | i >> 1 & 0x18 | n & 7;
                    }
                    if (n2 < 0 || n2 >= byArray.length) continue;
                    byte by = byArray[n2];
                    int n4 = 128;
                    int n5 = j % 8;
                    if (n5 > 0) {
                        n4 >>= n5;
                    }
                    boolean bl2 = bl = (by & n4) != 0;
                    if (n3 >= 0 && n3 < byArray.length) {
                        bufferedImage.setRGB(j, i, KC85.getRawRGB(ImgLoader.getKC85ColorIndex(byArray[n3], bl)));
                        continue;
                    }
                    bufferedImage.setRGB(j, i, bl ? -16777216 : -1);
                }
            }
        }
        return bufferedImage;
    }

    private static BufferedImage createImageByKC854IRM(byte[] byArray, byte[] byArray2, boolean bl) {
        BufferedImage bufferedImage = null;
        bufferedImage = byArray2 != null ? (bl ? ImgUtil.createBlackKC854HiresImage() : ImgLoader.createBlackKC85LowresImage()) : ImgLoader.createBlackKC85BWImage();
        if (bufferedImage != null && byArray != null) {
            for (int i = 0; i < 256; ++i) {
                for (int j = 0; j < 40; ++j) {
                    int n = j * 256 + i;
                    if (n < 0 || n >= byArray.length) continue;
                    byte by = byArray[n];
                    int n2 = 7;
                    if (byArray2 != null && n < byArray2.length) {
                        n2 = byArray2[n] & 0xFF;
                    }
                    int n3 = 128;
                    int n4 = j * 8;
                    for (int k = 0; k < 8; ++k) {
                        boolean bl2;
                        boolean bl3 = bl2 = (by & n3) != 0;
                        if (n2 >= 0) {
                            int n5 = 0;
                            n5 = bl && byArray2 != null ? (bl2 ? ((n2 & n3) != 0 ? 7 : 2) : ((n2 & n3) != 0 ? 5 : 0)) : ImgLoader.getKC85ColorIndex(n2, bl2);
                            bufferedImage.setRGB(n4, i, KC85.getRawRGB(n5));
                        } else {
                            bufferedImage.setRGB(n4, i, bl2 ? -16777216 : -1);
                        }
                        ++n4;
                        n3 >>= 1;
                    }
                }
            }
        }
        return bufferedImage;
    }

    private static String[] getIIOLowerFileSuffixes() {
        if (iioFileSuffixes == null && (iioFileSuffixes = ImageIO.getReaderFileSuffixes()) != null) {
            for (int i = 0; i < iioFileSuffixes.length; ++i) {
                String string = iioFileSuffixes[i].toLowerCase();
                ImgLoader.iioFileSuffixes[i] = string.startsWith(".") ? string : "." + string;
            }
        }
        return iioFileSuffixes;
    }

    private static int getKC85ColorIndex(int n, boolean bl) {
        if ((n & 0x80) != 0) {
            bl = false;
        }
        return bl ? n >> 3 & 0xF : (n & 7) + 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readKC85IRMFile(File file, boolean bl) throws IOException {
        BufferedInputStream bufferedInputStream;
        byte[] byArray;
        block17: {
            byArray = null;
            bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                byte[] byArray2 = new byte[128];
                if (EmuUtil.read(bufferedInputStream, byArray2) != byArray2.length) {
                    ImgLoader.throwUnsupportedFormat();
                }
                int n = -1;
                if (bl) {
                    n = ((InputStream)bufferedInputStream).read();
                    if (n < 0 || n > 7) {
                        ImgLoader.throwUnsupportedFormat();
                    }
                    byArray = new byte[n == 0 || n == 2 ? 12800 : 10240];
                } else {
                    byArray = new byte[10240];
                }
                Arrays.fill(byArray, (byte)0);
                boolean bl2 = false;
                if (bl) {
                    if (n == 2 || n == 3 || n == 6 || n == 7) {
                        bl2 = true;
                        if ((byArray2[17] & 0xFF) != 255 || (byArray2[18] & 0xFF) != 63) {
                            ImgLoader.throwUnsupportedFormat();
                        }
                    }
                } else if ((byArray2[16] & 0xFF) >= 3) {
                    bl2 = true;
                    if ((byArray2[17] & 0xFF) != 0 || (byArray2[18] & 0xFF) != 64) {
                        ImgLoader.throwUnsupportedFormat();
                    }
                }
                if (bl2) {
                    int n2;
                    int n3 = EmuUtil.getWord(byArray2, 17);
                    int n4 = EmuUtil.getWord(byArray2, 19);
                    int n5 = 16384;
                    if ((byArray2[16] & 0xFF) > 2) {
                        n5 = EmuUtil.getWord(byArray2, 21);
                    }
                    KC85ImgUnpacker kC85ImgUnpacker = new KC85ImgUnpacker();
                    if (bl) {
                        kC85ImgUnpacker.setMemByte(n3++, n);
                    }
                    while (n3 < n4 && (n2 = ((InputStream)bufferedInputStream).read()) >= 0) {
                        kC85ImgUnpacker.setMemByte(n3++, n2);
                    }
                    kC85ImgUnpacker.unpack(n5);
                    n3 = 32768;
                    n2 = 0;
                    while (n2 < byArray.length) {
                        byArray[n2++] = (byte)kC85ImgUnpacker.getMemByte(n3++, false);
                    }
                    break block17;
                }
                EmuUtil.read(bufferedInputStream, byArray);
            }
            catch (Throwable throwable) {
                EmuUtil.closeSilent(bufferedInputStream);
                throw throwable;
            }
        }
        EmuUtil.closeSilent(bufferedInputStream);
        return byArray;
    }

    private static File replaceExt(File file, String string) {
        File file2 = file.getParentFile();
        String string2 = file.getName();
        if (string2 != null) {
            int n = string2.lastIndexOf(46);
            string2 = n >= 0 ? string2.substring(0, n + 1) : string2 + ".";
            string2 = string2 + string;
        } else {
            string2 = string;
        }
        return file2 != null ? new File(file2, string2) : new File(string2);
    }

    private static void throwUnsupportedFormat() throws IOException {
        throw new IOException("Dateiformat nicht unterst\u00fctzt");
    }

    private ImgLoader() {
    }
}

