/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.JViewport;
import jkcemu.image.ImgUtil;

public class ImgFld
extends Component
implements Printable {
    private int defaultWidth;
    private int defaultHeight;
    private double curScale;
    private double scale;
    private Rotation rotation;
    private BufferedImage image;
    private Image scaledImg;
    private Dimension vpSize;
    private Color selectionColor;
    private Rectangle selection;
    private Rectangle selectedArea;
    private double savedScale;
    private Rotation savedRotation;
    private BufferedImage savedImage;
    private Point savedViewPos;

    public ImgFld(int n, int n2) {
        this.defaultWidth = n;
        this.defaultHeight = n2;
        this.rotation = Rotation.NONE;
        this.curScale = this.scale = 1.0;
        this.image = null;
        this.scaledImg = null;
        this.vpSize = null;
        this.selectionColor = Color.red;
        this.selection = null;
        this.selectedArea = null;
        this.savedScale = this.scale;
        this.savedRotation = null;
        this.savedImage = null;
        this.savedViewPos = null;
    }

    public synchronized void drawImage(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.image != null && graphics != null && n3 > 0 && n4 > 0) {
            Graphics graphics2 = graphics.create();
            if (!this.rotation.equals((Object)Rotation.NONE) && graphics2 instanceof Graphics2D) {
                switch (this.rotation) {
                    case LEFT: {
                        n = -n3;
                        ((Graphics2D)graphics2).rotate(-1.5707963267948966);
                        break;
                    }
                    case RIGHT: {
                        n2 = -n4;
                        ((Graphics2D)graphics2).rotate(1.5707963267948966);
                        break;
                    }
                    case DOWN: {
                        n = -n3;
                        n2 = -n4;
                        ((Graphics2D)graphics2).rotate(Math.PI);
                    }
                }
            }
            if (n3 == this.image.getWidth() && n4 == this.image.getHeight()) {
                graphics2.drawImage(this.image, n, n2, this);
                this.scaledImg = null;
            } else {
                if (this.scaledImg != null && (this.scaledImg.getWidth(this) != n3 || this.scaledImg.getHeight(this) != n4)) {
                    this.scaledImg = null;
                }
                if (this.scaledImg == null) {
                    this.scaledImg = this.image.getScaledInstance(n3, n4, 4);
                }
                graphics2.drawImage(this.scaledImg, n, n2, this);
            }
            graphics2.dispose();
        }
    }

    public double getCurScale() {
        return this.curScale;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public BufferedImage getNewPreviewImage() {
        Container container;
        BufferedImage bufferedImage = null;
        if (this.image != null && (container = this.getParent()) != null) {
            int n;
            int n2;
            float f;
            float f2 = container.getWidth();
            float f3 = container.getHeight();
            float f4 = this.image.getWidth();
            float f5 = this.image.getHeight();
            if (f2 > 0.0f && f3 > 0.0f && f4 > 0.0f && f5 > 0.0f && (f = Math.max(f2 / f4, f3 / f5)) < 1.0f && (bufferedImage = ImgUtil.createCompatibleImage(this.image, n2 = Math.round(f4 * f), n = Math.round(f5 * f))) != null) {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage(this.image, 0, 0, n2, n, this);
                graphics2D.dispose();
            }
        }
        return bufferedImage != null ? bufferedImage : this.image;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public Dimension getRotatedImageSize() {
        Dimension dimension = null;
        if (this.image != null) {
            int n = this.image.getWidth();
            int n2 = this.image.getHeight();
            if (n > 0 && n2 > 0) {
                dimension = this.isRotated90Degrees() ? new Dimension(n2, n) : new Dimension(n, n2);
            }
        }
        return dimension;
    }

    public double getScale() {
        return this.scale;
    }

    public Rectangle getSelectedArea() {
        Dimension dimension;
        Rectangle rectangle = null;
        Rectangle rectangle2 = this.selection;
        if (rectangle2 != null && (rectangle = this.selectedArea) == null && (dimension = this.getRotatedImageSize()) != null) {
            int n;
            int n2;
            int n3 = rectangle2.x;
            int n4 = rectangle2.y;
            int n5 = rectangle2.width;
            int n6 = rectangle2.height;
            if (n3 < 0) {
                n5 += n3;
                n3 = 0;
            }
            if (n4 < 0) {
                n6 += n4;
                n4 = 0;
            }
            if (n5 < 0) {
                n3 += n5;
                n5 = -n5;
            }
            if (n6 < 0) {
                n4 += n6;
                n6 = -n6;
            }
            if ((n2 = n3 + n5) > dimension.width) {
                n2 = dimension.width;
            }
            if ((n = n4 + n6) > dimension.height) {
                n = dimension.height;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            if (n2 >= n3 && n >= n4) {
                this.selectedArea = rectangle = new Rectangle(n3, n4, n2 - n3, n - n4);
            }
        }
        return rectangle;
    }

    public Rectangle getSelection() {
        return this.selection;
    }

    public boolean isRotated90Degrees() {
        return this.rotation.equals((Object)Rotation.LEFT) || this.rotation.equals((Object)Rotation.RIGHT);
    }

    public void save() {
        this.savedImage = this.image;
        this.savedRotation = this.rotation;
        this.savedScale = this.scale;
        this.savedViewPos = null;
        Container container = this.getParent();
        if (container != null && container instanceof JViewport) {
            this.savedViewPos = ((JViewport)container).getViewPosition();
        }
    }

    public void restore() {
        this.image = this.savedImage;
        this.rotation = this.savedRotation;
        this.scale = this.savedScale;
        this.scaledImg = null;
        this.selection = null;
        this.selectedArea = null;
        Container container = this.getParent();
        if (container != null && this.savedViewPos != null && container instanceof JViewport) {
            ((JViewport)container).setViewPosition(this.savedViewPos);
        }
        this.invalidate();
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        this.scaledImg = null;
        this.selection = null;
        this.selectedArea = null;
        this.invalidate();
    }

    public void setRotation(Rotation rotation) {
        this.rotation = rotation;
        this.selection = null;
        this.selectedArea = null;
        this.invalidate();
    }

    public void setScale(double d) {
        this.scale = d;
        this.selection = null;
        this.selectedArea = null;
        this.invalidate();
    }

    public void setSelection(Rectangle rectangle) {
        this.selection = rectangle;
        this.selectedArea = null;
        this.repaint();
    }

    public void setSelection(int n, int n2, int n3, int n4) {
        this.setSelection(new Rectangle(n, n2, n3, n4));
    }

    public void setSelectionColor(Color color) {
        this.selectionColor = color;
        this.repaint();
    }

    public void setViewportSize(Dimension dimension) {
        this.vpSize = dimension;
    }

    public Rectangle toUnrotated(int n, int n2, int n3, int n4) {
        Rectangle rectangle = null;
        if (this.image != null) {
            int n5 = this.image.getWidth();
            int n6 = this.image.getHeight();
            if (n5 > 0 && n6 > 0) {
                switch (this.rotation) {
                    case LEFT: {
                        rectangle = new Rectangle(n5 - n2 - n4, n, n4, n3);
                        break;
                    }
                    case RIGHT: {
                        rectangle = new Rectangle(n2, n6 - n - n3, n4, n3);
                        break;
                    }
                    case DOWN: {
                        rectangle = new Rectangle(n5 - n - n3, n6 - n2 - n4, n3, n4);
                        break;
                    }
                    default: {
                        rectangle = new Rectangle(n, n2, n3, n4);
                    }
                }
            }
        }
        return rectangle;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        int n2 = 1;
        if (graphics != null && pageFormat != null && n == 0 && this.image != null) {
            int n3 = (int)pageFormat.getImageableX() + 1;
            int n4 = (int)pageFormat.getImageableY() + 1;
            int n5 = (int)pageFormat.getImageableWidth() - 1;
            int n6 = (int)pageFormat.getImageableHeight() - 1;
            int n7 = this.image.getWidth();
            int n8 = this.image.getHeight();
            if (n5 > 0 && n6 > 0 && n7 > 0 && n8 > 0) {
                if (this.isRotated90Degrees()) {
                    int n9 = n5;
                    n5 = n6;
                    n6 = n9;
                }
                if (n7 > n5 || n8 > n6) {
                    double d = Math.min((double)n5 / (double)n7, (double)n6 / (double)n8);
                    n7 = (int)Math.round((double)n7 * d);
                    n8 = (int)Math.round((double)n8 * d);
                }
                this.drawImage(graphics, n3, n4, n7, n8);
                n2 = 0;
            }
        }
        return n2;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (!this.isPreferredSizeSet()) {
            int n = this.defaultWidth;
            int n2 = this.defaultHeight;
            if (this.image != null) {
                if (this.scale > 0.0) {
                    n = (int)Math.round((double)this.image.getWidth() * this.scale);
                    n2 = (int)Math.round((double)this.image.getHeight() * this.scale);
                } else if (this.vpSize != null) {
                    n = this.vpSize.width;
                    n2 = this.vpSize.height;
                }
            }
            if (this.isRotated90Degrees()) {
                int n3 = n;
                n = n2;
                n2 = n3;
            }
            dimension = new Dimension(n > 0 ? n : 0, n2 > 0 ? n2 : 0);
        }
        return dimension;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setPaintMode();
        Color color = this.getBackground();
        if (color != null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.image != null) {
            int n = this.image.getWidth();
            int n2 = this.image.getHeight();
            if (n > 0 && n2 > 0) {
                double d = this.scale;
                if (d <= 0.0 && this.vpSize != null) {
                    d = Math.min((double)(this.vpSize.width - 1) / (double)n, (double)(this.vpSize.height - 1) / (double)n2);
                }
                int n3 = n;
                int n4 = n2;
                if (d > 0.0) {
                    n3 = (int)Math.round((double)n * d);
                    n4 = (int)Math.round((double)n2 * d);
                    this.curScale = d;
                } else {
                    this.curScale = 1.0;
                }
                this.drawImage(graphics, 0, 0, n3, n4);
                Rectangle rectangle = this.getSelectedArea();
                if (rectangle != null) {
                    graphics.setColor(this.selectionColor);
                    graphics.drawRect((int)Math.round((double)rectangle.x * this.curScale), (int)Math.round((double)rectangle.y * this.curScale), (int)Math.round((double)(rectangle.width - 1) * this.curScale), (int)Math.round((double)(rectangle.height - 1) * this.curScale));
                }
            }
        }
    }

    public static enum Rotation {
        NONE,
        LEFT,
        RIGHT,
        DOWN;

    }
}

