/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.File;
import jkcemu.image.ImgFld;
import jkcemu.image.ImgUtil;

public class ImgEntry {
    private BufferedImage image;
    private Mode mode;
    private ImgFld.Rotation rotation;
    private String title;
    private File file;
    private byte[] memBytes;

    public ImgEntry(BufferedImage bufferedImage, Mode mode, ImgFld.Rotation rotation, String string, File file, byte[] byArray) {
        this.image = bufferedImage;
        this.mode = mode;
        this.rotation = rotation;
        this.title = string;
        this.file = file;
        this.memBytes = byArray;
    }

    public boolean equalsMode(Mode mode) {
        return this.mode.equals((Object)mode);
    }

    public File getFile() {
        return this.file;
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public byte[] getMemBytes() {
        return this.memBytes;
    }

    public Mode getMode() {
        return this.mode;
    }

    public ImgFld.Rotation getRotation() {
        return this.rotation;
    }

    public String getTitle() {
        return this.title;
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public boolean isAGrayMode() {
        return this.mode.equals((Object)Mode.GRAY) || this.mode.equals((Object)Mode.INVERTED_GRAY);
    }

    public boolean isAInversionMode() {
        return this.mode.equals((Object)Mode.INVERTED) || this.mode.equals((Object)Mode.INVERTED_INDEXED_COLORS) || this.mode.equals((Object)Mode.INVERTED_GRAY) || this.mode.equals((Object)Mode.INVERTED_MONOCHROME);
    }

    public boolean isAMonochromeMode() {
        return this.mode.equals((Object)Mode.MONOCHROME) || this.mode.equals((Object)Mode.INVERTED_MONOCHROME) || this.mode.equals((Object)Mode.AC1_ACC) || this.mode.equals((Object)Mode.AC1_SCCH) || this.mode.equals((Object)Mode.AC1_2010) || this.mode.equals((Object)Mode.Z1013) || this.mode.equals((Object)Mode.Z9001);
    }

    public boolean isA5105Format() {
        return this.mode.equals((Object)Mode.A5105);
    }

    public boolean isAC1Format() {
        return this.mode.equals((Object)Mode.AC1_ACC) || this.mode.equals((Object)Mode.AC1_SCCH) || this.mode.equals((Object)Mode.AC1_2010);
    }

    public boolean isKC854HiresFormat() {
        return this.mode.equals((Object)Mode.KC854_HIRES);
    }

    public boolean isKC85MonochromeFormat() {
        return this.isAMonochromeMode() && this.getWidth() == 320 && this.getHeight() == 256;
    }

    public boolean isLLC2HiresFormat() {
        return this.mode.equals((Object)Mode.MONOCHROME) || this.mode.equals((Object)Mode.INVERTED_MONOCHROME);
    }

    public boolean isZ1013Format() {
        return this.mode.equals((Object)Mode.Z1013);
    }

    public boolean isZ9001Format() {
        return this.mode.equals((Object)Mode.Z9001) && this.getWidth() == 320 && this.getHeight() == 192;
    }

    public static Mode probeMode(BufferedImage bufferedImage) {
        Mode mode = Mode.UNSPECIFIED;
        if (bufferedImage != null) {
            IndexColorModel indexColorModel = ImgUtil.getIndexColorModel(bufferedImage);
            if (indexColorModel != null) {
                int n = indexColorModel.getMapSize();
                if (n > 0) {
                    boolean bl = true;
                    boolean bl2 = true;
                    for (int i = 0; i < n; ++i) {
                        int n2 = indexColorModel.getRGB(i);
                        int n3 = n2 & 0xFF;
                        if (n3 != (n2 >> 16 & 0xFF) || n3 != (n2 >> 8 & 0xFF)) {
                            bl = false;
                            bl2 = false;
                            break;
                        }
                        if (n3 == 0 || n3 == 255) continue;
                        bl2 = false;
                    }
                    if (bl2) {
                        mode = Mode.MONOCHROME;
                    } else if (bl) {
                        mode = Mode.GRAY;
                    }
                }
            } else {
                int n = bufferedImage.getType();
                if (n == 10 || n == 11) {
                    mode = Mode.GRAY;
                }
            }
        }
        return mode;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setMemBytes(byte[] byArray) {
        this.memBytes = byArray;
    }

    public void setRotation(ImgFld.Rotation rotation) {
        this.rotation = rotation;
    }

    public static enum Mode {
        UNSPECIFIED,
        INDEXED_COLORS,
        GRAY,
        MONOCHROME,
        INVERTED,
        INVERTED_INDEXED_COLORS,
        INVERTED_GRAY,
        INVERTED_MONOCHROME,
        A5105,
        AC1_ACC,
        AC1_SCCH,
        AC1_2010,
        KC854_HIRES,
        Z1013,
        Z9001;

    }
}

