/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.CancelableProgressDlg;
import jkcemu.base.EmuUtil;
import jkcemu.image.ColorReducer;
import jkcemu.image.Dithering;
import jkcemu.image.ImageFrm;
import jkcemu.image.ImgFld;
import jkcemu.image.ImgUtil;

public class ImgAdjustDlg
extends BaseDlg
implements CancelableProgressDlg.Progressable,
ChangeListener,
Runnable {
    private static final int VALUE_MAX = 100;
    private static final float FLOAT_VALUE_MAX = 100.0f;
    private ImgFld imgFld;
    private CancelableProgressDlg progressDlg;
    private int progressValue;
    private int appliedBrightness;
    private float appliedContrast;
    private float appliedSaturation;
    private int appliedDiffR;
    private int appliedDiffG;
    private int appliedDiffB;
    private BufferedImage appliedImg;
    private BufferedImage orgImg;
    private BufferedImage srcImg;
    private int wImg;
    private int hImg;
    private int srcColorCnt;
    private byte[] srcReds;
    private byte[] srcGreens;
    private byte[] srcBlues;
    private byte[] srcAlphas;
    private byte[] previewReds;
    private byte[] previewGreens;
    private byte[] previewBlues;
    private JSlider sliderBrightness;
    private JSlider sliderContrast;
    private JSlider sliderSaturation;
    private JSlider sliderRed;
    private JSlider sliderGreen;
    private JSlider sliderBlue;
    private JSpinner spinnerBrightness;
    private JSpinner spinnerContrast;
    private JSpinner spinnerSaturation;
    private JSpinner spinnerRed;
    private JSpinner spinnerGreen;
    private JSpinner spinnerBlue;
    private JButton btnApply;
    private JButton btnReset;
    private JButton btnCancel;
    private boolean previewUpdEnabled;

    public static BufferedImage showDlg(ImageFrm imageFrm) {
        ImgFld imgFld = imageFrm.getImgFld();
        BufferedImage bufferedImage = null;
        BufferedImage bufferedImage2 = imgFld.getNewPreviewImage();
        if (bufferedImage2 != null) {
            if (ImgUtil.getIndexColorModel(bufferedImage2) == null) {
                bufferedImage2 = ColorReducer.work(imageFrm, "Erzeuge Vorschaubild...", bufferedImage2, 256, imgFld.getBackground(), Dithering.Algorithm.FLOYD_STEINBERG);
            }
            if (bufferedImage2 != null) {
                ImgAdjustDlg imgAdjustDlg = new ImgAdjustDlg(imageFrm, bufferedImage2, imgFld);
                imgAdjustDlg.setVisible(true);
                bufferedImage = imgAdjustDlg.appliedImg;
            }
        }
        return bufferedImage;
    }

    @Override
    public int getProgressMax() {
        return this.wImg * this.hImg;
    }

    @Override
    public int getProgressValue() {
        return this.progressValue;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.sliderBrightness) {
            this.spinnerBrightness.removeChangeListener(this);
            this.spinnerBrightness.setValue(this.sliderBrightness.getValue());
            this.spinnerBrightness.addChangeListener(this);
            this.updPreview();
        } else if (object == this.sliderContrast) {
            this.spinnerContrast.removeChangeListener(this);
            this.spinnerContrast.setValue(this.sliderContrast.getValue());
            this.spinnerContrast.addChangeListener(this);
            this.updPreview();
        } else if (object == this.sliderSaturation) {
            this.spinnerSaturation.removeChangeListener(this);
            this.spinnerSaturation.setValue(this.sliderSaturation.getValue());
            this.spinnerSaturation.addChangeListener(this);
            this.updPreview();
        } else if (object == this.sliderRed) {
            this.spinnerRed.removeChangeListener(this);
            this.spinnerRed.setValue(this.sliderRed.getValue());
            this.spinnerRed.addChangeListener(this);
            this.updPreview();
        } else if (object == this.sliderGreen) {
            this.spinnerGreen.removeChangeListener(this);
            this.spinnerGreen.setValue(this.sliderGreen.getValue());
            this.spinnerGreen.addChangeListener(this);
            this.updPreview();
        } else if (object == this.sliderBlue) {
            this.spinnerBlue.removeChangeListener(this);
            this.spinnerBlue.setValue(this.sliderBlue.getValue());
            this.spinnerBlue.addChangeListener(this);
            this.updPreview();
        } else if (object == this.spinnerBrightness) {
            this.sliderBrightness.removeChangeListener(this);
            this.sliderBrightness.setValue(EmuUtil.getInt(this.spinnerBrightness));
            this.sliderBrightness.addChangeListener(this);
            this.updPreview();
        } else if (object == this.spinnerContrast) {
            this.sliderContrast.removeChangeListener(this);
            this.sliderContrast.setValue(EmuUtil.getInt(this.spinnerContrast));
            this.sliderContrast.addChangeListener(this);
            this.updPreview();
        } else if (object == this.spinnerSaturation) {
            this.sliderSaturation.removeChangeListener(this);
            this.sliderSaturation.setValue(EmuUtil.getInt(this.spinnerSaturation));
            this.sliderSaturation.addChangeListener(this);
            this.updPreview();
        } else if (object == this.spinnerRed) {
            this.sliderRed.removeChangeListener(this);
            this.sliderRed.setValue(EmuUtil.getInt(this.spinnerRed));
            this.sliderRed.addChangeListener(this);
            this.updPreview();
        } else if (object == this.spinnerGreen) {
            this.sliderGreen.removeChangeListener(this);
            this.sliderGreen.setValue(EmuUtil.getInt(this.spinnerGreen));
            this.sliderGreen.addChangeListener(this);
            this.updPreview();
        } else if (object == this.spinnerBlue) {
            this.sliderBlue.removeChangeListener(this);
            this.sliderBlue.setValue(EmuUtil.getInt(this.spinnerBlue));
            this.sliderBlue.addChangeListener(this);
            this.updPreview();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.orgImg != null && this.progressDlg != null) {
            try {
                BufferedImage bufferedImage = new BufferedImage(this.wImg, this.hImg, this.orgImg.getTransparency() == 1 ? 5 : 2);
                this.progressValue = 0;
                for (int i = 0; i < this.hImg; ++i) {
                    for (int j = 0; j < this.wImg && !this.progressDlg.wasCancelled(); ++j) {
                        int n = this.orgImg.getRGB(j, i);
                        bufferedImage.setRGB(j, i, n & 0xFF000000 | this.convertRGB(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF, this.appliedBrightness, this.appliedContrast, this.appliedSaturation, this.appliedDiffR, this.appliedDiffG, this.appliedDiffB) & 0xFFFFFF);
                        ++this.progressValue;
                    }
                }
                if (!this.progressDlg.wasCancelled()) {
                    this.appliedImg = bufferedImage;
                }
            }
            finally {
                this.progressDlg.fireProgressFinished();
            }
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object == this.btnApply) {
            bl = true;
            this.doApply();
        }
        if (object == this.btnCancel) {
            bl = true;
            this.doClose();
        } else if (object == this.btnReset) {
            bl = true;
            this.doReset();
        }
        return bl;
    }

    private ImgAdjustDlg(ImageFrm imageFrm, BufferedImage bufferedImage, ImgFld imgFld) {
        super((Window)imageFrm, "Helligkeit, Kontrast, Farben");
        Object object;
        this.imgFld = imgFld;
        this.progressDlg = null;
        this.progressValue = 0;
        this.appliedBrightness = 0;
        this.appliedContrast = 0.0f;
        this.appliedSaturation = 0.0f;
        this.appliedDiffR = 0;
        this.appliedDiffG = 0;
        this.appliedDiffB = 0;
        this.appliedImg = null;
        this.srcImg = null;
        this.srcReds = null;
        this.srcGreens = null;
        this.srcBlues = null;
        this.srcColorCnt = 0;
        this.wImg = 0;
        this.hImg = 0;
        this.previewUpdEnabled = true;
        this.orgImg = imageFrm.getImage();
        if (this.orgImg != null) {
            this.wImg = this.orgImg.getWidth();
            this.hImg = this.orgImg.getHeight();
        }
        if (bufferedImage != null && (object = ImgUtil.getIndexColorModel(bufferedImage)) != null) {
            this.srcColorCnt = ((IndexColorModel)object).getMapSize();
            this.srcReds = new byte[this.srcColorCnt];
            this.srcGreens = new byte[this.srcColorCnt];
            this.srcBlues = new byte[this.srcColorCnt];
            this.srcAlphas = new byte[this.srcColorCnt];
            ((IndexColorModel)object).getReds(this.srcReds);
            ((IndexColorModel)object).getGreens(this.srcGreens);
            ((IndexColorModel)object).getBlues(this.srcBlues);
            ((IndexColorModel)object).getAlphas(this.srcAlphas);
            this.previewReds = new byte[this.srcColorCnt];
            this.previewGreens = new byte[this.srcColorCnt];
            this.previewBlues = new byte[this.srcColorCnt];
            this.srcImg = bufferedImage;
        }
        this.setLayout(new GridBagLayout());
        object = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0);
        this.sliderBrightness = this.createSlider();
        this.add((Component)this.sliderBrightness, object);
        this.sliderContrast = this.createSlider();
        ++((GridBagConstraints)object).gridx;
        this.add((Component)this.sliderContrast, object);
        this.sliderSaturation = this.createSlider();
        ++((GridBagConstraints)object).gridx;
        this.add((Component)this.sliderSaturation, object);
        this.sliderRed = this.createSlider();
        ((GridBagConstraints)object).insets.left = 20;
        ++((GridBagConstraints)object).gridx;
        this.add((Component)this.sliderRed, object);
        this.sliderGreen = this.createSlider();
        ((GridBagConstraints)object).insets.left = 5;
        ++((GridBagConstraints)object).gridx;
        this.add((Component)this.sliderGreen, object);
        this.sliderBlue = this.createSlider();
        ++((GridBagConstraints)object).gridx;
        this.add((Component)this.sliderBlue, object);
        this.spinnerBrightness = this.createSpinner();
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).gridx = 0;
        ++((GridBagConstraints)object).gridy;
        this.add((Component)this.spinnerBrightness, object);
        this.spinnerContrast = this.createSpinner();
        ++((GridBagConstraints)object).gridx;
        this.add((Component)this.spinnerContrast, object);
        this.spinnerSaturation = this.createSpinner();
        ++((GridBagConstraints)object).gridx;
        this.add((Component)this.spinnerSaturation, object);
        this.spinnerRed = this.createSpinner();
        ((GridBagConstraints)object).insets.left = 20;
        ++((GridBagConstraints)object).gridx;
        this.add((Component)this.spinnerRed, object);
        this.spinnerGreen = this.createSpinner();
        ((GridBagConstraints)object).insets.left = 5;
        ++((GridBagConstraints)object).gridx;
        this.add((Component)this.spinnerGreen, object);
        this.spinnerBlue = this.createSpinner();
        ++((GridBagConstraints)object).gridx;
        this.add((Component)this.spinnerBlue, object);
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).gridx = 0;
        ++((GridBagConstraints)object).gridy;
        this.add((Component)new JLabel("Helligkeit"), object);
        ++((GridBagConstraints)object).gridx;
        this.add((Component)new JLabel("Kontrast"), object);
        ++((GridBagConstraints)object).gridx;
        this.add((Component)new JLabel("Farbs\u00e4ttigung"), object);
        ((GridBagConstraints)object).insets.left = 20;
        ++((GridBagConstraints)object).gridx;
        this.add((Component)new JLabel("Rot"), object);
        ((GridBagConstraints)object).insets.left = 5;
        ++((GridBagConstraints)object).gridx;
        this.add((Component)new JLabel("Gr\u00fcn"), object);
        ++((GridBagConstraints)object).gridx;
        this.add((Component)new JLabel("Blau"), object);
        JPanel jPanel = new JPanel(new GridLayout(1, 3, 5, 5));
        ((GridBagConstraints)object).insets.top = 10;
        ((GridBagConstraints)object).insets.bottom = 10;
        ((GridBagConstraints)object).gridwidth = 0;
        ((GridBagConstraints)object).gridx = 0;
        ++((GridBagConstraints)object).gridy;
        this.add((Component)jPanel, object);
        this.btnApply = new JButton("Anwenden");
        this.btnApply.addActionListener(this);
        jPanel.add(this.btnApply);
        this.btnReset = new JButton("Zur\u00fccksetzen");
        this.btnReset.addActionListener(this);
        jPanel.add(this.btnReset);
        this.btnCancel = new JButton("Abbrechen");
        this.btnCancel.addActionListener(this);
        jPanel.add(this.btnCancel);
        this.pack();
        this.setParentCentered();
        this.setResizable(false);
        this.updPreview();
        imageFrm.fireFitImage();
    }

    private int convertRGB(int n, int n2, int n3, int n4, float f, float f2, int n5, int n6, int n7) {
        int n8 = ((n += n4 + n5) + (n3 += n4 + n7) + (n2 += n4 + n6)) / 3;
        n += Math.round((float)(n - n8) * f2 / 100.0f);
        n2 += Math.round((float)(n2 - n8) * f2 / 100.0f);
        n3 += Math.round((float)(n3 - n8) * f2 / 100.0f);
        n += Math.round((float)(n - 128) * f / 100.0f);
        n2 += Math.round((float)(n2 - 128) * f / 100.0f);
        n3 += Math.round((float)(n3 - 128) * f / 100.0f);
        if (n < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 255) {
            n2 = 255;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > 255) {
            n3 = 255;
        }
        return n << 16 & 0xFF0000 | n2 << 8 & 0xFF00 | n3 & 0xFF;
    }

    private JSlider createSlider() {
        JSlider jSlider = new JSlider(1, -100, 100, 0);
        jSlider.setLabelTable(jSlider.createStandardLabels(50));
        jSlider.setPaintLabels(true);
        jSlider.setPaintTicks(true);
        jSlider.setPaintTrack(true);
        jSlider.setBorder(BorderFactory.createEtchedBorder());
        jSlider.addChangeListener(this);
        return jSlider;
    }

    private JSpinner createSpinner() {
        return new JSpinner(new SpinnerNumberModel(0, -100, 100, 1));
    }

    private void doApply() {
        if (this.orgImg != null && this.srcReds != null && this.srcGreens != null && this.srcBlues != null && this.srcAlphas != null) {
            this.appliedBrightness = this.sliderBrightness.getValue();
            this.appliedContrast = this.getContrast();
            this.appliedSaturation = this.sliderSaturation.getValue();
            this.appliedDiffR = this.sliderRed.getValue();
            this.appliedDiffG = this.sliderGreen.getValue();
            this.appliedDiffB = this.sliderBlue.getValue();
            int n = 0;
            IndexColorModel indexColorModel = ImgUtil.getIndexColorModel(this.orgImg);
            if (indexColorModel != null) {
                n = indexColorModel.getMapSize();
            }
            if (n > 0 && n <= this.srcColorCnt) {
                byte[] byArray = new byte[this.srcColorCnt];
                byte[] byArray2 = new byte[this.srcColorCnt];
                byte[] byArray3 = new byte[this.srcColorCnt];
                for (int i = 0; i < this.srcColorCnt; ++i) {
                    int n2 = this.convertRGB(this.srcReds[i] & 0xFF, this.srcGreens[i] & 0xFF, this.srcBlues[i] & 0xFF, this.appliedBrightness, this.appliedContrast, this.appliedSaturation, this.appliedDiffR, this.appliedDiffG, this.appliedDiffB);
                    byArray[i] = (byte)(n2 >> 16);
                    byArray2[i] = (byte)(n2 >> 8);
                    byArray3[i] = (byte)n2;
                }
                this.appliedImg = new BufferedImage(new IndexColorModel(8, this.srcColorCnt, byArray, byArray2, byArray3), this.srcImg.getRaster(), false, new Hashtable());
                this.doClose();
            } else {
                this.doClose();
                this.progressDlg = new CancelableProgressDlg(this.getOwner(), "Einstellungen anwenden...", this);
                new Thread(Main.getThreadGroup(), this, "JKCEMU image adjuster").start();
                this.progressDlg.setVisible(true);
            }
        }
    }

    private void doReset() {
        this.previewUpdEnabled = false;
        this.sliderBrightness.setValue(0);
        this.sliderContrast.setValue(0);
        this.sliderSaturation.setValue(0);
        this.sliderRed.setValue(0);
        this.sliderGreen.setValue(0);
        this.sliderBlue.setValue(0);
        this.spinnerBrightness.setValue(0);
        this.spinnerContrast.setValue(0);
        this.spinnerSaturation.setValue(0);
        this.spinnerRed.setValue(0);
        this.spinnerGreen.setValue(0);
        this.spinnerBlue.setValue(0);
        this.previewUpdEnabled = true;
        this.updPreview();
    }

    private float getContrast() {
        float f = this.sliderContrast.getValue();
        if (f < 0.0f) {
            f *= 0.75f;
        }
        return f;
    }

    private void updPreview() {
        if (this.previewUpdEnabled && this.srcImg != null && this.srcReds != null && this.srcGreens != null && this.srcBlues != null && this.srcAlphas != null && this.previewReds != null && this.previewGreens != null && this.previewBlues != null) {
            int n = this.sliderBrightness.getValue();
            float f = this.getContrast();
            int n2 = this.sliderSaturation.getValue();
            int n3 = this.sliderRed.getValue();
            int n4 = this.sliderGreen.getValue();
            int n5 = this.sliderBlue.getValue();
            for (int i = 0; i < this.srcColorCnt; ++i) {
                int n6 = this.convertRGB(this.srcReds[i] & 0xFF, this.srcGreens[i] & 0xFF, this.srcBlues[i] & 0xFF, n, f, n2, n3, n4, n5);
                this.previewReds[i] = (byte)(n6 >> 16);
                this.previewGreens[i] = (byte)(n6 >> 8);
                this.previewBlues[i] = (byte)n6;
            }
            this.imgFld.setImage(new BufferedImage(new IndexColorModel(8, this.srcColorCnt, this.previewReds, this.previewGreens, this.previewBlues), this.srcImg.getRaster(), false, new Hashtable()));
            this.imgFld.repaint();
        }
    }
}

