/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Properties;
import java.util.Stack;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.filechooser.FileFilter;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileComparator;
import jkcemu.base.HelpFrm;
import jkcemu.image.AbstractImageFrm;
import jkcemu.image.BufferedImgBuilder;
import jkcemu.image.ColorInverter;
import jkcemu.image.CropDlg;
import jkcemu.image.Dithering;
import jkcemu.image.GrayScaler;
import jkcemu.image.IFFFile;
import jkcemu.image.ImgAdjustDlg;
import jkcemu.image.ImgEntry;
import jkcemu.image.ImgFld;
import jkcemu.image.ImgLoader;
import jkcemu.image.ImgPropsDlg;
import jkcemu.image.ImgSaver;
import jkcemu.image.ImgUtil;
import jkcemu.image.IndexColorsDlg;
import jkcemu.image.JASCPaletteFile;
import jkcemu.image.RemoveTransparencyDlg;
import jkcemu.image.RotateDlg;
import jkcemu.image.RoundCornersDlg;
import jkcemu.image.ScaleDlg;
import jkcemu.image.ThresholdDlg;
import jkcemu.print.PrintUtil;

public class ImageFrm
extends AbstractImageFrm
implements DropTargetListener,
FlavorListener,
MouseMotionListener {
    private static final String PROP_AUTORESIZE = "auto_resize";
    private static final String PROP_BACKGROUND = "background";
    private static final String VALUE_BLACK = "black";
    private static final String VALUE_GRAY = "gray";
    private static final String VALUE_WHITE = "white";
    private static final String VALUE_SYSTEM = "system";
    private static final String HELP_PAGE = "/help/tools/imageviewer.htm";
    private static final String ACTION_HISTORY_PREFIX = "history.";
    private static final String DEFAULT_STATUS_TEXT = "Bereit";
    private static final int MAX_CONTENT_SIZE_PERCENT = 75;
    private static final String TEXT_A5105_FMT = "A5105-Format (320x200, 16 Farben)";
    private static final String TEXT_AC1_ACC_FMT = "AC1-ACC-Blockgrafik (384x256, monochrom)";
    private static final String TEXT_AC1_SCCH_FMT = "AC1-SCCH-Blockgrafik (384x256, monochrom)";
    private static final String TEXT_AC1_2010_FMT = "AC1-2010-Blockgrafik (384x256, monochrom)";
    private static final String TEXT_KC85MONO_FMT = "KC85/2..5-Format ohne Farben (320x256, monochrom)";
    private static final String TEXT_KC854HIRES_FMT = "KC85/4,5-HIRES-Format (320x256, 4 Farben)";
    private static final String TEXT_LLC2HIRES_FMT = "LLC2-HIRES-Format (512x256, monochrom)";
    private static final String TEXT_Z1013_FMT = "Z1013-Blockgrafik (256x256, monochrom)";
    private static final String TEXT_Z9001_FMT = "Z9001-Blockgrafik (320x192, monochrom)";
    private static ImageFrm instance = null;
    private int lastRoundTopPixels = 0;
    private int lastRoundBottomPixels = 0;
    private boolean autoFitImage = true;
    private File[] files = null;
    private Object savedViewScale = null;
    private Point selectionStart = null;
    private CropDlg cropDlg = null;
    private Stack<ImgEntry> imgStack = new Stack();
    private JButton btnOpen;
    private JButton btnSaveAs;
    private JButton btnPrint;
    private JButton btnRotateLeft;
    private JButton btnRotateRight;
    private JButton btnFitImage;
    private JButton btnPrev;
    private JButton btnNext;
    private JMenuItem mnuOpen;
    private JMenuItem mnuSaveAs;
    private JMenuItem mnuExpImgA5105;
    private JMenuItem mnuExpImgKC852Monochrome;
    private JMenuItem mnuExpImgKC854Monochrome;
    private JMenuItem mnuExpImgKC854Hires;
    private JMenuItem mnuExpImgLLC2Hires;
    private JMenuItem mnuExpMemAC1;
    private JMenuItem mnuExpMemZ1013;
    private JMenuItem mnuExpMemZ9001;
    private JMenuItem mnuExpAppAC1;
    private JMenuItem mnuExpAppKC852;
    private JMenuItem mnuExpAppKC854;
    private JMenuItem mnuExpAppLLC2Hires;
    private JMenuItem mnuExpAppZ1013;
    private JMenuItem mnuExpAppZ9001;
    private JMenuItem mnuExpColorTab;
    private JMenuItem mnuImgProps;
    private JMenuItem mnuPrint;
    private JMenuItem mnuPrev;
    private JMenuItem mnuNext;
    private JMenuItem mnuClose;
    private JMenu mnuEdit;
    private JMenu mnuHistory;
    private JMenuItem mnuCopy;
    private JMenuItem mnuUndo;
    private JMenuItem mnuPaste;
    private JMenuItem mnuSelectArea;
    private JMenuItem mnuScaleImage;
    private JMenuItem mnuRotateImage;
    private JMenuItem mnuFlipHorizontal;
    private JMenuItem mnuRoundCorners;
    private JMenuItem mnuAdjustImage;
    private JMenuItem mnuIndexColors;
    private JMenuItem mnuToGray;
    private JMenuItem mnuToMonoFloydSteinberg;
    private JMenuItem mnuToMonoSierra3;
    private JMenuItem mnuToMonoAtkinson;
    private JMenuItem mnuThreshold;
    private JMenuItem mnuInvertImage;
    private JMenuItem mnuRemoveTransparency;
    private JMenu mnuConvert;
    private JMenuItem mnuToA5105;
    private JMenuItem mnuToAC1_ACC;
    private JMenuItem mnuToAC1_SCCH;
    private JMenuItem mnuToAC1_2010;
    private JMenuItem mnuToKC85Monochrome;
    private JMenuItem mnuToKC854Hires;
    private JMenuItem mnuToLLC2Hires21;
    private JMenuItem mnuToLLC2Hires43;
    private JMenuItem mnuToZ1013;
    private JMenuItem mnuToZ9001;
    private JMenuItem mnuBgSystem;
    private JMenuItem mnuBgBlack;
    private JMenuItem mnuBgGray;
    private JMenuItem mnuBgWhite;
    private JMenuItem mnuAutoResize;
    private JMenuItem mnuHelpContent;
    private JLabel labelStatus;
    private JComboBox<String> comboViewScale;

    public void fireFitImage() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImageFrm.this.doFitImage(false);
            }
        });
    }

    public ImgFld getImgFld() {
        return this.imgFld;
    }

    public String getMenuPathTextReduceColors() {
        return String.format("'%s' \u2192 '%s'", this.mnuEdit.getText(), this.mnuIndexColors.getText());
    }

    public static void open() {
        if (instance != null) {
            if (instance.getExtendedState() == 1) {
                instance.setExtendedState(0);
            }
        } else {
            instance = new ImageFrm();
        }
        instance.toFront();
        instance.setVisible(true);
    }

    public static void open(BufferedImage bufferedImage, String string) {
        ImageFrm.open();
        if (bufferedImage != null && instance.confirmImageSaved()) {
            ImgEntry.Mode mode = ImgEntry.Mode.UNSPECIFIED;
            IndexColorModel indexColorModel = ImgUtil.getIndexColorModel(bufferedImage);
            if (indexColorModel != null) {
                boolean bl = true;
                boolean bl2 = true;
                int n = indexColorModel.getMapSize();
                for (int i = 0; i < n; ++i) {
                    int n2;
                    int n3 = indexColorModel.getRGB(i);
                    if ((n3 >> 16 & 0xFF) != (n2 = n3 & 0xFF) || (n3 >> 8 & 0xFF) != n2) {
                        bl = false;
                        bl2 = false;
                        break;
                    }
                    if (n2 == 0 || n2 == 255) continue;
                    bl = false;
                }
                if (bl) {
                    mode = ImgEntry.Mode.MONOCHROME;
                } else if (bl2) {
                    mode = ImgEntry.Mode.GRAY;
                }
            }
            instance.showImageInternal(bufferedImage, mode, ImgFld.Rotation.NONE, null, string, true, null, null);
            instance.updFileList();
        }
    }

    public static void open(File file) {
        ImageFrm.open();
        if (file != null && instance.confirmImageSaved()) {
            instance.showImageFile(file);
        }
    }

    public void setSelection(int n, int n2, int n3, int n4) {
        this.imgFld.setSelection(n, n2, n3, n4);
    }

    public void setSelectionColor(Color color) {
        this.imgFld.setSelectionColor(color);
    }

    public void showDerivatedImage(BufferedImage bufferedImage, String string) {
        ImgEntry imgEntry = this.getCurImgEntry();
        if (imgEntry != null && bufferedImage != null) {
            this.showImageInternal(bufferedImage, imgEntry.getMode(), this.imgFld.getRotation(), null, string, false, null, null);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        File file = EmuUtil.fileDrop(this, dropTargetDropEvent);
        if (file != null && this.confirmImageSaved()) {
            this.showImageFile(file);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void flavorsChanged(FlavorEvent flavorEvent) {
        if (flavorEvent.getSource() == this.clipboard) {
            this.updPasteBtn();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this.imgFld) {
            String string = DEFAULT_STATUS_TEXT;
            Point point = this.toUnscaledPoint(mouseEvent);
            Point point2 = this.selectionStart;
            if (point2 != null) {
                int n = point2.x;
                int n2 = point2.y;
                int n3 = point.x - point2.x + 1;
                int n4 = point.y - point2.y + 1;
                Rectangle rectangle = null;
                if (this.cropDlg != null && this.cropDlg.isVisible()) {
                    rectangle = this.cropDlg.toRatio(point2.x, point2.y, point.x - point2.x + 1, point.y - point2.y + 1);
                }
                if (rectangle != null) {
                    this.imgFld.setSelection(rectangle);
                } else {
                    this.imgFld.setSelection(n, n2, n3, n4);
                }
                rectangle = this.imgFld.getSelectedArea();
                if (rectangle != null) {
                    if (this.cropDlg != null && this.cropDlg.isVisible()) {
                        this.cropDlg.setSelectedArea(rectangle);
                    }
                    string = String.format("Ausgew\u00e4hlter Bereich: X,Y=%d,%d  B,H=%d,%d", rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            } else {
                this.selectionStart = new Point(point.x, point.y);
            }
            this.labelStatus.setText(string);
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this.imgFld && this.imgFld.getSelection() == null) {
            String string = DEFAULT_STATUS_TEXT;
            BufferedImage bufferedImage = this.getImage();
            if (bufferedImage != null) {
                int n = bufferedImage.getWidth();
                int n2 = bufferedImage.getHeight();
                if (n > 0 && n2 > 0) {
                    Point point = this.toUnscaledPoint(mouseEvent);
                    if (point.x >= 0 && point.x < n && point.y >= 0 && point.y < n2) {
                        if (bufferedImage instanceof BufferedImage) {
                            int n3 = bufferedImage.getRGB(point.x, point.y);
                            string = bufferedImage.getTransparency() == 1 ? String.format("X,Y=%d,%d  RGB=%d,%d,%d", point.x, point.y, n3 >> 16 & 0xFF, n3 >> 8 & 0xFF, n3 & 0xFF) : String.format("X,Y=%d,%d  RGB=%d,%d,%d  Alpha=%d", point.x, point.y, n3 >> 16 & 0xFF, n3 >> 8 & 0xFF, n3 & 0xFF, n3 >> 24 & 0xFF);
                        } else {
                            string = String.format("X=%d Y=%d", point.x, point.y);
                        }
                    }
                }
            }
            this.labelStatus.setText(string);
            mouseEvent.consume();
        }
    }

    @Override
    public boolean applySettings(Properties properties, boolean bl) {
        boolean bl2 = false;
        if (properties != null) {
            bl2 = super.applySettings(properties, bl);
            String string = this.getSettingsPrefix();
            this.mnuAutoResize.setSelected(EmuUtil.getBooleanProperty(properties, string + PROP_AUTORESIZE, false));
            JMenuItem jMenuItem = this.mnuBgSystem;
            Color color = SystemColor.window;
            String string2 = properties.getProperty(string + PROP_BACKGROUND);
            if (string2 != null) {
                if ((string2 = string2.trim().toLowerCase()).equals(VALUE_BLACK)) {
                    color = Color.black;
                    jMenuItem = this.mnuBgBlack;
                } else if (string2.equals(VALUE_GRAY)) {
                    color = Color.gray;
                    jMenuItem = this.mnuBgGray;
                } else if (string2.equals(VALUE_WHITE)) {
                    color = Color.white;
                    jMenuItem = this.mnuBgWhite;
                }
            }
            jMenuItem.setSelected(true);
            this.imgFld.setBackground(color);
            this.imgFld.repaint();
        }
        return bl2;
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        super.componentResized(componentEvent);
        if (this.autoFitImage) {
            this.fitImage(false);
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        String string;
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object == this.btnRotateLeft) {
            bl = true;
            this.doRotateLeft();
        } else if (object == this.btnRotateRight) {
            bl = true;
            this.doRotateRight();
        } else if (object == this.btnFitImage) {
            bl = true;
            this.doFitImage(true);
        } else if (object == this.btnOpen || object == this.mnuOpen) {
            bl = true;
            this.doOpen();
        } else if (object == this.mnuClose) {
            bl = true;
            this.doClose();
        } else if (object == this.btnSaveAs || object == this.mnuSaveAs) {
            bl = true;
            this.doSaveAs();
        } else if (object == this.mnuExpImgA5105) {
            bl = true;
            this.doExport(ExpFmt.IMG_A5105);
        } else if (object == this.mnuExpImgKC852Monochrome) {
            bl = true;
            this.doExport(ExpFmt.IMG_KC852_MONOCHROME);
        } else if (object == this.mnuExpImgKC854Monochrome) {
            bl = true;
            this.doExport(ExpFmt.IMG_KC854_MONOCHROME);
        } else if (object == this.mnuExpImgKC854Hires) {
            bl = true;
            this.doExport(ExpFmt.IMG_KC854_HIRES);
        } else if (object == this.mnuExpImgLLC2Hires) {
            bl = true;
            this.doExport(ExpFmt.IMG_LLC2_HIRES);
        } else if (object == this.mnuExpAppAC1) {
            bl = true;
            this.doExport(ExpFmt.APP_AC1);
        } else if (object == this.mnuExpAppKC852) {
            bl = true;
            this.doExport(ExpFmt.APP_KC852);
        } else if (object == this.mnuExpAppKC854) {
            bl = true;
            this.doExport(ExpFmt.APP_KC854);
        } else if (object == this.mnuExpAppLLC2Hires) {
            bl = true;
            this.doExport(ExpFmt.APP_LLC2_HIRES);
        } else if (object == this.mnuExpAppZ1013) {
            bl = true;
            this.doExport(ExpFmt.APP_Z1013);
        } else if (object == this.mnuExpAppZ9001) {
            bl = true;
            this.doExport(ExpFmt.APP_Z9001);
        } else if (object == this.mnuExpMemAC1) {
            bl = true;
            this.doExport(ExpFmt.MEM_AC1);
        } else if (object == this.mnuExpMemZ1013) {
            bl = true;
            this.doExport(ExpFmt.MEM_Z1013);
        } else if (object == this.mnuExpMemZ9001) {
            bl = true;
            this.doExport(ExpFmt.MEM_Z9001);
        } else if (object == this.mnuExpColorTab) {
            bl = true;
            this.doExportColorTab();
        } else if (object == this.mnuImgProps) {
            bl = true;
            this.doImgProps();
        } else if (object == this.btnPrint || object == this.mnuPrint) {
            bl = true;
            if (this.getImage() != null) {
                PrintUtil.doPrint(this, this.imgFld, "Bildbetrachter");
            }
        } else if (object == this.btnPrev || object == this.mnuPrev) {
            bl = true;
            this.doPrev();
        } else if (object == this.btnNext || object == this.mnuNext) {
            bl = true;
            this.doNext();
        } else if (object == this.mnuCopy) {
            bl = true;
            this.doCopy();
        } else if (object == this.mnuPaste) {
            bl = true;
            this.doPaste();
        } else if (object == this.mnuRoundCorners) {
            bl = true;
            this.doRoundCorners();
        } else if (object == this.mnuSelectArea) {
            bl = true;
            this.doSelectArea();
        } else if (object == this.mnuScaleImage) {
            bl = true;
            this.doScaleImage();
        } else if (object == this.mnuRotateImage) {
            bl = true;
            this.doRotateImage();
        } else if (object == this.mnuFlipHorizontal) {
            bl = true;
            this.doFlipHorizontal();
        } else if (object == this.mnuAdjustImage) {
            bl = true;
            this.doAdjustImage();
        } else if (object == this.mnuIndexColors) {
            bl = true;
            this.doIndexColors();
        } else if (object == this.mnuToGray) {
            bl = true;
            this.doToGray();
        } else if (object == this.mnuToMonoFloydSteinberg) {
            bl = true;
            this.doToMonochrome(Dithering.Algorithm.FLOYD_STEINBERG);
        } else if (object == this.mnuToMonoSierra3) {
            bl = true;
            this.doToMonochrome(Dithering.Algorithm.SIERRA3);
        } else if (object == this.mnuToMonoAtkinson) {
            bl = true;
            this.doToMonochrome(Dithering.Algorithm.ATKINSON);
        } else if (object == this.mnuThreshold) {
            bl = true;
            this.doThreshold();
        } else if (object == this.mnuInvertImage) {
            bl = true;
            this.doInvertImage();
        } else if (object == this.mnuRemoveTransparency) {
            bl = true;
            this.doRemoveTransparency();
        } else if (object == this.mnuToA5105) {
            bl = true;
            this.doToA5105();
        } else if (object == this.mnuToAC1_ACC) {
            bl = true;
            this.doToAC1("AC1-ACC-Blockgrafik", "/rom/ac1/accfont.bin", ImgEntry.Mode.AC1_ACC);
        } else if (object == this.mnuToAC1_SCCH) {
            bl = true;
            this.doToAC1("AC1-SCCH-Blockgrafik", "/rom/ac1/scchfont.bin", ImgEntry.Mode.AC1_SCCH);
        } else if (object == this.mnuToAC1_2010) {
            bl = true;
            this.doToAC1("AC1-2010-Blockgrafik", "/rom/ac1/font2010.bin", ImgEntry.Mode.AC1_2010);
        } else if (object == this.mnuToKC85Monochrome) {
            bl = true;
            this.doToKC85Monochrome();
        } else if (object == this.mnuToKC854Hires) {
            bl = true;
            this.doToKC854Hires();
        } else if (object == this.mnuToLLC2Hires21) {
            bl = true;
            this.doToLLC2Hires(false);
        } else if (object == this.mnuToLLC2Hires43) {
            bl = true;
            this.doToLLC2Hires(true);
        } else if (object == this.mnuToZ1013) {
            bl = true;
            this.doToZ1013();
        } else if (object == this.mnuToZ9001) {
            bl = true;
            this.doToZ9001();
        } else if (object == this.mnuUndo) {
            bl = true;
            this.doUndo();
        } else if (object == this.mnuBgSystem) {
            bl = true;
            this.imgFld.setBackground(SystemColor.window);
            this.imgFld.repaint();
        } else if (object == this.mnuBgBlack) {
            bl = true;
            this.imgFld.setBackground(Color.black);
            this.imgFld.repaint();
        } else if (object == this.mnuBgGray) {
            bl = true;
            this.imgFld.setBackground(Color.gray);
            this.imgFld.repaint();
        } else if (object == this.mnuBgWhite) {
            bl = true;
            this.imgFld.setBackground(Color.white);
            this.imgFld.repaint();
        } else if (object == this.mnuHelpContent) {
            bl = true;
            HelpFrm.open(HELP_PAGE);
        }
        if (!bl && eventObject instanceof ActionEvent && (string = ((ActionEvent)eventObject).getActionCommand()) != null) {
            int n = ACTION_HISTORY_PREFIX.length();
            if (string.length() > n && string.startsWith(ACTION_HISTORY_PREFIX)) {
                try {
                    this.doRollbackTo(Integer.parseInt(string.substring(n)));
                    bl = true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (!bl) {
            bl = super.doAction(eventObject);
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        boolean bl = false;
        if (this.confirmImageSaved() && (bl = super.doClose()) && !Main.checkQuit(this)) {
            this.clearContent();
        }
        return bl;
    }

    @Override
    protected void doRotateLeft() {
        super.doRotateLeft();
        if (this.autoFitImage) {
            this.fitImage(false);
        }
        this.updCropDlg();
    }

    @Override
    protected void doRotateRight() {
        super.doRotateRight();
        if (this.autoFitImage) {
            this.fitImage(false);
        }
        this.updCropDlg();
    }

    @Override
    protected void doScaleView() {
        super.doScaleView();
        this.autoFitImage = false;
        this.btnFitImage.setEnabled(true);
    }

    @Override
    protected BufferedImage getImage() {
        return this.imgStack.isEmpty() ? null : this.imgStack.peek().getImage();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this.imgFld) {
            this.labelStatus.setText(DEFAULT_STATUS_TEXT);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this.imgFld) {
            this.imgFld.setSelection(null);
            this.imgFld.requestFocus();
            this.labelStatus.setText(DEFAULT_STATUS_TEXT);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this.imgFld) {
            this.selectionStart = null;
        }
    }

    @Override
    public void putSettingsTo(Properties properties) {
        if (properties != null) {
            super.putSettingsTo(properties);
            String string = this.getSettingsPrefix();
            properties.setProperty(string + PROP_AUTORESIZE, String.valueOf(this.mnuAutoResize.isSelected()));
            String string2 = VALUE_SYSTEM;
            if (this.mnuBgBlack.isSelected()) {
                string2 = VALUE_BLACK;
            } else if (this.mnuBgGray.isSelected()) {
                string2 = VALUE_GRAY;
            } else if (this.mnuBgWhite.isSelected()) {
                string2 = VALUE_WHITE;
            }
            properties.setProperty(string + PROP_BACKGROUND, string2);
        }
    }

    @Override
    protected void updWindowSize() {
        Dimension dimension;
        if (this.mnuAutoResize.isSelected() && (dimension = this.imgFld.getRotatedImageSize()) != null) {
            int n = dimension.width;
            int n2 = dimension.height;
            if (n > 0 && n2 > 0) {
                this.removeComponentListener(this);
                double d = this.imgFld.getScale();
                n = (int)Math.round((double)n * d);
                n2 = (int)Math.round((double)n2 * d);
                Dimension dimension2 = this.getMaxContentSize();
                if (n > dimension2.width || n2 > dimension.width) {
                    this.setPreferredSize(new Dimension(Math.min(n, dimension2.width), Math.min(n2, dimension2.height)));
                }
                this.pack();
                this.setPreferredSize(null);
                this.addComponentListener(this);
            }
        }
    }

    private void doExport(ExpFmt expFmt) {
        ImgEntry imgEntry = this.getCurImgEntry();
        if (imgEntry != null) {
            FileFilter fileFilter = null;
            String string = "";
            String string2 = "";
            boolean bl = false;
            BufferedImage bufferedImage = imgEntry.getImage();
            boolean bl2 = false;
            switch (expFmt) {
                case IMG_A5105: {
                    string2 = "A5105-";
                    if (!imgEntry.isA5105Format()) break;
                    fileFilter = ImgUtil.createA5105ImageFileFilter();
                    string = ".scr";
                    bl2 = true;
                    break;
                }
                case APP_AC1: 
                case MEM_AC1: {
                    string2 = "AC1-";
                    bl = true;
                    if (!imgEntry.isAC1Format()) break;
                    if (expFmt.equals((Object)ExpFmt.APP_AC1)) {
                        fileFilter = EmuUtil.getHeadersaveFileFilter();
                        string = ".z80";
                    } else {
                        fileFilter = EmuUtil.getBinaryFileFilter();
                        string = "_1000_17FF.bin";
                    }
                    bl2 = true;
                    break;
                }
                case APP_KC852: {
                    string2 = "KC85/2,3-";
                    bl = true;
                    if (!imgEntry.isKC85MonochromeFormat()) break;
                    fileFilter = EmuUtil.getKCSystemFileFilter();
                    string = ".kcc";
                    bl2 = true;
                    break;
                }
                case APP_KC854: {
                    string2 = "KC85/4,5-";
                    bl = true;
                    if (!imgEntry.isKC854HiresFormat() && !imgEntry.isKC85MonochromeFormat()) break;
                    fileFilter = EmuUtil.getKCSystemFileFilter();
                    string = ".kcc";
                    bl2 = true;
                    break;
                }
                case IMG_KC852_MONOCHROME: {
                    string2 = "KC85/2,3-Monochrom-";
                    bl = true;
                    if (!imgEntry.isKC85MonochromeFormat()) break;
                    fileFilter = ImgUtil.createKC852ImageFileFilter();
                    string = ".pic";
                    bl2 = true;
                    break;
                }
                case IMG_KC854_MONOCHROME: {
                    string2 = "KC85/4,5-Monochrom-";
                    bl = true;
                    if (!imgEntry.isKC85MonochromeFormat()) break;
                    fileFilter = ImgUtil.createKC854LowresImageFileFilter();
                    string = ".pip";
                    bl2 = true;
                    break;
                }
                case IMG_KC854_HIRES: {
                    string2 = "KC85/4,5-HIRES-";
                    bl = true;
                    if (!imgEntry.isKC854HiresFormat() && !imgEntry.isKC85MonochromeFormat()) break;
                    fileFilter = ImgUtil.createKC854HiresImageFileFilter();
                    string = ".hip";
                    bl2 = true;
                    break;
                }
                case APP_LLC2_HIRES: 
                case IMG_LLC2_HIRES: {
                    string2 = "LLC2-HIRES-";
                    bl = true;
                    if (!imgEntry.isLLC2HiresFormat()) break;
                    if (imgEntry.getMemBytes() == null) {
                        imgEntry.setMemBytes(ImgUtil.createLLC2HiresMemBytes(bufferedImage));
                    }
                    if (expFmt.equals((Object)ExpFmt.APP_LLC2_HIRES)) {
                        fileFilter = EmuUtil.getHeadersaveFileFilter();
                        string = ".z80";
                    } else {
                        fileFilter = ImgUtil.createLLC2HiresImageFileFilter();
                        string = ".pix";
                    }
                    bl2 = true;
                    break;
                }
                case APP_Z1013: 
                case MEM_Z1013: {
                    string2 = "Z1013-";
                    bl = true;
                    if (!imgEntry.isZ1013Format()) break;
                    if (expFmt.equals((Object)ExpFmt.APP_Z1013)) {
                        fileFilter = EmuUtil.getHeadersaveFileFilter();
                        string = ".z80";
                    } else {
                        fileFilter = EmuUtil.getBinaryFileFilter();
                        string = "_EC00_EFFF.bin";
                    }
                    bl2 = true;
                    break;
                }
                case APP_Z9001: 
                case MEM_Z9001: {
                    string2 = "Z9001-";
                    bl = true;
                    if (!imgEntry.isZ9001Format()) break;
                    if (expFmt.equals((Object)ExpFmt.APP_Z9001)) {
                        fileFilter = EmuUtil.getKCSystemFileFilter();
                        string = ".kcc";
                    } else {
                        fileFilter = EmuUtil.getBinaryFileFilter();
                        string = "_EC00_EFBF.bin";
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                int n;
                if (!this.isUnrotated()) {
                    BaseDlg.showInfoDlg(this, "Das Bild wird ohne die gerade angezeigte Drehung exportiert,\nda bei dem Dateiformat Breite und H\u00f6he nicht \u00e4nderbar sind.\nWenn Sie das Bild gedreht exportieren m\u00f6chten,\nm\u00fcssen Sie es zuerst drehen, und dann mit der entsprechenden\nFunktion im Men\u00fc \"" + this.mnuEdit.getText() + "\" \u2192 \"" + this.mnuConvert.getText() + "\"\n" + "in das gew\u00fcnschte Format umwandeln.");
                }
                String string3 = null;
                File file = null;
                File file2 = imgEntry.getFile();
                if (file2 != null) {
                    string3 = file2.getName();
                    file = file2.getParentFile();
                } else {
                    for (n = this.imgStack.size() - 1; file2 == null && n >= 0; --n) {
                        file2 = ((ImgEntry)this.imgStack.get(n)).getFile();
                    }
                    if (file2 != null) {
                        string3 = file2.getName();
                    }
                    file = Main.getLastDirFile(bl ? "software" : "image");
                }
                if (string3 != null && (n = string3.lastIndexOf(46)) >= 0) {
                    string3 = string3.substring(0, n);
                }
                if (string3 != null && string3.isEmpty()) {
                    string3 = null;
                }
                if (string3 == null) {
                    string3 = "noname";
                }
                string3 = string3 + string;
                File file3 = EmuUtil.showFileSaveDlg(this, string2 + "Bild exportieren", file != null ? new File(file, string3) : new File(string3), fileFilter);
                if (file3 != null) {
                    try {
                        switch (expFmt) {
                            case IMG_A5105: {
                                ImgSaver.saveImageA5105(this, bufferedImage, file3);
                                break;
                            }
                            case IMG_KC852_MONOCHROME: {
                                ImgSaver.saveImageKC852Monochrome(bufferedImage, file3);
                                break;
                            }
                            case IMG_KC854_MONOCHROME: {
                                ImgSaver.saveImageKC854Monochrome(bufferedImage, file3);
                                break;
                            }
                            case IMG_KC854_HIRES: {
                                ImgSaver.saveImageKC854Hires(bufferedImage, file3);
                                break;
                            }
                            case IMG_LLC2_HIRES: {
                                ImgUtil.writeToFile(imgEntry.getMemBytes(), file3);
                                break;
                            }
                            case APP_AC1: {
                                if (imgEntry.equalsMode(ImgEntry.Mode.AC1_ACC)) {
                                    ImgSaver.saveAppAC1ACC(imgEntry.getMemBytes(), file3);
                                    break;
                                }
                                ImgSaver.saveAppAC1SCCH(imgEntry.getMemBytes(), file3);
                                break;
                            }
                            case APP_KC852: {
                                ImgSaver.saveAppKC852BW(bufferedImage, file3);
                                break;
                            }
                            case APP_KC854: {
                                if (imgEntry.isKC854HiresFormat()) {
                                    ImgSaver.saveAppKC854Hires(bufferedImage, file3);
                                    break;
                                }
                                ImgSaver.saveAppKC854LowresBW(bufferedImage, file3);
                                break;
                            }
                            case APP_LLC2_HIRES: {
                                ImgSaver.saveAppLLC2Hires(imgEntry.getMemBytes(), file3);
                                break;
                            }
                            case APP_Z1013: {
                                ImgSaver.saveAppZ1013(imgEntry.getMemBytes(), file3);
                                break;
                            }
                            case APP_Z9001: {
                                ImgSaver.saveAppZ9001(imgEntry.getMemBytes(), file3);
                                break;
                            }
                            case MEM_AC1: {
                                ImgUtil.writeToFile(imgEntry.getMemBytes(), file3);
                                break;
                            }
                            case MEM_Z1013: {
                                ImgUtil.writeToFile(imgEntry.getMemBytes(), file3);
                                break;
                            }
                            case MEM_Z9001: {
                                ImgUtil.writeToFile(imgEntry.getMemBytes(), file3);
                                break;
                            }
                            default: {
                                bl2 = false;
                            }
                        }
                        if (bl2) {
                            this.imageSaved(file3, bl ? "software" : "image");
                        }
                    }
                    catch (IOException iOException) {
                        BaseDlg.showErrorDlg((Component)this, iOException);
                    }
                }
            } else {
                BaseDlg.showErrorDlg((Component)this, "Sie m\u00fcssen das Bild zuerst mit der entsprechenden Funktion\nim Men\u00fc \"" + this.mnuEdit.getText() + "\" \u2192 \"" + this.mnuConvert.getText() + "\"\n" + "in das entsprechende Format umwandeln,\n" + "bevor Sie es in dem Format exportieren" + " k\u00f6nnen.\n" + "Lesen Sie dazu bitte auch die Hinweise" + " in der Hilfe!", "Exportieren");
            }
        }
    }

    private void doExportColorTab() {
        BufferedImage bufferedImage = this.getImage();
        if (bufferedImage != null) {
            File file;
            int n = 0;
            IndexColorModel indexColorModel = ImgUtil.getIndexColorModel(bufferedImage);
            if (indexColorModel != null && (n = indexColorModel.getMapSize()) > 0 && (file = EmuUtil.showFileSaveDlg(this, "Farbpalette exportieren", Main.getLastDirFile("image"), IFFFile.getPaletteFileFilter(), JASCPaletteFile.getFileFilter())) != null) {
                try {
                    if (JASCPaletteFile.accept(file)) {
                        JASCPaletteFile.write(file, indexColorModel);
                    } else if (IFFFile.accept(file)) {
                        IFFFile.writePalette(file, indexColorModel);
                    } else {
                        throw new IOException(ImgUtil.createFileSuffixNotSupportedMsg(JASCPaletteFile.getFileSuffixes(), IFFFile.getFileSuffixes()));
                    }
                    Main.setLastFile(file, "image");
                }
                catch (IOException iOException) {
                    BaseDlg.showErrorDlg((Component)this, iOException);
                }
            }
            if (n == 0) {
                BaseDlg.showErrorDlg((Component)this, "Das Bild hat keine indexierten Farben,\ndie als Farbpalette exportiert werden k\u00f6nnten.");
            }
        }
    }

    private void doOpen() {
        File file;
        if (instance.confirmImageSaved() && (file = EmuUtil.showFileOpenDlg(this, "Bilddatei \u00f6ffnen", Main.getLastDirFile("image"), ImgLoader.createFileFilter())) != null && this.showImageFile(file)) {
            Main.setLastFile(file, "image");
        }
    }

    private void doPrev() {
        if (this.confirmImageSaved()) {
            boolean bl = false;
            if (!this.imgStack.isEmpty()) {
                File file;
                File file2 = ((ImgEntry)this.imgStack.get(0)).getFile();
                Object[] objectArray = this.files;
                if (file2 != null && objectArray != null && (file = file2.getParentFile()) != null && objectArray.length > 0) {
                    try {
                        int n = Arrays.binarySearch(objectArray, file2);
                        if (n < 0) {
                            n = -(n + 1);
                        }
                        if (--n < 0) {
                            n = objectArray.length - 1;
                        }
                        for (int i = n; i >= 0; --i) {
                            Object object = objectArray[i];
                            if (((File)object).equals(file2) || !ImgLoader.accept((File)object)) continue;
                            this.showImageFile((File)object);
                            bl = true;
                            break;
                        }
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
            if (!bl) {
                this.showNoMoreImageFileFound();
            }
        }
    }

    private void doNext() {
        if (this.confirmImageSaved()) {
            boolean bl = false;
            if (!this.imgStack.isEmpty()) {
                File file;
                File file2 = ((ImgEntry)this.imgStack.get(0)).getFile();
                Object[] objectArray = this.files;
                if (file2 != null && objectArray != null && (file = file2.getParentFile()) != null && objectArray.length > 0) {
                    try {
                        int n = Arrays.binarySearch(objectArray, file2);
                        n = n >= 0 ? ++n : -(n + 1);
                        if (n >= objectArray.length) {
                            n = 0;
                        }
                        for (int i = n; i < objectArray.length; ++i) {
                            Object object = objectArray[i];
                            if (((File)object).equals(file2) || !ImgLoader.accept((File)object)) continue;
                            this.showImageFile((File)object);
                            bl = true;
                            break;
                        }
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
            if (!bl) {
                this.showNoMoreImageFileFound();
            }
        }
    }

    private void doImgProps() {
        ImgEntry imgEntry = this.getCurImgEntry();
        if (imgEntry != null) {
            ImgPropsDlg.showDlg(this, imgEntry.getImage(), imgEntry.getFile());
        }
    }

    private void doFitImage(boolean bl) {
        this.autoFitImage = true;
        this.fitImage(bl);
    }

    private void doPaste() {
        if (this.clipboard != null) {
            try {
                BufferedImgBuilder bufferedImgBuilder;
                BufferedImage bufferedImage;
                Object object;
                if (this.clipboard.isDataFlavorAvailable(DataFlavor.imageFlavor) && (object = this.clipboard.getData(DataFlavor.imageFlavor)) != null && object instanceof Image && this.confirmImageSaved() && (bufferedImage = (bufferedImgBuilder = new BufferedImgBuilder(this)).buildFrom((Image)object, "Bild einf\u00fcgen...")) != null) {
                    this.showImageInternal(bufferedImage, bufferedImgBuilder.getMode(), ImgFld.Rotation.NONE, null, "Eingef\u00fcgtes Bild", true, null, null);
                    this.updFileList();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void doSaveAs() {
        int n = this.imgStack.size();
        if (n > 0) {
            ImgEntry imgEntry = this.imgStack.peek();
            File file = null;
            for (int i = n - 1; file == null && i >= 0; --i) {
                file = ((ImgEntry)this.imgStack.get(i)).getFile();
            }
            if (file != null) {
                String string = file.getName();
                if (string != null && string.isEmpty()) {
                    string = null;
                }
                if (string != null) {
                    Object object;
                    int n2 = this.imgStack.size() - 1;
                    if (n2 > 0) {
                        object = String.format("_(%d)", n2);
                        String string2 = string;
                        String string3 = "";
                        int n3 = string.lastIndexOf(46);
                        if (n3 >= 0) {
                            string2 = string.substring(0, n3);
                            string3 = string.substring(n3);
                        }
                        if (!string2.endsWith((String)object)) {
                            string2 = string2 + (String)object;
                        }
                        string = string2 + string3;
                    }
                    file = (object = file.getParentFile()) != null ? new File((File)object, string) : new File(string);
                }
            }
            if ((file = this.saveAs(file)) != null) {
                this.imageSaved(file, "image");
            }
        }
    }

    private void doFlipHorizontal() {
        ImgEntry imgEntry = this.getCurImgEntry();
        if (imgEntry != null) {
            BufferedImage bufferedImage;
            int n = imgEntry.getWidth();
            int n2 = imgEntry.getHeight();
            if (n > 0 && n2 > 0 && (bufferedImage = ImgUtil.createCompatibleImage(imgEntry.getImage(), n, n2)) != null) {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage(imgEntry.getImage(), n, 0, -n, n2, this);
                graphics2D.dispose();
                double d = this.getViewScale();
                this.showImageInternal(bufferedImage, imgEntry.getMode(), this.imgFld.getRotation(), !this.autoFitImage && d > 0.0 ? Double.valueOf(d) : null, "Horizontal gespiegelt", false, null, null);
            }
        }
    }

    private void doRotateImage() {
        ImgEntry imgEntry = this.getCurImgEntry();
        if (imgEntry != null) {
            this.saveView();
            BufferedImage bufferedImage = RotateDlg.showDlg(this);
            if (bufferedImage != null) {
                boolean bl = this.autoFitImage;
                double d = this.getViewScale();
                this.showImageInternal(bufferedImage, imgEntry.getMode(), this.imgFld.getRotation(), !this.autoFitImage && d > 0.0 ? Double.valueOf(d) : null, "Gedreht", false, null, null);
                this.doFitImage(false);
                this.autoFitImage = bl;
            } else {
                this.restoreView();
            }
        }
    }

    private void doRoundCorners() {
        ImgEntry imgEntry = this.getCurImgEntry();
        if (imgEntry != null) {
            RoundCornersDlg roundCornersDlg = new RoundCornersDlg((Window)this, this.lastRoundTopPixels, this.lastRoundBottomPixels);
            roundCornersDlg.setVisible(true);
            int n = roundCornersDlg.getNumTopPixels();
            int n2 = roundCornersDlg.getNumBottomPixels();
            if (n > 0 || n2 > 0) {
                BufferedImage bufferedImage = ImgUtil.roundCorners(this, imgEntry.getImage(), n, n2);
                if (bufferedImage != null) {
                    this.showImageInternal(bufferedImage, imgEntry.getMode(), this.imgFld.getRotation(), this.getViewScale(), "Ecken abgerundet", false, null, null);
                }
                this.lastRoundTopPixels = n;
                this.lastRoundBottomPixels = n2;
            }
        }
    }

    private void doScaleImage() {
        BufferedImage bufferedImage;
        ImgEntry imgEntry = this.getCurImgEntry();
        if (imgEntry != null && (bufferedImage = ScaleDlg.showDlg(this, imgEntry.getImage())) != null) {
            this.showImageInternal(bufferedImage, ImgEntry.probeMode(bufferedImage), this.imgFld.getRotation(), null, "Skaliert", false, null, null);
        }
    }

    private void doSelectArea() {
        BufferedImage bufferedImage = this.getImage();
        if (bufferedImage != null) {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            if (n > 0 && n2 > 0) {
                Rectangle rectangle = this.imgFld.getSelectedArea();
                if (this.cropDlg == null) {
                    this.cropDlg = new CropDlg(this);
                }
                this.cropDlg.setImageSize(n, n2);
                this.cropDlg.setSelectedArea(rectangle);
                this.cropDlg.setVisible(true);
                this.cropDlg.toFront();
                this.imgFld.setSelection(rectangle);
            }
        }
    }

    private void doAdjustImage() {
        ImgEntry imgEntry = this.getCurImgEntry();
        if (imgEntry != null) {
            this.saveView();
            BufferedImage bufferedImage = ImgAdjustDlg.showDlg(this);
            if (bufferedImage != null) {
                double d = this.getViewScale();
                this.showImageInternal(bufferedImage, imgEntry.getMode() == ImgEntry.Mode.INDEXED_COLORS ? ImgEntry.Mode.INDEXED_COLORS : ImgEntry.Mode.UNSPECIFIED, this.imgFld.getRotation(), !this.autoFitImage && d > 0.0 ? Double.valueOf(d) : null, "Helligkeit,  Kontrast, Farben eingestellt", false, null, null);
            } else {
                this.restoreView();
            }
        }
    }

    private void doIndexColors() {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2 = this.getImage();
        if (bufferedImage2 != null && (bufferedImage = IndexColorsDlg.showDlg(this, bufferedImage2)) != null) {
            int n;
            String string = "Indexierte Farben";
            IndexColorModel indexColorModel = ImgUtil.getIndexColorModel(bufferedImage);
            if (indexColorModel != null && (n = indexColorModel.getMapSize()) > 0) {
                string = String.format("%d indexierte Farben", n);
            }
            if (bufferedImage != null) {
                double d = this.getViewScale();
                this.showImageInternal(bufferedImage, ImgEntry.Mode.INDEXED_COLORS, this.imgFld.getRotation(), !this.autoFitImage && d > 0.0 ? Double.valueOf(d) : null, string, false, null, null);
            }
        }
    }

    private void doToGray() {
        ImgEntry imgEntry = this.getCurImgEntry();
        if (imgEntry != null) {
            if (imgEntry.isAGrayMode() || imgEntry.isAMonochromeMode()) {
                BaseDlg.showInfoDlg(this, "Das Bild ist bereits in Graustufen");
            } else {
                BufferedImage bufferedImage = GrayScaler.toGray(this, imgEntry.getImage());
                if (bufferedImage != null) {
                    double d = this.getViewScale();
                    this.showImageInternal(bufferedImage, ImgEntry.Mode.GRAY, this.imgFld.getRotation(), !this.autoFitImage && d > 0.0 ? Double.valueOf(d) : null, "Graustufen", false, null, null);
                }
            }
        }
    }

    private void doToMonochrome(Dithering.Algorithm algorithm) {
        ImgEntry imgEntry = this.getCurImgEntry();
        if (imgEntry != null) {
            if (imgEntry.isAMonochromeMode()) {
                this.showImgAlreadyMonochrome();
            } else {
                BufferedImage bufferedImage = Dithering.work(this, imgEntry.getImage(), ImgUtil.getColorModelBW(), algorithm);
                if (bufferedImage != null) {
                    double d = this.getViewScale();
                    this.showImageInternal(bufferedImage, ImgEntry.Mode.MONOCHROME, this.imgFld.getRotation(), !this.autoFitImage && d > 0.0 ? Double.valueOf(d) : null, "Monochrom", false, null, null);
                }
            }
        }
    }

    private void doThreshold() {
        ImgEntry imgEntry = this.getCurImgEntry();
        if (imgEntry != null) {
            if (imgEntry.equalsMode(ImgEntry.Mode.MONOCHROME)) {
                this.showImgAlreadyMonochrome();
            } else {
                this.saveView();
                BufferedImage bufferedImage = ThresholdDlg.showDlg(this);
                if (bufferedImage != null) {
                    double d = this.getViewScale();
                    this.showImageInternal(bufferedImage, ImgEntry.Mode.MONOCHROME, this.imgFld.getRotation(), !this.autoFitImage && d > 0.0 ? Double.valueOf(d) : null, "Monochrom", false, null, null);
                } else {
                    this.restoreView();
                }
            }
        }
    }

    private void doInvertImage() {
        ImgEntry imgEntry = this.getCurImgEntry();
        if (imgEntry != null) {
            if (imgEntry.isAInversionMode()) {
                BaseDlg.showErrorDlg((Component)this, "Das Bild wurde bereits invertiert.");
            } else {
                BufferedImage bufferedImage = ColorInverter.work(this, imgEntry.getImage());
                if (bufferedImage != null) {
                    ImgEntry.Mode mode = ImgEntry.Mode.INVERTED;
                    switch (imgEntry.getMode()) {
                        case INDEXED_COLORS: {
                            mode = ImgEntry.Mode.INVERTED_INDEXED_COLORS;
                            break;
                        }
                        case GRAY: {
                            mode = ImgEntry.Mode.INVERTED_GRAY;
                            break;
                        }
                        case MONOCHROME: {
                            mode = ImgEntry.Mode.INVERTED_MONOCHROME;
                        }
                    }
                    double d = this.getViewScale();
                    this.showImageInternal(bufferedImage, mode, this.imgFld.getRotation(), !this.autoFitImage && d > 0.0 ? Double.valueOf(d) : null, "Invertiert", false, null, null);
                }
            }
        }
    }

    private void doRemoveTransparency() {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2 = this.getImage();
        if (bufferedImage2 != null && bufferedImage2.getTransparency() != 1 && (bufferedImage = RemoveTransparencyDlg.showDlg(this, bufferedImage2)) != null) {
            double d = this.getViewScale();
            this.showImageInternal(bufferedImage, ImgEntry.Mode.UNSPECIFIED, this.imgFld.getRotation(), !this.autoFitImage && d > 0.0 ? Double.valueOf(d) : null, "Transparenz entfernt", false, null, null);
        }
    }

    private void doToA5105() {
        ImgEntry imgEntry = this.getCurImgEntry();
        if (imgEntry != null) {
            if (imgEntry.isA5105Format() && this.isUnrotated()) {
                BaseDlg.showInfoDlg(this, "Das Bild ist bereits im A5105-Format.");
            } else {
                this.showImageInternal(this.drawImageTo(imgEntry.getImage(), null, new BufferedImage(320, 200, 12, ImgUtil.getColorModelA5105())), ImgEntry.Mode.A5105, ImgFld.Rotation.NONE, null, TEXT_A5105_FMT, false, null, null);
            }
        }
    }

    private void doToAC1(String string, String string2, ImgEntry.Mode mode) {
        ImgEntry imgEntry = this.getCurImgEntry();
        if (imgEntry != null) {
            if (imgEntry.equalsMode(mode) && imgEntry.isAC1Format() && this.isUnrotated()) {
                BaseDlg.showInfoDlg(this, "Das Bild ist bereits in dem AC1-Format.");
            } else {
                this.toMonochromCharImage(imgEntry.getImage(), string, string2, 384, 256, mode, 6, true);
            }
        }
    }

    private void doToKC85Monochrome() {
        ImgEntry imgEntry = this.getCurImgEntry();
        if (imgEntry != null) {
            if (imgEntry.isKC85MonochromeFormat() && this.isUnrotated()) {
                BaseDlg.showInfoDlg(this, "Das Bild ist bereits im KC85/2..5-Format ohne Farben.");
            } else {
                this.showImageInternal(this.drawImageTo(imgEntry.getImage(), null, ImgUtil.createBlackKC85BWImage()), ImgEntry.Mode.MONOCHROME, ImgFld.Rotation.NONE, null, TEXT_KC85MONO_FMT, false, null, null);
            }
        }
    }

    private void doToKC854Hires() {
        ImgEntry imgEntry = this.getCurImgEntry();
        if (imgEntry != null) {
            if ((imgEntry.isKC854HiresFormat() || imgEntry.isKC85MonochromeFormat()) && this.isUnrotated()) {
                BaseDlg.showInfoDlg(this, "Das Bild ist bereits im KC85/4,5-HIRES-Format.");
            } else {
                this.showImageInternal(this.drawImageTo(imgEntry.getImage(), null, ImgUtil.createBlackKC854HiresImage()), ImgEntry.Mode.KC854_HIRES, ImgFld.Rotation.NONE, null, TEXT_KC854HIRES_FMT, false, null, null);
            }
        }
    }

    private void doToLLC2Hires(boolean bl) {
        ImgEntry imgEntry = this.getCurImgEntry();
        if (imgEntry != null) {
            if (imgEntry.isLLC2HiresFormat() && this.isUnrotated()) {
                BaseDlg.showInfoDlg(this, "Das Bild ist bereits im LLC2-HIRES-Format.");
            } else {
                Float f = null;
                if (bl) {
                    f = Float.valueOf(1.5f);
                }
                this.showImageInternal(this.drawImageTo(imgEntry.getImage(), f, new BufferedImage(512, 256, 12, ImgUtil.getColorModelBW())), ImgEntry.Mode.MONOCHROME, ImgFld.Rotation.NONE, null, TEXT_LLC2HIRES_FMT, false, null, null);
            }
        }
    }

    private void doToZ1013() {
        BufferedImage bufferedImage = this.getImage();
        if (bufferedImage != null) {
            this.toMonochromCharImage(bufferedImage, "Z1013-Blockgrafik", "/rom/z1013/z1013font.bin", 256, 256, ImgEntry.Mode.Z1013, 8, false);
        }
    }

    private void doToZ9001() {
        BufferedImage bufferedImage = this.getImage();
        if (bufferedImage != null) {
            this.toMonochromCharImage(bufferedImage, "Z9001-Blockgrafik", "/rom/z9001/z9001font.bin", 320, 192, ImgEntry.Mode.Z9001, 8, false);
        }
    }

    private void doRollbackTo(int n) {
        if (n >= 0 && n < this.imgStack.size()) {
            boolean bl = true;
            if (n + 2 < this.imgStack.size()) {
                bl = BaseDlg.showYesNoDlg(this, "M\u00f6chten Sie die letzten " + String.valueOf(this.imgStack.size() - n - 1) + " Bildbearbeitungsschritte verwerfen?");
            }
            if (bl) {
                while (n + 1 < this.imgStack.size()) {
                    this.imgStack.pop();
                }
                ImgEntry imgEntry = this.imgStack.pop();
                this.rebuildHistoryMenu();
                this.showImageInternal(imgEntry.getImage(), imgEntry.getMode(), imgEntry.getRotation(), null, imgEntry.getTitle(), this.imgStack.isEmpty(), imgEntry.getFile(), imgEntry.getMemBytes());
            }
        }
    }

    private void doUndo() {
        if (this.imgStack.size() > 1) {
            this.doRollbackTo(this.imgStack.size() - 2);
        }
    }

    private ImageFrm() {
        this.setTitleInternal(null);
        Main.updIcon(this);
        JMenu jMenu = new JMenu("Datei");
        jMenu.setMnemonic(68);
        this.mnuOpen = this.createJMenuItem("\u00d6ffnen...", 79, 2);
        jMenu.add(this.mnuOpen);
        this.mnuSaveAs = this.createJMenuItem("Speichern unter...", 80, 3);
        jMenu.add(this.mnuSaveAs);
        JMenu jMenu2 = new JMenu("Exportieren als");
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        this.mnuExpImgA5105 = this.createJMenuItem("A5105-Bilddatei...");
        jMenu2.add(this.mnuExpImgA5105);
        this.mnuExpImgKC852Monochrome = this.createJMenuItem("KC85/2,3-Bilddatei ohne Farben...");
        jMenu2.add(this.mnuExpImgKC852Monochrome);
        this.mnuExpImgKC854Monochrome = this.createJMenuItem("KC85/4,5-Bilddatei ohne Farben...");
        jMenu2.add(this.mnuExpImgKC854Monochrome);
        this.mnuExpImgKC854Hires = this.createJMenuItem("KC85/4,5-HIRES-Bilddatei...");
        jMenu2.add(this.mnuExpImgKC854Hires);
        this.mnuExpImgLLC2Hires = this.createJMenuItem("LLC2-HIRES-Bilddatei...");
        jMenu2.add(this.mnuExpImgLLC2Hires);
        JMenu jMenu3 = new JMenu("Abbilddatei f\u00fcr Bildwiederholspeicher f\u00fcr");
        jMenu2.add(jMenu3);
        this.mnuExpMemAC1 = this.createJMenuItem("AC1...");
        jMenu3.add(this.mnuExpMemAC1);
        this.mnuExpMemZ1013 = this.createJMenuItem("Z1013...");
        jMenu3.add(this.mnuExpMemZ1013);
        this.mnuExpMemZ9001 = this.createJMenuItem("Z9001...");
        jMenu3.add(this.mnuExpMemZ9001);
        JMenu jMenu4 = new JMenu("Programm zur Anzeige des Bildes im");
        jMenu2.add(jMenu4);
        this.mnuExpAppAC1 = this.createJMenuItem("AC1...");
        jMenu4.add(this.mnuExpAppAC1);
        this.mnuExpAppKC852 = this.createJMenuItem("KC85/2,3...");
        jMenu4.add(this.mnuExpAppKC852);
        this.mnuExpAppKC854 = this.createJMenuItem("KC85/4,5...");
        jMenu4.add(this.mnuExpAppKC854);
        this.mnuExpAppLLC2Hires = this.createJMenuItem("LLC2...");
        jMenu4.add(this.mnuExpAppLLC2Hires);
        this.mnuExpAppZ1013 = this.createJMenuItem("Z1013...");
        jMenu4.add(this.mnuExpAppZ1013);
        this.mnuExpAppZ9001 = this.createJMenuItem("Z9001...");
        jMenu4.add(this.mnuExpAppZ9001);
        this.mnuExpColorTab = this.createJMenuItem("Farbpalette exportieren...");
        jMenu.add(this.mnuExpColorTab);
        jMenu.addSeparator();
        this.mnuImgProps = this.createJMenuItem("Bildeigenschaften...");
        jMenu.add(this.mnuImgProps);
        this.mnuPrint = this.createJMenuItem("Drucken...", 80, 2);
        jMenu.add(this.mnuPrint);
        jMenu.addSeparator();
        this.mnuPrev = this.createJMenuItem("Vorheriges Bild", 37, 2);
        jMenu.add(this.mnuPrev);
        this.mnuNext = this.createJMenuItem("N\u00e4chstes Bild", 39, 2);
        jMenu.add(this.mnuNext);
        jMenu.addSeparator();
        this.mnuClose = this.createJMenuItem("Schlie\u00dfen");
        jMenu.add(this.mnuClose);
        this.mnuEdit = new JMenu("Bearbeiten");
        this.mnuEdit.setMnemonic(66);
        this.mnuUndo = this.createJMenuItem("R\u00fcckg\u00e4ngig", 90, 2);
        this.mnuEdit.add(this.mnuUndo);
        this.mnuHistory = new JMenu("Historie");
        this.mnuEdit.add(this.mnuHistory);
        this.mnuEdit.addSeparator();
        this.mnuCopy = this.createJMenuItem("Bild kopieren");
        this.mnuEdit.add(this.mnuCopy);
        this.mnuPaste = this.createJMenuItem("Bild einf\u00fcgen");
        this.mnuEdit.add(this.mnuPaste);
        this.mnuEdit.addSeparator();
        this.mnuRotateImage = this.createJMenuItem("Drehen...");
        this.mnuEdit.add(this.mnuRotateImage);
        this.mnuFlipHorizontal = this.createJMenuItem("Spiegeln...");
        this.mnuEdit.add(this.mnuFlipHorizontal);
        this.mnuSelectArea = this.createJMenuItem("Zuschneiden...");
        this.mnuEdit.add(this.mnuSelectArea);
        this.mnuScaleImage = this.createJMenuItem("Skalieren...");
        this.mnuEdit.add(this.mnuScaleImage);
        this.mnuRoundCorners = this.createJMenuItem("Ecken abrunden...");
        this.mnuEdit.add(this.mnuRoundCorners);
        this.mnuEdit.addSeparator();
        this.mnuAdjustImage = this.createJMenuItem("Helligkeit, Kontrast, Farben...");
        this.mnuEdit.add(this.mnuAdjustImage);
        this.mnuIndexColors = this.createJMenuItem("Farben reduzieren und indexieren...");
        this.mnuEdit.add(this.mnuIndexColors);
        JMenu jMenu5 = new JMenu("Schwarz/Wei\u00df wandeln");
        this.mnuEdit.add(jMenu5);
        this.mnuToGray = this.createJMenuItem("Graustufen");
        jMenu5.add(this.mnuToGray);
        this.mnuThreshold = this.createJMenuItem("Monochrom mittels Schwellwert");
        jMenu5.add(this.mnuThreshold);
        JMenu jMenu6 = new JMenu("Monochrom mittels Dithering");
        jMenu5.add(jMenu6);
        this.mnuToMonoFloydSteinberg = this.createJMenuItem(Dithering.getAlgorithmText(Dithering.Algorithm.FLOYD_STEINBERG));
        jMenu6.add(this.mnuToMonoFloydSteinberg);
        this.mnuToMonoSierra3 = this.createJMenuItem(Dithering.getAlgorithmText(Dithering.Algorithm.SIERRA3));
        jMenu6.add(this.mnuToMonoSierra3);
        this.mnuToMonoAtkinson = this.createJMenuItem(Dithering.getAlgorithmText(Dithering.Algorithm.ATKINSON));
        jMenu6.add(this.mnuToMonoAtkinson);
        this.mnuInvertImage = this.createJMenuItem("Invertieren");
        this.mnuEdit.add(this.mnuInvertImage);
        this.mnuRemoveTransparency = this.createJMenuItem("Transparenz entfernen...");
        this.mnuEdit.add(this.mnuRemoveTransparency);
        this.mnuEdit.addSeparator();
        this.mnuConvert = new JMenu("Konvertieren in");
        this.mnuEdit.add(this.mnuConvert);
        this.mnuToA5105 = this.createJMenuItem(TEXT_A5105_FMT);
        this.mnuConvert.add(this.mnuToA5105);
        this.mnuToAC1_ACC = this.createJMenuItem(TEXT_AC1_ACC_FMT);
        this.mnuConvert.add(this.mnuToAC1_ACC);
        this.mnuToAC1_SCCH = this.createJMenuItem(TEXT_AC1_SCCH_FMT);
        this.mnuConvert.add(this.mnuToAC1_SCCH);
        this.mnuToAC1_2010 = this.createJMenuItem(TEXT_AC1_2010_FMT);
        this.mnuConvert.add(this.mnuToAC1_2010);
        this.mnuToKC85Monochrome = this.createJMenuItem(TEXT_KC85MONO_FMT);
        this.mnuConvert.add(this.mnuToKC85Monochrome);
        this.mnuToKC854Hires = this.createJMenuItem(TEXT_KC854HIRES_FMT);
        this.mnuConvert.add(this.mnuToKC854Hires);
        this.mnuToLLC2Hires21 = this.createJMenuItem("LLC2-HIRES-Format (512x256, monochrom) ohne Anpassung f\u00fcr 4:3-Anzeige");
        this.mnuConvert.add(this.mnuToLLC2Hires21);
        this.mnuToLLC2Hires43 = this.createJMenuItem("LLC2-HIRES-Format (512x256, monochrom) mit Anpassung f\u00fcr 4:3-Anzeige");
        this.mnuConvert.add(this.mnuToLLC2Hires43);
        this.mnuToZ1013 = this.createJMenuItem(TEXT_Z1013_FMT);
        this.mnuConvert.add(this.mnuToZ1013);
        this.mnuToZ9001 = this.createJMenuItem(TEXT_Z9001_FMT);
        this.mnuConvert.add(this.mnuToZ9001);
        JMenu jMenu7 = new JMenu("Einstellungen");
        jMenu7.setMnemonic(69);
        this.mnuAutoResize = new JCheckBoxMenuItem("Fenster an Bildgr\u00f6\u00dfe anpassen", false);
        jMenu7.add(this.mnuAutoResize);
        jMenu7.addSeparator();
        JMenu jMenu8 = new JMenu("Hintergrundfarbe");
        jMenu7.add(jMenu8);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.mnuBgSystem = new JRadioButtonMenuItem("System", true);
        this.mnuBgSystem.addActionListener(this);
        buttonGroup.add(this.mnuBgSystem);
        jMenu8.add(this.mnuBgSystem);
        jMenu8.addSeparator();
        this.mnuBgBlack = new JRadioButtonMenuItem("schwarz", false);
        this.mnuBgBlack.addActionListener(this);
        buttonGroup.add(this.mnuBgBlack);
        jMenu8.add(this.mnuBgBlack);
        this.mnuBgGray = new JRadioButtonMenuItem("grau", false);
        this.mnuBgGray.addActionListener(this);
        buttonGroup.add(this.mnuBgGray);
        jMenu8.add(this.mnuBgGray);
        this.mnuBgWhite = new JRadioButtonMenuItem("wei\u00df", false);
        this.mnuBgWhite.addActionListener(this);
        buttonGroup.add(this.mnuBgWhite);
        jMenu8.add(this.mnuBgWhite);
        JMenu jMenu9 = new JMenu("?");
        this.mnuHelpContent = this.createJMenuItem("Hilfe...");
        jMenu9.add(this.mnuHelpContent);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        jMenuBar.add(this.mnuEdit);
        jMenuBar.add(jMenu7);
        jMenuBar.add(jMenu9);
        this.setJMenuBar(jMenuBar);
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.add((Component)jPanel, "North");
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        jToolBar.setOrientation(0);
        jToolBar.setRollover(true);
        jPanel.add(jToolBar);
        this.btnOpen = this.createImageButton("/images/file/open.png", this.mnuOpen.getText());
        jToolBar.add(this.btnOpen);
        this.btnSaveAs = this.createImageButton("/images/file/save_as.png", "Speichern unter");
        jToolBar.add(this.btnSaveAs);
        this.btnPrint = this.createImageButton("/images/file/print.png", "Drucken");
        jToolBar.add(this.btnPrint);
        jToolBar.addSeparator();
        this.btnRotateLeft = this.createImageButton("/images/edit/rotate_left.png", "Nach links drehen");
        jToolBar.add(this.btnRotateLeft);
        this.btnRotateRight = this.createImageButton("/images/edit/rotate_right.png", "Nach rechts drehen");
        jToolBar.add(this.btnRotateRight);
        jToolBar.addSeparator();
        this.comboViewScale = this.createScaleComboBox(100, 10, 15, 25, 33, 50, 75, 100, 200, 300, 400);
        jToolBar.add(this.comboViewScale);
        this.btnFitImage = this.createImageButton("/images/edit/fit.png", "Bild an Fenstergr\u00f6\u00dfe anpassen");
        jToolBar.add(this.btnFitImage);
        jToolBar.addSeparator();
        this.btnPrev = this.createImageButton("/images/nav/back.png", "Vorheriges Bild");
        jToolBar.add(this.btnPrev);
        jToolBar.addSeparator();
        this.btnNext = this.createImageButton("/images/nav/next.png", "N\u00e4chstes Bild");
        jToolBar.add(this.btnNext);
        jToolBar.addSeparator();
        this.labelStatus = new JLabel(DEFAULT_STATUS_TEXT);
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel2.add(this.labelStatus);
        this.add((Component)jPanel2, "South");
        new DropTarget(this.imgFld, this).setActive(true);
        new DropTarget(this.scrollPane, this).setActive(true);
        if (!this.applySettings(Main.getProperties(), true)) {
            this.pack();
            this.setScreenCentered();
        }
        this.setResizable(true);
        this.imgFld.addMouseListener(this);
        this.imgFld.addMouseMotionListener(this);
        if (this.clipboard != null) {
            this.clipboard.addFlavorListener(this);
        }
        this.clearContent();
    }

    private void clearContent() {
        this.showImageInternal(null, ImgEntry.Mode.UNSPECIFIED, ImgFld.Rotation.NONE, null, null, true, null, null);
        this.updFileList();
        this.updPasteBtn();
        this.labelStatus.setText(DEFAULT_STATUS_TEXT);
    }

    private void clearHistoryMenu() {
        try {
            int n = this.mnuHistory.getItemCount();
            for (int i = 0; i < n; ++i) {
                this.mnuHistory.getItem(i).removeActionListener(this);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.mnuHistory.removeAll();
    }

    private boolean confirmImageSaved() {
        boolean bl = true;
        int n = this.imgStack.size();
        if (n > 1 && this.imgStack.peek().getFile() == null) {
            bl = BaseDlg.showYesNoWarningDlg(this, "Das angezeigte Bild wurde nicht gespeichert.\nM\u00f6chten Sie es verwerfen?", "Bild nicht gespeichert");
        }
        return bl;
    }

    private BufferedImage drawImageTo(BufferedImage bufferedImage, Float f, BufferedImage bufferedImage2) {
        if (bufferedImage != null && bufferedImage2 != null) {
            float f2 = bufferedImage.getWidth();
            float f3 = bufferedImage.getHeight();
            ImgFld.Rotation rotation = this.imgFld.getRotation();
            if (rotation.equals((Object)ImgFld.Rotation.LEFT) || rotation.equals((Object)ImgFld.Rotation.RIGHT)) {
                f2 = bufferedImage.getHeight();
                f3 = bufferedImage.getWidth();
            }
            if (f != null) {
                f2 *= f.floatValue();
            }
            float f4 = f2 / f3;
            int n = bufferedImage2.getWidth();
            int n2 = bufferedImage2.getHeight();
            float f5 = (float)n / (float)n2;
            int n3 = 0;
            int n4 = 0;
            int n5 = n;
            int n6 = n2;
            if (f5 < f4) {
                n5 = n;
                n6 = Math.round((float)n / f2 * f3);
                n4 = (n2 - n6) / 2;
            } else if (f5 > f4) {
                n6 = n2;
                n5 = Math.round((float)n2 / f3 * f2);
                n3 = (n - n5) / 2;
            }
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setColor(Color.black);
            graphics2D.fillRect(0, 0, n, n2);
            if (!rotation.equals((Object)ImgFld.Rotation.NONE)) {
                int n7 = 0;
                switch (rotation) {
                    case LEFT: {
                        graphics2D.rotate(-1.5707963267948966);
                        n3 = -((n2 - n6) / 2) - n6;
                        n4 = (n - n5) / 2;
                        n7 = n5;
                        n5 = n6;
                        n6 = n7;
                        break;
                    }
                    case RIGHT: {
                        graphics2D.rotate(1.5707963267948966);
                        n3 = (n2 - n6) / 2;
                        n4 = -((n - n5) / 2) - n5;
                        n7 = n5;
                        n5 = n6;
                        n6 = n7;
                        break;
                    }
                    case DOWN: {
                        graphics2D.rotate(Math.PI);
                        n3 = -((n - n5) / 2) - n5;
                        n4 = -((n2 - n6) / 2) - n6;
                    }
                }
            }
            graphics2D.drawImage(bufferedImage, n3, n4, n5, n6, this);
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    private void fitImage(boolean bl) {
        boolean bl2 = false;
        Dimension dimension = this.imgFld.getRotatedImageSize();
        if (dimension != null) {
            bl2 = true;
            JViewport jViewport = this.scrollPane.getViewport();
            if (jViewport != null) {
                int n = jViewport.getWidth();
                int n2 = jViewport.getHeight();
                if (n > 0 && n2 > 0 && dimension.width > 0 && dimension.height > 0 && (bl || n < dimension.width || n2 < dimension.height)) {
                    this.scrollPane.invalidate();
                    this.imgFld.setScale(Math.min((double)n / (double)dimension.width, (double)n2 / (double)dimension.height));
                    this.scrollPane.validate();
                    this.scrollPane.repaint();
                    this.updViewScaleFld();
                    bl2 = false;
                }
            }
        }
        this.btnFitImage.setEnabled(bl2);
    }

    private ImgEntry getCurImgEntry() {
        return this.imgStack.isEmpty() ? null : this.imgStack.peek();
    }

    private Dimension getMaxContentSize() {
        Dimension dimension;
        Dimension dimension2 = null;
        Toolkit toolkit = this.getToolkit();
        if (toolkit != null && (dimension = toolkit.getScreenSize()) != null && dimension.width > 0 && dimension.height > 0) {
            dimension2 = new Dimension(dimension.width * 75 / 100, dimension.height * 75 / 100);
        }
        return dimension2 != null ? dimension2 : new Dimension(0, 0);
    }

    private static int getNumMatchingPixels(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = 0;
        for (int i = 0; i < byArray2.length; ++i) {
            int n4 = 0;
            if (byArray != null && n < byArray.length) {
                n4 = byArray[n++] & 0xFF;
            }
            int n5 = byArray2[i] & 0xFF;
            int n6 = 1;
            for (int j = 0; j < n2; ++j) {
                if ((n4 & n6) == (n5 & n6)) {
                    ++n3;
                }
                n6 <<= 1;
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void imageSaved(File file, String string) {
        if (file == null) return;
        Main.setLastFile(file, string);
        if (this.imgStack.size() == 1) {
            if (this.files == null) return;
            try {
                if (Arrays.binarySearch(this.files, file) >= 0) return;
                this.files = null;
                return;
            }
            catch (ClassCastException classCastException) {
                this.files = null;
                return;
            }
            finally {
                if (this.files == null) {
                    this.updFileListBtnsEnabled();
                }
            }
        } else {
            ImgEntry imgEntry = this.getCurImgEntry();
            if (imgEntry == null) return;
            imgEntry.setFile(file);
        }
    }

    private boolean isUnrotated() {
        return this.imgFld.getRotation().equals((Object)ImgFld.Rotation.NONE);
    }

    private void rebuildHistoryMenu() {
        this.clearHistoryMenu();
        int n = this.imgStack.size() - 1;
        for (int i = 0; i < n; ++i) {
            String string = ((ImgEntry)this.imgStack.get(i)).getTitle();
            if (string == null) {
                string = "kein Titel";
            }
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.setActionCommand(ACTION_HISTORY_PREFIX + String.valueOf(i));
            jMenuItem.addActionListener(this);
            this.mnuHistory.add(jMenuItem);
        }
    }

    private void saveView() {
        this.savedViewScale = this.autoFitImage ? null : this.comboViewScale.getSelectedItem();
        this.imgFld.save();
    }

    private void restoreView() {
        this.imgFld.restore();
        String string = null;
        if (this.savedViewScale != null) {
            string = this.savedViewScale.toString();
        }
        if (string != null) {
            this.comboViewScale.setSelectedItem(string);
        } else {
            this.doFitImage(false);
        }
    }

    private void setTitleInternal(String string) {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("JKCEMU Bildbetrachter");
        if (string != null) {
            String string2;
            BufferedImage bufferedImage;
            if (!string.isEmpty()) {
                stringBuilder.append(": ");
                stringBuilder.append(string);
            }
            if ((bufferedImage = this.getImage()) != null && !string.contains(string2 = String.format("%dx%d", bufferedImage.getWidth(), bufferedImage.getHeight()))) {
                stringBuilder.append(" (");
                stringBuilder.append(string2);
                stringBuilder.append(')');
            }
        }
        this.setTitle(stringBuilder.toString());
    }

    private boolean showImageFile(File file) {
        boolean bl = false;
        if (file != null) {
            CharSequence charSequence;
            ImgEntry imgEntry = null;
            String string = null;
            try {
                imgEntry = ImgLoader.load(file);
                if (imgEntry != null) {
                    charSequence = file.getName();
                    if (charSequence != null && ((String)charSequence).isEmpty()) {
                        charSequence = null;
                    }
                    if (charSequence == null) {
                        charSequence = file.getPath();
                    }
                    BufferedImage bufferedImage = imgEntry.getImage();
                    this.showImageInternal(bufferedImage, imgEntry.getMode(), ImgFld.Rotation.NONE, null, (String)charSequence, true, file, null);
                    this.updFileList();
                    bl = true;
                } else {
                    string = "Dateiformat nicht unterst\u00fctzt";
                }
            }
            catch (Exception exception) {
                string = exception.getMessage();
            }
            if (imgEntry == null) {
                charSequence = new StringBuilder(64);
                ((StringBuilder)charSequence).append("Bilddatei kann nicht geladen werden");
                if (string != null) {
                    ((StringBuilder)charSequence).append(":\n");
                    ((StringBuilder)charSequence).append(string);
                } else {
                    ((StringBuilder)charSequence).append('.');
                }
                BaseDlg.showErrorDlg((Component)this, ((StringBuilder)charSequence).toString());
            }
        }
        return bl;
    }

    private void showImageInternal(BufferedImage bufferedImage, ImgEntry.Mode mode, ImgFld.Rotation rotation, Double d, String string, boolean bl, File file, byte[] byArray) {
        int n;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        int n3 = 0;
        double d2 = 1.0;
        if (bufferedImage != null) {
            n2 = bufferedImage.getWidth();
            n3 = bufferedImage.getHeight();
            if (n2 > 0 && n3 > 0) {
                bl3 = true;
                if (d == null && this.mnuAutoResize.isSelected()) {
                    n = 0;
                    int n4 = 0;
                    JViewport jViewport = this.scrollPane.getViewport();
                    if (jViewport != null) {
                        n = jViewport.getWidth();
                        n4 = jViewport.getHeight();
                    }
                    if (n2 > n || n3 > n4) {
                        Dimension dimension = this.getMaxContentSize();
                        int n5 = dimension.width;
                        int n6 = dimension.height;
                        if (n5 < 1 || n6 < 1) {
                            n5 = 640;
                            n6 = 480;
                        }
                        bl2 = true;
                        if (n2 > n5 || n3 > n6) {
                            d2 = Math.min((double)n5 / (double)n2, (double)n6 / (double)n3);
                        }
                    }
                }
            }
        }
        n = 0;
        ImgEntry imgEntry = this.getCurImgEntry();
        if (bl) {
            this.imgStack.clear();
            this.clearHistoryMenu();
        } else {
            imgEntry.setRotation(this.imgFld.getRotation());
        }
        if (bufferedImage != null) {
            this.imgStack.push(new ImgEntry(bufferedImage, mode, rotation, string, file, byArray));
            this.rebuildHistoryMenu();
            n = bufferedImage.getTransparency() != 1 ? 1 : 0;
        }
        this.scrollPane.invalidate();
        this.imgFld.setImage(bufferedImage);
        if (d != null) {
            this.imgFld.setScale(d);
            this.autoFitImage = false;
        } else {
            this.imgFld.setScale(d2);
            this.autoFitImage = true;
        }
        this.imgFld.setRotation(rotation);
        this.scrollPane.validate();
        this.scrollPane.repaint();
        this.setTitleInternal(string);
        this.updViewScaleFld();
        if (imgEntry != null) {
            imgEntry.getImage().flush();
        }
        this.btnSaveAs.setEnabled(bl3);
        this.btnPrint.setEnabled(bl3);
        this.btnRotateLeft.setEnabled(bl3);
        this.btnRotateRight.setEnabled(bl3);
        this.mnuSaveAs.setEnabled(bl3);
        this.mnuExpImgA5105.setEnabled(bl3);
        this.mnuExpImgKC852Monochrome.setEnabled(bl3);
        this.mnuExpImgKC854Monochrome.setEnabled(bl3);
        this.mnuExpImgKC854Hires.setEnabled(bl3);
        this.mnuExpImgLLC2Hires.setEnabled(bl3);
        this.mnuExpAppAC1.setEnabled(bl3);
        this.mnuExpAppKC852.setEnabled(bl3);
        this.mnuExpAppKC854.setEnabled(bl3);
        this.mnuExpAppLLC2Hires.setEnabled(bl3);
        this.mnuExpAppZ1013.setEnabled(bl3);
        this.mnuExpAppZ9001.setEnabled(bl3);
        this.mnuExpMemAC1.setEnabled(bl3);
        this.mnuExpMemZ1013.setEnabled(bl3);
        this.mnuExpMemZ9001.setEnabled(bl3);
        this.mnuExpColorTab.setEnabled(bl3);
        this.mnuImgProps.setEnabled(bl3);
        this.mnuPrint.setEnabled(bl3);
        this.mnuUndo.setEnabled(this.imgStack.size() > 1);
        this.mnuHistory.setEnabled(this.imgStack.size() > 1);
        this.mnuCopy.setEnabled(bl3);
        this.mnuAdjustImage.setEnabled(bl3);
        this.mnuFlipHorizontal.setEnabled(bl3);
        this.mnuIndexColors.setEnabled(bl3);
        this.mnuRoundCorners.setEnabled(bl3);
        this.mnuRotateImage.setEnabled(bl3);
        this.mnuSelectArea.setEnabled(bl3);
        this.mnuScaleImage.setEnabled(bl3);
        this.mnuToGray.setEnabled(bl3);
        this.mnuToMonoFloydSteinberg.setEnabled(bl3);
        this.mnuToMonoSierra3.setEnabled(bl3);
        this.mnuToMonoAtkinson.setEnabled(bl3);
        this.mnuThreshold.setEnabled(bl3);
        this.mnuInvertImage.setEnabled(bl3);
        this.mnuRemoveTransparency.setEnabled(bl3 && n != 0);
        this.mnuToA5105.setEnabled(bl3);
        this.mnuToAC1_ACC.setEnabled(bl3);
        this.mnuToAC1_SCCH.setEnabled(bl3);
        this.mnuToAC1_2010.setEnabled(bl3);
        this.mnuToKC85Monochrome.setEnabled(bl3);
        this.mnuToKC854Hires.setEnabled(bl3);
        this.mnuToLLC2Hires21.setEnabled(bl3);
        this.mnuToLLC2Hires43.setEnabled(bl3);
        this.mnuToZ1013.setEnabled(bl3);
        this.mnuToZ9001.setEnabled(bl3);
        if (this.cropDlg != null) {
            if (bl3) {
                this.cropDlg.setImageSize(n2, n3);
            } else {
                this.cropDlg.doClose();
            }
        }
        if (bl2) {
            this.updWindowSize();
        }
        if (d == null) {
            this.fitImage(false);
        }
    }

    private void showImgAlreadyMonochrome() {
        BaseDlg.showInfoDlg(this, "Das Bild ist bereits monochrom.");
    }

    private void showNoMoreImageFileFound() {
        BaseDlg.showErrorDlg((Component)this, "Keine weitere Bilddatei gefunden");
    }

    private void toMonochromCharImage(BufferedImage bufferedImage, String string, String string2, int n, int n2, ImgEntry.Mode mode, int n3, boolean bl) {
        int n4;
        int n5;
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 12, ImgUtil.getColorModelBW());
        this.drawImageTo(bufferedImage, null, bufferedImage2);
        byte[] byArray = EmuUtil.readResource(this, string2);
        byte[] byArray2 = new byte[8];
        int n6 = n / n3;
        int n7 = n2 / 8;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n6 * n7);
        for (int i = 0; i < n7; ++i) {
            for (int j = 0; j < n6; ++j) {
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                n5 = 0;
                for (n4 = 0; n4 < 8; ++n4) {
                    n13 = i * 8 + n4;
                    n12 = 0;
                    n11 = bl ? 1 : 128;
                    for (n10 = 0; n10 < n3; ++n10) {
                        n9 = 0;
                        n8 = j * n3 + n10;
                        if (n8 < n && n13 < n2) {
                            n9 = bufferedImage2.getRGB(n8, n13);
                        }
                        if ((n9 >> 16 & 0xFF) + (n9 >> 8 & 0xFF) + (n9 & 0xFF) > 384) {
                            n12 |= n11;
                        }
                        if (bl) {
                            n11 <<= 1;
                            continue;
                        }
                        n11 >>= 1;
                    }
                    byArray2[n5++] = (byte)n12;
                }
                n4 = 255;
                n13 = ImageFrm.getNumMatchingPixels(byArray, n4 * 8, byArray2, n3);
                for (n12 = 254; n12 >= 0; --n12) {
                    n11 = ImageFrm.getNumMatchingPixels(byArray, n12 * 8, byArray2, n3);
                    if (n11 <= n13) continue;
                    n4 = n12;
                    n13 = n11;
                    if (n13 == 8 * n3) break;
                }
                byteArrayOutputStream.write(n4);
                n12 = n4 * 8;
                for (n11 = 0; n11 < 8; ++n11) {
                    n10 = i * 8 + n11;
                    n9 = 0;
                    if (byArray != null && n12 < byArray.length) {
                        n9 = byArray[n12] & 0xFF;
                    }
                    n8 = bl ? 1 : 128;
                    for (int k = 0; k < n3; ++k) {
                        int n14 = j * n3 + k;
                        if (n14 < n && n10 < n2) {
                            bufferedImage2.setRGB(n14, n10, (n9 & n8) != 0 ? -1 : -16777216);
                        }
                        if (bl) {
                            n8 <<= 1;
                            continue;
                        }
                        n8 >>= 1;
                    }
                    ++n12;
                }
            }
        }
        byte[] byArray3 = null;
        if (byteArrayOutputStream.size() > 0) {
            if (bl) {
                byte[] byArray4 = byteArrayOutputStream.toByteArray();
                if (byArray4 != null && byArray4.length > 0) {
                    byArray3 = new byte[byArray4.length];
                    n5 = byArray4.length - 1;
                    n4 = 0;
                    while (n5 >= 0 && n4 < byArray3.length) {
                        byArray3[n4++] = byArray4[n5--];
                    }
                }
            } else {
                byArray3 = byteArrayOutputStream.toByteArray();
            }
        }
        this.showImageInternal(bufferedImage2, mode, ImgFld.Rotation.NONE, null, string, false, null, byArray3);
    }

    private Point toUnscaledPoint(MouseEvent mouseEvent) {
        double d = this.imgFld.getCurScale();
        return new Point((int)Math.round((double)mouseEvent.getX() / d), (int)Math.round((double)mouseEvent.getY() / d));
    }

    private void updCropDlg() {
        if (this.cropDlg != null && this.cropDlg.isVisible()) {
            Dimension dimension = this.imgFld.getRotatedImageSize();
            if (dimension != null) {
                this.cropDlg.setImageSize(dimension.width, dimension.height);
            } else {
                this.cropDlg.doClose();
            }
        }
    }

    private void updPasteBtn() {
        boolean bl = false;
        if (this.clipboard != null) {
            try {
                bl = this.clipboard.isDataFlavorAvailable(DataFlavor.imageFlavor);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.mnuPaste.setEnabled(bl);
    }

    private void updFileListBtnsEnabled() {
        File file;
        boolean bl = false;
        boolean bl2 = false;
        if (this.files != null && !this.imgStack.isEmpty() && (file = ((ImgEntry)this.imgStack.get(0)).getFile()) != null && this.files.length > 0) {
            try {
                int n = Arrays.binarySearch(this.files, file, FileComparator.getInstance());
                bl2 = n < 0 ? (n = -(n + 1)) < this.files.length : n + 1 < this.files.length;
                bl = n > 0;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.btnPrev.setEnabled(bl);
        this.mnuPrev.setEnabled(bl);
        this.btnNext.setEnabled(bl2);
        this.mnuNext.setEnabled(bl2);
    }

    private void updFileList() {
        File file;
        File file2;
        File[] fileArray = null;
        if (!this.imgStack.isEmpty() && (file2 = ((ImgEntry)this.imgStack.get(0)).getFile()) != null && (file = file2.getParentFile()) != null && (fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string != null ? ImgLoader.accept(new File(file, string)) : false;
            }
        })) != null) {
            if (fileArray.length > 1) {
                try {
                    FileComparator fileComparator = FileComparator.getInstance();
                    Arrays.sort(fileArray, fileComparator);
                }
                catch (Exception exception) {}
            } else {
                fileArray = null;
            }
        }
        this.files = fileArray;
        this.updFileListBtnsEnabled();
    }

    private static enum ExpFmt {
        IMG_A5105,
        IMG_KC852_MONOCHROME,
        IMG_KC854_MONOCHROME,
        IMG_KC854_HIRES,
        IMG_LLC2_HIRES,
        APP_AC1,
        APP_KC852,
        APP_KC854,
        APP_LLC2_HIRES,
        APP_Z1013,
        APP_Z9001,
        MEM_AC1,
        MEM_Z1013,
        MEM_Z9001;

    }
}

