/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.Set;
import java.util.TreeSet;
import jkcemu.Main;
import jkcemu.base.CancelableProgressDlg;
import jkcemu.image.ImgUtil;

public class GrayScaler
implements CancelableProgressDlg.Progressable,
Runnable {
    private BufferedImage srcImg;
    private BufferedImage retImg;
    private Integer grayRGBForTransp;
    private int wImg;
    private int hImg;
    private volatile int progressValue;
    private CancelableProgressDlg dlg;

    public static int toGray(int n) {
        int n2 = Math.round((float)(n >> 16 & 0xFF) * 0.299f + (float)(n >> 8 & 0xFF) * 0.587f + (float)(n & 0xFF) * 0.114f);
        return n & 0xFF000000 | n2 << 16 & 0xFF0000 | n2 << 8 & 0xFF00 | n2 & 0xFF;
    }

    public static BufferedImage toGray(Window window, BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = null;
        if (bufferedImage.getTransparency() == 1) {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            Set<Integer> set = GrayScaler.getIndexedColors(bufferedImage);
            if (!set.isEmpty() && set.size() <= 256) {
                bufferedImage2 = ImgUtil.createIndexedColorsImage(n, n2, set);
            }
            if (bufferedImage2 == null) {
                bufferedImage2 = new BufferedImage(n, n2, 13, ImgUtil.getColorModelSortedGray());
            }
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage((Image)bufferedImage, 0, 0, window);
            graphics2D.dispose();
        } else {
            GrayScaler grayScaler = new GrayScaler(bufferedImage);
            grayScaler.dlg = new CancelableProgressDlg(window, "Graustufen erzeugen", grayScaler);
            new Thread(Main.getThreadGroup(), grayScaler, "JKCEMU gray scaler").start();
            grayScaler.dlg.setVisible(true);
            if (!grayScaler.dlg.wasCancelled()) {
                bufferedImage2 = grayScaler.retImg;
            }
        }
        return bufferedImage2;
    }

    @Override
    public int getProgressMax() {
        return this.wImg * this.hImg;
    }

    @Override
    public int getProgressValue() {
        return this.progressValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            BufferedImage bufferedImage = null;
            Set<Integer> set = GrayScaler.getIndexedColors(this.srcImg);
            if (!set.isEmpty() && set.size() <= 256) {
                bufferedImage = ImgUtil.createIndexedColorsImage(this.wImg, this.hImg, set);
            }
            if (bufferedImage == null) {
                bufferedImage = new BufferedImage(this.wImg, this.hImg, 2);
            }
            for (int i = 0; i < this.hImg; ++i) {
                for (int j = 0; j < this.wImg && !this.dlg.wasCancelled(); ++j) {
                    bufferedImage.setRGB(j, i, GrayScaler.toGray(this.srcImg.getRGB(j, i)));
                    ++this.progressValue;
                }
            }
            if (!this.dlg.wasCancelled()) {
                this.retImg = bufferedImage;
            }
        }
        finally {
            this.dlg.fireProgressFinished();
        }
    }

    private GrayScaler(BufferedImage bufferedImage) {
        this.srcImg = bufferedImage;
        this.retImg = null;
        this.wImg = bufferedImage.getWidth();
        this.hImg = bufferedImage.getHeight();
        this.progressValue = 0;
        this.dlg = null;
    }

    private static Set<Integer> getIndexedColors(BufferedImage bufferedImage) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        IndexColorModel indexColorModel = ImgUtil.getIndexColorModel(bufferedImage);
        if (indexColorModel != null) {
            int n = indexColorModel.getMapSize();
            for (int i = 0; i < n; ++i) {
                treeSet.add(GrayScaler.toGray(indexColorModel.getRGB(i)));
            }
        }
        return treeSet;
    }
}

