/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.File;
import java.util.EventObject;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import jkcemu.Main;
import jkcemu.base.BaseFrm;
import jkcemu.image.ImgFld;
import jkcemu.image.ImgSaver;
import jkcemu.image.ImgSelection;

public abstract class AbstractImageFrm
extends BaseFrm
implements ComponentListener {
    protected Clipboard clipboard = null;
    protected ImgFld imgFld;
    protected JScrollPane scrollPane;
    private JComboBox<String> comboScale = null;

    protected AbstractImageFrm() {
        Main.updIcon(this);
        Toolkit toolkit = this.getToolkit();
        if (toolkit != null) {
            this.clipboard = toolkit.getSystemClipboard();
        }
        this.setLayout(new BorderLayout(0, 0));
        this.imgFld = new ImgFld(342, 256);
        this.scrollPane = new JScrollPane(this.imgFld, 22, 32);
        this.add((Component)this.scrollPane, "Center");
        this.addComponentListener(this);
    }

    protected JComboBox<String> createScaleComboBox(int n, int ... nArray) {
        String string = null;
        this.comboScale = new JComboBox();
        this.comboScale.setEditable(true);
        for (int n2 : nArray) {
            String string2 = String.format("%d %%", n2);
            this.comboScale.addItem(string2);
            if (n2 != n) continue;
            string = string2;
        }
        if (string != null) {
            this.comboScale.setSelectedItem(string);
        }
        this.comboScale.setToolTipText("Skalierung der Anzeige");
        this.comboScale.addActionListener(this);
        return this.comboScale;
    }

    protected void doCopy() {
        BufferedImage bufferedImage;
        if (this.clipboard != null && (bufferedImage = this.getImage()) != null) {
            try {
                ImgSelection imgSelection = new ImgSelection(bufferedImage);
                this.clipboard.setContents(imgSelection, imgSelection);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    protected void doRotateLeft() {
        this.scrollPane.invalidate();
        switch (this.imgFld.getRotation()) {
            case NONE: {
                this.imgFld.setRotation(ImgFld.Rotation.LEFT);
                break;
            }
            case LEFT: {
                this.imgFld.setRotation(ImgFld.Rotation.DOWN);
                break;
            }
            case RIGHT: {
                this.imgFld.setRotation(ImgFld.Rotation.NONE);
                break;
            }
            case DOWN: {
                this.imgFld.setRotation(ImgFld.Rotation.RIGHT);
            }
        }
        this.scrollPane.validate();
        this.scrollPane.repaint();
        this.updWindowSize();
    }

    protected void doRotateRight() {
        this.scrollPane.invalidate();
        switch (this.imgFld.getRotation()) {
            case NONE: {
                this.imgFld.setRotation(ImgFld.Rotation.RIGHT);
                break;
            }
            case LEFT: {
                this.imgFld.setRotation(ImgFld.Rotation.NONE);
                break;
            }
            case RIGHT: {
                this.imgFld.setRotation(ImgFld.Rotation.DOWN);
                break;
            }
            case DOWN: {
                this.imgFld.setRotation(ImgFld.Rotation.LEFT);
            }
        }
        this.scrollPane.validate();
        this.scrollPane.repaint();
        this.updWindowSize();
    }

    protected void doScaleView() {
        double d = this.getViewScale();
        if (d > 0.0) {
            this.scrollPane.invalidate();
            this.imgFld.setScale(d);
            this.scrollPane.validate();
            this.scrollPane.repaint();
            this.updViewScaleFld();
            this.updWindowSize();
        }
    }

    protected abstract BufferedImage getImage();

    protected double getViewScale() {
        String string;
        Object object;
        double d = -1.0;
        if (this.comboScale != null && (object = this.comboScale.getSelectedItem()) != null && (string = object.toString()) != null) {
            int n = string.indexOf(37);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            try {
                int n2 = Integer.parseInt(string.trim());
                if (n2 > 0) {
                    d = (double)n2 / 100.0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d;
    }

    protected File saveAs(File file) {
        File file2 = null;
        BufferedImage bufferedImage = this.getImage();
        if (bufferedImage != null) {
            ImgFld.Rotation rotation = this.imgFld.getRotation();
            if (rotation != ImgFld.Rotation.NONE) {
                int n;
                ColorModel colorModel;
                int n2 = bufferedImage.getWidth();
                int n3 = bufferedImage.getHeight();
                int n4 = 0;
                if (bufferedImage instanceof BufferedImage && (n4 = bufferedImage.getType()) == 0 && (colorModel = bufferedImage.getColorModel()) != null && !colorModel.hasAlpha()) {
                    n4 = 5;
                }
                if (n4 == 0) {
                    n4 = 2;
                }
                if (n2 > 0 && n3 > 0 && (n = JOptionPane.showConfirmDialog(this, "Soll das Bild gedreht gespeichert werden,\nso wie Sie es gerade sehen?", "Bild gedreht", 1, 3)) == 0) {
                    BufferedImage bufferedImage2 = null;
                    bufferedImage2 = rotation == ImgFld.Rotation.LEFT || rotation == ImgFld.Rotation.RIGHT ? new BufferedImage(n3, n2, n4) : new BufferedImage(n2, n3, n4);
                    Graphics2D graphics2D = bufferedImage2.createGraphics();
                    this.imgFld.drawImage(graphics2D, 0, 0, n2, n3);
                    graphics2D.dispose();
                    bufferedImage = bufferedImage2;
                }
            }
            file2 = ImgSaver.saveImageAs(this, bufferedImage, file);
        }
        return file2;
    }

    protected void updViewScaleFld() {
        this.comboScale.removeActionListener(this);
        this.comboScale.setSelectedItem(String.format("%d %%", Math.round(this.imgFld.getScale() * 100.0)));
        this.comboScale.addActionListener(this);
    }

    protected void updWindowSize() {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        JViewport jViewport = this.scrollPane.getViewport();
        if (jViewport != null) {
            this.imgFld.setViewportSize(jViewport.getExtentSize());
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        Object object;
        boolean bl = false;
        if (eventObject != null && (object = eventObject.getSource()) == this.comboScale) {
            bl = true;
            this.doScaleView();
        }
        return bl;
    }
}

