/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.filebrowser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Set;

public class TarEntry {
    private String entryName;
    private EntryType entryType;
    private String typeText;
    private String linkTarget;
    private Set<PosixFilePermission> permissions;
    private long entrySize;
    private long entryTime;
    private String errMsg;

    public String getErrorMsg() {
        return this.errMsg;
    }

    public String getLinkTarget() {
        return this.linkTarget;
    }

    public String getName() {
        return this.entryName;
    }

    public Set<PosixFilePermission> getPosixFilePermissions() {
        return this.permissions;
    }

    public long getSize() {
        return this.entrySize;
    }

    public long getTime() {
        return this.entryTime;
    }

    public String getTypeText() {
        return this.typeText;
    }

    public boolean isDirectory() {
        return this.entryType.equals((Object)EntryType.DIRECTORY);
    }

    public boolean isRegularFile() {
        return this.entryType.equals((Object)EntryType.REGULAR_FILE);
    }

    public boolean isSymbolicLink() {
        return this.entryType.equals((Object)EntryType.SYMBOLIC_LINK);
    }

    public static TarEntry readEntryHeader(InputStream inputStream) throws IOException {
        Serializable serializable;
        CharSequence charSequence;
        int n;
        int n2;
        int n3;
        String string = null;
        byte[] byArray = new byte[512];
        boolean bl = false;
        do {
            if (!TarEntry.readFilledBlock(inputStream, byArray)) {
                return null;
            }
            int n4 = byArray[156] & 0xFF;
            if (n4 == 103) {
                bl = true;
                inputStream.skip(512L);
                continue;
            }
            if (n4 == 120) {
                bl = true;
                if (!TarEntry.readFilledBlock(inputStream, byArray)) {
                    return null;
                }
                try {
                    n3 = 0;
                    while (n3 < byArray.length) {
                        String string2;
                        byte by;
                        for (n2 = n3; n2 < byArray.length && (by = byArray[n2]) != 0 && by != 10 && by != 13; ++n2) {
                        }
                        if (n2 > n3 && (n = (string2 = new String(byArray, n3, n2 - n3, "ISO-8859-1")).indexOf(" path=")) >= 0 && n + 6 < string2.length()) {
                            string = string2.substring(n + 6);
                        }
                        n3 = n2 + 1;
                    }
                }
                catch (Exception exception) {}
            } else {
                bl = false;
            }
        } while (bl);
        String string3 = null;
        n3 = TarEntry.parseOctalNumber(byArray, 148, 156);
        n2 = 148;
        while (n2 < 156) {
            byArray[n2++] = 32;
        }
        int n5 = 0;
        n = 0;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            n5 += byArray[n2];
            n += byArray[n2] & 0xFF;
        }
        if (n5 != n3 && n != n3) {
            string3 = TarEntry.addLine(string3, "Pr\u00fcfsumme im TAR-Kopfblock fehlerhaft");
        }
        if (string == null) {
            int n6;
            charSequence = new StringBuilder(100);
            n2 = 0;
            while (n2 < 100 && (n6 = byArray[n2++] & 0xFF) != 0) {
                if (n6 >= 32) {
                    charSequence.append((char)n6);
                    continue;
                }
                string3 = TarEntry.addLine(string3, "Ung\u00fcltiges Zeichen im Namen des Eintrags");
            }
            string = charSequence.toString();
        }
        if (string.isEmpty()) {
            string3 = TarEntry.addLine(string3, "Name des Eintrags fehlt");
        }
        charSequence = null;
        String string4 = null;
        EntryType entryType = EntryType.OTHER;
        int n7 = TarEntry.parseOctalNumber(byArray, 100, 108);
        long l = TarEntry.parseOctalNumber(byArray, 124, 136);
        long l2 = (long)TarEntry.parseOctalNumber(byArray, 136, 148) * 1000L;
        int n8 = byArray[156] & 0xFF;
        switch (n8) {
            case 0: 
            case 48: {
                entryType = EntryType.REGULAR_FILE;
                string4 = "Datei";
                break;
            }
            case 49: 
            case 50: {
                char c;
                serializable = new StringBuilder(128);
                n2 = 157;
                while (n2 < 257 && (c = (char)(byArray[n2++] & 0xFF)) > '\u0000') {
                    ((StringBuilder)serializable).append(c);
                }
                if (((StringBuilder)serializable).length() > 0) {
                    charSequence = ((StringBuilder)serializable).toString();
                }
                if (n8 == 50) {
                    entryType = EntryType.SYMBOLIC_LINK;
                    string4 = "Sym. Link: " + ((StringBuilder)serializable).toString();
                    break;
                }
                string4 = "Link: " + ((StringBuilder)serializable).toString();
                break;
            }
            case 51: 
            case 52: {
                string4 = "Ger\u00e4tedatei";
                break;
            }
            case 53: {
                entryType = EntryType.DIRECTORY;
                string4 = "Verzeichnis";
                break;
            }
            case 54: {
                string4 = "FIFO";
                break;
            }
            default: {
                string4 = n8 > 32 ? "Typ: " + Character.toString((char)n8) : "Typ: " + Integer.toString(n8);
            }
        }
        serializable = new HashSet();
        if ((n7 & 1) != 0) {
            serializable.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        if ((n7 & 2) != 0) {
            serializable.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((n7 & 4) != 0) {
            serializable.add(PosixFilePermission.OTHERS_READ);
        }
        if ((n7 & 8) != 0) {
            serializable.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((n7 & 0x10) != 0) {
            serializable.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((n7 & 0x20) != 0) {
            serializable.add(PosixFilePermission.GROUP_READ);
        }
        if ((n7 & 0x40) != 0) {
            serializable.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((n7 & 0x80) != 0) {
            serializable.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((n7 & 0x100) != 0) {
            serializable.add(PosixFilePermission.OWNER_READ);
        }
        return new TarEntry(string, entryType, string4, (String)charSequence, (Set<PosixFilePermission>)((Object)serializable), l, l2, string3);
    }

    private TarEntry(String string, EntryType entryType, String string2, String string3, Set<PosixFilePermission> set, long l, long l2, String string4) {
        this.entryName = string;
        this.entryType = entryType;
        this.typeText = string2;
        this.linkTarget = string3;
        this.permissions = set;
        this.entrySize = l;
        this.entryTime = l2;
        this.errMsg = string4;
    }

    private static String addLine(String string, String string2) {
        return string != null ? string + "\n" + string2 : string2;
    }

    private static int parseOctalNumber(byte[] byArray, int n, int n2) {
        while (n < n2 && byArray[n] == 32) {
            ++n;
        }
        int n3 = 0;
        byte by = byArray[n];
        while (n < n2 && by >= 48 && by <= 55) {
            n3 = n3 << 3 | by & 7;
            by = byArray[n++];
        }
        return n3;
    }

    private static boolean readFilledBlock(InputStream inputStream, byte[] byArray) throws IOException {
        int n = 0;
        boolean bl = true;
        while (bl) {
            n = 0;
            while (n < byArray.length) {
                int n2 = inputStream.read();
                if (n2 < 0) {
                    if (bl) {
                        return false;
                    }
                    throw new IOException("Unerwartetes Ende der TAR-Datei");
                }
                if (n2 != 0) {
                    bl = false;
                }
                byArray[n++] = (byte)n2;
            }
        }
        return true;
    }

    public static enum EntryType {
        DIRECTORY,
        SYMBOLIC_LINK,
        REGULAR_FILE,
        OTHER;

    }
}

