/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.filebrowser;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileStore;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;

public class FilePropDlg
extends BaseDlg
implements FileVisitor<Path>,
Runnable {
    private Path path;
    private JButton btnOK;
    private JLabel sizeLabel;
    private long dirSize;
    private volatile boolean threadEnabled;

    public FilePropDlg(Frame frame, Path path) throws IOException {
        super((Window)frame, "Eigenschaften");
        this.path = path;
        this.sizeLabel = null;
        this.dirSize = 0L;
        this.threadEnabled = true;
        try {
            Object object;
            Object object2;
            String string;
            Object object3;
            UserPrincipal userPrincipal = null;
            GroupPrincipal groupPrincipal = null;
            String string2 = null;
            Object object4 = null;
            try {
                PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
                if (posixFileAttributeView != null && (object3 = posixFileAttributeView.readAttributes()) != null) {
                    object4 = object3;
                    userPrincipal = object3.owner();
                    groupPrincipal = object3.group();
                    string2 = PosixFilePermissions.toString(object3.permissions());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object4 == null) {
                object4 = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            }
            if (userPrincipal == null) {
                try {
                    userPrincipal = Files.getOwner(path, LinkOption.NOFOLLOW_LINKS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            int n = -1;
            object3 = new ArrayList();
            String string3 = path.toString();
            Path path2 = path.getFileName();
            if (path2 != null && (string = path2.toString()) != null && !string.isEmpty()) {
                string3 = string;
            }
            if (string3 != null && !string3.isEmpty()) {
                object3.add(new String[]{"Name:", string3});
            }
            if (object4.isRegularFile()) {
                long l = object4.size();
                if (l >= 0L) {
                    object3.add(new String[]{"Gr\u00f6\u00dfe:", EmuUtil.formatSize(l, false, true)});
                }
            } else if (object4.isDirectory()) {
                n = object3.size();
                object3.add(new String[]{"Gr\u00f6\u00dfe aller Dateien:", "wird berechnet..."});
            } else if (object4.isSymbolicLink()) {
                try {
                    string = null;
                    object2 = Files.readSymbolicLink(path);
                    if (object2 != null) {
                        string = object2.toString();
                    }
                    object3.add(new String[]{"Symbolischer Link auf:", string != null ? string : ""});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                object = Files.getLastModifiedTime(path, new LinkOption[0]);
                if (object != null) {
                    object3.add(new String[]{"Zuletzt ge\u00e4ndert:", DateFormat.getDateTimeInstance(2, 2).format(new Date(((FileTime)object).toMillis()))});
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (userPrincipal != null && (object = userPrincipal.getName()) != null && !((String)object).isEmpty()) {
                object3.add(new String[]{"Eigent\u00fcmer:", object});
            }
            if (groupPrincipal != null && (object = groupPrincipal.getName()) != null && !((String)object).isEmpty()) {
                object3.add(new String[]{"Gruppe:", object});
            }
            if (string2 != null) {
                object3.add(new String[]{"Berechtigungen:", string2});
            }
            try {
                object3.add(new String[]{"Lesezugriff:", Files.isReadable(path) ? "ja" : "nein"});
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                object3.add(new String[]{"Schreibzugriff:", Files.isWritable(path) ? "ja" : "nein"});
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                object3.add(new String[]{"Versteckt:", Files.isHidden(path) ? "ja" : "nein"});
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setLayout(new GridBagLayout());
            object = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0);
            this.addLines((List<String[]>)object3, (GridBagConstraints)object, n);
            try {
                long l;
                object2 = Files.getFileStore(path);
                if (object2 != null && (l = ((FileStore)object2).getTotalSpace()) > 0L) {
                    object3.clear();
                    JLabel jLabel = new JLabel("Datentr\u00e4ger");
                    Font font = jLabel.getFont();
                    if (font != null) {
                        jLabel.setFont(new Font(font.getName(), 1, font.getSize()));
                    }
                    ((GridBagConstraints)object).insets.top = 15;
                    ((GridBagConstraints)object).gridwidth = 0;
                    ((GridBagConstraints)object).gridx = 0;
                    this.add((Component)jLabel, object);
                    ((GridBagConstraints)object).insets.top = 0;
                    ((GridBagConstraints)object).insets.bottom = 0;
                    ((GridBagConstraints)object).gridwidth = 1;
                    ++((GridBagConstraints)object).gridy;
                    string3 = ((FileStore)object2).name();
                    if (string3 != null && !string3.isEmpty()) {
                        object3.add(new String[]{"Name:", string3});
                    }
                    if ((string3 = ((FileStore)object2).type()) != null && !string3.isEmpty()) {
                        object3.add(new String[]{"Typ:", string3});
                    }
                    object3.add(new String[]{"Gr\u00f6\u00dfe:", EmuUtil.formatSize(l, false, true)});
                    object3.add(new String[]{"Freier Speicher:", EmuUtil.formatSize(((FileStore)object2).getUnallocatedSpace(), false, true)});
                    this.addLines((List<String[]>)object3, (GridBagConstraints)object, -1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.btnOK = new JButton("OK");
            this.btnOK.addActionListener(this);
            ((GridBagConstraints)object).anchor = 10;
            ((GridBagConstraints)object).insets.top = 15;
            ((GridBagConstraints)object).insets.bottom = 10;
            ((GridBagConstraints)object).gridwidth = 0;
            ((GridBagConstraints)object).gridx = 0;
            ++((GridBagConstraints)object).gridy;
            this.add((Component)this.btnOK, object);
            this.pack();
            this.setParentCentered();
            this.setResizable(false);
            if (this.threadEnabled && this.sizeLabel != null) {
                new Thread(Main.getThreadGroup(), this, "JKCEMU directory size calculator").start();
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new IOException("Dateiattribute k\u00e4nnen nicht gelesen werden.\n");
        }
    }

    @Override
    public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
        if (iOException != null) {
            throw iOException;
        }
        return this.threadEnabled ? FileVisitResult.CONTINUE : FileVisitResult.TERMINATE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
        return this.threadEnabled ? FileVisitResult.CONTINUE : FileVisitResult.TERMINATE;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
        long l;
        if (basicFileAttributes.isRegularFile() && (l = basicFileAttributes.size()) > 0L) {
            this.dirSize += l;
        }
        return this.threadEnabled ? FileVisitResult.CONTINUE : FileVisitResult.TERMINATE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path path, IOException iOException) throws IOException {
        if (iOException != null && (Files.isRegularFile(path, LinkOption.NOFOLLOW_LINKS) || Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS))) {
            throw iOException;
        }
        return this.threadEnabled ? FileVisitResult.CONTINUE : FileVisitResult.TERMINATE;
    }

    @Override
    public void run() {
        if (this.threadEnabled && this.sizeLabel != null) {
            String string = "unbekannt";
            try {
                this.dirSize = 0L;
                Files.walkFileTree(this.path, this);
                if (this.threadEnabled) {
                    string = EmuUtil.formatSize(this.dirSize, false, true);
                }
            }
            catch (AccessDeniedException accessDeniedException) {
                string = "wegen fehlender Berechtigung nicht ermittelbar";
            }
            catch (Exception exception) {
                string = "konnte nicht ermittelt werden";
            }
            final String string2 = string;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FilePropDlg.this.setSizeText(string2);
                }
            });
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        Object object;
        boolean bl = false;
        if (eventObject != null && (object = eventObject.getSource()) != null && object == this.btnOK) {
            bl = true;
            this.doClose();
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        boolean bl = super.doClose();
        if (bl) {
            this.threadEnabled = false;
        }
        return bl;
    }

    private void addLines(List<String[]> list, GridBagConstraints gridBagConstraints, int n) {
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            String[] stringArray = list.get(i);
            if (stringArray.length <= 1) continue;
            gridBagConstraints.gridx = 0;
            this.add((Component)new JLabel(stringArray[0]), gridBagConstraints);
            ++gridBagConstraints.gridx;
            JLabel jLabel = new JLabel(stringArray[1]);
            this.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            if (i != n) continue;
            this.sizeLabel = jLabel;
        }
    }

    private void setSizeText(String string) {
        if (this.sizeLabel != null) {
            this.sizeLabel.setText(string);
            this.pack();
            this.setParentCentered();
        }
    }
}

