/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.filebrowser;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.JTableHeader;
import jkcemu.Main;
import jkcemu.audio.AudioFile;
import jkcemu.audio.AudioUtil;
import jkcemu.audio.PCMDataInfo;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileEntry;
import jkcemu.base.FileInfo;
import jkcemu.base.FileTableModel;
import jkcemu.disk.AbstractFloppyDisk;
import jkcemu.disk.DiskUtil;
import jkcemu.filebrowser.ExtendedFileEntry;
import jkcemu.filebrowser.FileCheckResult;
import jkcemu.filebrowser.FileInfoFld;
import jkcemu.filebrowser.FileNode;
import jkcemu.filebrowser.FileTableCellRenderer;
import jkcemu.filebrowser.ImageCard;
import jkcemu.filebrowser.TarEntry;
import jkcemu.image.ImgEntry;
import jkcemu.image.ImgLoader;
import jkcemu.image.ImgUtil;

public class FilePreviewFld
extends JPanel
implements MouseListener,
Runnable {
    private static final String CARD_NAME_FILE_TABLE = "file.table";
    private static final String CARD_NAME_IMAGE = "image";
    private static final String CARD_NAME_TEXT = "text";
    private static final String CARD_NAME_EMPTY = "empty";
    private Frame owner;
    private long maxFileSize;
    private Object lockMonitor;
    private boolean fieldsAdded;
    private boolean sortCaseSensitive;
    private boolean fileChanged;
    private FileNode fileNode;
    private Thread thread;
    private FileInfoFld headerFld;
    private JPanel detailsFld;
    private CardLayout cardLayout;
    private ImageCard imageCard;
    private JTextArea textArea;
    private FileTableModel fileTableModel;
    private JTableHeader fileTableHeader;
    private JTable fileTable;

    public FilePreviewFld(Frame frame) {
        this.owner = frame;
        this.maxFileSize = 0L;
        this.lockMonitor = "lock monitor";
        this.fieldsAdded = false;
        this.sortCaseSensitive = false;
        this.fileChanged = false;
        this.fileNode = null;
        this.thread = null;
        this.setLayout(new BorderLayout(5, 5));
        this.headerFld = new FileInfoFld(15);
        this.add((Component)this.headerFld, "North");
        this.cardLayout = new CardLayout();
        this.detailsFld = new JPanel(this.cardLayout);
        this.add((Component)this.detailsFld, "Center");
        this.detailsFld.add((Component)new JPanel(), CARD_NAME_EMPTY);
        this.imageCard = new ImageCard();
        this.detailsFld.add((Component)this.imageCard, CARD_NAME_IMAGE);
        this.textArea = new JTextArea();
        this.textArea.setBorder(BorderFactory.createLineBorder(this.getForeground(), 1));
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Monospaced", 0, 9));
        this.textArea.setPreferredSize(new Dimension(1, 1));
        this.detailsFld.add((Component)this.textArea, CARD_NAME_TEXT);
        this.fileTableModel = new FileTableModel(FileTableModel.Column.NAME, FileTableModel.Column.INFO, FileTableModel.Column.LAST_MODIFIED);
        this.fileTable = new JTable(this.fileTableModel);
        this.fileTable.setAutoResizeMode(0);
        this.fileTable.setColumnSelectionAllowed(false);
        this.fileTable.setRowSelectionAllowed(true);
        this.fileTable.setSelectionMode(2);
        this.detailsFld.add((Component)new JScrollPane(this.fileTable, 22, 30), CARD_NAME_FILE_TABLE);
        FileTableCellRenderer fileTableCellRenderer = new FileTableCellRenderer();
        this.fileTable.setDefaultRenderer(Number.class, fileTableCellRenderer);
        this.fileTable.setDefaultRenderer(Object.class, fileTableCellRenderer);
        this.fileTable.setDefaultRenderer(String.class, fileTableCellRenderer);
        this.fileTable.setDefaultRenderer(Date.class, fileTableCellRenderer);
        EmuUtil.setTableColWidths(this.fileTable, 150, 100, 140);
        this.fileTableHeader = this.fileTable.getTableHeader();
        if (this.fileTableHeader != null) {
            this.fileTableHeader.addMouseListener(this);
        }
    }

    public JTable getJTable() {
        return this.fileTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileNode(FileNode fileNode, long l, boolean bl) {
        Object object = this.lockMonitor;
        synchronized (object) {
            this.fileNode = fileNode;
            this.maxFileSize = l;
            this.fileChanged = true;
            try {
                this.lockMonitor.notifyAll();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
        this.fileTableModel.setSortCaseSensitive(bl);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getSource() == this.fileTableHeader && mouseEvent.getClickCount() > 0 && (n = this.fileTableHeader.columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()))) >= 0) {
            this.fileTableModel.sort(this.fileTable.convertColumnIndexToModel(n));
            this.fileTableModel.fireTableDataChanged();
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.thread != null) {
            try {
                Serializable serializable;
                Object object;
                boolean bl = false;
                boolean bl2 = false;
                FileNode fileNode = null;
                long l = 0L;
                while (!bl2 && this.thread != null) {
                    object = this.lockMonitor;
                    synchronized (object) {
                        bl = this.sortCaseSensitive;
                        fileNode = this.fileNode;
                        bl2 = this.fileChanged;
                        l = this.maxFileSize;
                        if (bl2) {
                            this.fileNode = null;
                            this.fileChanged = false;
                        } else {
                            try {
                                this.lockMonitor.wait();
                            }
                            catch (IllegalMonitorStateException illegalMonitorStateException) {
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (!bl2 || this.thread == null) continue;
                object = null;
                HashMap<FileInfoFld.Item, Object> hashMap = new HashMap<FileInfoFld.Item, Object>();
                String[] stringArray = null;
                if (fileNode != null && (serializable = fileNode.getFile()) != null) {
                    Object object2;
                    Path path;
                    String string;
                    long l2 = ((File)serializable).lastModified();
                    if (l2 > 0L) {
                        hashMap.put(FileInfoFld.Item.LAST_MODIFIED, l2);
                    }
                    if ((string = ((File)serializable).getName()) != null && !string.isEmpty()) {
                        hashMap.put(FileInfoFld.Item.NAME, string);
                    }
                    if (fileNode.getAllowsChildren()) {
                        this.addDirectoryInfo(hashMap, fileNode.children(), bl);
                        object = CARD_NAME_FILE_TABLE;
                    }
                    if ((path = fileNode.getPath()) != null && Files.isSymbolicLink(path) && (object2 = Files.readSymbolicLink(path)) != null) {
                        hashMap.put(FileInfoFld.Item.LINKED_TO, object2);
                    }
                    if (((File)serializable).isFile()) {
                        Object object3;
                        int n;
                        object2 = null;
                        if (string != null && (n = string.lastIndexOf(46)) >= 0 && n < string.length() - 1) {
                            object2 = string.substring(n + 1).toUpperCase();
                        }
                        if (object2 != null) {
                            hashMap.put(FileInfoFld.Item.TYPE, (String)object2 + "-Datei");
                        } else {
                            hashMap.put(FileInfoFld.Item.TYPE, "Datei");
                        }
                        hashMap.put(FileInfoFld.Item.SIZE, ((File)serializable).length());
                        FileCheckResult fileCheckResult = fileNode.getCheckResult();
                        if (fileCheckResult.isAudioFile() || fileCheckResult.isTapeFile()) {
                            this.addAudioInfo(hashMap, (File)serializable);
                        } else if (fileCheckResult.isImageFile()) {
                            if (this.addImageInfo(hashMap, (File)serializable, l)) {
                                object = CARD_NAME_IMAGE;
                            }
                        } else if (fileCheckResult.isPlainDiskFile()) {
                            if (this.addPlainDiskInfo(hashMap, fileCheckResult.isCompressedFile() ? "Komprimierte einfache Abbilddatei" : "Einfache Abbilddatei", (File)serializable, l, bl)) {
                                object = CARD_NAME_FILE_TABLE;
                            }
                        } else if (fileCheckResult.isNonPlainDiskFile()) {
                            if (FilePreviewFld.checkFileSize(((File)serializable).length(), l)) {
                                try {
                                    object3 = DiskUtil.readNonPlainDiskFile(this.owner, (File)serializable, true);
                                    if (object3 != null) {
                                        this.addDiskInfo(hashMap, fileCheckResult.isCompressedFile(), (AbstractFloppyDisk)object3, bl);
                                        object = CARD_NAME_FILE_TABLE;
                                    }
                                }
                                catch (IOException iOException) {}
                            }
                        } else if (fileCheckResult.isTextFile()) {
                            if (this.addTextInfo(hashMap, (File)serializable, l)) {
                                object = CARD_NAME_TEXT;
                            }
                        } else if (fileCheckResult.isArchiveFile()) {
                            if (this.addArchiveInfo(hashMap, (File)serializable, l, bl)) {
                                object = CARD_NAME_FILE_TABLE;
                            }
                        } else {
                            object3 = fileCheckResult.getFileInfo();
                            if (object3 != null) {
                                hashMap.put(FileInfoFld.Item.TYPE, ((FileInfo)object3).getFileText());
                                String string2 = ((FileInfo)object3).getAddrText();
                                String string3 = ((FileInfo)object3).getFileDesc();
                                if (string2 != null && string3 != null) {
                                    stringArray = new String[]{string2, string3};
                                } else if (string2 != null) {
                                    stringArray = new String[]{string2};
                                } else if (string3 != null) {
                                    stringArray = new String[]{string3};
                                }
                            }
                        }
                    }
                }
                serializable = hashMap;
                String[] stringArray2 = stringArray;
                Object object4 = object;
                EventQueue.invokeLater(new Runnable((Map)((Object)serializable), stringArray2, (String)object4){
                    final /* synthetic */ Map val$theInfoItems;
                    final /* synthetic */ String[] val$theAddonLines;
                    final /* synthetic */ String val$theCardName;
                    {
                        this.val$theInfoItems = map;
                        this.val$theAddonLines = stringArray;
                        this.val$theCardName = string;
                    }

                    @Override
                    public void run() {
                        FilePreviewFld.this.setContents(this.val$theInfoItems, this.val$theAddonLines, this.val$theCardName);
                    }
                });
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.thread == null) {
            Thread thread;
            this.thread = thread = new Thread(Main.getThreadGroup(), this, "JKCEMU File Browser Details Viewer");
            thread.setDaemon(true);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.thread != null) {
            Object object = this.lockMonitor;
            synchronized (object) {
                try {
                    this.lockMonitor.notifyAll();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    // empty catch block
                }
            }
        }
        this.thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAudioInfo(Map<FileInfoFld.Item, Object> map, File file) {
        boolean bl = EmuUtil.isGZipFile(file);
        PCMDataInfo pCMDataInfo = null;
        try {
            pCMDataInfo = AudioFile.getInfo(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (pCMDataInfo == null) {
                pCMDataInfo = AudioUtil.openAudioOrTapeFile(file);
            }
            if (pCMDataInfo != null) {
                long l;
                map.put(FileInfoFld.Item.TYPE, bl ? "Komprimierte Sound-Datei" : "Sound-/Tape-Datei");
                String string = AudioUtil.getAudioFormatText(pCMDataInfo);
                if (string != null && !string.isEmpty()) {
                    map.put(FileInfoFld.Item.FORMAT, string);
                }
                if ((l = pCMDataInfo.getFrameCount()) > 0L) {
                    map.put(FileInfoFld.Item.DURATION, (double)l / (double)pCMDataInfo.getFrameRate());
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (pCMDataInfo != null && pCMDataInfo instanceof Closeable) {
                EmuUtil.closeSilent((Closeable)((Object)pCMDataInfo));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean addArchiveInfo(Map<FileInfoFld.Item, Object> map, File file, long l, boolean bl) {
        boolean bl2;
        block16: {
            block19: {
                String string;
                block17: {
                    ZipFile zipFile;
                    block15: {
                        bl2 = false;
                        string = file.getName();
                        if (string == null || !FilePreviewFld.checkFileSize(file.length(), l)) break block16;
                        string = string.toLowerCase();
                        map.put(FileInfoFld.Item.TYPE, "Archivdatei");
                        this.fileTableModel.clear(false);
                        if (!string.endsWith(".jar") && !string.endsWith(".zip")) break block17;
                        zipFile = null;
                        try {
                            zipFile = new ZipFile(file);
                            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                            if (enumeration == null) break block15;
                            while (enumeration.hasMoreElements()) {
                                this.fileTableModel.addRow(new ExtendedFileEntry(enumeration.nextElement()), false);
                            }
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            EmuUtil.closeSilent(zipFile);
                        }
                        catch (IOException iOException) {
                            EmuUtil.closeSilent(zipFile);
                            {
                                catch (Throwable throwable) {
                                    EmuUtil.closeSilent(zipFile);
                                    throw throwable;
                                }
                            }
                        }
                    }
                    EmuUtil.closeSilent(zipFile);
                    bl2 = true;
                    break block19;
                }
                if (!string.endsWith(".tar") && !string.endsWith(".tar.gz") && !string.endsWith(".tgz")) break block19;
                InputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(file);
                    if (string.endsWith("z")) {
                        inputStream = new GZIPInputStream(inputStream);
                    }
                    TarEntry tarEntry = TarEntry.readEntryHeader(inputStream);
                    while (tarEntry != null) {
                        this.fileTableModel.addRow(new ExtendedFileEntry(tarEntry), false);
                        long l2 = tarEntry.getSize();
                        if (l2 > 0L) {
                            if (l2 % 512L != 0L) {
                                l2 = l2 + 512L & 0xFFFFFFFFFFFFFE00L;
                            }
                            inputStream.skip(l2);
                        }
                        tarEntry = TarEntry.readEntryHeader(inputStream);
                    }
                }
                catch (IOException iOException) {
                    EmuUtil.closeSilent(inputStream);
                    catch (Throwable throwable) {
                        EmuUtil.closeSilent(inputStream);
                        throw throwable;
                    }
                }
                EmuUtil.closeSilent(inputStream);
                bl2 = true;
            }
            this.fileTableModel.setSortCaseSensitive(bl);
            this.fileTableModel.fireTableDataChanged();
        }
        return bl2;
    }

    private void addDirectoryInfo(Map<FileInfoFld.Item, Object> map, Enumeration enumeration, boolean bl) {
        boolean bl2 = false;
        map.put(FileInfoFld.Item.TYPE, "Verzeichnis");
        this.fileTableModel.clear(false);
        if (enumeration != null) {
            try {
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (e == null || !(e instanceof FileNode)) continue;
                    this.fileTableModel.addRow(new ExtendedFileEntry((FileNode)e), false);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        this.fileTableModel.setSortCaseSensitive(bl);
        this.fileTableModel.fireTableDataChanged();
    }

    private boolean addDiskInfo(Map<FileInfoFld.Item, Object> map, boolean bl, AbstractFloppyDisk abstractFloppyDisk, boolean bl2) {
        boolean bl3 = false;
        List<FileEntry> list = DiskUtil.readDirectory(abstractFloppyDisk);
        if (list != null) {
            String string = abstractFloppyDisk.getFileFormatText();
            if (string == null) {
                string = "Diskettenabbilddatei";
            }
            if (bl) {
                string = "Komprimierte " + string;
            }
            this.fileTableModel.clear(false);
            for (FileEntry fileEntry : list) {
                this.fileTableModel.addRow(fileEntry, false);
            }
            this.fileTableModel.setSortCaseSensitive(bl2);
            this.fileTableModel.fireTableDataChanged();
            bl3 = true;
        }
        return bl3;
    }

    private boolean addImageInfo(Map<FileInfoFld.Item, Object> map, File file, long l) {
        boolean bl = false;
        if (FilePreviewFld.checkFileSize(file.length(), l)) {
            try {
                Object object;
                Image image = null;
                if (file.getPath().toLowerCase().endsWith(".gif")) {
                    try {
                        object = this.getToolkit();
                        if (object != null) {
                            image = ((Toolkit)object).createImage(file.getPath());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (image != null) {
                    ImgUtil.ensureImageLoaded(this, image);
                } else {
                    object = ImgLoader.load(file);
                    if (object != null) {
                        image = ((ImgEntry)object).getImage();
                    }
                }
                if (image != null) {
                    String string;
                    Object object2;
                    map.put(FileInfoFld.Item.TYPE, "Bilddatei");
                    int n = image.getWidth(this);
                    int n2 = image.getHeight(this);
                    if (n > 0 && n2 > 0) {
                        map.put(FileInfoFld.Item.FORMAT, String.format("%dx%d Pixel", n, n2));
                    }
                    if ((object2 = image.getProperty("comment", this)) != null && !object2.equals(Image.UndefinedProperty) && (string = object2.toString()) != null && !(string = string.trim()).isEmpty()) {
                        map.put(FileInfoFld.Item.COMMENT, string);
                    }
                    this.imageCard.setImage(image);
                    bl = true;
                }
            }
            catch (Exception exception) {
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
        }
        return bl;
    }

    private boolean addPlainDiskInfo(Map<FileInfoFld.Item, Object> map, String string, File file, long l, boolean bl) {
        List<FileEntry> list;
        boolean bl2 = false;
        String string2 = file.getName();
        if (string2 != null && FilePreviewFld.checkFileSize(file.length(), l) && (list = DiskUtil.readDirFromPlainDisk(file)) != null) {
            map.put(FileInfoFld.Item.TYPE, string);
            this.fileTableModel.clear(false);
            for (FileEntry fileEntry : list) {
                this.fileTableModel.addRow(fileEntry, false);
            }
            this.fileTableModel.setSortCaseSensitive(bl);
            this.fileTableModel.fireTableDataChanged();
            bl2 = true;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addTextInfo(Map<FileInfoFld.Item, Object> map, File file, long l) {
        boolean bl = false;
        BufferedReader bufferedReader = null;
        try {
            Toolkit toolkit = this.getToolkit();
            if (toolkit != null) {
                Dimension dimension = toolkit.getScreenSize();
                Font font = this.textArea.getFont();
                if (dimension != null && font != null) {
                    int n;
                    int n2 = font.getSize();
                    if (dimension.height > 0 && n2 > 0 && (n = dimension.height / n2) > 0) {
                        bufferedReader = new BufferedReader(new FileReader(file));
                        StringBuilder stringBuilder = new StringBuilder(n * 256);
                        int n3 = 0;
                        String string = bufferedReader.readLine();
                        while (string != null && n > 0 && FilePreviewFld.checkFileSize(n3, l)) {
                            stringBuilder.append(string);
                            stringBuilder.append('\n');
                            n3 += string.length();
                            ++n3;
                            --n;
                            string = bufferedReader.readLine();
                        }
                        this.textArea.setText(stringBuilder.toString());
                        this.textArea.setCaretPosition(0);
                        map.put(FileInfoFld.Item.TYPE, "Textdatei");
                        bl = true;
                    }
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            EmuUtil.closeSilent(bufferedReader);
        }
        return bl;
    }

    private static boolean checkFileSize(long l, long l2) {
        return l2 == 0L || l2 > 0L && l <= l2;
    }

    private void setContents(Map<FileInfoFld.Item, Object> map, String[] stringArray, String string) {
        if (string != null) {
            this.headerFld.setMinRows(0);
        }
        this.headerFld.setValues(map, stringArray);
        this.cardLayout.show(this.detailsFld, string != null ? string : CARD_NAME_EMPTY);
        this.invalidate();
    }
}

