/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.filebrowser;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileTreeNode;
import jkcemu.base.FileTreeNodeComparator;
import jkcemu.filebrowser.FileActionMngr;
import jkcemu.filebrowser.FileCheckResult;

public class FileNode
extends FileTreeNode
implements FileActionMngr.FileObject {
    private FileCheckResult fileCheckResult = null;

    public FileNode(TreeNode treeNode, Path path, File file, boolean bl, FileSystemView fileSystemView) {
        super(treeNode, path, file, bl, fileSystemView);
    }

    public boolean fileNameEndsWith(String string) {
        String string2;
        boolean bl = false;
        if (this.file != null && string != null && (string2 = this.file.getName()) != null) {
            bl = string2.toLowerCase().endsWith(string);
        }
        return bl;
    }

    @Override
    public FileCheckResult getCheckResult() {
        if (this.fileCheckResult == null) {
            try {
                this.fileCheckResult = FileCheckResult.checkFile(this.getFile());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return this.fileCheckResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void refresh(DefaultTreeModel defaultTreeModel, boolean bl, FileTreeNodeComparator fileTreeNodeComparator) {
        Iterable<Path> iterable = null;
        this.removeAllChildren();
        try {
            boolean bl2 = false;
            File[] fileArray = null;
            File file = this.getFile();
            if (file != null) {
                boolean bl3 = false;
                Path path = this.getPath();
                if (path != null && (!Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS) || Files.isSymbolicLink(path))) {
                    bl3 = true;
                }
                if (!bl3) {
                    if (this.fsv != null) {
                        if (file.isDirectory()) {
                            fileArray = this.fsv.getFiles(file, !bl);
                        }
                    } else {
                        try {
                            iterable = Files.newDirectoryStream(path);
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else {
                bl2 = true;
                if (this.fsv != null) {
                    fileArray = this.fsv.getRoots();
                } else {
                    iterable = FileSystems.getDefault().getRootDirectories();
                }
            }
            if (fileArray != null) {
                for (File object2 : fileArray) {
                    boolean bl3 = false;
                    boolean bl4 = false;
                    String string = null;
                    if (this.fsv != null) {
                        string = this.fsv.getSystemDisplayName(object2);
                        bl4 = this.fsv.isHiddenFile(object2);
                    } else {
                        bl4 = object2.isHidden();
                    }
                    if (string == null) {
                        string = bl2 ? object2.getPath() : object2.getName();
                    }
                    if (string == null) continue;
                    if (string.equals(".") || string.equals("..")) {
                        bl3 = true;
                    }
                    if (bl3 || !bl && bl4) continue;
                    FileNode fileNode = new FileNode(this, null, object2, bl2, this.fsv);
                    fileNode.updNode();
                    this.add(fileNode);
                }
            }
            if (iterable != null) {
                for (Path path : iterable) {
                    try {
                        void var11_22;
                        Object object;
                        boolean bl6 = false;
                        Object var11_19 = null;
                        if (bl2) {
                            String string = path.toString();
                        } else {
                            object = path.getFileName();
                            if (object != null) {
                                String string = object.toString();
                            }
                        }
                        if (var11_22 == null) continue;
                        if (var11_22.equals(".") || var11_22.equals("..")) {
                            bl6 = true;
                        }
                        if (bl6 || !bl && Files.isHidden(path)) continue;
                        object = new FileNode(this, path, null, bl2, bl2 ? null : this.fsv);
                        ((FileTreeNode)object).updNode();
                        this.add((FileTreeNode)object);
                    }
                    catch (IOException iOException) {}
                }
            }
            fileTreeNodeComparator.setForFileSystemRoots(bl2);
            this.sort(fileTreeNodeComparator);
        }
        finally {
            if (iterable != null && iterable instanceof Closeable) {
                EmuUtil.closeSilent((Closeable)((Object)iterable));
            }
            if (defaultTreeModel != null) {
                defaultTreeModel.nodeStructureChanged(this);
            }
        }
    }

    public List<FileNode> refreshNodeFor(Path path, DefaultTreeModel defaultTreeModel, boolean bl, FileTreeNodeComparator fileTreeNodeComparator) {
        List<FileNode> list = null;
        if (path != null) {
            try {
                list = this.refreshNodeForInternal(path.toAbsolutePath().normalize(), defaultTreeModel, bl, fileTreeNodeComparator);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public void setPath(Path path) {
        this.path = path;
        this.file = null;
    }

    private List<FileNode> refreshNodeForInternal(Path path, DefaultTreeModel defaultTreeModel, boolean bl, FileTreeNodeComparator fileTreeNodeComparator) {
        List<FileNode> list = null;
        if (path != null) {
            try {
                boolean bl2 = true;
                if (this.path != null) {
                    Path path2 = this.path.toAbsolutePath();
                    if (path2.equals(path)) {
                        this.refresh(defaultTreeModel, bl, fileTreeNodeComparator);
                        bl2 = false;
                        list = new ArrayList();
                        list.add(this);
                    } else if (path2.startsWith(path)) {
                        list = new ArrayList<FileNode>();
                        list.add(this);
                    }
                }
                if (bl2 && this.vChildren != null) {
                    for (FileTreeNode fileTreeNode : this.vChildren) {
                        List<FileNode> list2;
                        if (!(fileTreeNode instanceof FileNode) || (list2 = ((FileNode)fileTreeNode).refreshNodeForInternal(path, defaultTreeModel, bl, fileTreeNodeComparator)) == null) continue;
                        if (list != null) {
                            list.addAll(list2);
                            continue;
                        }
                        list = list2;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list;
    }
}

