/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.filebrowser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.EventObject;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.BaseFrm;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileEntry;
import jkcemu.base.FileTableModel;
import jkcemu.base.HelpFrm;
import jkcemu.etc.CksCalculator;

public class FileChecksumFrm
extends BaseFrm
implements ListSelectionListener,
Runnable {
    private static final String BTN_TEXT_CALCULATE = "Berechnen";
    private static final String HELP_PAGE = "/help/tools/filechecksum.htm";
    private static FileChecksumFrm instance = null;
    private JMenuItem mnuClose;
    private JMenuItem mnuCopyUpper;
    private JMenuItem mnuCopyLower;
    private JMenuItem mnuCompare;
    private JMenuItem mnuHelpContent;
    private JPopupMenu mnuPopup;
    private JMenuItem mnuPopupCopyUpper;
    private JMenuItem mnuPopupCopyLower;
    private JMenuItem mnuPopupCompare;
    private JLabel labelAlgorithm;
    private JComboBox<String> comboAlgorithm;
    private JButton btnAction;
    private JTable table;
    private FileTableModel tableModel;
    private Thread thread = null;
    private String algorithm = null;
    private CksCalculator cks = null;
    private volatile boolean cancelled = false;
    private volatile boolean filesChanged = false;

    public static void open() {
        if (instance != null) {
            if (instance.getExtendedState() == 1) {
                instance.setExtendedState(0);
            }
        } else {
            instance = new FileChecksumFrm();
        }
        instance.toFront();
        instance.setVisible(true);
    }

    public static void open(Collection<File> collection) {
        FileChecksumFrm.open();
        instance.setFiles(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFiles(Collection<File> collection) {
        this.cancelled = true;
        FileTableModel fileTableModel = this.tableModel;
        synchronized (fileTableModel) {
            this.filesChanged = true;
            this.tableModel.clear(false);
            if (collection != null) {
                for (File file : collection) {
                    if (!file.isFile()) continue;
                    FileEntry fileEntry = new FileEntry();
                    fileEntry.setName(file.getName());
                    fileEntry.setFile(file);
                    this.tableModel.addRow(fileEntry, false);
                }
            }
            this.tableModel.fireTableDataChanged();
        }
        this.updFields();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updEditBtns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        String string = null;
        CksCalculator cksCalculator = null;
        int n = 0;
        FileTableModel fileTableModel = this.tableModel;
        synchronized (fileTableModel) {
            string = this.algorithm;
            cksCalculator = this.cks;
            n = this.tableModel.getRowCount();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    object = this.tableModel.getRow(i);
                    if (object == null) continue;
                    ((FileEntry)object).setValue(null);
                }
                this.fireTableRowsUpdated(0, n - 1);
            }
        }
        if (cksCalculator != null && n > 0) {
            for (int i = 0; !this.cancelled && i < n; ++i) {
                FileEntry fileEntry = null;
                object = this.tableModel;
                synchronized (object) {
                    if (i < this.tableModel.getRowCount()) {
                        fileEntry = this.tableModel.getRow(i);
                    }
                }
                if (fileEntry != null) {
                    object = null;
                    cksCalculator.reset();
                    try {
                        object = new BufferedInputStream(new FileInputStream(fileEntry.getFile()));
                        fileEntry.setMarked(true);
                        fileEntry.setValue("Wird berechnet...");
                        this.fireTableRowsUpdated(i, i);
                        if (cksCalculator != null) {
                            int n2 = ((InputStream)object).read();
                            while (!this.cancelled && n2 != -1) {
                                cksCalculator.update(n2);
                                n2 = ((InputStream)object).read();
                            }
                            if (!this.cancelled) {
                                fileEntry.setValue(cksCalculator.getValue());
                            }
                        }
                        if (this.cancelled) {
                            fileEntry.setValue(null);
                        }
                        fileEntry.setMarked(false);
                    }
                    catch (IOException iOException) {
                        String string2 = iOException.getMessage();
                        if (string2 != null) {
                            fileEntry.setValue("Fehler: " + string2);
                        } else {
                            fileEntry.setValue("Fehler");
                        }
                    }
                    finally {
                        if (object != null) {
                            try {
                                ((InputStream)object).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    if (!this.filesChanged) {
                        this.fireTableRowsUpdated(i, i);
                    }
                } else {
                    this.cancelled = true;
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileChecksumFrm.this.updEditBtns();
                    }
                });
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileChecksumFrm.this.calculationFinished();
            }
        });
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject != null) {
            Object object = eventObject.getSource();
            if (object == this.mnuClose) {
                bl = true;
                this.doClose();
            } else if (object == this.btnAction) {
                bl = true;
                this.doCalculate();
            } else if (object == this.mnuCopyUpper || object == this.mnuPopupCopyUpper) {
                bl = true;
                this.doCopyUpper();
            } else if (object == this.mnuCopyLower || object == this.mnuPopupCopyLower) {
                bl = true;
                this.doCopyLower();
            } else if (object == this.mnuCompare || object == this.mnuPopupCompare) {
                bl = true;
                this.doCompare();
            } else if (object == this.mnuHelpContent) {
                bl = true;
                HelpFrm.open(HELP_PAGE);
            }
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        boolean bl = super.doClose();
        if (bl) {
            this.cancelled = true;
            Thread thread = this.thread;
            if (thread != null) {
                thread.interrupt();
            }
            instance = null;
        }
        return bl;
    }

    @Override
    public void lookAndFeelChanged() {
        if (this.mnuPopup != null) {
            SwingUtilities.updateComponentTreeUI(this.mnuPopup);
        }
    }

    @Override
    protected boolean showPopup(MouseEvent mouseEvent) {
        Component component;
        boolean bl = false;
        if (mouseEvent != null && (component = mouseEvent.getComponent()) != null) {
            this.mnuPopup.show(component, mouseEvent.getX(), mouseEvent.getY());
            bl = true;
        }
        return bl;
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this) {
            this.cancelled = true;
        }
    }

    private FileChecksumFrm() {
        this.setTitle("JKCEMU Pr\u00fcfsumme-/Hash-Wert berechnen");
        Main.updIcon(this);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("Datei");
        jMenu.setMnemonic(68);
        jMenuBar.add(jMenu);
        this.mnuClose = this.createJMenuItem("Schlie\u00dfen");
        jMenu.add(this.mnuClose);
        JMenu jMenu2 = new JMenu("Bearbeiten");
        jMenu2.setMnemonic(66);
        jMenuBar.add(jMenu2);
        this.mnuCopyUpper = this.createJMenuItem("Wert in Gro\u00dfschreibweise kopieren");
        jMenu2.add(this.mnuCopyUpper);
        this.mnuCopyLower = this.createJMenuItem("Wert in Kleinschreibweise kopieren");
        jMenu2.add(this.mnuCopyLower);
        jMenu2.addSeparator();
        this.mnuCompare = this.createJMenuItem("Wert mit Zwischenablage vergleichen");
        jMenu2.add(this.mnuCompare);
        JMenu jMenu3 = new JMenu("?");
        jMenuBar.add(jMenu3);
        this.mnuHelpContent = this.createJMenuItem("Hilfe...");
        jMenu3.add(this.mnuHelpContent);
        this.mnuPopup = new JPopupMenu();
        this.mnuPopupCopyUpper = this.createJMenuItem("Wert in Gro\u00dfschreibweise kopieren");
        this.mnuPopup.add(this.mnuPopupCopyUpper);
        this.mnuPopupCopyLower = this.createJMenuItem("Wert in Kleinschreibweise kopieren");
        this.mnuPopup.add(this.mnuPopupCopyLower);
        this.mnuPopup.addSeparator();
        this.mnuPopupCompare = this.createJMenuItem("Wert mit Zwischenablage vergleichen");
        this.mnuPopup.add(this.mnuPopupCompare);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.labelAlgorithm = new JLabel("Algorithmus:");
        this.labelAlgorithm.setEnabled(false);
        this.add((Component)this.labelAlgorithm, gridBagConstraints);
        this.comboAlgorithm = new JComboBox<String>(CksCalculator.getAvailableAlgorithms());
        this.comboAlgorithm.setEditable(false);
        this.comboAlgorithm.setEnabled(false);
        ++gridBagConstraints.gridx;
        this.add(this.comboAlgorithm, gridBagConstraints);
        this.btnAction = new JButton(BTN_TEXT_CALCULATE);
        this.btnAction.setEnabled(false);
        this.btnAction.addActionListener(this);
        ++gridBagConstraints.gridx;
        this.add((Component)this.btnAction, gridBagConstraints);
        FileTableModel.Column[] columnArray = new FileTableModel.Column[]{FileTableModel.Column.NAME, FileTableModel.Column.VALUE};
        this.tableModel = new FileTableModel(columnArray);
        this.table = new JTable(this.tableModel);
        this.table.addMouseListener(this);
        this.table.setAutoResizeMode(0);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JScrollPane(this.table), gridBagConstraints);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        if (listSelectionModel != null) {
            listSelectionModel.addListSelectionListener(this);
            this.mnuCopyUpper.setEnabled(false);
            this.mnuCopyLower.setEnabled(false);
            this.mnuCompare.setEnabled(false);
            this.mnuPopupCopyUpper.setEnabled(false);
            this.mnuPopupCopyLower.setEnabled(false);
            this.mnuPopupCompare.setEnabled(false);
        }
        EmuUtil.setTableColWidths(this.table, 200, 150);
        if (!this.applySettings(Main.getProperties(), true)) {
            this.table.setPreferredScrollableViewportSize(new Dimension(350, 200));
            this.pack();
            this.setScreenCentered();
            this.table.setPreferredScrollableViewportSize(new Dimension(1, 1));
        }
        this.setResizable(true);
    }

    private void calculationFinished() {
        this.thread = null;
        this.updFields();
    }

    private void copyToClipboard(String string) {
        try {
            Clipboard clipboard;
            Toolkit toolkit;
            if (string != null && (toolkit = this.getToolkit()) != null && (clipboard = toolkit.getSystemClipboard()) != null) {
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, stringSelection);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void doCopyUpper() {
        String string = this.getSelectedValue();
        if (string != null) {
            this.copyToClipboard(string.toUpperCase());
        }
    }

    private void doCopyLower() {
        String string = this.getSelectedValue();
        if (string != null) {
            this.copyToClipboard(string.toLowerCase());
        }
    }

    private void doCompare() {
        String string = this.getSelectedValue();
        if (string != null && string.length() > 0) {
            String string2 = null;
            try {
                Object object;
                Clipboard clipboard;
                Toolkit toolkit = this.getToolkit();
                if (toolkit != null && (clipboard = toolkit.getSystemClipboard()) != null && clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor) && (object = clipboard.getData(DataFlavor.stringFlavor)) != null) {
                    string2 = object.toString();
                }
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
            if (string2 != null) {
                try {
                    string2 = string2.replaceAll("[ \t\r\n]", "");
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
                if (string2.length() < 1) {
                    string2 = null;
                }
            }
            if (string2 != null) {
                if (string.equalsIgnoreCase(string2)) {
                    JOptionPane.showMessageDialog(this, "Der ausgew\u00e4hlte Wert stimmt mit dem\nin der Zwischenablage stehenden Text \u00fcberein.", "\u00dcbereinstimmung", 1);
                } else {
                    JOptionPane.showMessageDialog(this, "Der ausgew\u00e4hlte Wert stimmt mit dem\nin der Zwischenablage stehenden Text\nnicht \u00fcberein.", "Abweichung", 2);
                }
            } else {
                BaseDlg.showErrorDlg((Component)this, "Die Zwischenablage enth\u00e4lt keinen Text.\nKopieren Sie bitte den zu pr\u00fcfenden Wert\nin die Zwischenablage und\nrufen die Funktion noch einmal auf.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCalculate() {
        FileTableModel fileTableModel = this.tableModel;
        synchronized (fileTableModel) {
            if (this.thread != null) {
                this.cancelled = true;
            } else {
                String string;
                Object object = this.comboAlgorithm.getSelectedItem();
                if (object != null && (string = object.toString()) != null) {
                    this.cks = null;
                    try {
                        this.cks = new CksCalculator(string);
                        this.algorithm = string;
                        this.cancelled = false;
                        this.filesChanged = false;
                        this.thread = new Thread(Main.getThreadGroup(), this, "JKCEMU Checksum Calculator");
                        this.thread.start();
                        this.updFields();
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        BaseDlg.showErrorDlg((Component)this, "Der Algorithmus wird nicht unterst&uuml;tzt.");
                    }
                }
            }
        }
    }

    private void fireTableRowsUpdated(final int n, final int n2) {
        final FileTableModel fileTableModel = this.tableModel;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (n2 < fileTableModel.getRowCount()) {
                    fileTableModel.fireTableRowsUpdated(n, n2);
                }
            }
        });
    }

    private String getSelectedValue() {
        Object object;
        FileEntry fileEntry;
        String string = null;
        int n = this.table.getSelectedRow();
        if (n >= 0 && (fileEntry = this.tableModel.getRow(n)) != null && !fileEntry.isMarked() && (object = fileEntry.getValue()) != null) {
            string = object.toString();
        }
        return string;
    }

    private void updEditBtns() {
        FileEntry fileEntry;
        boolean bl = false;
        int n = this.table.getSelectedRow();
        if (n >= 0 && (fileEntry = this.tableModel.getRow(n)) != null) {
            bl = !fileEntry.isMarked() && fileEntry.getValue() != null;
        }
        this.mnuCopyUpper.setEnabled(bl);
        this.mnuCopyLower.setEnabled(bl);
        this.mnuCompare.setEnabled(bl);
        this.mnuPopupCopyUpper.setEnabled(bl);
        this.mnuPopupCopyLower.setEnabled(bl);
        this.mnuPopupCompare.setEnabled(bl);
    }

    private void updFields() {
        if (this.thread != null) {
            this.labelAlgorithm.setEnabled(false);
            this.comboAlgorithm.setEnabled(false);
            this.btnAction.setText("Abbrechen");
        } else {
            boolean bl = this.tableModel.getRowCount() > 0;
            this.labelAlgorithm.setEnabled(bl);
            this.comboAlgorithm.setEnabled(bl);
            this.btnAction.setText(BTN_TEXT_CALCULATE);
            this.btnAction.setEnabled(bl);
        }
    }
}

