/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.filebrowser;

import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import jkcemu.audio.AudioUtil;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileFormat;
import jkcemu.base.FileInfo;
import jkcemu.disk.AbstractFloppyDisk;
import jkcemu.disk.DiskUtil;
import jkcemu.image.ImgLoader;
import jkcemu.text.TextUtil;

public class FileCheckResult {
    private int hsFileType;
    private boolean audioFile;
    private boolean archiveFile;
    private boolean binFile;
    private boolean compressedFile;
    private boolean headersaveFile;
    private boolean imageFile;
    private boolean kcBasicHeadFile;
    private boolean kcBasicFile;
    private boolean kcSysFile;
    private boolean nonPlainDiskFile;
    private boolean plainDiskFile;
    private boolean tapeFile;
    private boolean textFile;
    private boolean kc85TapFile;
    private boolean z9001TapFile;
    private boolean startableFile;
    private FileInfo fileInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static FileCheckResult checkFile(File file) {
        FileCheckResult fileCheckResult;
        block39: {
            fileCheckResult = null;
            if (file == null) break block39;
            int n = -1;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            boolean bl10 = false;
            boolean bl11 = false;
            boolean bl12 = false;
            boolean bl13 = false;
            boolean bl14 = false;
            boolean bl15 = false;
            boolean bl16 = false;
            FileInfo fileInfo = null;
            if (file.isFile() && file.canRead()) {
                String string;
                boolean bl17 = false;
                if (AudioUtil.isAudioFile(file)) {
                    bl = true;
                    bl17 = true;
                }
                if (ImgLoader.accept(file)) {
                    bl6 = true;
                    bl17 = true;
                }
                if ((string = file.getName()) != null) {
                    if (TextUtil.endsWith(string = string.toLowerCase(), EmuUtil.archiveFileExtensions)) {
                        bl2 = true;
                        bl17 = true;
                    } else if (TextUtil.endsWith(string, DiskUtil.anaDiskFileExt) || TextUtil.endsWith(string, DiskUtil.copyQMFileExt) || TextUtil.endsWith(string, DiskUtil.dskFileExt) || TextUtil.endsWith(string, DiskUtil.imageDiskFileExt) || TextUtil.endsWith(string, DiskUtil.teleDiskFileExt)) {
                        bl12 = true;
                        bl17 = true;
                    } else if (TextUtil.endsWith(string, DiskUtil.plainDiskFileExt)) {
                        bl13 = true;
                        bl17 = true;
                    } else if (TextUtil.endsWith(string, DiskUtil.gzAnaDiskFileExt) || TextUtil.endsWith(string, DiskUtil.gzCopyQMFileExt) || TextUtil.endsWith(string, DiskUtil.gzDskFileExt) || TextUtil.endsWith(string, DiskUtil.gzImageDiskFileExt) || TextUtil.endsWith(string, DiskUtil.gzTeleDiskFileExt)) {
                        bl12 = true;
                        bl4 = true;
                        bl17 = true;
                    } else if (TextUtil.endsWith(string, DiskUtil.gzPlainDiskFileExt)) {
                        bl13 = true;
                        bl4 = true;
                        bl17 = true;
                    } else if (TextUtil.endsWith(string, AudioUtil.tapeFileExtensions)) {
                        bl14 = true;
                    } else if (TextUtil.endsWith(string, EmuUtil.textFileExtensions)) {
                        bl15 = true;
                        bl17 = true;
                    } else if (string.endsWith(".bin")) {
                        bl3 = true;
                        bl17 = true;
                    } else if (string.endsWith(".gz")) {
                        bl4 = true;
                        bl17 = true;
                    }
                }
                if (!bl17) {
                    FileInputStream fileInputStream;
                    block38: {
                        fileInputStream = null;
                        try {
                            FileFormat fileFormat;
                            fileInputStream = new FileInputStream(file);
                            byte[] byArray = new byte[40];
                            int n2 = EmuUtil.read(fileInputStream, byArray);
                            if (n2 < 3) break block38;
                            if (n2 < byArray.length) {
                                byArray = Arrays.copyOf(byArray, n2);
                            }
                            if (AbstractFloppyDisk.isDiskFileHeader(byArray)) {
                                bl12 = true;
                                break block38;
                            }
                            fileInfo = FileInfo.analyzeFile(byArray, file);
                            if (fileInfo == null) break block38;
                            if (fileInfo.equalsFileFormat(FileFormat.KCBASIC_HEAD_PRG) || fileInfo.equalsFileFormat(FileFormat.KCBASIC_HEAD_DATA) || fileInfo.equalsFileFormat(FileFormat.KCBASIC_HEAD_ASC)) {
                                bl7 = true;
                            } else if (fileInfo.equalsFileFormat(FileFormat.KCBASIC_PRG)) {
                                bl8 = true;
                            } else if (fileInfo.equalsFileFormat(FileFormat.KCB) || fileInfo.equalsFileFormat(FileFormat.KCC)) {
                                bl9 = true;
                            } else if (fileInfo.equalsFileFormat(FileFormat.KCTAP_KC85) || fileInfo.equalsFileFormat(FileFormat.KCTAP_BASIC_PRG) || fileInfo.equalsFileFormat(FileFormat.KCTAP_BASIC_DATA) || fileInfo.equalsFileFormat(FileFormat.KCTAP_BASIC_ASC)) {
                                bl10 = true;
                            } else if (fileInfo.equalsFileFormat(FileFormat.KCTAP_Z9001)) {
                                bl11 = true;
                            }
                            int n3 = fileInfo.getBegAddr();
                            int n4 = fileInfo.getEndAddr();
                            int n5 = fileInfo.getStartAddr();
                            if (n5 >= 0 && n5 >= n3 && n5 <= n4) {
                                bl16 = true;
                            }
                            if ((fileFormat = fileInfo.getFileFormat()) == null || !fileFormat.equals(FileFormat.HEADERSAVE)) break block38;
                            bl5 = true;
                            n = fileInfo.getFileType();
                        }
                        catch (Exception exception) {
                            EmuUtil.closeSilent(fileInputStream);
                            catch (Throwable throwable) {
                                EmuUtil.closeSilent(fileInputStream);
                                throw throwable;
                            }
                        }
                    }
                    EmuUtil.closeSilent(fileInputStream);
                }
            }
            fileCheckResult = new FileCheckResult(n, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl12, bl13, bl14, bl15, bl10, bl11, bl16, fileInfo);
        }
        return fileCheckResult;
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public int getHeadersaveFileType() {
        return this.hsFileType;
    }

    public boolean isAudioFile() {
        return this.audioFile;
    }

    public boolean isArchiveFile() {
        return this.archiveFile;
    }

    public boolean isBinFile() {
        return this.binFile;
    }

    public boolean isCompressedFile() {
        return this.compressedFile;
    }

    public boolean isHeadersaveFile() {
        return this.headersaveFile;
    }

    public boolean isImageFile() {
        return this.imageFile;
    }

    public boolean isKC85TapFile() {
        return this.kc85TapFile;
    }

    public boolean isKCBasicHeadFile() {
        return this.kcBasicHeadFile;
    }

    public boolean isKCBasicFile() {
        return this.kcBasicFile;
    }

    public boolean isKCSysFile() {
        return this.kcSysFile;
    }

    public boolean isNonPlainDiskFile() {
        return this.nonPlainDiskFile;
    }

    public boolean isPlainDiskFile() {
        return this.plainDiskFile;
    }

    public boolean isStartableFile() {
        return this.startableFile;
    }

    public boolean isTapeFile() {
        return this.tapeFile;
    }

    public boolean isTextFile() {
        return this.textFile;
    }

    public boolean isZ9001TapFile() {
        return this.z9001TapFile;
    }

    private FileCheckResult(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13, boolean bl14, boolean bl15, boolean bl16, FileInfo fileInfo) {
        this.hsFileType = n;
        this.audioFile = bl;
        this.archiveFile = bl2;
        this.binFile = bl3;
        this.compressedFile = bl4;
        this.headersaveFile = bl5;
        this.imageFile = bl6;
        this.kcBasicHeadFile = bl7;
        this.kcBasicFile = bl8;
        this.kcSysFile = bl9;
        this.nonPlainDiskFile = bl10;
        this.plainDiskFile = bl11;
        this.tapeFile = bl12;
        this.textFile = bl13;
        this.kc85TapFile = bl14;
        this.z9001TapFile = bl15;
        this.startableFile = bl16;
        this.fileInfo = fileInfo;
    }
}

