/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.filebrowser;

import java.io.File;
import java.util.zip.ZipEntry;
import jkcemu.base.FileEntry;
import jkcemu.filebrowser.FileNode;
import jkcemu.filebrowser.TarEntry;

public class ExtendedFileEntry
extends FileEntry {
    private FileNode fileNode;
    private TarEntry tarEntry;
    private ZipEntry zipEntry;

    public ExtendedFileEntry(File file) {
        this.fileNode = null;
        this.tarEntry = null;
        this.zipEntry = null;
        this.setFile(file);
    }

    public ExtendedFileEntry(FileNode fileNode) {
        this.fileNode = fileNode;
        this.tarEntry = null;
        this.zipEntry = null;
        if (fileNode != null) {
            this.setName(fileNode.toString());
            this.setFile(fileNode.getFile());
        }
    }

    public ExtendedFileEntry(TarEntry tarEntry) {
        this.fileNode = null;
        this.tarEntry = tarEntry;
        this.zipEntry = null;
        if (tarEntry != null) {
            this.setName(tarEntry.getName());
            this.setDirectory(this.tarEntry.isDirectory());
            this.setLastModified(tarEntry.getTime());
            this.setSize(this.tarEntry.getSize());
        }
    }

    public ExtendedFileEntry(ZipEntry zipEntry) {
        this.fileNode = null;
        this.tarEntry = null;
        this.zipEntry = zipEntry;
        if (zipEntry != null) {
            String string;
            this.setName(zipEntry.getName());
            this.setDirectory(this.zipEntry.isDirectory());
            if (!this.isDirectory() && (string = this.zipEntry.getName()) != null && (string.endsWith("/") || string.endsWith("\\"))) {
                this.setDirectory(true);
            }
            this.setLastModified(zipEntry.getTime());
            if (!this.isDirectory()) {
                this.setSize(this.zipEntry.getSize());
            }
        }
    }

    public FileNode getFileNode() {
        return this.fileNode;
    }

    @Override
    public Object getInfo() {
        Object object = null;
        if (this.tarEntry != null && !this.tarEntry.isRegularFile()) {
            object = this.tarEntry.getTypeText();
        }
        return object != null ? object : super.getInfo();
    }
}

