/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.etc;

import java.util.Random;
import jkcemu.Main;

public class PSG8910
extends Thread {
    public static final int PORT_A = 0;
    public static final int PORT_B = 1;
    private Callback callback;
    private int clockHz;
    private int regNum;
    private volatile int frameRate;
    private volatile int amplitudeA;
    private volatile int amplitudeB;
    private volatile int amplitudeC;
    private volatile int periodA;
    private volatile int periodB;
    private volatile int periodC;
    private volatile int periodNoise;
    private volatile int periodEnvelope;
    private volatile int shapeEnvelope;
    private volatile int modeBits;
    private volatile int portA;
    private volatile int portB;
    private volatile int[] volumeValues;
    private int channelOutA;
    private int channelOutB;
    private int channelOutC;
    private int noiseCounter;
    private int toneCounterA;
    private int toneCounterB;
    private int toneCounterC;
    private int shapeCounter;
    private int shapeStep;
    private int shapeValue;
    private boolean toneStateA;
    private boolean toneStateB;
    private boolean toneStateC;
    private boolean noiseState;
    private boolean envelopeDiv2Counter;
    private volatile boolean threadEnabled;
    private Random random;
    private Object waitMonitor;

    public PSG8910(int n, int n2, Callback callback) {
        super(Main.getThreadGroup(), "JKCEMU PSG");
        this.clockHz = n;
        this.callback = callback;
        this.frameRate = 0;
        this.volumeValues = new int[16];
        this.random = new Random();
        this.waitMonitor = new Object();
        this.threadEnabled = true;
        float f = 1.0f;
        for (int i = this.volumeValues.length - 1; i > 0; --i) {
            this.volumeValues[i] = Math.round(f * (float)n2);
            f = (float)((double)f * 0.707);
        }
        this.volumeValues[0] = 0;
        this.reset();
    }

    public int access(boolean bl, boolean bl2, boolean bl3, int n) {
        int n2 = -1;
        if (!bl && bl2 && !bl3 || bl && !bl2 && !bl3 || bl && bl2 && bl3) {
            this.regNum = n & 0xF;
        } else if (!bl && bl2 && bl3) {
            n2 = this.getRegister(this.regNum);
        } else if (bl && !bl2 && bl3) {
            this.setRegister(this.regNum, n);
        }
        return n2;
    }

    public void die() {
        this.threadEnabled = false;
        this.interrupt();
        this.wakeUp();
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public int getRegister(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = this.periodA & 0xFF;
                break;
            }
            case 1: {
                n2 = this.periodA >> 8 & 0xF;
                break;
            }
            case 2: {
                n2 = this.periodB & 0xFF;
                break;
            }
            case 3: {
                n2 = this.periodB >> 8 & 0xF;
                break;
            }
            case 4: {
                n2 = this.periodC & 0xFF;
                break;
            }
            case 5: {
                n2 = this.periodC >> 8 & 0xF;
                break;
            }
            case 6: {
                n2 = this.periodNoise;
                break;
            }
            case 7: {
                n2 = this.modeBits;
                break;
            }
            case 8: {
                n2 = this.amplitudeA;
                break;
            }
            case 9: {
                n2 = this.amplitudeB;
                break;
            }
            case 10: {
                n2 = this.amplitudeC;
                break;
            }
            case 11: {
                n2 = this.periodEnvelope & 0xFF;
                break;
            }
            case 12: {
                n2 = this.periodEnvelope >> 8 & 0xFF;
                break;
            }
            case 13: {
                n2 = this.shapeEnvelope;
                break;
            }
            case 14: {
                n2 = this.portA;
                if ((this.modeBits & 0x40) != 0 || this.callback == null) break;
                n2 = this.callback.psgReadPort(this, 0);
                break;
            }
            case 15: {
                n2 = this.portB;
                if ((this.modeBits & 0x80) != 0 || this.callback == null) break;
                n2 = this.callback.psgReadPort(this, 1);
            }
        }
        return n2;
    }

    public void reset() {
        this.portA = 255;
        this.portB = 255;
        this.modeBits = 255;
        this.amplitudeA = 0;
        this.amplitudeB = 0;
        this.amplitudeC = 0;
        this.periodA = 0;
        this.periodB = 0;
        this.periodC = 0;
        this.periodNoise = 0;
        this.periodEnvelope = 0;
        this.shapeEnvelope = 0;
        this.regNum = 0;
        this.channelOutA = 0;
        this.channelOutB = 0;
        this.channelOutC = 0;
        this.noiseCounter = 0;
        this.shapeCounter = 0;
        this.shapeStep = 0;
        this.shapeValue = 0;
        this.toneCounterA = 0;
        this.toneCounterB = 0;
        this.toneCounterC = 0;
        this.toneStateA = false;
        this.toneStateB = false;
        this.toneStateC = false;
        this.noiseState = false;
    }

    public void setFrameRate(int n) {
        this.frameRate = n;
        if (this.frameRate > 0) {
            this.wakeUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegister(int n, int n2) {
        switch (n) {
            case 0: {
                this.periodA = this.periodA & 0xF00 | n2 & 0xFF;
                break;
            }
            case 1: {
                this.periodA = n2 << 8 & 0xF00 | this.periodA & 0xFF;
                break;
            }
            case 2: {
                this.periodB = this.periodB & 0xF00 | n2 & 0xFF;
                break;
            }
            case 3: {
                this.periodB = n2 << 8 & 0xF00 | this.periodB & 0xFF;
                break;
            }
            case 4: {
                this.periodC = this.periodC & 0xF00 | n2 & 0xFF;
                break;
            }
            case 5: {
                this.periodC = n2 << 8 & 0xF00 | this.periodC & 0xFF;
                break;
            }
            case 6: {
                this.periodNoise = n2 & 0x1F;
                break;
            }
            case 7: {
                this.modeBits = n2 & 0xFF;
                break;
            }
            case 8: {
                this.amplitudeA = n2 & 0x1F;
                break;
            }
            case 9: {
                this.amplitudeB = n2 & 0x1F;
                break;
            }
            case 10: {
                this.amplitudeC = n2 & 0x1F;
                break;
            }
            case 11: {
                PSG8910 pSG8910 = this;
                synchronized (pSG8910) {
                    this.periodEnvelope = this.periodEnvelope & 0xFF00 | n2 & 0xFF;
                    this.resetShape();
                    break;
                }
            }
            case 12: {
                PSG8910 pSG8910 = this;
                synchronized (pSG8910) {
                    this.periodEnvelope = n2 << 8 & 0xFF00 | this.periodEnvelope & 0xFF;
                    this.resetShape();
                    break;
                }
            }
            case 13: {
                PSG8910 pSG8910 = this;
                synchronized (pSG8910) {
                    this.shapeEnvelope = n2 & 0xF;
                    this.resetShape();
                    break;
                }
            }
            case 14: {
                if ((this.modeBits & 0x40) == 0) break;
                this.portA = n2;
                if (this.callback == null) break;
                this.callback.psgWritePort(this, 0, n2);
                break;
            }
            case 15: {
                if ((this.modeBits & 0x80) == 0) break;
                this.portB = n2;
                if (this.callback == null) break;
                this.callback.psgWritePort(this, 1, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (this.threadEnabled) {
            int n4 = this.frameRate;
            if (n4 > 0) {
                int n5;
                if (n4 != n2) {
                    n = 0;
                }
                if ((n5 = (this.clockHz + n) / n4) > 0) {
                    int n6;
                    for (n6 = n3 + n5; n6 >= 8; n6 -= 8) {
                        this.internalClockPhaseChange();
                    }
                    n3 = n6;
                }
                this.callback.psgWriteFrame(this, this.channelOutA, this.channelOutB, this.channelOutC);
                n = this.clockHz - n5 * n4;
                continue;
            }
            Object object = this.waitMonitor;
            synchronized (object) {
                try {
                    this.waitMonitor.wait();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private int getOutValue(int n, boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = n > 15 ? this.volumeValues[this.shapeValue] : this.volumeValues[n];
        }
        return n2;
    }

    private synchronized void internalClockPhaseChange() {
        if (this.toneCounterA > 0) {
            --this.toneCounterA;
        } else {
            this.toneCounterA = this.periodA;
            if (this.toneCounterA > 0) {
                --this.toneCounterA;
                this.toneStateA = !this.toneStateA;
            } else {
                this.toneStateA = true;
            }
        }
        if (this.toneCounterB > 0) {
            --this.toneCounterB;
        } else {
            this.toneCounterB = this.periodB;
            if (this.toneCounterB > 0) {
                --this.toneCounterB;
                this.toneStateB = !this.toneStateB;
            } else {
                this.toneStateB = true;
            }
        }
        if (this.toneCounterC > 0) {
            --this.toneCounterC;
        } else {
            this.toneCounterC = this.periodC;
            if (this.toneCounterC > 0) {
                --this.toneCounterC;
                this.toneStateC = !this.toneStateB;
            } else {
                this.toneStateC = true;
            }
        }
        if (this.noiseCounter > 0) {
            --this.noiseCounter;
        } else {
            this.noiseCounter = this.periodNoise;
            if (this.noiseCounter > 0) {
                --this.noiseCounter;
            }
            if (this.random.nextBoolean()) {
                this.noiseState = !this.noiseState;
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        switch (this.modeBits & 9) {
            case 0: {
                bl = this.toneStateA || this.noiseState;
                break;
            }
            case 1: {
                bl = this.noiseState;
                break;
            }
            case 8: {
                bl = this.toneStateA;
            }
        }
        switch (this.modeBits & 0x12) {
            case 0: {
                bl2 = this.toneStateB || this.noiseState;
                break;
            }
            case 2: {
                bl2 = this.noiseState;
                break;
            }
            case 16: {
                bl2 = this.toneStateB;
            }
        }
        switch (this.modeBits & 0x24) {
            case 0: {
                bl3 = this.toneStateC || this.noiseState;
                break;
            }
            case 4: {
                bl3 = this.noiseState;
                break;
            }
            case 32: {
                bl3 = this.toneStateC;
            }
        }
        boolean bl4 = this.envelopeDiv2Counter = !this.envelopeDiv2Counter;
        if (this.envelopeDiv2Counter) {
            if (this.shapeCounter > 0) {
                --this.shapeCounter;
            }
            if (this.shapeCounter == 0) {
                this.shapeCounter = this.periodEnvelope;
                switch (this.shapeEnvelope) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 15: {
                        if (this.shapeStep < 15) {
                            ++this.shapeStep;
                            this.shapeValue = this.shapeStep & 0xF;
                            break;
                        }
                        this.shapeValue = 0;
                        break;
                    }
                    case 8: {
                        if (this.shapeStep < 15) {
                            ++this.shapeStep;
                            this.shapeValue = 15 - this.shapeStep & 0xF;
                            break;
                        }
                        this.shapeStep = 0;
                        this.shapeValue = 15;
                        break;
                    }
                    case 10: {
                        this.shapeStep = this.shapeStep < 31 ? ++this.shapeStep : 0;
                        if (this.shapeStep < 16) {
                            this.shapeValue = 15 - this.shapeStep & 0xF;
                            break;
                        }
                        this.shapeValue = this.shapeStep - 16 & 0xF;
                        break;
                    }
                    case 11: {
                        if (this.shapeStep < 15) {
                            ++this.shapeStep;
                            if (this.shapeValue <= 0) break;
                            --this.shapeValue;
                            break;
                        }
                        this.shapeValue = 15;
                        break;
                    }
                    case 12: {
                        if (this.shapeStep < 15) {
                            ++this.shapeStep;
                            this.shapeValue = this.shapeStep & 0xF;
                            break;
                        }
                        this.shapeStep = 0;
                        this.shapeValue = 0;
                        break;
                    }
                    case 13: {
                        if (this.shapeStep >= 15) break;
                        ++this.shapeStep;
                        this.shapeValue = this.shapeStep & 0xF;
                        break;
                    }
                    case 14: {
                        this.shapeStep = this.shapeStep < 31 ? ++this.shapeStep : 0;
                        if (this.shapeStep < 16) {
                            this.shapeValue = this.shapeStep & 0xF;
                            break;
                        }
                        this.shapeValue = 31 - this.shapeStep & 0xF;
                        break;
                    }
                    default: {
                        if (this.shapeStep < 16) {
                            ++this.shapeStep;
                        }
                        if (this.shapeValue <= 0) break;
                        --this.shapeValue;
                    }
                }
            }
        }
        this.channelOutA = this.getOutValue(this.amplitudeA, bl);
        this.channelOutB = this.getOutValue(this.amplitudeB, bl2);
        this.channelOutC = this.getOutValue(this.amplitudeC, bl3);
    }

    private void resetShape() {
        this.shapeStep = 0;
        this.shapeValue = this.shapeEnvelope <= 3 || this.shapeEnvelope >= 8 && this.shapeEnvelope <= 11 ? 15 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUp() {
        Object object = this.waitMonitor;
        synchronized (object) {
            try {
                this.waitMonitor.notify();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
    }

    public static interface Callback {
        public int psgReadPort(PSG8910 var1, int var2);

        public void psgWritePort(PSG8910 var1, int var2, int var3);

        public void psgWriteFrame(PSG8910 var1, int var2, int var3, int var4);
    }
}

