/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.etc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;

public class ChessboardFld
extends JComponent {
    private static final int MARGIN = 20;
    private static final int SQUARE_WIDTH = 40;
    private static final int PREFERRED_WIDTH = 360;
    private static Map<EmuSys.Chessman, Image> imgMap = null;
    private EmuThread emuThread;
    private Color colorWhiteSquare;
    private Color colorBlackSquare;
    private boolean swapped;

    public ChessboardFld(EmuThread emuThread) {
        this.emuThread = emuThread;
        this.colorWhiteSquare = new Color(255, 200, 200);
        this.colorBlackSquare = new Color(200, 150, 0);
        this.swapped = false;
        if (imgMap == null) {
            imgMap = new HashMap<EmuSys.Chessman, Image>();
            Toolkit toolkit = this.getToolkit();
            if (toolkit != null) {
                ChessboardFld.addImage(imgMap, toolkit, EmuSys.Chessman.WHITE_PAWN, "pawn_w.png");
                ChessboardFld.addImage(imgMap, toolkit, EmuSys.Chessman.WHITE_KNIGHT, "knight_w.png");
                ChessboardFld.addImage(imgMap, toolkit, EmuSys.Chessman.WHITE_BISHOP, "bishop_w.png");
                ChessboardFld.addImage(imgMap, toolkit, EmuSys.Chessman.WHITE_ROOK, "rook_w.png");
                ChessboardFld.addImage(imgMap, toolkit, EmuSys.Chessman.WHITE_QUEEN, "queen_w.png");
                ChessboardFld.addImage(imgMap, toolkit, EmuSys.Chessman.WHITE_KING, "king_w.png");
                ChessboardFld.addImage(imgMap, toolkit, EmuSys.Chessman.BLACK_PAWN, "pawn_b.png");
                ChessboardFld.addImage(imgMap, toolkit, EmuSys.Chessman.BLACK_KNIGHT, "knight_b.png");
                ChessboardFld.addImage(imgMap, toolkit, EmuSys.Chessman.BLACK_BISHOP, "bishop_b.png");
                ChessboardFld.addImage(imgMap, toolkit, EmuSys.Chessman.BLACK_ROOK, "rook_b.png");
                ChessboardFld.addImage(imgMap, toolkit, EmuSys.Chessman.BLACK_QUEEN, "queen_b.png");
                ChessboardFld.addImage(imgMap, toolkit, EmuSys.Chessman.BLACK_KING, "king_b.png");
                Collection<Image> collection = imgMap.values();
                if (collection != null && !collection.isEmpty()) {
                    MediaTracker mediaTracker = new MediaTracker(this);
                    int n = 0;
                    for (Image image : collection) {
                        mediaTracker.addImage(image, n++);
                    }
                    try {
                        mediaTracker.waitForAll();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        this.setFont(new Font("SansSerif", 0, 12));
    }

    public BufferedImage createImage() {
        BufferedImage bufferedImage = new BufferedImage(360, 360, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (graphics2D != null) {
            this.drawChessboard(graphics2D, 0, 0);
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    public void swap() {
        this.swapped = !this.swapped;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(360, 360);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n = Math.min((this.getWidth() - 360) / 2, 0);
        int n2 = Math.min((this.getHeight() - 360) / 2, 0);
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        this.drawChessboard(graphics, n, n2);
    }

    private static void addImage(Map<EmuSys.Chessman, Image> map, Toolkit toolkit, EmuSys.Chessman chessman, String string) {
        Image image;
        URL uRL = ChessboardFld.class.getResource("/images/chess/" + string);
        if (uRL != null && (image = toolkit.createImage(uRL)) != null) {
            map.put(chessman, image);
        }
    }

    private void drawChessboard(Graphics graphics, int n, int n2) {
        EmuSys emuSys;
        int n3;
        graphics.setColor(Color.white);
        graphics.fillRect(n, n2, 360, 360);
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, 360, 360);
        graphics.setFont(this.getFont());
        for (int i = 0; i < 8; ++i) {
            String string = Character.toString((char)(this.swapped ? 49 + i : 56 - i));
            int n4 = n2 + 20 + i * 40 + 20 + 4;
            graphics.setColor(Color.black);
            graphics.drawString(string, n + 6, n4);
            graphics.drawString(string, n + 20 + 320 + 6, n4);
            for (n3 = 0; n3 < 8; ++n3) {
                graphics.setColor(((i ^ n3) & 1) == 0 ? this.colorWhiteSquare : this.colorBlackSquare);
                graphics.fillRect(n + 20 + n3 * 40, n2 + 20 + i * 40, 40, 40);
            }
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.setColor(Color.black);
        for (int i = 0; i < 8; ++i) {
            String string = Character.toString((char)(this.swapped ? 72 - i : 65 + i));
            n3 = fontMetrics != null ? fontMetrics.stringWidth(string) : 8;
            graphics.drawString(string, n + 20 + i * 40 + (40 - n3) / 2, n2 + 16);
            graphics.drawString(string, n + 20 + i * 40 + (40 - n3) / 2, n2 + 20 + 320 + 14);
        }
        if (imgMap != null && (emuSys = this.emuThread.getEmuSys()) != null && emuSys.supportsChessboard()) {
            for (int i = 0; i < 8; ++i) {
                for (n3 = 0; n3 < 8; ++n3) {
                    Image image;
                    EmuSys.Chessman chessman = emuSys.getChessman(i, n3);
                    if (chessman == null || (image = imgMap.get((Object)chessman)) == null) continue;
                    int n5 = image.getWidth(this);
                    int n6 = image.getHeight(this);
                    if (n5 <= 0 || n6 <= 0) continue;
                    int n7 = i;
                    int n8 = n3;
                    if (this.swapped) {
                        n7 = 7 - i;
                        n8 = 7 - n3;
                    }
                    graphics.drawImage(image, n + 20 + n8 * 40 + (40 - n5) / 2, n2 + 20 + (7 - n7) * 40 + (40 - n6) / 2, this);
                }
            }
        }
    }
}

