/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.etc;

import z80emu.Z80CPU;
import z80emu.Z80MaxSpeedListener;
import z80emu.Z80TStatesListener;

public class CRTC6845
implements Z80MaxSpeedListener,
Z80TStatesListener {
    private SyncListener syncListener;
    private Z80CPU cpu;
    private int khz;
    private int regNum;
    private int startAddr;
    private int crsAddr;
    private int crsRasterStart;
    private int crsRasterEnd;
    private int crsBlinkMode;
    private CursorMode crsMode;
    private int hCharTotal;
    private int hCharVisible;
    private int hCharSyncPos;
    private int hCharSyncWidth;
    private int hSyncWidthCounter;
    private int vCharTotal;
    private int vCharVisible;
    private int vCharSyncPos;
    private int vCharLines;
    private int vCharCounter;
    private int vLineCounter;
    private int totalLineCounter;
    private int lineTStatesCounter;
    private int tStatesHSyncPos;
    private int tStatesHSyncWidth;
    private int tStatesLineWidth;
    private int curAddr;
    private boolean vSync;

    public CRTC6845(int n, SyncListener syncListener) {
        this.khz = n > 1 ? n : 1;
        this.syncListener = syncListener;
        this.cpu = null;
        this.reset();
    }

    public boolean isVSync() {
        return this.vSync;
    }

    public int read() {
        int n = 0;
        switch (this.regNum) {
            case 12: {
                n = this.startAddr >> 8 & 0x3F;
                break;
            }
            case 13: {
                n = this.startAddr & 0xFF;
                break;
            }
            case 14: {
                n = this.crsAddr >> 8 & 0x3F;
                break;
            }
            case 15: {
                n = this.crsAddr & 0xFF;
            }
        }
        return n;
    }

    private void reset() {
        this.regNum = 0;
        this.startAddr = 0;
        this.crsAddr = 0;
        this.crsRasterStart = 0;
        this.crsRasterEnd = 0;
        this.crsBlinkMode = 0;
        this.crsMode = CursorMode.INVISIBLE;
        this.hCharTotal = 0;
        this.hCharVisible = 0;
        this.hCharSyncPos = 0;
        this.hCharSyncWidth = 0;
        this.hSyncWidthCounter = 0;
        this.vCharTotal = 0;
        this.vCharVisible = 0;
        this.vCharSyncPos = 0;
        this.vCharLines = 0;
        this.vCharCounter = 0;
        this.vLineCounter = 0;
        this.totalLineCounter = 0;
        this.lineTStatesCounter = 0;
        this.tStatesHSyncPos = 0;
        this.tStatesHSyncWidth = 0;
        this.tStatesLineWidth = 0;
        this.curAddr = 0;
    }

    public int getHCharVisible() {
        return this.hCharVisible;
    }

    public int getStartAddr() {
        return this.startAddr;
    }

    public void setRegNum(int n) {
        this.regNum = n & 0x1F;
    }

    public void write(int n) {
        switch (this.regNum) {
            case 0: {
                this.hCharTotal = n & 0xFF;
                this.calcTStates();
                break;
            }
            case 1: {
                this.hCharVisible = n & 0xFF;
                break;
            }
            case 2: {
                this.hCharSyncPos = n & 0xFF;
                this.calcTStates();
                break;
            }
            case 3: {
                this.hCharSyncWidth = n & 0xF;
                this.calcTStates();
                break;
            }
            case 4: {
                this.vCharTotal = n & 0x7F;
                break;
            }
            case 6: {
                this.vCharVisible = n & 0x7F;
                break;
            }
            case 7: {
                this.vCharSyncPos = n & 0x7F;
                break;
            }
            case 9: {
                this.vCharLines = n & 0x1F;
                break;
            }
            case 10: {
                this.crsRasterStart = n & 0x1F;
                switch (n & 0x60) {
                    case 96: {
                        this.crsMode = CursorMode.BLINK_FAST;
                        break;
                    }
                    case 64: {
                        this.crsMode = CursorMode.BLINK_SLOW;
                        break;
                    }
                    case 32: {
                        this.crsMode = CursorMode.INVISIBLE;
                        break;
                    }
                    case 0: {
                        this.crsMode = CursorMode.BLINK_NONE;
                    }
                }
                break;
            }
            case 11: {
                this.crsRasterEnd = n & 0x1F;
                break;
            }
            case 12: {
                this.startAddr = n << 8 & 0xFF00 | this.startAddr & 0xFF;
                break;
            }
            case 13: {
                this.startAddr = this.startAddr & 0x3F00 | n & 0xFF;
                break;
            }
            case 14: {
                this.crsAddr = n << 8 & 0x3F00 | this.crsAddr & 0xFF;
                break;
            }
            case 15: {
                this.crsAddr = this.crsAddr & 0x3F00 | n & 0xFF;
            }
        }
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        this.cpu = z80CPU;
        this.calcTStates();
    }

    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        if (this.lineTStatesCounter < this.tStatesHSyncPos && this.lineTStatesCounter + n >= this.tStatesHSyncPos) {
            this.hSyncWidthCounter = this.tStatesHSyncWidth + this.tStatesHSyncPos - this.lineTStatesCounter - n;
            this.syncListener.crtcHSyncBegin(this.totalLineCounter, this.vLineCounter, this.curAddr);
        } else if (this.hSyncWidthCounter > 0) {
            this.hSyncWidthCounter -= n;
            if (this.hSyncWidthCounter <= 0) {
                this.syncListener.crtcHSyncEnd();
            }
        }
        this.lineTStatesCounter += n;
        if (this.lineTStatesCounter >= this.tStatesLineWidth) {
            this.lineTStatesCounter -= this.tStatesLineWidth;
            ++this.totalLineCounter;
            if (this.vLineCounter < this.vCharLines) {
                ++this.vLineCounter;
            } else {
                this.vLineCounter = 0;
                if (this.vCharCounter < this.vCharTotal) {
                    ++this.vCharCounter;
                    this.curAddr += this.hCharVisible;
                } else {
                    this.vCharCounter = 0;
                    this.curAddr = this.startAddr;
                }
                if (this.vCharCounter == this.vCharSyncPos) {
                    this.vSync = true;
                    this.syncListener.crtcVSyncBegin();
                }
                if (this.vCharCounter == 0) {
                    this.vSync = false;
                    this.syncListener.crtcVSyncEnd();
                    this.totalLineCounter = 0;
                }
            }
        }
    }

    private void calcTStates() {
        int n = this.cpu.getMaxSpeedKHz();
        this.tStatesHSyncPos = this.hCharSyncPos * n / this.khz;
        this.tStatesHSyncWidth = this.hCharSyncWidth * n / this.khz;
        this.tStatesLineWidth = this.hCharTotal * n / this.khz;
        this.lineTStatesCounter = 0;
    }

    private static enum CursorMode {
        BLINK_FAST,
        BLINK_SLOW,
        BLINK_NONE,
        INVISIBLE;

    }

    public static interface SyncListener {
        public void crtcHSyncBegin(int var1, int var2, int var3);

        public void crtcHSyncEnd();

        public void crtcVSyncBegin();

        public void crtcVSyncEnd();
    }
}

