/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.etc;

import java.util.zip.Checksum;

public class CRC16
implements Checksum {
    private int polynom;
    private int initValue;
    private int crcValue;

    public CRC16(int n, int n2) {
        this.polynom = n;
        this.initValue = n2;
        this.reset();
    }

    public static CRC16 createCRC16CCITT() {
        return new CRC16(4129, 65535);
    }

    @Override
    public long getValue() {
        return (long)this.crcValue & 0xFFFFL;
    }

    @Override
    public void reset() {
        this.crcValue = this.initValue;
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            this.update(byArray[n++]);
            --n2;
        }
    }

    @Override
    public void update(int n) {
        n <<= 8;
        for (int i = 0; i < 8; ++i) {
            if (((n ^ this.crcValue) & 0x8000) != 0) {
                this.crcValue <<= 1;
                this.crcValue ^= this.polynom;
            } else {
                this.crcValue <<= 1;
            }
            n <<= 1;
        }
    }
}

