/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.zxspectrum;

import java.io.IOException;
import java.util.NoSuchElementException;
import jkcemu.audio.BitSampleBuffer;
import jkcemu.base.ByteIterator;
import jkcemu.base.EmuUtil;

public class ZXSpectrumAudioCreator
extends BitSampleBuffer {
    private static final int SAMPLE_RATE = 44100;
    private static final float T_STATES_PER_SAMPLE = 79.36508f;
    private ByteIterator iter;
    private boolean phase = false;

    public ZXSpectrumAudioCreator(byte[] byArray, int n, int n2) throws IOException {
        super(44100, 32768);
        if (EmuUtil.isTextAt("ZXTape!\u001a", byArray, n)) {
            int n3 = "ZXTape!\u001a".length();
            this.iter = new ByteIterator(byArray, n + n3, n2 - n3);
            this.processTzxFile();
        } else {
            this.iter = new ByteIterator(byArray, n, n2);
            this.processTapFile();
        }
    }

    private void addSamplesByMillis(int n) throws IOException {
        if (n > 0) {
            this.addSamples(Math.round((float)n * 44100.0f / 1000.0f), this.phase);
        }
    }

    private void addSamplesByTStates(int n) throws IOException {
        this.addSamples(Math.round((float)n / 79.36508f), this.phase);
    }

    private void changePhase() {
        this.phase = !this.phase;
    }

    private void processStdTapBlock(int n, int n2) throws IOException, NoSuchElementException {
        this.processTapBlock(2168, 667, 735, 855, 1710, 8063, 3223, 8, n, n2);
    }

    private void processTapBlock(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) throws IOException, NoSuchElementException {
        if (n10 > 0) {
            int n11;
            int n12 = this.iter.nextByte();
            int n13 = (n12 & 0x80) != 0 ? n7 : n6;
            for (n11 = 0; n11 < n13; ++n11) {
                this.addSamplesByTStates(n);
                this.changePhase();
            }
            if (n2 > 0) {
                this.addSamplesByTStates(n2);
                this.changePhase();
            }
            if (n3 > 0) {
                this.addSamplesByTStates(n3);
                this.changePhase();
            }
            while (true) {
                n11 = --n10 > 0 ? 8 : n8;
                for (int i = 0; i < n11; ++i) {
                    int n14 = (n12 & 0x80) != 0 ? n5 : n4;
                    this.addSamplesByTStates(n14);
                    this.changePhase();
                    this.addSamplesByTStates(n14);
                    this.changePhase();
                    n12 <<= 1;
                }
                if (n10 == 0) break;
                n12 = this.iter.nextByte();
            }
            if (n9 > 0) {
                this.addSamplesByMillis(1);
                this.phase = false;
                if (--n9 > 0) {
                    this.addSamplesByMillis(n9);
                }
            }
        }
    }

    private void processTapFile() throws IOException, NoSuchElementException {
        try {
            int n = this.iter.nextWord();
            while (this.iter.hasNext()) {
                this.processStdTapBlock(1000, n);
                n = this.iter.nextWord();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void processTzxBlock10() throws IOException, NoSuchElementException {
        int n = this.iter.nextWord();
        int n2 = this.iter.nextWord();
        this.processStdTapBlock(n, n2);
    }

    private void processTzxBlock11() throws IOException, NoSuchElementException {
        int n = this.iter.nextWord();
        int n2 = this.iter.nextWord();
        int n3 = this.iter.nextWord();
        int n4 = this.iter.nextWord();
        int n5 = this.iter.nextWord();
        int n6 = this.iter.nextWord();
        int n7 = this.iter.nextByte();
        int n8 = this.iter.nextWord();
        int n9 = this.iter.nextInt3LE();
        this.processTapBlock(n, n2, n3, n4, n5, n6, n6, n7, n8, n9);
    }

    private void processTzxBlock12() throws IOException, NoSuchElementException {
        int n = this.iter.nextWord();
        int n2 = this.iter.nextWord();
        for (int i = 0; i < n2; ++i) {
            this.addSamplesByTStates(n);
            this.changePhase();
        }
    }

    private void processTzxBlock13() throws IOException, NoSuchElementException {
        int n = this.iter.nextByte();
        for (int i = 0; i < n; ++i) {
            this.addSamplesByTStates(this.iter.nextWord());
            this.changePhase();
        }
    }

    private void processTzxBlock14() throws IOException, NoSuchElementException {
        int n = this.iter.nextWord();
        int n2 = this.iter.nextWord();
        int n3 = this.iter.nextByte();
        int n4 = this.iter.nextWord();
        int n5 = this.iter.nextInt3LE();
        this.processTapBlock(0, 0, 0, n, n2, 0, 0, n3, n4, n5);
    }

    private void processTzxBlock15() throws IOException, NoSuchElementException {
        int n = this.iter.nextWord();
        int n2 = this.iter.nextWord();
        int n3 = this.iter.nextByte();
        int n4 = this.iter.nextInt3LE();
        if (n4 > 0) {
            int n5 = Math.round((float)n / 79.36508f);
            do {
                int n6 = n4 > 1 ? 8 : Math.max(n3, 8);
                int n7 = this.iter.nextByte();
                for (int i = 0; i < n6; ++i) {
                    this.phase = (n7 & 0x80) != 0;
                    this.addSamples(n5, this.phase);
                    n7 <<= 1;
                }
            } while (--n4 > 0);
            this.changePhase();
            this.addSamplesByMillis(n2);
        }
    }

    private void processTzxBlock18() throws IOException, NoSuchElementException {
        int n = this.iter.nextInt4LE();
        int n2 = this.iter.nextWord();
        int n3 = this.iter.nextInt3LE();
        if (n3 != 44100) {
            throw new IOException("Block-ID 18: Abtastrate " + String.valueOf(n3) + " Hz nicht unterst\u00fctzt");
        }
        int n4 = this.iter.nextByte();
        if (n4 != 1) {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("CSW-Kompressionsmethode ");
            if (n4 == 2) {
                stringBuilder.append("Z-RLE");
            } else {
                stringBuilder.append(n4);
            }
            stringBuilder.append(" nicht unterst\u00fctzt");
            throw new IOException(stringBuilder.toString());
        }
        this.iter.skip(4);
        boolean bl = true;
        int n5 = n - 10;
        while (n5 != 0 && this.iter.hasNext()) {
            int n6 = this.iter.nextByte();
            if (n5 > 0) {
                --n5;
            }
            if (n6 == 0) {
                n6 = this.iter.nextInt4LE();
                if (n5 > 0 && (n5 -= 4) < 0) {
                    n5 = 0;
                }
            }
            if (bl) {
                bl = false;
            } else {
                this.changePhase();
            }
            this.addSamples(n6, this.phase);
        }
    }

    private void processTzxBlock20() throws IOException, NoSuchElementException {
        int n = this.iter.nextWord();
        if (n == 0) {
            n = 5000;
        }
        this.phase = false;
        this.addSamplesByMillis(n);
    }

    private void processTzxBlock2B() throws NoSuchElementException {
        int n = this.iter.nextInt4LE();
        boolean bl = this.phase = this.iter.nextByte() != 0;
        if (--n > 0) {
            this.iter.skip(n);
        }
    }

    private void processTzxFile() throws IOException {
        try {
            this.iter.skip(2);
            block17: while (this.iter.hasNext()) {
                int n = this.iter.nextByte();
                switch (n) {
                    case 16: {
                        this.processTzxBlock10();
                        continue block17;
                    }
                    case 17: {
                        this.processTzxBlock11();
                        continue block17;
                    }
                    case 18: {
                        this.processTzxBlock12();
                        continue block17;
                    }
                    case 19: {
                        this.processTzxBlock13();
                        continue block17;
                    }
                    case 20: {
                        this.processTzxBlock14();
                        continue block17;
                    }
                    case 21: {
                        this.processTzxBlock15();
                        continue block17;
                    }
                    case 24: {
                        this.processTzxBlock18();
                        continue block17;
                    }
                    case 32: {
                        this.processTzxBlock20();
                        continue block17;
                    }
                    case 34: {
                        continue block17;
                    }
                    case 43: {
                        this.processTzxBlock2B();
                        continue block17;
                    }
                    case 33: 
                    case 48: {
                        this.iter.skip(this.iter.nextByte());
                        continue block17;
                    }
                    case 50: {
                        this.iter.skip(this.iter.nextWord());
                        continue block17;
                    }
                    case 53: {
                        this.iter.skip(16);
                        this.iter.skip(this.iter.nextInt4LE());
                        continue block17;
                    }
                }
                throw new IOException(String.format("Die TZX-Datei enth\u00e4lt mit ID %02X ein nicht unterst\u00fctztes Blockformat.", n));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }
}

