/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.z9001;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import jkcemu.base.AbstractSettingsFld;
import jkcemu.base.AutoInputSettingsFld;
import jkcemu.base.AutoLoadSettingsFld;
import jkcemu.base.EmuUtil;
import jkcemu.base.RAMFloppiesSettingsFld;
import jkcemu.base.RAMFloppy;
import jkcemu.base.ROMFileSettingsFld;
import jkcemu.base.SettingsFrm;
import jkcemu.base.UserInputException;
import jkcemu.disk.GIDESettingsFld;

public class Z9001SettingsFld
extends AbstractSettingsFld {
    private static final String DEFAULT_LABEL_ROM_MODULE = "Inhalt des ROM-Moduls:";
    private JTabbedPane tabbedPane;
    private JPanel tabEtc;
    private JPanel tabExt;
    private JPanel tabGraph;
    private JPanel tabMem;
    private JPanel tabPrinter;
    private GIDESettingsFld tabGIDE;
    private RAMFloppiesSettingsFld tabRF;
    private AutoLoadSettingsFld tabAutoLoad;
    private AutoInputSettingsFld tabAutoInput;
    private JRadioButton btnMonoGraphNone;
    private JRadioButton btnMonoGraphKRT;
    private JRadioButton btnColorGraphNone;
    private JRadioButton btnColorGraphKRT;
    private JRadioButton btnColorGraphRobotron;
    private JCheckBox btnFontProgrammable;
    private JCheckBox btn80Chars;
    private JCheckBox btnFixedScreenSize;
    private JCheckBox btnRam16k4000;
    private JCheckBox btnRam16k8000;
    private JCheckBox btnRam64k;
    private JCheckBox btnRom16k4000;
    private JCheckBox btnRom32k4000;
    private JCheckBox btnRom16k8000;
    private JCheckBox btnRom10kC000;
    private JCheckBox btnRomMega;
    private JCheckBox btnRomBoot;
    private ROMFileSettingsFld fldRomModule;
    private JRadioButton btnCatchPrintCalls;
    private JRadioButton btnPrinterModule;
    private JRadioButton btnNoPrinter;
    private JCheckBox btnFloppyDisk;
    private JCheckBox btnPlotter;
    private JCheckBox btnKCNet;
    private JCheckBox btnVDIP;
    private JCheckBox btnRTC;
    private JCheckBox btnPasteFast;
    private ROMFileSettingsFld fldAltOS;
    private ROMFileSettingsFld fldAltBASIC;
    private ROMFileSettingsFld fldAltFont;
    private Map<AbstractButton, AbstractButton[]> switchOffMap = new HashMap<AbstractButton, AbstractButton[]>();

    public Z9001SettingsFld(SettingsFrm settingsFrm, String string, boolean bl) {
        super(settingsFrm, string);
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(1);
        this.add((Component)this.tabbedPane, "Center");
        this.tabGraph = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Grafik", this.tabGraph);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnMonoGraphNone = new JRadioButton("S/W, Blockgrafik", false);
        buttonGroup.add(this.btnMonoGraphNone);
        this.tabGraph.add((Component)this.btnMonoGraphNone, gridBagConstraints);
        this.btnMonoGraphKRT = new JRadioButton("S/W, KRT-Vollgrafikerweiterung", false);
        buttonGroup.add(this.btnMonoGraphKRT);
        gridBagConstraints.insets.top = 0;
        ++gridBagConstraints.gridy;
        this.tabGraph.add((Component)this.btnMonoGraphKRT, gridBagConstraints);
        this.btnColorGraphNone = new JRadioButton("Farbe, Blockgrafik", true);
        buttonGroup.add(this.btnColorGraphNone);
        ++gridBagConstraints.gridy;
        this.tabGraph.add((Component)this.btnColorGraphNone, gridBagConstraints);
        this.btnColorGraphKRT = new JRadioButton("Farbe, KRT-Vollgrafikerweiterung", false);
        buttonGroup.add(this.btnColorGraphKRT);
        ++gridBagConstraints.gridy;
        this.tabGraph.add((Component)this.btnColorGraphKRT, gridBagConstraints);
        this.btnColorGraphRobotron = new JRadioButton("Farbe, Robotron-Vollgrafikerweiterung", false);
        buttonGroup.add(this.btnColorGraphRobotron);
        ++gridBagConstraints.gridy;
        this.tabGraph.add((Component)this.btnColorGraphRobotron, gridBagConstraints);
        this.btnFontProgrammable = new JCheckBox("Programmierbarer Zeichengenerator", false);
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 0;
        ++gridBagConstraints.gridy;
        this.tabGraph.add((Component)this.btnFontProgrammable, gridBagConstraints);
        this.btn80Chars = new JCheckBox("40/80-Zeichen-Umschaltung", false);
        gridBagConstraints.insets.top = 0;
        ++gridBagConstraints.gridy;
        this.tabGraph.add((Component)this.btn80Chars, gridBagConstraints);
        this.btnFixedScreenSize = new JCheckBox("Gleiche Fenstergr\u00f6\u00dfe in beiden Bildschirmmodi");
        gridBagConstraints.insets.left = 50;
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        this.tabGraph.add((Component)this.btnFixedScreenSize, gridBagConstraints);
        this.tabMem = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Speichermodule", this.tabMem);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.btnRam16k4000 = new JCheckBox("16K RAM-Modul (4000h-7FFFh)", false);
        this.tabMem.add((Component)this.btnRam16k4000, gridBagConstraints2);
        this.btnRam16k8000 = new JCheckBox("16K RAM-Modul (8000h-BFFFh)", false);
        ++gridBagConstraints2.gridx;
        this.tabMem.add((Component)this.btnRam16k8000, gridBagConstraints2);
        this.btnRam64k = new JCheckBox("64K RAM-Modul (2 x 4000h-7FFFh, 1 x 8000h-E7FFh)", false);
        gridBagConstraints2.insets.top = 0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        this.tabMem.add((Component)this.btnRam64k, gridBagConstraints2);
        this.btnRom16k4000 = new JCheckBox("16K ROM-Modul (4000h-7FFFh)", false);
        gridBagConstraints2.insets.top = 10;
        gridBagConstraints2.gridwidth = 1;
        ++gridBagConstraints2.gridy;
        this.tabMem.add((Component)this.btnRom16k4000, gridBagConstraints2);
        this.btnRom16k8000 = new JCheckBox("16K ROM-Modul (8000h-BFFFh)", false);
        ++gridBagConstraints2.gridx;
        this.tabMem.add((Component)this.btnRom16k8000, gridBagConstraints2);
        this.btnRom32k4000 = new JCheckBox("32K ROM-Modul (4000h-BFFFh)", false);
        gridBagConstraints2.insets.top = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        this.tabMem.add((Component)this.btnRom32k4000, gridBagConstraints2);
        this.btnRom10kC000 = new JCheckBox("10K ROM-Modul (C000h-E7FFh)", false);
        ++gridBagConstraints2.gridx;
        this.tabMem.add((Component)this.btnRom10kC000, gridBagConstraints2);
        this.btnRomMega = new JCheckBox("Mega-ROM-Modul (256 x C000h-E7FFh)", false);
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        this.tabMem.add((Component)this.btnRomMega, gridBagConstraints2);
        this.btnRomBoot = new JCheckBox("Boot-ROM-Modul (C000h-E7FFh, nur mit Floppy-Disk-Modul sinnvoll)", false);
        ++gridBagConstraints2.gridy;
        this.tabMem.add((Component)this.btnRomBoot, gridBagConstraints2);
        this.fldRomModule = new ROMFileSettingsFld(settingsFrm, this.propPrefix + "rom_module.", DEFAULT_LABEL_ROM_MODULE);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets.top = 10;
        gridBagConstraints2.gridwidth = 0;
        ++gridBagConstraints2.gridy;
        this.tabMem.add((Component)this.fldRomModule, gridBagConstraints2);
        this.switchOffMap.put(this.btnRam16k4000, Z9001SettingsFld.toArray(this.btnRam64k, this.btnRom16k4000, this.btnRom32k4000));
        this.switchOffMap.put(this.btnRam16k8000, Z9001SettingsFld.toArray(this.btnRam64k, this.btnRom32k4000, this.btnRom16k8000));
        this.switchOffMap.put(this.btnRam64k, Z9001SettingsFld.toArray(this.btnRam16k4000, this.btnRam16k8000, this.btnRom16k4000, this.btnRom32k4000, this.btnRom16k8000, this.btnRom10kC000));
        this.switchOffMap.put(this.btnRom16k4000, Z9001SettingsFld.toArray(this.btnRam16k4000, this.btnRam64k, this.btnRom32k4000, this.btnRom16k8000, this.btnRom10kC000, this.btnRomBoot, this.btnRomMega));
        this.switchOffMap.put(this.btnRom32k4000, Z9001SettingsFld.toArray(this.btnRam16k4000, this.btnRam64k, this.btnRom16k4000, this.btnRom16k8000, this.btnRom10kC000, this.btnRomBoot, this.btnRomMega));
        this.switchOffMap.put(this.btnRom16k8000, Z9001SettingsFld.toArray(this.btnRam16k8000, this.btnRam64k, this.btnRom16k4000, this.btnRom32k4000, this.btnRom10kC000, this.btnRomBoot, this.btnRomMega));
        this.switchOffMap.put(this.btnRom10kC000, Z9001SettingsFld.toArray(this.btnRam64k, this.btnRom16k4000, this.btnRom32k4000, this.btnRom16k8000, this.btnRomBoot, this.btnRomMega));
        this.switchOffMap.put(this.btnRomBoot, Z9001SettingsFld.toArray(this.btnRom16k4000, this.btnRom32k4000, this.btnRom16k8000, this.btnRom10kC000, this.btnRomMega));
        this.switchOffMap.put(this.btnRomMega, Z9001SettingsFld.toArray(this.btnRom16k4000, this.btnRom32k4000, this.btnRom16k8000, this.btnRom10kC000, this.btnRomBoot));
        this.updMemFieldsEnabled();
        this.tabRF = new RAMFloppiesSettingsFld(settingsFrm, string, "RAM-Floppy an E/A-Adressen 20h/21h", RAMFloppy.RFType.ADW, "RAM-Floppy an E/A-Adressen 24h/25h", RAMFloppy.RFType.ADW);
        this.tabbedPane.addTab("RAM-Floppies", this.tabRF);
        this.tabPrinter = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Drucker", this.tabPrinter);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.btnCatchPrintCalls = new JRadioButton("BOS-Aufrufe f\u00fcr Druckerausgaben abfangen", false);
        buttonGroup2.add(this.btnCatchPrintCalls);
        this.tabPrinter.add((Component)this.btnCatchPrintCalls, gridBagConstraints3);
        this.btnPrinterModule = new JRadioButton("V.24-Druckermodul emulieren", false);
        buttonGroup2.add(this.btnPrinterModule);
        gridBagConstraints3.insets.top = 0;
        ++gridBagConstraints3.gridy;
        this.tabPrinter.add((Component)this.btnPrinterModule, gridBagConstraints3);
        this.btnNoPrinter = new JRadioButton("Keinen Drucker emulieren", true);
        buttonGroup2.add(this.btnNoPrinter);
        gridBagConstraints3.insets.bottom = 5;
        ++gridBagConstraints3.gridy;
        this.tabPrinter.add((Component)this.btnNoPrinter, gridBagConstraints3);
        this.tabGIDE = new GIDESettingsFld(settingsFrm, string);
        this.tabbedPane.addTab("GIDE", this.tabGIDE);
        this.tabExt = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Erweiterungen", this.tabExt);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.btnFloppyDisk = new JCheckBox("Floppy-Disk-Modul", false);
        this.tabExt.add((Component)this.btnFloppyDisk, gridBagConstraints4);
        this.btnPlotter = new JCheckBox("Plotter XY4131 / XY4140", false);
        gridBagConstraints4.insets.top = 0;
        ++gridBagConstraints4.gridy;
        this.tabExt.add((Component)this.btnPlotter, gridBagConstraints4);
        this.btnKCNet = new JCheckBox("KCNet-kompatible Netzwerkkarte", false);
        ++gridBagConstraints4.gridy;
        this.tabExt.add((Component)this.btnKCNet, gridBagConstraints4);
        this.btnVDIP = new JCheckBox("USB-Anschluss (Vinculum VDIP Modul)", false);
        ++gridBagConstraints4.gridy;
        this.tabExt.add((Component)this.btnVDIP, gridBagConstraints4);
        this.btnRTC = new JCheckBox("Echtzeituhr", false);
        this.btnRTC.addActionListener(this);
        gridBagConstraints4.insets.bottom = 5;
        ++gridBagConstraints4.gridy;
        this.tabExt.add((Component)this.btnRTC, gridBagConstraints4);
        this.tabEtc = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Sonstiges", this.tabEtc);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.btnPasteFast = new JCheckBox("Einf\u00fcgen von Text direkt in den Tastaturpuffer", true);
        ++gridBagConstraints5.gridy;
        this.tabEtc.add((Component)this.btnPasteFast, gridBagConstraints5);
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.insets.top = 10;
        gridBagConstraints5.insets.bottom = 10;
        ++gridBagConstraints5.gridy;
        this.tabEtc.add((Component)new JSeparator(), gridBagConstraints5);
        this.fldAltOS = new ROMFileSettingsFld(settingsFrm, string + "os.", "Alternatives Betriebssystem (F000h-FFFFh):");
        gridBagConstraints5.insets.top = 5;
        gridBagConstraints5.insets.bottom = 5;
        ++gridBagConstraints5.gridy;
        this.tabEtc.add((Component)this.fldAltOS, gridBagConstraints5);
        if (bl) {
            this.fldAltBASIC = new ROMFileSettingsFld(settingsFrm, string + "basic.", "Alternativer BASIC-ROM (C000h-E7FFh):");
            ++gridBagConstraints5.gridy;
            this.tabEtc.add((Component)this.fldAltBASIC, gridBagConstraints5);
        } else {
            this.fldAltBASIC = null;
        }
        this.fldAltFont = new ROMFileSettingsFld(settingsFrm, string + "font.", "Alternativer Zeichensatz:");
        ++gridBagConstraints5.gridy;
        this.tabEtc.add((Component)this.fldAltFont, gridBagConstraints5);
        this.tabAutoLoad = new AutoLoadSettingsFld(settingsFrm, string, 2500, true);
        this.tabbedPane.addTab("AutoLoad", this.tabAutoLoad);
        this.tabAutoInput = new AutoInputSettingsFld(settingsFrm, string, true, 2500);
        this.tabbedPane.addTab("AutoInput", this.tabAutoInput);
        this.btnMonoGraphNone.addActionListener(this);
        this.btnMonoGraphKRT.addActionListener(this);
        this.btnColorGraphNone.addActionListener(this);
        this.btnColorGraphKRT.addActionListener(this);
        this.btnColorGraphRobotron.addActionListener(this);
        this.btnFontProgrammable.addActionListener(this);
        this.btn80Chars.addActionListener(this);
        this.btnFixedScreenSize.addActionListener(this);
        this.btnRam16k4000.addActionListener(this);
        this.btnRam16k8000.addActionListener(this);
        this.btnRam64k.addActionListener(this);
        this.btnRom16k4000.addActionListener(this);
        this.btnRom32k4000.addActionListener(this);
        this.btnRom16k8000.addActionListener(this);
        this.btnRom10kC000.addActionListener(this);
        this.btnRomBoot.addActionListener(this);
        this.btnRomMega.addActionListener(this);
        this.btnCatchPrintCalls.addActionListener(this);
        this.btnPrinterModule.addActionListener(this);
        this.btnNoPrinter.addActionListener(this);
        this.btnFloppyDisk.addActionListener(this);
        this.btnPlotter.addActionListener(this);
        this.btnKCNet.addActionListener(this);
        this.btnVDIP.addActionListener(this);
        this.btnPasteFast.addActionListener(this);
    }

    @Override
    public void applyInput(Properties properties, boolean bl) throws UserInputException {
        JPanel jPanel = null;
        try {
            jPanel = this.tabGraph;
            boolean bl2 = false;
            String string = "none";
            if (this.btnMonoGraphKRT.isSelected()) {
                string = "krt";
            } else if (this.btnColorGraphNone.isSelected()) {
                bl2 = true;
            } else if (this.btnColorGraphKRT.isSelected()) {
                bl2 = true;
                string = "krt";
            } else if (this.btnColorGraphRobotron.isSelected()) {
                bl2 = true;
                string = "robotron";
            }
            EmuUtil.setProperty(properties, this.propPrefix + "color", bl2);
            EmuUtil.setProperty(properties, this.propPrefix + "graphic.type", string);
            EmuUtil.setProperty(properties, this.propPrefix + "font.programmable", this.btnFontProgrammable.isSelected());
            EmuUtil.setProperty(properties, this.propPrefix + "80_chars.enabled", this.btn80Chars.isSelected());
            EmuUtil.setProperty(properties, this.propPrefix + "fixed_screen_size", this.btnFixedScreenSize.isSelected());
            jPanel = this.tabMem;
            EmuUtil.setProperty(properties, this.propPrefix + "ram_16k_4000.enabled", this.btnRam16k4000.isSelected());
            EmuUtil.setProperty(properties, this.propPrefix + "ram_16k_8000.enabled", this.btnRam16k8000.isSelected());
            EmuUtil.setProperty(properties, this.propPrefix + "ram_64k.enabled", this.btnRam64k.isSelected());
            File file = this.fldRomModule.getFile();
            boolean bl3 = this.btnRom16k4000.isSelected();
            boolean bl4 = this.btnRom32k4000.isSelected();
            boolean bl5 = this.btnRom16k8000.isSelected();
            boolean bl6 = this.btnRom10kC000.isSelected();
            if ((bl3 || bl4 || bl5 || bl6) && file == null && bl) {
                throw new UserInputException("Datei f\u00fcr ROM-Modul nicht ausgew\u00e4hlt");
            }
            EmuUtil.setProperty(properties, this.propPrefix + "rom_module." + "file", file != null ? file.getPath() : file);
            EmuUtil.setProperty(properties, this.propPrefix + "rom_16k_4000.enabled", bl3);
            EmuUtil.setProperty(properties, this.propPrefix + "rom_32k_4000.enabled", bl4);
            EmuUtil.setProperty(properties, this.propPrefix + "rom_16k_8000.enabled", bl5);
            EmuUtil.setProperty(properties, this.propPrefix + "rom_10k_c000.enabled", bl6);
            EmuUtil.setProperty(properties, this.propPrefix + "rom_boot.enabled", this.btnRomBoot.isSelected());
            EmuUtil.setProperty(properties, this.propPrefix + "rom_mega.enabled", this.btnRomMega.isSelected());
            jPanel = this.tabRF;
            this.tabRF.applyInput(properties, bl);
            jPanel = this.tabPrinter;
            EmuUtil.setProperty(properties, this.propPrefix + "catch_print_calls", this.btnCatchPrintCalls.isSelected());
            EmuUtil.setProperty(properties, this.propPrefix + "printer_module.enabled", this.btnPrinterModule.isSelected());
            jPanel = this.tabGIDE;
            this.tabGIDE.applyInput(properties, bl);
            jPanel = this.tabExt;
            EmuUtil.setProperty(properties, this.propPrefix + "fdc.enabled", this.btnFloppyDisk.isSelected());
            EmuUtil.setProperty(properties, this.propPrefix + "plotter.enabled", this.btnPlotter.isSelected());
            EmuUtil.setProperty(properties, this.propPrefix + "kcnet.enabled", this.btnKCNet.isSelected());
            EmuUtil.setProperty(properties, this.propPrefix + "vdip.enabled", this.btnVDIP.isSelected());
            EmuUtil.setProperty(properties, this.propPrefix + "rtc.enabled", this.btnRTC.isSelected());
            jPanel = this.tabEtc;
            EmuUtil.setProperty(properties, this.propPrefix + "paste.fast", this.btnPasteFast.isSelected());
            this.fldAltOS.applyInput(properties, bl);
            if (this.fldAltBASIC != null) {
                this.fldAltBASIC.applyInput(properties, bl);
            }
            this.fldAltFont.applyInput(properties, bl);
            jPanel = this.tabAutoLoad;
            this.tabAutoLoad.applyInput(properties, bl);
            jPanel = this.tabAutoInput;
            this.tabAutoInput.applyInput(properties, bl);
        }
        catch (UserInputException userInputException) {
            if (jPanel != null) {
                this.tabbedPane.setSelectedComponent(jPanel);
            }
            throw userInputException;
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null && object instanceof AbstractButton) {
            AbstractButton[] abstractButtonArray;
            AbstractButton abstractButton = (AbstractButton)object;
            if (abstractButton.isSelected() && (abstractButtonArray = this.switchOffMap.get(abstractButton)) != null) {
                for (int i = 0; i < abstractButtonArray.length; ++i) {
                    abstractButtonArray[i].setSelected(false);
                }
            }
            this.updMemFieldsEnabled();
            this.fireDataChanged();
            bl = true;
        }
        if (!bl) {
            bl = this.tabGIDE.doAction(eventObject);
        }
        if (!bl) {
            bl = this.tabAutoLoad.doAction(eventObject);
        }
        if (!bl) {
            bl = this.tabAutoInput.doAction(eventObject);
        }
        return bl;
    }

    @Override
    public void lookAndFeelChanged() {
        this.fldRomModule.lookAndFeelChanged();
        this.fldAltOS.lookAndFeelChanged();
        if (this.fldAltBASIC != null) {
            this.fldAltBASIC.lookAndFeelChanged();
        }
        this.fldAltFont.lookAndFeelChanged();
        this.tabGIDE.lookAndFeelChanged();
        this.tabAutoLoad.lookAndFeelChanged();
        this.tabAutoInput.lookAndFeelChanged();
    }

    @Override
    public void updFields(Properties properties) {
        boolean bl = EmuUtil.getBooleanProperty(properties, this.propPrefix + "color", true);
        String string = EmuUtil.getProperty(properties, this.propPrefix + "graphic.type");
        if (bl) {
            if (string.equals("krt")) {
                this.btnColorGraphKRT.setSelected(true);
            } else if (string.equals("robotron")) {
                this.btnColorGraphRobotron.setSelected(true);
            } else {
                this.btnColorGraphNone.setSelected(true);
            }
        } else if (string.equals("krt")) {
            this.btnMonoGraphKRT.setSelected(true);
        } else {
            this.btnMonoGraphNone.setSelected(true);
        }
        this.btnFontProgrammable.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "font.programmable", false));
        this.btn80Chars.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "80_chars.enabled", false));
        this.btnFixedScreenSize.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "fixed_screen_size", false));
        this.btnRam16k4000.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "ram_16k_4000.enabled", false));
        this.btnRam16k8000.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "ram_16k_8000.enabled", false));
        this.btnRam64k.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "ram_64k.enabled", false));
        this.btnRom16k4000.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "rom_16k_4000.enabled", false));
        this.btnRom32k4000.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "rom_32k_4000.enabled", false));
        this.btnRom16k8000.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "rom_16k_8000.enabled", false));
        this.btnRom10kC000.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "rom_10k_c000.enabled", false));
        this.btnRomBoot.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "rom_boot.enabled", false));
        this.btnRomMega.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "rom_mega.enabled", false));
        this.fldRomModule.updFields(properties);
        this.updMemFieldsEnabled();
        this.tabRF.updFields(properties);
        if (EmuUtil.getBooleanProperty(properties, this.propPrefix + "printer_module.enabled", false)) {
            this.btnPrinterModule.setSelected(true);
        } else if (EmuUtil.getBooleanProperty(properties, this.propPrefix + "catch_print_calls", false)) {
            this.btnCatchPrintCalls.setSelected(true);
        } else {
            this.btnNoPrinter.setSelected(true);
        }
        this.tabGIDE.updFields(properties);
        this.btnFloppyDisk.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "fdc.enabled", false));
        this.btnPlotter.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "plotter.enabled", false));
        this.btnKCNet.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "kcnet.enabled", false));
        this.btnVDIP.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "vdip.enabled", false));
        this.btnRTC.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "rtc.enabled", false));
        this.btnPasteFast.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "paste.fast", true));
        this.fldAltOS.updFields(properties);
        if (this.fldAltBASIC != null) {
            this.fldAltBASIC.updFields(properties);
        }
        this.fldAltFont.updFields(properties);
        this.tabAutoLoad.updFields(properties);
        this.tabAutoInput.updFields(properties);
    }

    private static AbstractButton[] toArray(AbstractButton ... abstractButtonArray) {
        return abstractButtonArray;
    }

    private void updMemFieldsEnabled() {
        String string = DEFAULT_LABEL_ROM_MODULE;
        boolean bl = false;
        if (this.btnRom16k4000.isSelected() || this.btnRom32k4000.isSelected() || this.btnRom16k8000.isSelected() || this.btnRom10kC000.isSelected()) {
            bl = true;
        } else if (this.btnRomBoot.isSelected()) {
            string = "Alternativer Inhalt des Boot-ROM-Moduls:";
            bl = true;
        } else if (this.btnRomMega.isSelected()) {
            string = "Alternativer Inhalt des Mega-ROM-Moduls:";
            bl = true;
        }
        this.fldRomModule.setLabelText(string);
        this.fldRomModule.setEnabled(bl);
        this.btnFixedScreenSize.setEnabled(this.btn80Chars.isSelected());
    }
}

