/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.z9001;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.EmuSys;
import jkcemu.emusys.Z9001;

public class Z9001KeyboardFld
extends AbstractKeyboardFld<Z9001> {
    private static final int FS_SMALL = 9;
    private static final int FS_KEY = 12;
    private static final int FS_SKEY = 9;
    private static final int MARGIN_WIN = 15;
    private static final int MARGIN_FRM = 8;
    private static final int KEY_W = 30;
    private static final int KEY_H = 10;
    private static final int KEY_COL_W = 45;
    private static final int KEY_ROW_H = 43;
    private static final int LKEY_W = 75;
    private static final int LED_W = 12;
    private static final int Y_COLOR = 24;
    private static final int Y_KEY0 = 46;
    private static final int X_KEY0 = 15;
    private static final int X_KEY1 = 60;
    private static final int X_KEY2 = 105;
    private static final int X_KEY3 = 150;
    private static final int X_KEY4 = 195;
    private static final int X_KEY5 = 240;
    private static final int X_KEY6 = 285;
    private static final int X_KEY7 = 330;
    private static final int X_KEY8 = 375;
    private static final int X_KEY9 = 420;
    private static final int X_KEY10 = 465;
    private static final int X_KEY11 = 510;
    private static final int X_KEY12 = 600;
    private static final int X_KEY13 = 645;
    private Image imgLeft = this.getImage("/images/keyboard/z9001/left.png");
    private Image imgRight = this.getImage("/images/keyboard/z9001/right.png");
    private Image imgUp = this.getImage("/images/keyboard/z9001/up.png");
    private Image imgDown = this.getImage("/images/keyboard/z9001/down.png");
    private Image imgFirst = this.getImage("/images/keyboard/z9001/first.png");
    private Image imgLast = this.getImage("/images/keyboard/z9001/last.png");
    private Color colorKeyLight = new Color(180, 180, 180);
    private Color colorKeyDark = new Color(20, 20, 20);
    private Color colorKeySelected = new Color(120, 120, 120);
    private Color colorLEDGreenOn = Color.green;
    private Color colorLEDGreenOff = new Color(60, 120, 60);
    private Font fontSmall = new Font("SansSerif", 0, 9);
    private Font fontKey = new Font("SansSerif", 1, 12);
    private Font fontSpecialKey = new Font("SansSerif", 0, 9);
    private AbstractKeyboardFld.KeyData resetKey;
    private int[] kbMatrix = new int[8];
    private int curIdx = 0;

    public Z9001KeyboardFld(Z9001 z9001) {
        super(z9001, 65, true);
        int n = 46;
        this.addKey(15, n, 30, 10, this.colorKeyLight, 2, 128, true, null);
        this.addDarkKey(60, n, 1, 1);
        this.addDarkKey(105, n, 2, 1);
        this.addDarkKey(150, n, 3, 1);
        this.addDarkKey(195, n, 4, 1);
        this.addDarkKey(240, n, 5, 1);
        this.addDarkKey(285, n, 6, 1);
        this.addDarkKey(330, n, 7, 1);
        this.addDarkKey(375, n, 0, 2);
        this.addDarkKey(420, n, 1, 2);
        this.addDarkKey(465, n, 0, 1);
        this.addDarkKey(510, n, 0, 4);
        this.addLightKey(600, n, 4, 32, "F4");
        this.resetKey = new AbstractKeyboardFld.KeyData(645, n, 75, 10, null, null, null, new Color(200, 0, 0), null, -1, 0, false, null);
        this.keys[this.curIdx++] = this.resetKey;
        this.addLightKey(15, n += 43, 1, 128, "F7");
        this.addDarkKey(60, n, 1, 16);
        this.addDarkKey(105, n, 7, 16);
        this.addDarkKey(150, n, 5, 4);
        this.addDarkKey(195, n, 2, 16);
        this.addDarkKey(240, n, 4, 16);
        this.addDarkKey(285, n, 2, 32);
        this.addDarkKey(330, n, 5, 16);
        this.addDarkKey(375, n, 1, 8);
        this.addDarkKey(420, n, 7, 8);
        this.addDarkKey(465, n, 0, 16);
        this.addDarkKey(510, n, 6, 32);
        this.addLightKey(600, n, 5, 32, "Einfg");
        this.addLightKey(645, n, 4, 128, "F1");
        this.addLightKey(15, n += 43, 3, 128, "F8");
        this.addDarkKey(60, n, 1, 4);
        this.addDarkKey(105, n, 3, 16);
        this.addDarkKey(150, n, 4, 4);
        this.addDarkKey(195, n, 6, 4);
        this.addDarkKey(240, n, 7, 4);
        this.addDarkKey(285, n, 0, 8);
        this.addDarkKey(330, n, 2, 8);
        this.addDarkKey(375, n, 3, 8);
        this.addDarkKey(420, n, 4, 8);
        this.addDarkKey(465, n, 2, 2);
        this.addDarkKey(510, n, 7, 2);
        this.addLightKey(600, n, 4, 64, "Esc");
        this.addLongLightKey(645, n, 5, 128, "F2");
        this.addDarkKey(60, n += 43, 1, 32);
        this.addDarkKey(105, n, 0, 32);
        this.addDarkKey(150, n, 3, 4);
        this.addDarkKey(195, n, 6, 16);
        this.addDarkKey(240, n, 2, 4);
        this.addDarkKey(285, n, 6, 8);
        this.addDarkKey(330, n, 5, 8);
        this.addDarkKey(375, n, 4, 2);
        this.addDarkKey(420, n, 6, 2);
        this.addDarkKey(465, n, 3, 2);
        this.addDarkKey(510, n, 5, 2);
        this.addLightKey(600, n, 3, 32, "Strg + \u2190");
        this.addLongLightKey(645, n, 6, 64, "F3");
        AbstractKeyboardFld.KeyData keyData = this.addKey(15, n += 43, 75, 10, this.colorKeyLight, 0, 128, true, null);
        this.addLightKey(105, n, 0, 64);
        this.addLightKey(150, n, 1, 64);
        this.addLongLightKey(195, n, 7, 64, "Leerzeichen");
        this.addLongLightKey(285, n, 7, 64, "Leerzeichen");
        this.addLightKey(375, n, 3, 64);
        this.addLightKey(420, n, 2, 64);
        AbstractKeyboardFld.KeyData keyData2 = this.addKey(465, n, 75, 10, this.colorKeyLight, 0, 128, true, null);
        this.addLightKey(600, n, 6, 128);
        this.addLongLightKey(645, n, 5, 64, "Enter");
        int n2 = 245;
        n2 = this.imgDown != null ? (n2 += Math.max(12, this.imgDown.getHeight(this))) : (n2 += 12);
        this.setPreferredSize(new Dimension(735, n2));
        this.setShiftKeys(keyData, keyData2);
    }

    @Override
    public boolean accepts(EmuSys emuSys) {
        return emuSys instanceof Z9001;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void keySelectionChanged() {
        Arrays.fill(this.kbMatrix, 0);
        List list = this.selectedKeys;
        synchronized (list) {
            for (AbstractKeyboardFld.KeyData keyData : this.selectedKeys) {
                if (keyData.col < 0 || keyData.col >= this.kbMatrix.length) continue;
                int n = keyData.col;
                this.kbMatrix[n] = this.kbMatrix[n] | keyData.value;
            }
        }
        ((Z9001)this.emuSys).updKeyboardMatrix(this.kbMatrix);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this) {
            if (Z9001KeyboardFld.hits(this.resetKey, mouseEvent)) {
                this.fireWarmResetAfterDelay();
            }
            super.mousePressed(mouseEvent);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        int n2 = 24;
        graphics.setFont(this.fontSmall);
        this.drawCenter(graphics, 60, n2, 30, "BLACK");
        this.drawCenter(graphics, 105, n2, 30, "RED");
        this.drawCenter(graphics, 150, n2, 30, "GREEN");
        this.drawCenter(graphics, 195, n2, 30, "YELLOW");
        this.drawCenter(graphics, 240, n2, 30, "BLUE");
        this.drawCenter(graphics, 285, n2, 30, "MAGENTA");
        this.drawCenter(graphics, 330, n2, 30, "CYAN");
        this.drawCenter(graphics, 375, n2, 30, "WHITE");
        graphics.setFont(this.fontKey);
        n2 = 41;
        this.drawCenter(graphics, 60, n2, 30, "!");
        this.drawCenter(graphics, 105, n2, 30, "\"");
        this.drawCenter(graphics, 150, n2, 30, "#");
        this.drawCenter(graphics, 195, n2, 30, "$");
        this.drawCenter(graphics, 240, n2, 30, "%");
        this.drawCenter(graphics, 285, n2, 30, "&");
        this.drawCenter(graphics, 330, n2, 30, "'");
        this.drawCenter(graphics, 375, n2, 30, "(");
        this.drawCenter(graphics, 420, n2, 30, ")");
        this.drawCenter(graphics, 465, n2, 30, "_");
        this.drawCenter(graphics, 465, n2 += 86, 30, "*");
        this.drawCenter(graphics, 510, n2, 30, "/");
        this.drawCenter(graphics, 375, n2 += 43, 30, "<");
        this.drawCenter(graphics, 420, n2, 30, ">");
        this.drawCenter(graphics, 465, n2, 30, "+");
        this.drawCenter(graphics, 510, n2, 30, "-");
        n2 = 69;
        this.drawCenter(graphics, 60, n2, 30, "1");
        this.drawCenter(graphics, 105, n2, 30, "2");
        this.drawCenter(graphics, 150, n2, 30, "3");
        this.drawCenter(graphics, 195, n2, 30, "4");
        this.drawCenter(graphics, 240, n2, 30, "5");
        this.drawCenter(graphics, 285, n2, 30, "6");
        this.drawCenter(graphics, 330, n2, 30, "7");
        this.drawCenter(graphics, 375, n2, 30, "8");
        this.drawCenter(graphics, 420, n2, 30, "9");
        this.drawCenter(graphics, 465, n2, 30, "0");
        this.drawCenter(graphics, 510, n2, 30, "@");
        this.drawCenter(graphics, 60, n2 += 43, 30, "Q");
        this.drawCenter(graphics, 105, n2, 30, "W");
        this.drawCenter(graphics, 150, n2, 30, "E");
        this.drawCenter(graphics, 195, n2, 30, "R");
        this.drawCenter(graphics, 240, n2, 30, "T");
        this.drawCenter(graphics, 285, n2, 30, "Z");
        this.drawCenter(graphics, 330, n2, 30, "U");
        this.drawCenter(graphics, 375, n2, 30, "I");
        this.drawCenter(graphics, 420, n2, 30, "O");
        this.drawCenter(graphics, 465, n2, 30, "P");
        this.drawCenter(graphics, 510, n2, 30, "^");
        this.drawCenter(graphics, 60, n2 += 43, 30, "A");
        this.drawCenter(graphics, 105, n2, 30, "S");
        this.drawCenter(graphics, 150, n2, 30, "D");
        this.drawCenter(graphics, 195, n2, 30, "F");
        this.drawCenter(graphics, 240, n2, 30, "G");
        this.drawCenter(graphics, 285, n2, 30, "H");
        this.drawCenter(graphics, 330, n2, 30, "J");
        this.drawCenter(graphics, 375, n2, 30, "K");
        this.drawCenter(graphics, 420, n2, 30, "L");
        this.drawCenter(graphics, 465, n2, 30, ":");
        this.drawCenter(graphics, 510, n2, 30, "?");
        this.drawCenter(graphics, 60, n2 += 43, 30, "Y");
        this.drawCenter(graphics, 105, n2, 30, "X");
        this.drawCenter(graphics, 150, n2, 30, "C");
        this.drawCenter(graphics, 195, n2, 30, "V");
        this.drawCenter(graphics, 240, n2, 30, "B");
        this.drawCenter(graphics, 285, n2, 30, "N");
        this.drawCenter(graphics, 330, n2, 30, "M");
        this.drawCenter(graphics, 375, n2, 30, ",");
        this.drawCenter(graphics, 420, n2, 30, ".");
        this.drawCenter(graphics, 465, n2, 30, ";");
        this.drawCenter(graphics, 510, n2, 30, "=");
        if (this.imgLast != null && (n = this.imgLast.getHeight(this)) > 0) {
            this.drawCenter(graphics, 600, n2 - 12 - 10 - n - 4, 30, this.imgLast);
        }
        this.drawCenter(graphics, 600, n2 - 12 + 3, 30, this.imgFirst);
        graphics.setFont(this.fontSpecialKey);
        n2 = 41;
        this.drawCenter(graphics, 600, n2, 30, "CONT");
        this.drawCenter(graphics, 600, n2 += 43, 30, "DEL");
        this.drawCenter(graphics, 600, n2 += 43, 30, "CL LN");
        n2 = 66;
        this.drawCenter(graphics, 15, n2, 30, "CONTR");
        this.drawCenter(graphics, 600, n2, 30, "PAUSE");
        this.drawRight(graphics, 645, n2, 75, "RESET");
        this.drawCenter(graphics, 15, n2 += 43, 30, "COLOR");
        this.drawCenter(graphics, 600, n2, 30, "INS");
        this.drawRight(graphics, 645, n2, 30, "LIST");
        this.drawCenter(graphics, 600, n2 += 43, 30, "ESC");
        this.drawRight(graphics, 645, n2, 75, "RUN");
        this.drawRight(graphics, 645, n2 += 43, 75, "STOP");
        this.drawRight(graphics, 645, n2 += 43, 75, "ENTER");
        n2 = 231;
        this.drawCenter(graphics, 105, n2, 30, this.imgLeft);
        this.drawCenter(graphics, 150, n2, 30, this.imgRight);
        this.drawCenter(graphics, 375, n2, 30, this.imgUp);
        this.drawCenter(graphics, 420, n2, 30, this.imgDown);
        graphics.drawString("SHIFT", 15, n2 += 7);
        this.drawRight(graphics, 465, n2, 75, "SHIFT");
        this.drawRight(graphics, 600, n2, 30, "SHIFT LOCK");
        n = 690;
        n2 = 79;
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, 30, 30);
        graphics.setColor(Color.red);
        graphics.fillOval(n += 9, n2 += 9, 12, 12);
        n = 7;
        n2 = 124;
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, 45, 68);
        n2 = 161;
        this.drawCenter(graphics, 15, n2, 30, "GRAPHIC");
        graphics.setColor(((Z9001)this.emuSys).getGraphicLED() ? this.colorLEDGreenOn : this.colorLEDGreenOff);
        n = 24;
        n2 = 174;
        graphics.fillOval(n, n2, 12, 12);
        for (AbstractKeyboardFld.KeyData keyData : this.keys) {
            graphics.setColor(this.isKeySelected(keyData) ? this.colorKeySelected : keyData.color);
            graphics.fillRect(keyData.x, keyData.y, keyData.w, keyData.h);
            graphics.setColor(Color.black);
            graphics.drawRect(keyData.x, keyData.y, keyData.w, keyData.h);
        }
    }

    @Override
    public void setEmuSys(EmuSys emuSys) {
        if (!(emuSys instanceof Z9001)) {
            throw new IllegalArgumentException("EmuSys != Z9001");
        }
        this.emuSys = (Z9001)emuSys;
    }

    private AbstractKeyboardFld.KeyData addKey(int n, int n2, int n3, int n4, Color color, int n5, int n6, boolean bl, String string) {
        AbstractKeyboardFld.KeyData keyData = new AbstractKeyboardFld.KeyData(n, n2, n3, n4, null, null, null, color, null, n5, n6, bl, string);
        this.keys[this.curIdx++] = keyData;
        return keyData;
    }

    private void addDarkKey(int n, int n2, int n3, int n4) {
        this.addKey(n, n2, 30, 10, this.colorKeyDark, n3, n4, false, null);
    }

    private void addLightKey(int n, int n2, int n3, int n4) {
        this.addKey(n, n2, 30, 10, this.colorKeyLight, n3, n4, false, null);
    }

    private void addLightKey(int n, int n2, int n3, int n4, String string) {
        this.addKey(n, n2, 30, 10, this.colorKeyLight, n3, n4, false, string);
    }

    private void addLongLightKey(int n, int n2, int n3, int n4, String string) {
        this.addKey(n, n2, 75, 10, this.colorKeyLight, n3, n4, false, string);
    }

    private void drawCenter(Graphics graphics, int n, int n2, int n3, String string) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (fontMetrics != null) {
            graphics.drawString(string, n + (n3 - fontMetrics.stringWidth(string)) / 2, n2);
        } else {
            graphics.drawString(string, n, n2);
        }
    }

    private void drawCenter(Graphics graphics, int n, int n2, int n3, Image image) {
        int n4;
        if (image != null && (n4 = image.getWidth(this)) > 0) {
            graphics.drawImage(image, n + (n3 - n4) / 2, n2, this);
        }
    }

    private void drawRight(Graphics graphics, int n, int n2, int n3, String string) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (fontMetrics != null) {
            graphics.drawString(string, n + (n3 - fontMetrics.stringWidth(string)), n2);
        } else {
            graphics.drawString(string, n, n2);
        }
    }
}

