/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.z1013;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.Arrays;
import java.util.List;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.EmuSys;
import jkcemu.emusys.Z1013;
import jkcemu.emusys.z1013.KeyboardMatrix;
import jkcemu.emusys.z1013.KeyboardMatrix8x4;
import jkcemu.emusys.z1013.Z1013Keyboard;

public class Z1013KeyboardFld8x4
extends AbstractKeyboardFld<Z1013> {
    private static final String[] keyImgResources = new String[]{"/images/keyboard/z1013/key_at.png", "/images/keyboard/z1013/key_a.png", "/images/keyboard/z1013/key_b.png", "/images/keyboard/z1013/key_c.png", "/images/keyboard/z1013/key_d.png", "/images/keyboard/z1013/key_e.png", "/images/keyboard/z1013/key_f.png", "/images/keyboard/z1013/key_g.png", "/images/keyboard/z1013/key_h.png", "/images/keyboard/z1013/key_i.png", "/images/keyboard/z1013/key_j.png", "/images/keyboard/z1013/key_k.png", "/images/keyboard/z1013/key_l.png", "/images/keyboard/z1013/key_m.png", "/images/keyboard/z1013/key_n.png", "/images/keyboard/z1013/key_o.png", "/images/keyboard/z1013/key_p.png", "/images/keyboard/z1013/key_q.png", "/images/keyboard/z1013/key_r.png", "/images/keyboard/z1013/key_s.png", "/images/keyboard/z1013/key_t.png", "/images/keyboard/z1013/key_u.png", "/images/keyboard/z1013/key_v.png", "/images/keyboard/z1013/key_w.png", "/images/keyboard/z1013/key_shift1.png", "/images/keyboard/z1013/key_shift2.png", "/images/keyboard/z1013/key_shift3.png", "/images/keyboard/z1013/key_shift4.png", "/images/keyboard/z1013/key_left.png", "/images/keyboard/z1013/key_space.png", "/images/keyboard/z1013/key_right.png", "/images/keyboard/z1013/key_enter.png"};
    private static final int MARGIN = 5;
    private int keyWidth = 0;
    private int keyHeight = 0;
    private int[] kbMatrix = new int[8];

    public Z1013KeyboardFld8x4(Z1013 z1013) {
        super(z1013, 32, true);
        int n = 5;
        int n2 = 5;
        Toolkit toolkit = this.getToolkit();
        if (toolkit != null) {
            int n3 = 1;
            for (int i = 0; i < keyImgResources.length; ++i) {
                Image image;
                int n4 = i % 8;
                if (i > 0 && n4 == 0) {
                    n3 <<= 1;
                    n = 5;
                    n2 += this.keyHeight + 5;
                }
                if ((image = this.getImage(keyImgResources[i])) != null) {
                    if (this.keyWidth <= 0) {
                        this.keyWidth = Math.max(0, image.getWidth(this));
                    }
                    if (this.keyHeight <= 0) {
                        this.keyHeight = Math.max(0, image.getHeight(this));
                    }
                }
                boolean bl = false;
                String string = null;
                if (n3 == 8 && n4 < 4) {
                    bl = true;
                    string = String.format("F%d", n4 + 1);
                }
                this.keys[i] = new AbstractKeyboardFld.KeyData(n, n2, this.keyWidth, this.keyHeight, null, null, null, null, image, n4, n3, bl, string);
                n += this.keyWidth + 5;
            }
        }
        this.setPreferredSize(new Dimension(n, n2 + this.keyHeight + 5));
    }

    @Override
    public boolean accepts(EmuSys emuSys) {
        KeyboardMatrix keyboardMatrix;
        Z1013Keyboard z1013Keyboard;
        boolean bl = false;
        if (emuSys instanceof Z1013 && (z1013Keyboard = ((Z1013)emuSys).getZ1013Keyboard()) != null && (keyboardMatrix = z1013Keyboard.getKeyboardMatrix()) != null && keyboardMatrix instanceof KeyboardMatrix8x4) {
            bl = true;
        }
        return bl;
    }

    @Override
    public String getKeyboardName() {
        return "Z1013 Folienflachtastatur";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void keySelectionChanged() {
        Z1013Keyboard z1013Keyboard = ((Z1013)this.emuSys).getZ1013Keyboard();
        KeyboardMatrix keyboardMatrix = z1013Keyboard.getKeyboardMatrix();
        if (keyboardMatrix instanceof KeyboardMatrix8x4) {
            Arrays.fill(this.kbMatrix, 0);
            List list = this.selectedKeys;
            synchronized (list) {
                for (AbstractKeyboardFld.KeyData keyData : this.selectedKeys) {
                    if (keyData.col < 0 || keyData.col >= this.kbMatrix.length) continue;
                    int n = keyData.col;
                    this.kbMatrix[n] = this.kbMatrix[n] | keyData.value;
                }
            }
            ((KeyboardMatrix8x4)keyboardMatrix).updKeyboardMatrix(this.kbMatrix);
            z1013Keyboard.putRowValuesToPIO();
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n > 0 && n2 > 0 && this.keyWidth > 0 && this.keyHeight > 0) {
            graphics.setColor(Color.gray);
            graphics.fillRect(0, 0, n, n2);
            for (AbstractKeyboardFld.KeyData keyData : this.keys) {
                if (keyData.image == null) continue;
                if (this.isKeySelected(keyData)) {
                    graphics.setColor(Color.darkGray);
                    graphics.fillRect(keyData.x, keyData.y, this.keyWidth, this.keyHeight);
                }
                graphics.drawImage(keyData.image, keyData.x, keyData.y, this);
            }
        }
    }

    @Override
    public void setEmuSys(EmuSys emuSys) {
        if (!this.accepts(emuSys)) {
            throw new IllegalArgumentException("EmuSys != Z1013/8x4");
        }
        this.emuSys = (Z1013)emuSys;
    }
}

