/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.z1013;

import java.util.Properties;
import jkcemu.Main;
import jkcemu.emusys.z1013.KeyboardMatrix;
import jkcemu.emusys.z1013.KeyboardMatrix8x4;
import jkcemu.emusys.z1013.KeyboardMatrix8x8;
import jkcemu.emusys.z1013.KeyboardMatrixK7659;
import jkcemu.emusys.z1013.KeyboardMatrixK7669;
import jkcemu.emusys.z1013.KeyboardMatrixS6009;
import z80emu.Z80PIO;

public class Z1013Keyboard {
    private Z80PIO z80pio;
    private volatile KeyboardMatrix keyboardMatrix;
    private volatile boolean fontAltEnabled;
    private volatile int selectedCol;

    public Z1013Keyboard(Z80PIO z80PIO) {
        this.z80pio = z80PIO;
        this.keyboardMatrix = null;
        this.fontAltEnabled = false;
        this.selectedCol = 0;
        this.applySettings(Main.getProperties());
        if (this.keyboardMatrix == null) {
            this.keyboardMatrix = new KeyboardMatrix8x4();
        }
    }

    public void applySettings(Properties properties) {
        if (properties != null) {
            KeyboardMatrix keyboardMatrix = null;
            String string = properties.getProperty("jkcemu.z1013.monitor");
            if (string != null) {
                if (string.equals("A.2")) {
                    keyboardMatrix = new KeyboardMatrix8x8();
                } else if (string.equals("RB_K7659") || string.equals("BL4_K7659")) {
                    keyboardMatrix = new KeyboardMatrixK7659();
                } else if (string.equals("INCOM_K7669")) {
                    keyboardMatrix = new KeyboardMatrixK7669();
                } else if (string.equals("RB_S6009")) {
                    keyboardMatrix = new KeyboardMatrixS6009();
                }
            }
            if (keyboardMatrix == null) {
                keyboardMatrix = new KeyboardMatrix8x4();
            }
            this.keyboardMatrix = keyboardMatrix;
        }
    }

    public KeyboardMatrix getKeyboardMatrix() {
        return this.keyboardMatrix;
    }

    public String getKeyboardType() {
        return this.keyboardMatrix.getKeyboardType();
    }

    public void putRowValuesToPIO() {
        this.z80pio.putInValuePortB(~this.keyboardMatrix.getRowValues(this.selectedCol, (this.z80pio.fetchOutValuePortB(false) & 0x10) != 0), 31);
    }

    public void reset() {
        this.keyboardMatrix.reset();
    }

    public boolean setKeyChar(char c, boolean bl) {
        boolean bl2 = false;
        int n = 0;
        n = c == '\n' ? 13 : (int)c;
        if (n > 0 && n <= 255 && this.keyboardMatrix.setKeyCharCode(n, bl)) {
            this.putRowValuesToPIO();
            bl2 = true;
        }
        return bl2;
    }

    public boolean setKeyCode(int n) {
        boolean bl = this.keyboardMatrix.setKeyCode(n);
        this.putRowValuesToPIO();
        return bl;
    }

    public void setKeyReleased() {
        this.keyboardMatrix.setKeyReleased();
        this.putRowValuesToPIO();
    }

    public synchronized void setSelectedCol(int n) {
        this.selectedCol = n;
        this.putRowValuesToPIO();
    }
}

