/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.z1013;

import java.util.Arrays;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.emusys.z1013.KeyboardMatrix;

public class KeyboardMatrix8x8
extends KeyboardMatrix {
    private static String matrixNormal = "13579-QETUO@ADGJL*YCBM.^24680[WRZIP]SFHK+\\XVN,/_";
    private static String matrixShift = "!#%')=qetuo`adgjl:ycbm>~\"$&( {wrzip}sfhk;|xvn<?\u007f";
    private int[] keyboardMatrix = new int[8];

    public KeyboardMatrix8x8() {
        this.reset();
    }

    public synchronized void updKeyboardMatrix(int[] nArray) {
        int n;
        int n2 = Math.min(nArray.length, this.keyboardMatrix.length);
        for (n = 0; n < n2; ++n) {
            this.keyboardMatrix[n] = nArray[n];
        }
        while (n < this.keyboardMatrix.length) {
            this.keyboardMatrix[n] = 0;
            ++n;
        }
    }

    @Override
    public String getKeyboardType() {
        return "8x8";
    }

    @Override
    public int getRowValues(int n, boolean bl) {
        int n2 = 0;
        if (n >= 0) {
            if (this.onlyShiftKeysReadable()) {
                if (n == 6) {
                    n2 = this.keyboardMatrix[n] & 0x20;
                } else if (n == 7) {
                    n2 = this.keyboardMatrix[n] & 0x40;
                }
            } else if (n < this.keyboardMatrix.length) {
                n2 = this.keyboardMatrix[n];
                if (bl) {
                    n2 >>= 4;
                }
            }
        }
        return n2 & 0xF;
    }

    @Override
    public void reset() {
        super.reset();
        Arrays.fill(this.keyboardMatrix, 0);
    }

    @Override
    public synchronized boolean setKeyCode(int n) {
        boolean bl = true;
        this.reset();
        switch (n) {
            case 112: {
                this.keyboardMatrix[6] = 1;
                break;
            }
            case 10: {
                this.keyboardMatrix[6] = 2;
                break;
            }
            case 37: {
                this.keyboardMatrix[6] = 4;
                break;
            }
            case 39: {
                this.keyboardMatrix[6] = 8;
                break;
            }
            case 32: {
                this.keyboardMatrix[6] = 16;
                break;
            }
            case 38: {
                this.keyboardMatrix[6] = 64;
                break;
            }
            case 40: {
                this.keyboardMatrix[6] = 128;
                break;
            }
            case 8: {
                this.setKeyCharCode(8, false);
                break;
            }
            case 9: {
                this.setKeyCharCode(9, false);
                break;
            }
            case 127: {
                this.setKeyCharCode(127, false);
                break;
            }
            default: {
                bl = false;
            }
        }
        this.updShiftKeysPressed();
        return bl;
    }

    @Override
    public void updKeyboardFld(AbstractKeyboardFld abstractKeyboardFld) {
        if (abstractKeyboardFld != null) {
            abstractKeyboardFld.updKeySelection(this.keyboardMatrix);
        }
    }

    @Override
    protected boolean updKeyboardMatrix(int n, boolean bl) {
        int n2;
        boolean bl2 = false;
        boolean bl3 = false;
        if (n > 0 && n < 32) {
            n += 64;
            bl3 = true;
        }
        if ((n2 = matrixNormal.indexOf(n)) >= 0) {
            int n3 = 1 << n2 / 6;
            int n4 = n2 % 6;
            this.keyboardMatrix[n4] = this.keyboardMatrix[n4] | n3;
            bl2 = true;
        } else {
            n2 = matrixShift.indexOf(n);
            if (n2 >= 0) {
                int n5 = 1 << n2 / 6;
                int n6 = n2 % 6;
                this.keyboardMatrix[n6] = this.keyboardMatrix[n6] | n5;
                this.keyboardMatrix[7] = this.keyboardMatrix[7] | 0x40;
                bl2 = true;
            }
        }
        if (bl2) {
            if (bl3) {
                this.keyboardMatrix[6] = this.keyboardMatrix[6] | 0x20;
            }
            this.updShiftKeysPressed();
        }
        if (n == 241) {
            this.keyboardMatrix[6] = 1;
        }
        return bl2;
    }

    private void updShiftKeysPressed() {
        this.setShiftKeysPressed((this.keyboardMatrix[6] & 0x20) != 0 || (this.keyboardMatrix[7] & 0x40) != 0);
    }
}

