/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.llc1;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.List;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.EmuSys;
import jkcemu.emusys.LLC1;

public class LLC1KeyboardFld
extends AbstractKeyboardFld<LLC1> {
    private static final int MARGIN = 10;
    private static final int FONT_SIZE = 18;
    private static final int KEY_SIZE = 50;
    private Font fontBtn = new Font("SansSerif", 0, 18);
    private int[] kbMatrix = new int[4];
    private int curIdx = 0;
    private int curX = 10;
    private int curY = 10;

    public LLC1KeyboardFld(LLC1 lLC1) {
        super(lLC1, 22, true);
        this.addKey("C", 0, 129);
        this.addKey("D", 1, 129);
        this.addKey("E", 2, 129);
        this.addKey("F", 3, 129);
        this.curX = 10;
        this.curY += 50;
        this.addKey("8", 0, 4);
        this.addKey("9", 1, 4);
        this.addKey("A", 2, 4);
        this.addKey("B", 3, 4);
        this.curX += 25;
        this.addKey("EIN", 1, 130, "M");
        this.addKey("REG", 0, 130, "R");
        this.curX = 10;
        this.curY += 50;
        this.addKey("4", 0, 2);
        this.addKey("5", 1, 2);
        this.addKey("6", 2, 2);
        this.addKey("7", 3, 2);
        this.curX += 25;
        this.addKey("HP", 2, 132, "H");
        this.addKey("ES", 0, 132, "S");
        this.curX = 10;
        this.curY += 50;
        this.addKey("0", 0, 1);
        this.addKey("1", 1, 1);
        this.addKey("2", 2, 1);
        this.addKey("3", 3, 1);
        this.curX += 25;
        this.addKey("DL", 1, 132, "G oder J");
        this.addKey("ST", 2, 130, "X oder Enter");
        int n = this.curY + 50 + 10;
        this.setPreferredSize(new Dimension(345, 220));
    }

    @Override
    public boolean accepts(EmuSys emuSys) {
        return emuSys instanceof LLC1;
    }

    @Override
    public String getKeyboardName() {
        return "LLC1 Hexadezimaltastatur";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void keySelectionChanged() {
        Arrays.fill(this.kbMatrix, 0);
        List list = this.selectedKeys;
        synchronized (list) {
            for (AbstractKeyboardFld.KeyData keyData : this.selectedKeys) {
                if (keyData.col < 0 || keyData.col >= this.kbMatrix.length) continue;
                int n = keyData.col;
                this.kbMatrix[n] = this.kbMatrix[n] | keyData.value;
            }
        }
        ((LLC1)this.emuSys).updKeyboardMatrix(this.kbMatrix);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setFont(this.fontBtn);
        graphics.setPaintMode();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (AbstractKeyboardFld.KeyData keyData : this.keys) {
            FontMetrics fontMetrics;
            boolean bl = this.isKeySelected(keyData);
            if (bl) {
                graphics.setColor(Color.gray);
                graphics.fillRect(keyData.x + 1, keyData.y + 1, keyData.w - 1, keyData.h - 1);
            }
            graphics.setColor(Color.lightGray);
            graphics.draw3DRect(keyData.x + 1, keyData.y + 1, keyData.w - 1, keyData.h - 1, !bl);
            if (keyData.text1 == null || (fontMetrics = graphics.getFontMetrics()) == null) continue;
            graphics.setColor(Color.black);
            graphics.drawString(keyData.text1, keyData.x + (keyData.w - fontMetrics.stringWidth(keyData.text1)) / 2 + 1, keyData.y + 18 + (keyData.h - 18) / 2 - 1);
        }
    }

    @Override
    public void setEmuSys(EmuSys emuSys) {
        if (!(emuSys instanceof LLC1)) {
            throw new IllegalArgumentException("EmuSys != LLC1");
        }
        this.emuSys = (LLC1)emuSys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updKeySelection(int[] nArray) {
        boolean bl = false;
        List list = this.selectedKeys;
        synchronized (list) {
            bl = !this.selectedKeys.isEmpty();
            this.selectedKeys.clear();
            if (nArray != null) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == 0) continue;
                    for (AbstractKeyboardFld.KeyData keyData : this.keys) {
                        if (keyData.col != i || keyData.value != nArray[i]) continue;
                        bl = true;
                        keyData.locked = false;
                        this.selectedKeys.add(keyData);
                    }
                }
            }
        }
        if (bl) {
            this.repaint();
        }
    }

    private void addKey(String string, int n, int n2, String string2) {
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 50, 50, string, null, null, null, null, n, n2, false, string2);
        this.curX += 50;
    }

    private void addKey(String string, int n, int n2) {
        this.addKey(string, n, n2, null);
    }
}

