/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.lc80;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.Properties;
import jkcemu.base.AbstractScreenDevice;
import jkcemu.base.AbstractScreenFrm;
import jkcemu.base.CharRaster;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.emusys.LC80;
import jkcemu.text.TextUtil;

public class TVTerminal
extends AbstractScreenDevice
implements KeyListener {
    private static final int ROW_COUNT = 25;
    private static final int COL_COUNT = 40;
    private static final String START_MSG = "TV Terminal      (c)SP/RW 2007/2016 V1.2RS232 8,N,1 9600 Bd\r\n";
    private static byte[] romFont = null;
    private LC80 lc80;
    private boolean ignoreKeyChar;
    private volatile CharacterIterator pasteIter;
    private int cursorX;
    private int cursorY;
    private int screenByteBuf;
    private boolean screenSimpleNewLine;
    private byte[][] screenRows;

    public TVTerminal(LC80 lC80, Properties properties) {
        super(properties);
        this.lc80 = lC80;
        this.ignoreKeyChar = false;
        this.pasteIter = null;
        this.cursorX = 0;
        this.cursorY = 0;
        this.screenByteBuf = 0;
        this.screenSimpleNewLine = false;
        this.screenRows = new byte[25][];
        for (int i = 0; i < this.screenRows.length; ++i) {
            this.screenRows[i] = new byte[40];
            Arrays.fill(this.screenRows[i], (byte)32);
        }
        if (romFont == null) {
            romFont = this.readResource("/rom/lc80/tvterm_font.bin");
        }
    }

    public void keyCharQueueEmpty() {
        CharacterIterator characterIterator = this.pasteIter;
        if (characterIterator != null) {
            char c = characterIterator.current();
            characterIterator.next();
            if (c == '\uffff') {
                this.pasteIter = null;
                AbstractScreenFrm abstractScreenFrm = this.getScreenFrm();
                if (abstractScreenFrm != null) {
                    abstractScreenFrm.firePastingTextFinished();
                }
            } else {
                if (c == '\n') {
                    c = '\r';
                }
                this.lc80.putToSIOChannelB(TVTerminal.toLC80exCode(c));
            }
        }
    }

    public void reset() {
        this.pasteIter = null;
        this.screenByteBuf = 0;
        this.clearScreen();
        int n = START_MSG.length();
        for (int i = 0; i < n; ++i) {
            this.write(START_MSG.charAt(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(int n) {
        if (this.screenByteBuf == 19) {
            if (n < 0) return;
            if (n >= 40) return;
            this.cursorX = n;
            this.screenByteBuf = 0;
            return;
        }
        if (this.screenByteBuf == 20) {
            if (n < 0) return;
            if (n >= 25) return;
            this.cursorY = n;
            this.screenByteBuf = 0;
            return;
        }
        switch (n) {
            case 1: {
                this.cursorX = 0;
                this.cursorY = 0;
                return;
            }
            case 8: {
                this.cursorLeft();
                return;
            }
            case 9: {
                this.cursorRight();
                return;
            }
            case 10: {
                if (this.screenSimpleNewLine) {
                    this.newLine();
                    return;
                }
                if (this.cursorY < 24) {
                    ++this.cursorY;
                    return;
                }
                this.scrollScreen();
                return;
            }
            case 12: {
                this.clearScreen();
                return;
            }
            case 13: {
                if (this.screenSimpleNewLine) {
                    this.newLine();
                    return;
                }
                this.cursorX = 0;
                return;
            }
            case 15: {
                int n2 = this.cursorX + 8;
                int n3 = n2 / 8;
                this.cursorX = n3 * 8 + n2 % 8;
                return;
            }
            case 17: {
                this.screenSimpleNewLine = true;
                return;
            }
            case 18: {
                this.screenSimpleNewLine = false;
                return;
            }
            case 19: 
            case 20: {
                this.screenByteBuf = n;
                return;
            }
            case 127: {
                if (!this.cursorLeft()) return;
                boolean bl = false;
                byte[][] byArray = this.screenRows;
                synchronized (this.screenRows) {
                    if (this.cursorY >= 0 && this.cursorY < this.screenRows.length) {
                        byte[] byArray2 = this.screenRows[this.cursorY];
                        if (this.cursorX >= 0 && this.cursorX < byArray2.length) {
                            byArray2[this.cursorX] = 32;
                            bl = true;
                        }
                    }
                    // ** MonitorExit[var3_6] (shouldn't be in output)
                    if (!bl) return;
                    this.setScreenDirty();
                    return;
                }
            }
        }
        boolean bl = false;
        byte[][] byArray = this.screenRows;
        synchronized (this.screenRows) {
            if (this.cursorY >= 0 && this.cursorY < this.screenRows.length) {
                byte[] byArray3 = this.screenRows[this.cursorY];
                if (this.cursorX >= 0 && this.cursorX < byArray3.length) {
                    byArray3[this.cursorX] = (byte)n;
                    bl = true;
                }
            }
            this.cursorRight();
            // ** MonitorExit[var3_7] (shouldn't be in output)
            if (!bl) return;
            this.setScreenDirty();
            return;
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (!keyEvent.isAltDown()) {
            int n = 0;
            this.ignoreKeyChar = false;
            switch (keyEvent.getKeyCode()) {
                case 112: {
                    n = 241;
                    break;
                }
                case 113: {
                    n = 242;
                    break;
                }
                case 114: {
                    n = 243;
                    break;
                }
                case 115: {
                    n = 244;
                    break;
                }
                case 116: {
                    n = 245;
                    break;
                }
                case 117: {
                    n = 246;
                    break;
                }
                case 118: {
                    n = 247;
                    break;
                }
                case 119: {
                    n = 248;
                    break;
                }
                case 120: {
                    n = 249;
                    break;
                }
                case 121: {
                    n = 250;
                    break;
                }
                case 122: {
                    n = 251;
                    break;
                }
                case 123: {
                    n = 252;
                    break;
                }
                case 40: {
                    n = 10;
                    break;
                }
                case 38: {
                    n = 11;
                    break;
                }
                case 37: {
                    n = 8;
                    break;
                }
                case 39: {
                    n = 9;
                    break;
                }
                case 10: {
                    n = 13;
                    break;
                }
                case 32: {
                    n = 32;
                    break;
                }
                case 8: {
                    n = 127;
                    break;
                }
                case 74: {
                    if (!keyEvent.isControlDown()) break;
                    n = 10;
                    break;
                }
                case 77: {
                    if (!keyEvent.isControlDown()) break;
                    n = 13;
                }
            }
            if (n > 0) {
                this.lc80.putToSIOChannelB(n);
                this.ignoreKeyChar = true;
                keyEvent.consume();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (!keyEvent.isAltDown() && keyEvent.getKeyCode() != 121) {
            this.ignoreKeyChar = false;
            keyEvent.consume();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (!this.ignoreKeyChar && !keyEvent.isAltDown()) {
            char c = keyEvent.getKeyChar();
            c = c > '\u0000' && c < '\u007f' ? TVTerminal.toLC80exCode(TextUtil.toReverseCase(c)) : (char)'\u0000';
            if (c > '\u0000') {
                this.lc80.putToSIOChannelB(c);
            }
            this.ignoreKeyChar = false;
            keyEvent.consume();
        }
    }

    @Override
    public void cancelPastingText() {
        this.pasteIter = null;
        AbstractScreenFrm abstractScreenFrm = this.getScreenFrm();
        if (abstractScreenFrm != null) {
            abstractScreenFrm.firePastingTextFinished();
        }
    }

    @Override
    public boolean canExtractScreenText() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getColorIndex(int n, int n2) {
        int n3 = 0;
        int n4 = n2 % 9;
        if (n4 < 0) return n3;
        if (n4 >= 9) return n3;
        byte[] byArray = romFont;
        if (byArray == null) return n3;
        int n5 = n / 8;
        int n6 = n2 / 9;
        byte[][] byArray2 = this.screenRows;
        synchronized (this.screenRows) {
            if (n6 < 0) return n3;
            if (n6 >= this.screenRows.length) return n3;
            byte[] byArray3 = this.screenRows[n6];
            if (byArray3 == null) return n3;
            if (n5 < 0) return n3;
            if (n5 >= byArray3.length) return n3;
            int n7 = byArray3[n5] & 0xFF;
            if (n4 == 8 && n7 >= 128 && n7 <= 191) {
                n4 = 7;
            }
            if (n4 >= 8) return n3;
            int n8 = 0;
            int n9 = n7 * 8 + n4;
            if (n9 >= 0 && n9 < byArray.length) {
                n8 = byArray[n9] & 0xFF;
            }
            if (n8 == 0) return n3;
            int n10 = 128;
            int n11 = n % 8;
            if (n11 > 0) {
                n10 >>= n11;
            }
            if ((n8 & n10) == 0) return n3;
            return 1;
        }
    }

    @Override
    public CharRaster getCurScreenCharRaster() {
        return new CharRaster(40, 25, 9, 9, 8, 0);
    }

    @Override
    public EmuThread getEmuThread() {
        return this.lc80.getEmuThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getScreenChar(CharRaster charRaster, int n, int n2) {
        int n3 = -1;
        byte[][] byArray = this.screenRows;
        synchronized (this.screenRows) {
            byte[] byArray2;
            if (n2 >= 0 && n2 < this.screenRows.length && (byArray2 = this.screenRows[n2]) != null && n >= 0 && n < byArray2.length) {
                int n4 = byArray2[n] & 0xFF;
                if (n4 >= 32 && n4 < 127) {
                    n3 = n4;
                } else {
                    switch (n4) {
                        case 192: {
                            n3 = 196;
                            break;
                        }
                        case 193: {
                            n3 = 214;
                            break;
                        }
                        case 194: {
                            n3 = 220;
                            break;
                        }
                        case 195: {
                            n3 = 228;
                            break;
                        }
                        case 196: {
                            n3 = 246;
                            break;
                        }
                        case 197: {
                            n3 = 252;
                            break;
                        }
                        case 198: {
                            n3 = 223;
                            break;
                        }
                        case 199: {
                            n3 = 167;
                            break;
                        }
                        default: {
                            n3 = 32;
                        }
                    }
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return n3;
        }
    }

    @Override
    public int getScreenHeight() {
        return 225;
    }

    @Override
    public int getScreenWidth() {
        return 320;
    }

    @Override
    public String getTitle() {
        return "JKCEMU: TV Terminal 1.2";
    }

    @Override
    public void startPastingText(String string) {
        this.pasteIter = new StringCharacterIterator(string);
        this.keyCharQueueEmpty();
    }

    @Override
    public boolean supportsCopyToClipboard() {
        return true;
    }

    @Override
    public boolean supportsPasteFromClipboard() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearScreen() {
        byte[][] byArray = this.screenRows;
        synchronized (this.screenRows) {
            for (int i = 0; i < this.screenRows.length; ++i) {
                Arrays.fill(this.screenRows[i], (byte)32);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.cursorX = 0;
            this.cursorY = 0;
            this.setScreenDirty();
            return;
        }
    }

    private boolean cursorLeft() {
        boolean bl = false;
        if (this.cursorX > 0) {
            --this.cursorX;
            bl = true;
        } else {
            this.cursorX = 39;
            if (this.cursorY > 0) {
                --this.cursorY;
                bl = true;
            }
        }
        return bl;
    }

    private void cursorRight() {
        if (this.cursorX < 39) {
            ++this.cursorX;
        } else {
            this.newLine();
        }
    }

    private void newLine() {
        this.cursorX = 0;
        if (this.cursorY < 24) {
            ++this.cursorY;
        } else {
            this.scrollScreen();
        }
    }

    private byte[] readResource(String string) {
        return EmuUtil.readResource(this.lc80.getScreenFrm(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrollScreen() {
        byte[][] byArray = this.screenRows;
        synchronized (this.screenRows) {
            byte[] byArray2 = this.screenRows[0];
            for (int i = 1; i < this.screenRows.length; ++i) {
                this.screenRows[i - 1] = this.screenRows[i];
            }
            Arrays.fill(byArray2, (byte)32);
            this.screenRows[this.screenRows.length - 1] = byArray2;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void setScreenDirty() {
        AbstractScreenFrm abstractScreenFrm = this.getScreenFrm();
        if (abstractScreenFrm != null) {
            abstractScreenFrm.setScreenDirty(true);
        }
    }

    private static char toLC80exCode(char c) {
        switch (c) {
            case '\u00c4': {
                c = (char)192;
                break;
            }
            case '\u00d6': {
                c = (char)193;
                break;
            }
            case '\u00dc': {
                c = (char)194;
                break;
            }
            case '\u00e4': {
                c = (char)195;
                break;
            }
            case '\u00f6': {
                c = (char)196;
                break;
            }
            case '\u00fc': {
                c = (char)197;
                break;
            }
            case '\u00df': {
                c = (char)198;
                break;
            }
            case '\u00a7': {
                c = (char)199;
            }
        }
        return c;
    }
}

