/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.kc85;

import java.awt.Component;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.emusys.kc85.AbstractKC85Module;

public class M040
extends AbstractKC85Module {
    private int typeByte;
    private int begAddr;
    private int begAddrMask;
    private int romLen;
    private byte[] rom;
    private String fileName;

    public M040(int n, EmuThread emuThread, int n2, Component component, String string) {
        super(n);
        this.typeByte = n2;
        this.fileName = string;
        this.begAddr = 0;
        if (n2 == 248) {
            this.begAddrMask = 49152;
            this.romLen = 16384;
        } else {
            this.begAddrMask = 57344;
            this.romLen = 8192;
        }
        this.reload(component);
    }

    @Override
    public void appendEtcInfoHTMLTo(StringBuilder stringBuilder) {
        stringBuilder.append("ROM-Gr\u00f6\u00dfe: ");
        stringBuilder.append(this.romLen / 1024);
        stringBuilder.append(" KByte");
    }

    @Override
    public int getBegAddr() {
        return this.begAddr;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getModuleName() {
        return "M040";
    }

    @Override
    public int getTypeByte() {
        return this.typeByte;
    }

    @Override
    public int readMemByte(int n) {
        int n2;
        int n3 = -1;
        if (this.enabled && n >= this.begAddr && n < this.begAddr + this.romLen && this.rom != null && (n2 = n - this.begAddr) < this.rom.length) {
            n3 = this.rom[n2] & 0xFF;
        }
        return n3;
    }

    @Override
    public void reload(Component component) {
        this.rom = EmuUtil.readFile(component, this.fileName, true, 16384, "M040 ROM-Datei");
        if (this.typeByte == 1 && this.rom != null) {
            if (this.rom.length > 8192) {
                this.begAddrMask = 49152;
                this.romLen = 16384;
            } else {
                this.begAddrMask = 57344;
                this.romLen = 8192;
            }
        }
    }

    @Override
    public void setStatus(int n) {
        super.setStatus(n);
        this.begAddr = n << 8 & this.begAddrMask;
    }
}

