/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.kc85;

import jkcemu.base.EmuThread;
import jkcemu.emusys.kc85.KC85JoystickModule;
import jkcemu.print.PrintMngr;
import z80emu.Z80CPU;
import z80emu.Z80TStatesListener;

public class M021
extends KC85JoystickModule
implements Z80TStatesListener {
    private EmuThread emuThread;
    private boolean cenStrobe;
    private volatile int cenBusyTStateCounter;

    public M021(int n, EmuThread emuThread) {
        super(n);
        this.emuThread = emuThread;
        this.cenStrobe = false;
        this.cenBusyTStateCounter = 0;
        this.pio.putInValuePortA(0, 64);
    }

    @Override
    public synchronized void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        if (this.cenBusyTStateCounter > 0) {
            this.cenBusyTStateCounter -= n;
            if (this.cenBusyTStateCounter <= 0) {
                this.pio.putInValuePortA(0, 64);
            }
        }
    }

    @Override
    public String getModuleName() {
        return "M021";
    }

    @Override
    public boolean supportsPrinter() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeIOByte(int n, int n2, int n3) {
        boolean bl = false;
        if ((n &= 0xFF) >= 144 && n < 152) {
            switch (n & 0xFF) {
                case 144: {
                    boolean bl2;
                    this.pio.writeDataA(n2);
                    PrintMngr printMngr = this.emuThread.getPrintMngr();
                    if (printMngr == null) break;
                    boolean bl3 = bl2 = (this.pio.fetchOutValuePortA(false) & 0x80) == 0;
                    if (bl2 == this.cenStrobe) break;
                    this.cenStrobe = bl2;
                    if (!bl2) break;
                    printMngr.putByte(this.pio.fetchOutValuePortB(false));
                    this.pio.putInValuePortA(64, 64);
                    M021 m021 = this;
                    synchronized (m021) {
                        this.cenBusyTStateCounter = this.emuThread.getZ80CPU().getMaxSpeedKHz() / 20;
                        if (this.cenBusyTStateCounter < 1) {
                            this.cenBusyTStateCounter = 1;
                        }
                        break;
                    }
                }
                case 145: {
                    this.pio.writeDataB(n2);
                    break;
                }
                case 146: {
                    this.pio.writeControlA(n2);
                    this.pio.putInValuePortA(this.cenBusyTStateCounter > 0 ? 64 : 0, 64);
                    break;
                }
                case 147: {
                    this.pio.writeControlB(n2);
                }
            }
            bl = true;
        }
        return bl;
    }
}

