/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.kc85;

import java.util.Properties;
import jkcemu.Main;
import jkcemu.base.ScreenFrm;
import jkcemu.disk.FloppyDiskDrive;
import jkcemu.emusys.kc85.AbstractKC85Module;
import jkcemu.emusys.kc85.D004ProcSys;
import z80emu.Z80CPU;
import z80emu.Z80Memory;

public class D004
extends AbstractKC85Module {
    private byte[] rom;
    private int romAddr;
    private boolean connected;
    private boolean cpuEnableValue;
    private boolean cpuStopValue;
    private boolean cpuResetValue;
    private boolean cpuNMIValue;
    private D004ProcSys procSys;
    private Thread thread;

    public D004(ScreenFrm screenFrm, Properties properties, String string, byte[] byArray) {
        super(252);
        this.rom = byArray;
        this.romAddr = 49152;
        this.connected = false;
        this.cpuEnableValue = false;
        this.cpuStopValue = false;
        this.cpuResetValue = false;
        this.cpuNMIValue = false;
        this.procSys = new D004ProcSys(screenFrm, properties, string);
        this.thread = null;
    }

    public void applySettings(Properties properties) {
        this.procSys.applySettings(properties);
    }

    public boolean canApplySettings(Properties properties) {
        return this.procSys.canApplySettings(properties);
    }

    public Z80CPU getZ80CPU() {
        return this.procSys.getZ80CPU();
    }

    public Z80Memory getZ80Memory() {
        return this.procSys;
    }

    public synchronized void fireStop() {
        if (this.thread != null) {
            this.procSys.fireStop();
            this.thread = null;
        }
    }

    public int getSupportedFloppyDiskDriveCount() {
        return this.procSys.getSupportedFloppyDiskDriveCount();
    }

    public boolean isRunning() {
        return this.thread != null;
    }

    public void loadIntoRAM(byte[] byArray, int n, int n2) {
        this.procSys.loadIntoRAM(byArray, n, n2);
    }

    public void setDrive(int n, FloppyDiskDrive floppyDiskDrive) {
        this.procSys.setDrive(n, floppyDiskDrive);
    }

    @Override
    public void appendEtcInfoHTMLTo(StringBuilder stringBuilder) {
        stringBuilder.append("Transfer-RAM ");
        stringBuilder.append(this.connected ? "verbunden" : "getrennt");
    }

    @Override
    public int getBegAddr() {
        return this.romAddr;
    }

    @Override
    public void clearRAM() {
        this.procSys.clearRAM();
    }

    @Override
    public void die() {
        this.procSys.die();
    }

    @Override
    public String getModuleName() {
        return "D004";
    }

    @Override
    public int getTypeByte() {
        return 167;
    }

    @Override
    public int readMemByte(int n) {
        int n2;
        int n3 = -1;
        if (this.enabled && this.rom != null && (n2 = n - this.romAddr) >= 0 && n2 < this.rom.length) {
            n3 = this.rom[n2] & 0xFF;
        }
        return n3;
    }

    @Override
    public int readIOByte(int n, int n2) {
        int n3;
        int n4 = -1;
        if (this.connected && (n3 = n & 0xFF) >= 240 && n3 <= 243) {
            n4 = this.procSys.getMemByte(0xFC00 | n3 << 8 | n >> 8 & 0xFF, false);
        }
        return n4;
    }

    @Override
    public void setStatus(int n) {
        super.setStatus(n);
        this.connected = (n & 4) != 0;
        this.romAddr = (n & 0x20) != 0 ? 57344 : 49152;
    }

    @Override
    public boolean writeIOByte(int n, int n2, int n3) {
        boolean bl = false;
        int n4 = n & 0xFF;
        if (n4 >= 240 && n4 <= 244) {
            if (this.connected) {
                if (n4 >= 240 && n4 <= 243) {
                    bl = this.procSys.setMemByte(0xFC00 | n4 << 8 | n >> 8 & 0xFF, n2);
                } else if (n4 == 244) {
                    boolean bl2;
                    boolean bl3 = bl2 = (n2 & 1) != 0;
                    if (bl2 != this.cpuEnableValue) {
                        this.cpuEnableValue = bl2;
                        if (bl2) {
                            this.enableCPU();
                        }
                    }
                    boolean bl4 = bl2 = (n2 & 2) != 0;
                    if (bl2 != this.cpuStopValue) {
                        this.cpuStopValue = bl2;
                        if (bl2) {
                            this.fireStop();
                        }
                    }
                    boolean bl5 = bl2 = (n2 & 4) != 0;
                    if (bl2 != this.cpuResetValue) {
                        this.cpuResetValue = bl2;
                        if (bl2 && this.thread != null) {
                            this.procSys.fireReset();
                        }
                    }
                    boolean bl6 = bl2 = (n2 & 8) != 0;
                    if (bl2 != this.cpuNMIValue) {
                        this.cpuNMIValue = bl2;
                        if (bl2 && this.thread != null) {
                            this.procSys.fireNMI();
                        }
                    }
                }
            }
            bl = true;
        }
        return bl;
    }

    private synchronized void enableCPU() {
        if (this.thread == null) {
            Thread thread;
            this.thread = thread = new Thread(Main.getThreadGroup(), this.procSys, "D004");
            thread.start();
        }
    }
}

