/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.etc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.EmuSys;
import jkcemu.emusys.SC2;

public class SC2KeyboardFld
extends AbstractKeyboardFld<SC2> {
    private static final int MARGIN = 5;
    private static final int LED_SIZE = 12;
    private static final int KEY_SIZE = 60;
    private static final int KEY_Y0 = 50;
    private Color colorBg;
    private Color colorLEDon;
    private Color colorLEDoff;
    private Color colorTextDark;
    private Color colorTextLight;
    private Font fontTitle;
    private Font fontLabel;
    private Font fontKey;
    private Image imgLedFld;
    private Image imgKeyDark;
    private Image imgKeyLight;
    private Image imgKeySelected;
    private AbstractKeyboardFld.KeyData resetKey;
    private int[] kbMatrix = new int[4];
    private int curIdx = 0;
    private int curX = 35;
    private int curY = 50;

    public SC2KeyboardFld(SC2 sC2) {
        super(sC2, 15, true);
        this.colorBg = new Color(20, 20, 20);
        this.colorLEDon = Color.red;
        this.colorLEDoff = new Color(80, 50, 50);
        this.colorTextDark = new Color(20, 20, 20);
        this.colorTextLight = new Color(180, 180, 180);
        this.fontTitle = new Font("SansSerif", 1, 16);
        this.fontLabel = new Font("SansSerif", 1, 12);
        this.fontKey = new Font("SansSerif", 1, 16);
        this.imgLedFld = this.getImage("/images/keyboard/sc2/led_field.png");
        this.imgKeyDark = this.getImage("/images/keyboard/sc2/key_dark.png");
        this.imgKeyLight = this.getImage("/images/keyboard/sc2/key_light.png");
        this.imgKeySelected = this.getImage("/images/keyboard/sc2/key_selected.png");
        this.resetKey = this.addKey(this.imgKeyDark, "R", null, -1, -1, "Esc");
        this.addKey(this.imgKeyDark, "K", null, 3, 16, "K oder +");
        this.addKey(this.imgKeyDark, "W", null, 3, 32, "W");
        this.curX = 5;
        this.curY += 60;
        this.addKey(this.imgKeyDark, "P", null, 3, 128, "P");
        this.addKey(this.imgKeyDark, "T", null, 0, 32, "T");
        this.addKey(this.imgKeyDark, "L", null, 0, 64, "L oder Backspace");
        this.addKey(this.imgKeyDark, "Q", null, 0, 128, "Q oder Enter");
        this.curX = 5;
        this.curY += 60;
        this.addKey(this.imgKeyLight, "A", "1", 1, 16, "A oder 1");
        this.addKey(this.imgKeyLight, "B", "2", 1, 32, "B oder 2");
        this.addKey(this.imgKeyLight, "C", "3", 1, 64, "C oder 3");
        this.addKey(this.imgKeyLight, "D", "4", 1, 128, "D oder 4");
        this.curX = 5;
        this.curY += 60;
        this.addKey(this.imgKeyLight, "E", "5", 2, 16, "E oder 5");
        this.addKey(this.imgKeyLight, "F", "6", 2, 32, "F oder 6");
        this.addKey(this.imgKeyLight, "G", "7", 2, 64, "G oder 7");
        this.addKey(this.imgKeyLight, "H", "8", 2, 128, "E oder 8");
        this.setPreferredSize(new Dimension(250, 295));
    }

    @Override
    public boolean accepts(EmuSys emuSys) {
        return emuSys instanceof SC2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void keySelectionChanged() {
        Arrays.fill(this.kbMatrix, 0);
        List list = this.selectedKeys;
        synchronized (list) {
            for (AbstractKeyboardFld.KeyData keyData : this.selectedKeys) {
                if (keyData.col < 0 || keyData.col >= this.kbMatrix.length) continue;
                int n = keyData.col;
                this.kbMatrix[n] = this.kbMatrix[n] | keyData.value;
            }
        }
        ((SC2)this.emuSys).updKeyboardMatrix(this.kbMatrix);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this) {
            if (SC2KeyboardFld.hits(this.resetKey, mouseEvent)) {
                this.fireWarmResetAfterDelay();
            }
            super.mousePressed(mouseEvent);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        String string;
        graphics.setColor(this.colorBg);
        graphics.fillRect(0, 0, this.getWidth(), 45);
        graphics.setColor(Color.black);
        graphics.fillRect(0, 45, this.getWidth(), this.getHeight() - 50 + 5);
        if (this.imgLedFld != null) {
            graphics.drawImage(this.imgLedFld, 5, 50, this);
            graphics.drawImage(this.imgLedFld, 215, 50, this);
        }
        graphics.setFont(this.fontTitle);
        graphics.setColor(this.colorTextLight);
        int n = 5 + this.fontTitle.getSize();
        graphics.drawString("SCHACHCOMPUTER", 5, n);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (fontMetrics != null) {
            string = "SC2";
            graphics.drawString(string, this.getWidth() - 5 - fontMetrics.stringWidth(string), n);
        }
        graphics.setFont(this.fontLabel);
        n += this.fontLabel.getSize();
        graphics.drawString("SCHACH", 5, n += 5);
        fontMetrics = graphics.getFontMetrics();
        if (fontMetrics != null) {
            string = "MATT";
            graphics.drawString(string, this.getWidth() - 5 - fontMetrics.stringWidth(string), n);
        }
        graphics.setColor(((SC2)this.emuSys).getLEDChessValue() ? this.colorLEDon : this.colorLEDoff);
        graphics.fillOval(14, 74, 12, 12);
        graphics.setColor(((SC2)this.emuSys).getLEDMateValue() ? this.colorLEDon : this.colorLEDoff);
        graphics.fillOval(this.getWidth() - 5 - 30 + 9, 74, 12, 12);
        graphics.setFont(this.fontKey);
        fontMetrics = graphics.getFontMetrics();
        int n2 = 24;
        for (AbstractKeyboardFld.KeyData keyData : this.keys) {
            Image image = null;
            image = this.isKeySelected(keyData) ? this.imgKeySelected : keyData.image;
            if (image != null) {
                graphics.drawImage(image, keyData.x, keyData.y, this);
            }
            if (keyData.text1 == null) continue;
            if (fontMetrics != null) {
                n2 = (60 - fontMetrics.stringWidth(keyData.text1)) / 2;
            }
            if (keyData.text2 != null) {
                graphics.setColor(this.colorTextDark);
                graphics.drawString(keyData.text1, keyData.x + n2, keyData.y + 30 - 2);
                if (fontMetrics != null) {
                    n2 = (60 - fontMetrics.stringWidth(keyData.text2)) / 2;
                }
                graphics.drawString(keyData.text2, keyData.x + 30 - 5, keyData.y + 30 + 15);
                continue;
            }
            graphics.setColor(this.colorTextLight);
            graphics.drawString(keyData.text1, keyData.x + 30 - 6, keyData.y + 30 + 6);
        }
    }

    @Override
    public void setEmuSys(EmuSys emuSys) {
        if (!(emuSys instanceof SC2)) {
            throw new IllegalArgumentException("EmuSys != SC2");
        }
        this.emuSys = (SC2)emuSys;
    }

    private AbstractKeyboardFld.KeyData addKey(Image image, String string, String string2, int n, int n2, String string3) {
        AbstractKeyboardFld.KeyData keyData = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 60, 60, string, string2, null, null, image, n, n2, false, string3);
        this.keys[this.curIdx++] = keyData;
        this.curX += 60;
        return keyData;
    }
}

