/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.customsys;

import java.awt.Component;
import jkcemu.base.EmuUtil;
import jkcemu.text.TextUtil;

public class CustomSysROM {
    private int begAddr;
    private int size;
    private String fileName;
    private int switchIOAddr;
    private int switchIOMask;
    private int switchIOValue;
    private boolean bootROM;
    private boolean enableOnReset;
    private boolean enabled;
    private String addrText;
    private String optionText;
    private byte[] data;

    public CustomSysROM(int n, int n2, String string, int n3, int n4, int n5, boolean bl, boolean bl2) {
        this.begAddr = n;
        this.size = n2;
        this.fileName = string;
        this.switchIOAddr = n3;
        this.switchIOMask = n4 & 0xFF;
        this.switchIOValue = n5 & this.switchIOMask;
        this.enableOnReset = bl;
        this.bootROM = bl2;
        this.enabled = true;
        this.data = null;
        this.addrText = String.format("%04Xh-%04Xh", this.begAddr, this.begAddr + this.size - 1);
        StringBuilder stringBuilder = new StringBuilder();
        if (this.switchIOAddr >= 0) {
            stringBuilder.append(this.switchIOMask != 0 ? (char)'S' : 'A');
        }
        if (bl2) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append('B');
        }
        this.optionText = stringBuilder.toString();
        this.reset();
    }

    public boolean declaresSameROM(CustomSysROM customSysROM) {
        boolean bl = false;
        if (this.begAddr == customSysROM.begAddr && this.size == customSysROM.size && TextUtil.equals(this.fileName, customSysROM.fileName) && this.bootROM == customSysROM.bootROM) {
            if (this.switchIOAddr >= 0 || customSysROM.switchIOAddr >= 0) {
                if (this.switchIOAddr == customSysROM.switchIOAddr && this.switchIOMask == customSysROM.switchIOMask) {
                    if (this.switchIOMask != 0) {
                        if (this.switchIOValue == customSysROM.switchIOValue) {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public String getAddressText() {
        return this.addrText;
    }

    public int getBegAddr() {
        return this.begAddr;
    }

    public boolean getEnableOnReset() {
        return this.enableOnReset;
    }

    public String getFileName() {
        return this.fileName;
    }

    public synchronized int getMemByte(int n) {
        int n2 = -1;
        if (this.enabled && n >= this.begAddr && n < this.begAddr + this.size) {
            int n3;
            n2 = 255;
            if (this.data != null && (n3 = n - this.begAddr) >= 0 && n3 < this.data.length) {
                n2 = this.data[n3] & 0xFF;
            }
        }
        return n2;
    }

    public String getOptionText() {
        return this.optionText;
    }

    public int getSize() {
        return this.size;
    }

    public int getSwitchIOAddr() {
        return this.switchIOAddr;
    }

    public int getSwitchIOMask() {
        return this.switchIOMask;
    }

    public int getSwitchIOValue() {
        return this.switchIOValue;
    }

    public boolean isBootROM() {
        return this.bootROM;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isEnabledAfterReset() {
        return this.enableOnReset || this.switchIOMask == 0;
    }

    public synchronized void load(Component component) {
        this.data = EmuUtil.readFile(component, this.fileName, true, this.size, "ROM " + this.addrText);
    }

    public void reset() {
        this.enabled = this.switchIOAddr >= 0 ? (this.switchIOMask != 0 ? this.enableOnReset : true) : true;
    }

    public void writeIOByte(int n, int n2) {
        if (this.switchIOAddr >= 0 && n == this.switchIOAddr) {
            this.enabled = this.switchIOMask != 0 ? (n2 & this.switchIOMask) == this.switchIOValue : false;
        }
    }
}

