/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.a5105;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.Arrays;
import jkcemu.base.EmuThread;
import jkcemu.base.ScreenFrm;
import jkcemu.etc.GDC82720;

public class VIS
implements GDC82720.GDCListener,
GDC82720.VRAM {
    private static final int COLOR_COUNT = 16;
    private static final int DEFAULT_SCREEN_HEIGHT = 250;
    private static final int DEFAULT_SCREEN_WIDTH = 320;
    private GDC82720 gdc;
    private ScreenFrm screenFrm;
    private BufferedImage screenImage;
    private int screenWidth;
    private IndexColorModel colorModel;
    private Color[] colors;
    private int[] colorRGBs;
    private boolean colorMode;
    private boolean fixedScreenSize;
    private boolean fontGenVisAccess;
    private boolean fontGenEnabled;
    private boolean lightColors;
    private boolean w640;
    private int mode;
    private int colorReg0;
    private int colorReg1;
    private int colorReg2;
    private int colorReg3;
    private int colorReg4;
    private int fontBaseAddr;
    private int fontRowAddr;
    private byte[] fontBytes;
    private short[] vram;

    public VIS(ScreenFrm screenFrm, GDC82720 gDC82720) {
        this.screenFrm = screenFrm;
        this.gdc = gDC82720;
        this.screenWidth = 320;
        this.fontBytes = new byte[2048];
        this.vram = new short[65536];
        this.colorModel = null;
        this.colors = new Color[16];
        this.colorRGBs = new int[16];
        Arrays.fill(this.colors, Color.black);
        Arrays.fill(this.colorRGBs, 0);
        this.reset(EmuThread.ResetLevel.POWER_ON);
    }

    public boolean canExtractScreenText() {
        return this.fontGenEnabled && this.gdc.canExtractScreenText();
    }

    public static IndexColorModel createColorModel(float f) {
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = new byte[16];
        int n = Math.round(255.0f * f);
        int n2 = Math.round(180.0f * f);
        int n3 = Math.round(80.0f * f);
        for (int i = 0; i < 16; ++i) {
            if ((i & 8) != 0) {
                byArray[i] = (byte)((i & 4) != 0 ? n : n3);
                byArray2[i] = (byte)((i & 2) != 0 ? n : n3);
                byArray3[i] = (byte)((i & 1) != 0 ? n : n3);
                continue;
            }
            byArray[i] = (byte)((i & 4) != 0 ? n2 : 0);
            byArray2[i] = (byte)((i & 2) != 0 ? n2 : 0);
            byArray3[i] = (byte)((i & 1) != 0 ? n2 : 0);
        }
        return new IndexColorModel(4, 16, byArray, byArray2, byArray3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createColors(float f) {
        Color[] colorArray = this.colors;
        synchronized (this.colors) {
            this.screenImage = null;
            this.colorModel = VIS.createColorModel(f);
            this.colorModel.getRGBs(this.colorRGBs);
            for (int i = 0; i < 16; ++i) {
                this.colors[i] = new Color(this.colorRGBs[i]);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public int getBorderColorIndex() {
        return this.colorReg0;
    }

    public int getCharColCount() {
        return this.getScreenWidth() / this.getCharWidth();
    }

    public int getCharRowCount() {
        return this.fontGenEnabled ? this.gdc.getCharRowCount() : 0;
    }

    public int getCharTopLine() {
        int n = (250 - this.gdc.getDisplayLines()) / 2;
        if (n < 0) {
            n = 0;
        }
        int n2 = n + this.gdc.getCharTopLine();
        if (this.fixedScreenSize || this.screenFrm.isFullScreenMode()) {
            n2 *= 2;
        }
        return n2;
    }

    public int getCharWidth() {
        return 8 * this.getScreenWidth() / this.screenWidth;
    }

    public Color getColor(int n) {
        return n >= 0 && n < this.colors.length ? this.colors[n] : Color.black;
    }

    public int getColorCount() {
        return this.colors.length;
    }

    public int getScreenHeight() {
        return this.fixedScreenSize || this.screenFrm.isFullScreenMode() ? 500 : 250;
    }

    public int getScreenWidth() {
        int n = 320;
        if (this.fixedScreenSize || this.screenFrm.isFullScreenMode()) {
            n = 640;
        } else if (this.screenWidth > 320) {
            n = this.screenWidth;
        }
        return n;
    }

    public boolean isFixedScreenSize() {
        return this.fixedScreenSize;
    }

    public void paintScreen(Graphics graphics, int n, int n2, int n3) {
        BufferedImage bufferedImage = this.getScreenImage();
        if (bufferedImage != null) {
            int n4 = bufferedImage.getWidth();
            int n5 = bufferedImage.getHeight();
            int n6 = this.colorRGBs[this.colorReg0];
            int n7 = 0;
            int n8 = (250 - this.gdc.getDisplayLines()) / 2;
            if (n8 > 0) {
                if (this.fixedScreenSize || this.screenFrm.isFullScreenMode()) {
                    n8 *= 2;
                }
                n2 += n8 * n3;
            }
            for (int i = 0; i < n5; ++i) {
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16;
                int n17 = 0;
                int n18 = 0;
                if ((n16 = this.gdc.getDisplayValue(n18++, i)) < 0) {
                    for (n15 = 0; n15 < n4; ++n15) {
                        bufferedImage.setRGB(n15, i, n6);
                    }
                } else if (this.mode == 0 && (n16 & 0x40000) == 0) {
                    n7 = (n16 & 0x100000) != 0 ? 0 : ++n7;
                    while (n16 >= 0) {
                        n15 = 0;
                        n14 = this.getVRAMWord(n16 & 0x3FFFF);
                        if (this.fontGenEnabled) {
                            if (n7 < 8 && (n13 = n14 << 3 & 0x7F8 | n7) < this.fontBytes.length) {
                                n15 = this.fontBytes[n13] & 0xFF;
                            }
                        } else {
                            n15 = n14 & 0xFF;
                        }
                        if ((n16 & 0x80000) != 0) {
                            n15 = ~n15 & 0xFF;
                        }
                        n13 = n14 >> 13 & 7;
                        if (this.lightColors) {
                            n13 |= 8;
                        }
                        n11 = n12 = this.colorRGBs[n13];
                        if ((n14 & 0x1000) == 0 || (n16 & 0x200000) != 0) {
                            n11 = this.colorRGBs[n14 >> 8 & 0xF];
                        }
                        n10 = 1;
                        for (n9 = 0; n9 < 8; ++n9) {
                            bufferedImage.setRGB(n17++, i, (n15 & n10) != 0 ? n11 : n12);
                            n10 <<= 1;
                        }
                        if (n17 < n4) {
                            n16 = this.gdc.getDisplayValue(n18++, i);
                            continue;
                        }
                        break;
                    }
                } else if (this.mode == 0) {
                    while (n16 >= 0) {
                        n15 = this.getVRAMWord(n16 & 0x3FFFF);
                        n14 = 1;
                        n13 = 0;
                        for (n12 = 0; n12 < 16; ++n12) {
                            bufferedImage.setRGB(n17++, i, this.colorRGBs[(n15 & n14) != 0 ? this.colorReg2 : this.colorReg1]);
                            n14 <<= 1;
                        }
                        if (n17 < n4) {
                            n16 = this.gdc.getDisplayValue(n18++, i);
                            continue;
                        }
                        break;
                    }
                } else if (this.mode == 1) {
                    while (n16 >= 0) {
                        n15 = this.getVRAMWord(n16 & 0x3FFFF);
                        n14 = 1;
                        n13 = 256;
                        n12 = 0;
                        for (n11 = 0; n11 < 8; ++n11) {
                            n10 = 0;
                            if ((n15 & n14) != 0) {
                                n10 |= 1;
                            }
                            if ((n15 & n13) != 0) {
                                n10 |= 2;
                            }
                            switch (n10) {
                                case 0: {
                                    n12 = this.colorReg1;
                                    break;
                                }
                                case 1: {
                                    n12 = this.colorReg2;
                                    break;
                                }
                                case 2: {
                                    n12 = this.colorReg3;
                                    break;
                                }
                                case 3: {
                                    n12 = this.colorReg4;
                                }
                            }
                            bufferedImage.setRGB(n17++, i, this.colorRGBs[n12]);
                            n14 <<= 1;
                            n13 <<= 1;
                        }
                        if (n17 < n4) {
                            n16 = this.gdc.getDisplayValue(n18++, i);
                            continue;
                        }
                        break;
                    }
                } else if (this.mode == 2) {
                    while (n16 >= 0) {
                        n15 = this.getVRAMWord(n16 & 0x3FFFF);
                        n14 = 1;
                        n13 = 16;
                        n12 = 256;
                        n11 = 4096;
                        for (n10 = 0; n10 < 4; ++n10) {
                            n9 = 0;
                            if ((n15 & n14) != 0) {
                                n9 |= 1;
                            }
                            if ((n15 & n13) != 0) {
                                n9 |= 2;
                            }
                            if ((n15 & n12) != 0) {
                                n9 |= 4;
                            }
                            if ((n15 & n11) != 0) {
                                n9 |= 8;
                            }
                            bufferedImage.setRGB(n17++, i, this.colorRGBs[n9]);
                            n14 <<= 1;
                            n13 <<= 1;
                            n12 <<= 1;
                            n11 <<= 1;
                        }
                        if (n17 < n4) {
                            n16 = this.gdc.getDisplayValue(n18++, i);
                            continue;
                        }
                        break;
                    }
                }
                while (n17 < n4) {
                    bufferedImage.setRGB(n17++, i, n6);
                }
            }
            if (this.fixedScreenSize || this.screenFrm.isFullScreenMode()) {
                graphics.drawImage(bufferedImage, n, n2, 640 * n3, 2 * bufferedImage.getHeight() * n3, this.screenFrm);
            } else if (n3 > 1) {
                graphics.drawImage(bufferedImage, n, n2, bufferedImage.getWidth() * n3, bufferedImage.getHeight() * n3, this.screenFrm);
            } else {
                graphics.drawImage(bufferedImage, n, n2, this.screenFrm);
            }
        }
    }

    public int readFontByte() {
        int n = 0;
        if (!this.fontGenVisAccess) {
            int n2 = this.fontBaseAddr | this.fontRowAddr;
            if (n2 >= 0 && n2 < this.fontBytes.length) {
                n = this.fontBytes[n2] & 0xFF;
            }
            this.fontRowAddr = this.fontRowAddr + 1 & 7;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(EmuThread.ResetLevel resetLevel) {
        this.fontGenVisAccess = false;
        this.fontGenEnabled = false;
        this.lightColors = false;
        this.mode = -1;
        this.colorReg0 = 0;
        this.colorReg0 = 0;
        this.colorReg0 = 0;
        this.colorReg0 = 0;
        this.fontBaseAddr = 0;
        this.fontRowAddr = 0;
        if (resetLevel == EmuThread.ResetLevel.POWER_ON) {
            Arrays.fill(this.fontBytes, (byte)0);
            Arrays.fill(this.vram, (short)0);
        }
        Color[] colorArray = this.colors;
        synchronized (this.colors) {
            this.screenImage = null;
            this.w640 = false;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.screenFrm.setScreenDirty(true);
            return;
        }
    }

    public void setFixedScreenSize(boolean bl) {
        this.fixedScreenSize = bl;
    }

    public void writeFontAddr(int n) {
        if (!this.fontGenVisAccess) {
            this.fontBaseAddr = n << 3 & 0x7F8;
            this.fontRowAddr = 0;
        }
    }

    public void writeFontByte(int n) {
        if (!this.fontGenVisAccess) {
            int n2 = this.fontBaseAddr | this.fontRowAddr;
            if (n2 >= 0 && n2 < this.fontBytes.length) {
                this.fontBytes[n2] = (byte)n;
            }
            this.fontRowAddr = this.fontRowAddr + 1 & 7;
            this.screenFrm.setScreenDirty(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMode(int n) {
        boolean bl = false;
        switch (n & 0x70) {
            case 0: {
                int n2 = this.mode;
                this.colorMode = (n & 3) != 3;
                switch (n & 7) {
                    case 0: 
                    case 3: 
                    case 4: {
                        this.mode = 0;
                        this.updScreenWidth();
                        break;
                    }
                    case 1: 
                    case 5: {
                        this.mode = 1;
                        this.updScreenWidth();
                        break;
                    }
                    case 2: 
                    case 6: {
                        this.mode = 2;
                        this.updScreenWidth();
                    }
                }
                if (this.mode == n2) break;
                bl = true;
                break;
            }
            case 16: {
                boolean bl2 = this.w640;
                boolean bl3 = this.fontGenEnabled;
                Color[] colorArray = this.colors;
                synchronized (this.colors) {
                    this.w640 = (n & 2) == 0;
                    this.fontGenVisAccess = (n & 1) == 0;
                    this.fontGenEnabled = (n & 4) == 0;
                    this.lightColors = (n & 8) != 0;
                    this.updScreenWidth();
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    if (this.w640 == bl2 && this.fontGenEnabled == bl3) break;
                    bl = true;
                    break;
                }
            }
            case 32: {
                this.colorReg0 = n & 0xF;
                break;
            }
            case 48: {
                this.colorReg1 = n & 0xF;
                break;
            }
            case 64: {
                this.colorReg2 = n & 0xF;
                break;
            }
            case 80: {
                this.colorReg3 = n & 0xF;
                break;
            }
            case 96: {
                this.colorReg4 = n & 0xF;
            }
        }
        {
            if (bl) {
                this.screenFrm.clearScreenSelection();
                this.screenFrm.fireUpdScreenTextActionsEnabled();
            }
            this.screenFrm.setScreenDirty(true);
            return;
        }
    }

    @Override
    public void screenConfigChanged(GDC82720 gDC82720) {
        this.screenFrm.clearScreenSelection();
        this.screenFrm.fireUpdScreenTextActionsEnabled();
    }

    @Override
    public void screenDirty(GDC82720 gDC82720) {
        this.screenFrm.setScreenDirty(true);
    }

    @Override
    public int getVRAMWord(int n) {
        return this.vram[n & 0xFFFF] & 0xFFFF;
    }

    @Override
    public void setVRAMWord(int n, int n2) {
        this.vram[n & 0xFFFF] = (short)n2;
        this.screenFrm.setScreenDirty(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getScreenImage() {
        BufferedImage bufferedImage = this.screenImage;
        Color[] colorArray = this.colors;
        synchronized (this.colors) {
            int n = this.gdc.getDisplayLines();
            int n2 = this.screenWidth;
            if (bufferedImage != null && (bufferedImage.getHeight() != n || bufferedImage.getWidth() != n2)) {
                bufferedImage = null;
            }
            if (bufferedImage == null && n > 0 && n2 > 0) {
                IndexColorModel indexColorModel = this.colorModel;
                bufferedImage = indexColorModel != null ? new BufferedImage(n2, n, 12, indexColorModel) : new BufferedImage(n2, n, 5);
                this.screenImage = bufferedImage;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return bufferedImage;
        }
    }

    private void updScreenWidth() {
        int n;
        int n2 = this.getScreenWidth();
        int n3 = n = this.w640 ? 640 : 320;
        if (this.mode == 2) {
            n /= 2;
        }
        this.screenWidth = n;
        if (n != n2 && !this.fixedScreenSize) {
            this.screenFrm.fireScreenSizeChanged();
        }
    }
}

