/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.a5105;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Arrays;
import java.util.List;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.EmuSys;
import jkcemu.emusys.A5105;

public class A5105KeyboardFld
extends AbstractKeyboardFld<A5105> {
    private static final int TEXT_FONT_SIZE = 9;
    private static final int LETTER_FONT_SIZE = 14;
    private static final int DIGIT_FONT_SIZE = 12;
    private static final int LED_SIZE = 8;
    private static final int KEY_SIZE = 40;
    private static final int KEY_HALF_SIZE = 20;
    private static final int MEDIUM_KEY_SIZE = 50;
    private static final int LARGE_KEY_SIZE = 60;
    private static final int SPACE_KEY_SIZE = 320;
    private static final int MARGIN = 20;
    private Image imgKey40x40 = this.getImage("/images/keyboard/key40x40.png");
    private Image imgKey50x40 = this.getImage("/images/keyboard/key50x40.png");
    private Image imgKey60x40 = this.getImage("/images/keyboard/key60x40.png");
    private Image imgKey320x40 = this.getImage("/images/keyboard/key320x40.png");
    private Image imgLeft = this.getImage("/images/keyboard/a5105/left.png");
    private Image imgRight = this.getImage("/images/keyboard/a5105/right.png");
    private Image imgUp = this.getImage("/images/keyboard/a5105/up.png");
    private Image imgDown = this.getImage("/images/keyboard/a5105/down.png");
    private Image imgHome = this.getImage("/images/keyboard/a5105/home.png");
    private Image imgShift = this.getImage("/images/keyboard/a5105/shift.png");
    private Color colorLEDGreenOn = Color.GREEN;
    private Color colorLEDGreenOff = new Color(60, 120, 60);
    private Color colorLEDYellowOn = Color.YELLOW;
    private Color colorLEDYellowOff = new Color(120, 120, 0);
    private Font fontText = new Font("SansSerif", 0, 9);
    private Font fontLetter = new Font("SansSerif", 0, 14);
    private Font fontDigit = new Font("SansSerif", 0, 12);
    private int[] kbMatrix = new int[9];
    private int curIdx = 0;
    private int curX = 20;
    private int curY = 20;
    private int xRow1Left;
    private int xRow1Right;
    private int xRow3Right;

    public A5105KeyboardFld(A5105 a5105) {
        super(a5105, 69, true);
        this.addKey("PF 1", null, 7, 2, "F1");
        this.curX += 20;
        this.xRow1Left = this.curX;
        this.addKey(this.imgHome, 8, 2, "F6 oder Pos1");
        this.addKey("1", "!", 0, 2);
        this.addKey("2", "\"", 0, 4);
        this.addKey("3", "\\", 0, 8);
        this.addKey("4", "$", 0, 16);
        this.addKey("5", "%", 0, 32);
        this.addKey("6", "&", 0, 64);
        this.addKey("7", "/", 0, 128);
        this.addKey("8", "(", 1, 1);
        this.addKey("9", ")", 1, 2);
        this.addKey("0", "=", 0, 1);
        this.addKey("?", "\u00df", 2, 2);
        this.addKey("#", "^", 1, 128);
        this.addKey("'", "`", 2, 1);
        this.xRow1Right = this.curX - 1;
        this.curX += 30;
        int n = this.curX + 30;
        this.addLargeKey("STOP", 7, 16, "F7");
        this.curX = 20;
        this.curY += 40;
        this.addKey("PF 2", null, 7, 1, "F2");
        this.curX += 40;
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 40, 40, "CTRL", null, null, null, null, 6, 4, true, null);
        this.curX += 40;
        this.addKey("Q", 4, 64);
        this.addKey("W", 5, 16);
        this.addKey("E", 3, 4);
        this.addKey("R", 4, 128);
        this.addKey("T", 5, 2);
        this.addKey("Z", 5, 128);
        this.addKey("U", 5, 4);
        this.addKey("I", 3, 64);
        this.addKey("O", 4, 16);
        this.addKey("P", 4, 32);
        this.addKey("\u00dc", 1, 64);
        this.addKey("<", ">", 1, 4);
        this.curX = n - 20;
        this.addKey(this.imgUp, 8, 32);
        this.curX = 20;
        this.curY += 40;
        this.addKey("PF 3", null, 6, 128, "F3");
        this.curX += 40;
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 50, 40, "CAPS\nLOCK", null, null, null, null, 6, 8, false, null);
        this.curX += 50;
        this.addKey("A", 2, 64);
        this.addKey("S", 5, 1);
        this.addKey("D", 3, 2);
        this.addKey("F", 3, 8);
        this.addKey("G", 3, 16);
        this.addKey("H", 3, 32);
        this.addKey("J", 3, 128);
        this.addKey("K", 4, 1);
        this.addKey("L", 4, 2);
        this.addKey("\u00d6", 1, 16);
        this.addKey("\u00c4", 1, 32);
        this.addKey("+", "*", 1, 8);
        this.xRow3Right = this.curX - 1;
        this.curX = n - 40;
        this.addKey(this.imgLeft, 8, 16);
        this.addKey(this.imgRight, 8, 128);
        int n2 = this.curX + 20;
        this.curX = 20;
        this.curY += 40;
        this.addKey("PF 4", null, 6, 64, "F4");
        this.curX += 20;
        this.addKey("ESC", 6, 2);
        AbstractKeyboardFld.KeyData keyData = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 50, 40, null, null, null, null, this.imgShift, 6, 1, true, null);
        this.keys[this.curIdx++] = keyData;
        this.curX += 50;
        this.addKey("Y", 5, 64);
        this.addKey("X", 5, 32);
        this.addKey("C", 3, 1);
        this.addKey("V", 5, 8);
        this.addKey("B", 2, 128);
        this.addKey("N", 4, 8);
        this.addKey("M", 4, 4);
        this.addKey(",", ";", 2, 4);
        this.addKey(".", ":", 2, 8);
        this.addKey("-", "_", 2, 16);
        AbstractKeyboardFld.KeyData keyData2 = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 60, 40, null, null, null, null, this.imgShift, 6, 1, true, null);
        this.keys[this.curIdx++] = keyData2;
        this.curX = n - 20;
        this.addKey(this.imgDown, 8, 64);
        this.curX = 20;
        this.curY += 40;
        this.addKey("PF 5", null, 6, 32, "F5");
        this.curX += 50;
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 40, 40, "GRAPH", null, null, null, null, 7, 4, true, null);
        this.curX += 40;
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 40, 40, "ALT", null, null, null, null, 6, 16, true, null);
        this.curX += 40;
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 320, 40, null, null, null, null, null, 8, 1, false, null);
        this.curX += 320;
        this.addKey("INS\nMODE", null, 8, 4, "Einfg");
        this.addKey("DEL", null, 8, 8, "Entf");
        this.curX = n - 30;
        this.addLargeKey("ENTER", 7, 128, null);
        int n3 = this.curY + 40 + 20;
        this.setPreferredSize(new Dimension(n2, n3));
        this.setShiftKeys(keyData, keyData2);
    }

    @Override
    public boolean accepts(EmuSys emuSys) {
        return emuSys instanceof A5105;
    }

    @Override
    public boolean getSelectionChangeOnShiftOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void keySelectionChanged() {
        Arrays.fill(this.kbMatrix, 0);
        List list = this.selectedKeys;
        synchronized (list) {
            for (AbstractKeyboardFld.KeyData keyData : this.selectedKeys) {
                if (keyData.col < 0 || keyData.col >= this.kbMatrix.length) continue;
                int n = keyData.col;
                this.kbMatrix[n] = this.kbMatrix[n] | keyData.value;
            }
        }
        ((A5105)this.emuSys).updKeyboardMatrix(this.kbMatrix);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setPaintMode();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (AbstractKeyboardFld.KeyData keyData : this.keys) {
            if (this.isKeySelected(keyData)) {
                graphics.setColor(Color.gray);
                graphics.fillRect(keyData.x, keyData.y, keyData.w, keyData.h);
            }
            switch (keyData.w) {
                case 40: {
                    if (this.imgKey40x40 == null) break;
                    graphics.drawImage(this.imgKey40x40, keyData.x, keyData.y, this);
                    break;
                }
                case 50: {
                    if (this.imgKey50x40 == null) break;
                    graphics.drawImage(this.imgKey50x40, keyData.x, keyData.y, this);
                    break;
                }
                case 60: {
                    if (this.imgKey60x40 == null) break;
                    graphics.drawImage(this.imgKey60x40, keyData.x, keyData.y, this);
                    break;
                }
                case 320: {
                    if (this.imgKey320x40 == null) break;
                    graphics.drawImage(this.imgKey320x40, keyData.x, keyData.y, this);
                }
            }
            if (keyData.image != null) {
                graphics.drawImage(keyData.image, keyData.x, keyData.y, this);
                continue;
            }
            graphics.setColor(Color.black);
            if (keyData.text1 == null) continue;
            if (keyData.text2 != null) {
                graphics.setFont(this.fontDigit);
                this.drawMultiLineString(graphics, keyData.x, keyData.y, keyData.w, keyData.text2, 8, 17, 12);
                this.drawMultiLineString(graphics, keyData.x, keyData.y, keyData.w, keyData.text1, 8, 31, 12);
                continue;
            }
            if (keyData.text1.length() == 1) {
                graphics.setFont(this.fontLetter);
                graphics.drawString(keyData.text1, keyData.x + 8, keyData.y + 6 + 14);
                continue;
            }
            graphics.setFont(this.fontText);
            this.drawMultiLineString(graphics, keyData.x, keyData.y, keyData.w, keyData.text1, 8, 17, 9);
        }
        graphics.setColor(Color.gray);
        graphics.drawLine(this.xRow1Left, 60, this.xRow1Left, 140);
        int n = this.xRow1Left + 6;
        int n2 = 76;
        graphics.setColor(((A5105)this.emuSys).getTapeLED() ? this.colorLEDGreenOn : this.colorLEDGreenOff);
        graphics.fillOval(n, n2, 8, 8);
        graphics.setColor(((A5105)this.emuSys).getCapsLockLED() ? this.colorLEDYellowOn : this.colorLEDYellowOff);
        graphics.fillOval(n, n2 + 40, 8, 8);
        n2 = 100;
        graphics.setColor(Color.gray);
        graphics.drawLine(this.xRow1Right, 60, this.xRow1Right, n2);
        graphics.drawLine(this.xRow1Right, n2, this.xRow3Right, n2);
        graphics.setColor(Color.red);
        n = this.xRow1Right - 20 + 6;
        n2 = 76;
        graphics.fillOval(n, n2, 8, 8);
    }

    @Override
    public void setEmuSys(EmuSys emuSys) {
        if (!(emuSys instanceof A5105)) {
            throw new IllegalArgumentException("EmuSys != A5105");
        }
        this.emuSys = (A5105)emuSys;
    }

    private void addKey(Image image, int n, int n2, String string) {
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 40, 40, null, null, null, null, image, n, n2, false, string);
        this.curX += 40;
    }

    private void addKey(Image image, int n, int n2) {
        this.addKey(image, n, n2, null);
    }

    private void addKey(String string, String string2, int n, int n2, String string3) {
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 40, 40, string, string2, null, null, null, n, n2, false, string3);
        this.curX += 40;
    }

    private void addKey(String string, String string2, int n, int n2) {
        this.addKey(string, string2, n, n2, null);
    }

    private void addKey(String string, int n, int n2) {
        this.addKey(string, null, n, n2, null);
    }

    private void addLargeKey(String string, int n, int n2, String string2) {
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 60, 40, string, null, null, null, null, n, n2, false, string2);
        this.curX += 60;
    }

    private void drawMultiLineString(Graphics graphics, int n, int n2, int n3, String string, int n4, int n5, int n6) {
        if (string != null) {
            String string2 = null;
            String string3 = null;
            int n7 = string.indexOf(10);
            if (n7 >= 0) {
                string2 = string.substring(0, n7);
                if (n7 + 1 < string.length()) {
                    string3 = string.substring(n7 + 1);
                }
            } else {
                string2 = string;
            }
            if (string2 != null) {
                int n8 = -1;
                FontMetrics fontMetrics = graphics.getFontMetrics();
                if (fontMetrics != null) {
                    n8 = fontMetrics.stringWidth(string2);
                    if (string3 != null) {
                        n8 = Math.max(n8, fontMetrics.stringWidth(string3));
                    }
                }
                if (n3 - 2 * n4 < n8) {
                    n4 = (n3 - n8) / 2;
                }
                graphics.drawString(string2, n + n4, n2 + n5);
                if (string3 != null) {
                    graphics.drawString(string3, n + n4, n2 + (n5 += n6 + 1));
                }
            }
        }
    }
}

