/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.Timer;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.CharRaster;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileFormat;
import jkcemu.base.RAMFloppy;
import jkcemu.base.SourceUtil;
import jkcemu.disk.FDC8272;
import jkcemu.disk.FloppyDiskDrive;
import jkcemu.disk.FloppyDiskFormat;
import jkcemu.disk.FloppyDiskInfo;
import jkcemu.disk.GIDE;
import jkcemu.emusys.z9001.Z9001KeyboardFld;
import jkcemu.etc.Plotter;
import jkcemu.etc.RTC7242X;
import jkcemu.etc.VDIP;
import jkcemu.net.KCNet;
import jkcemu.text.TextUtil;
import z80emu.Z80CPU;
import z80emu.Z80CTC;
import z80emu.Z80CTCListener;
import z80emu.Z80InterruptSource;
import z80emu.Z80MemView;
import z80emu.Z80PCListener;
import z80emu.Z80PIO;
import z80emu.Z80SIO;
import z80emu.Z80SIOChannelListener;

public class Z9001
extends EmuSys
implements ActionListener,
FDC8272.DriveSelector,
Z80CTCListener,
Z80PCListener,
Z80SIOChannelListener {
    public static final String SYSNAME_KC85_1 = "KC85_1";
    public static final String SYSNAME_KC87 = "KC87";
    public static final String SYSNAME_Z9001 = "Z9001";
    public static final String SYSTEXT_KC85_1 = "KC85/1";
    public static final String PROP_PREFIX_KC85_1 = "jkcemu.kc85_1.";
    public static final String PROP_PREFIX_KC87 = "jkcemu.kc87.";
    public static final String PROP_PREFIX_Z9001 = "jkcemu.z9001.";
    public static final String PROP_80CHARS_ENABLED = "80_chars.enabled";
    public static final String PROP_FONT_PROGRAMMABLE = "font.programmable";
    public static final String PROP_GRAPHIC_TYPE = "graphic.type";
    public static final String PROP_PLOTTER_ENABLED = "plotter.enabled";
    public static final String PROP_PRINTER_MOD_ENABLED = "printer_module.enabled";
    public static final String PROP_RAM16K4000_ENABLED = "ram_16k_4000.enabled";
    public static final String PROP_RAM64K_ENABLED = "ram_64k.enabled";
    public static final String PROP_RAM16K8000_ENABLED = "ram_16k_8000.enabled";
    public static final String PROP_ROM_MOD_PREFIX = "rom_module.";
    public static final String PROP_ROM10KC000_ENABLED = "rom_10k_c000.enabled";
    public static final String PROP_ROM16K4000_ENABLED = "rom_16k_4000.enabled";
    public static final String PROP_ROM16K8000_ENABLED = "rom_16k_8000.enabled";
    public static final String PROP_ROM32K4000_ENABLED = "rom_32k_4000.enabled";
    public static final String PROP_ROM64K_ENABLED = "rom_64k.enabled";
    public static final String PROP_ROMBOOT_ENABLED = "rom_boot.enabled";
    public static final String VALUE_GRAPHIC_KRT = "krt";
    public static final String VALUE_GRAPHIC_ROBOTRON = "robotron";
    public static final int DEFAULT_PROMPT_AFTER_RESET_MILLIS_MAX = 2500;
    public static final boolean DEFAULT_SWAP_KEY_CHAR_CASE = true;
    public static final String[] basicTokens = new String[]{"END", "FOR", "NEXT", "DATA", "INPUT", "DIM", "READ", "LET", "GOTO", "RUN", "IF", "RESTORE", "GOSUB", "RETURN", "REM", "STOP", "OUT", "ON", "NULL", "WAIT", "DEF", "POKE", "DOKE", "AUTO", "LINES", "CLS", "WIDTH", "BYE", "!", "CALL", "PRINT", "CONT", "LIST", "CLEAR", "CLOAD", "CSAVE", "NEW", "TAB(", "TO", "FN", "SPC(", "THEN", "NOT", "STEP", "+", "-", "*", "/", "^", "AND", "OR", ">", "=", "<", "SGN", "INT", "ABS", "USR", "FRE", "INP", "POS", "SQR", "RND", "LN", "EXP", "COS", "SIN", "TAN", "ATN", "PEEK", "DEEK", "PI", "LEN", "STR$", "VAL", "ASC", "CHR$", "LEFT$", "RIGHT$", "MID$", "LOAD", "TRON", "TROFF", "EDIT", "ELSE", "INKEY$", "JOYST", "STRING$", "INSTR", "RENUMBER", "DELETE", "PAUSE", "BEEP", "WINDOW", "BORDER", "INK", "PAPER", "AT", "PSET", "LINE", "CIRCLE", "!", "PAINT", "LABEL", "SIZE", "ZERO", "HOME", "!", "GCLS", "SCALE", "SCREEN", "POINT", "XPOS", "!", "YPOS"};
    private static final String[] biosCallNames = new String[]{"INIT", "WBOOT", "CONST", "CONIN", "COOUT", "LIST", "PUNCH", "READER", "GSTIK", "BOSER", "STIME", "GTIME", "SDMA", "READ", "WRITE", "LLIST", "GCURS", "SCURS", "BOSER", "GIOBY", "SIOBY", "GMEM", "SMEM"};
    private static final int[][] basicRGBValues = new int[][]{{0, 0, 0}, {255, 0, 0}, {0, 255, 0}, {255, 255, 0}, {0, 0, 255}, {255, 0, 255}, {0, 255, 255}, {255, 255, 255}};
    private static final int[][] kbMatrixNormal = new int[][]{{48, 49, 50, 51, 52, 53, 54, 55}, {56, 57, 58, 59, 44, 61, 46, 63}, {64, 65, 66, 67, 68, 69, 70, 71}, {72, 73, 74, 75, 76, 77, 78, 79}, {80, 81, 82, 83, 84, 85, 86, 87}, {88, 89, 90, 0, 0, 0, 94, 0}};
    private static final int[][] kbMatrixShift = new int[][]{{95, 33, 34, 35, 36, 37, 38, 39}, {40, 41, 42, 43, 60, 45, 62, 47}, {0, 97, 98, 99, 100, 101, 102, 103}, {104, 105, 106, 107, 108, 109, 110, 111}, {112, 113, 114, 115, 116, 117, 118, 119}, {120, 121, 122, 0, 0, 0, 0, 0}};
    private static final int[] char128ToUnicode = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9674, -1, 9711, -1, 9700, 9699, 9585, 9586, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9473, 9475, 9531, 9507, 9523, 9515, 9547, 9495, 9487, 9491, 9499, -1, -1, -1, -1, 9587, 9624, 9629, 9623, 9622, 9612, 9616, 9600, 9604, 9626, 9630, 9631, 9625, 9627, 9628, 9698, 9701, -1, -1, -1, -1, 9823, -1, -1, 9618, -1, 9830, 9827, 9829, 9824, -1, -1, 9679, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9601, 9602, 9603, 9604, 9605, 9606, 9607, 9608};
    private static final int GRAPHIC_NONE = 0;
    private static final int GRAPHIC_ROBOTRON = 1;
    private static final int GRAPHIC_KRT = 2;
    private static final int PLOTTER_WIDTH = 1800;
    private static final int PLOTTER_HEIGHT = 2550;
    private static final FloppyDiskInfo[] availableFloppyDisks = new FloppyDiskInfo[]{new FloppyDiskInfo("/disks/z9001/z9cpasys.dump.gz", "Z9001 CP/A Systemdiskette", 0, 2048, true)};
    private static byte[] os11 = null;
    private static byte[] os12 = null;
    private static byte[] os13 = null;
    private static byte[] basic86 = null;
    private static byte[] bootROMBytes = null;
    private static byte[] megaROMBytes = null;
    private static byte[] printerModBytes = null;
    private static byte[] kc87FontBytes = null;
    private static byte[] z9001FontBytes = null;
    private byte[] fontBytes;
    private byte[] romOS = null;
    private byte[] romBasic = null;
    private byte[] romBoot = null;
    private byte[] romMega = null;
    private byte[] rom16k4000 = null;
    private byte[] rom32k4000 = null;
    private byte[] rom16k8000 = null;
    private byte[] rom10kC000 = null;
    private byte[] ramFont;
    private byte[] ramColor;
    private byte[] ramColor2;
    private byte[] ramVideo;
    private byte[] ramVideo2;
    private byte[] ramPixel;
    private byte[] ramExt;
    private boolean ram16k4000 = false;
    private boolean ram16k8000 = false;
    private boolean ram64k = false;
    private boolean romModuleEnabled;
    private int megaROMSeg;
    private int fontOffs;
    private int graphType;
    private int graphBank;
    private int graphAddrL;
    private int graphBgColor;
    private int graphFgColor;
    private boolean graphBorder;
    private boolean graphMode;
    private boolean graphicLED = false;
    private volatile boolean fixedScreenSize;
    private boolean kc87;
    private boolean pasteFast;
    private boolean plotterPenState;
    private boolean plotterMoveState;
    private boolean printerModule;
    private boolean pcListenerAdded;
    private boolean mode20Rows;
    private boolean c80Active;
    private boolean c80Enabled;
    private boolean c80MemSwap;
    private boolean colorSwap;
    private boolean fdcReset;
    private boolean fdcTC;
    private boolean rf1ReadOnly;
    private boolean rf2ReadOnly;
    private boolean ram4000ExtEnabled;
    private boolean ramC000Enabled;
    private boolean ramFontActive;
    private boolean ramFontEnabled;
    private boolean tapeInPhase;
    private int lineNum;
    private int lineTStates;
    private int tStatesPerLine;
    private int tStatesVisible;
    private int borderColorIdx;
    private int joy0ActionMask;
    private int joy1ActionMask;
    private int[] kbMatrix;
    private String sysName;
    private String romOSFile = null;
    private String romBasicFile = null;
    private String romModuleFile = null;
    private RAMFloppy ramFloppy1;
    private RAMFloppy ramFloppy2;
    private Z80PIO pio90;
    private Z80PIO pio88;
    private Z80CTC ctc80;
    private Z80CTC ctcA8;
    private Z80SIO sioB0;
    private FDC8272 fdc;
    private GIDE gide;
    private RTC7242X rtc;
    private Plotter plotter;
    private KCNet kcNet;
    private VDIP vdip;
    private Z9001KeyboardFld keyboardFld = null;
    private Timer blinkTimer;
    private Color[] colors;
    private FloppyDiskDrive[] floppyDiskDrives;

    public Z9001(EmuThread emuThread, Properties properties) {
        super(emuThread, properties, "");
        this.sysName = EmuUtil.getProperty(properties, "jkcemu.system");
        switch (this.sysName) {
            case "KC87": {
                this.kc87 = true;
                this.propPrefix = PROP_PREFIX_KC87;
                break;
            }
            case "KC85_1": {
                this.kc87 = false;
                this.propPrefix = PROP_PREFIX_KC85_1;
                break;
            }
            default: {
                this.kc87 = false;
                this.propPrefix = PROP_PREFIX_Z9001;
            }
        }
        if (this.emulatesFloppyDisk(properties)) {
            this.floppyDiskDrives = new FloppyDiskDrive[2];
            Arrays.fill(this.floppyDiskDrives, null);
            this.fdc = new FDC8272(this, 4);
        } else {
            this.floppyDiskDrives = null;
            this.fdc = null;
        }
        if (this.emulatesPlotter(properties)) {
            this.plotter = new Plotter();
            this.plotter.applySettings(properties);
            this.plotter.setPageSize(1800, 2550);
        } else {
            this.plotter = null;
        }
        this.kcNet = this.emulatesKCNet(properties) ? new KCNet("Netzwerk-PIO (E/A-Adressen C0-C3)") : null;
        if (this.emulatesUSB(properties)) {
            this.vdip = new VDIP(this.emuThread.getFileTimesViewFactory(), "USB-PIO (E/A-Adressen DC-DF)");
            this.vdip.applySettings(properties);
        } else {
            this.vdip = null;
        }
        this.printerModule = this.emulatesPrinterModule(properties);
        if (this.printerModule && printerModBytes == null) {
            printerModBytes = this.readResource("/rom/z9001/modprinter.bin");
        }
        this.gide = GIDE.getGIDE(this.screenFrm, properties, this.propPrefix);
        this.rtc = this.emulatesRTC(properties) ? new RTC7242X() : null;
        this.c80Active = false;
        this.c80Enabled = this.emulates80CharsMode(properties);
        this.fixedScreenSize = this.isFixedScreenSize(properties);
        this.ramVideo = new byte[1024];
        this.ramVideo2 = this.c80Enabled ? new byte[1024] : null;
        this.ram16k4000 = this.emulatesRAM16K4000(properties);
        this.ram16k8000 = this.emulatesRAM16K8000(properties);
        this.ram64k = this.emulatesRAM64K(properties);
        this.ramExt = null;
        if (this.ram64k) {
            this.ramExt = this.emuThread.getExtendedRAM(16384);
        }
        this.ramFloppy1 = RAMFloppy.prepare(this.emuThread.getRAMFloppy1(), this.sysName, RAMFloppy.RFType.ADW, "RAM-Floppy an E/A-Adressen 20h/21h", properties, this.propPrefix + "ramfloppy.1.");
        this.ramFloppy2 = RAMFloppy.prepare(this.emuThread.getRAMFloppy2(), this.sysName, RAMFloppy.RFType.ADW, "RAM-Floppy an E/A-Adressen 24h/25h", properties, this.propPrefix + "ramfloppy.2.");
        this.lineNum = 0;
        this.lineTStates = 0;
        this.tapeInPhase = this.emuThread.readTapeInPhase();
        this.pcListenerAdded = false;
        this.mode20Rows = false;
        this.colorSwap = false;
        this.borderColorIdx = 0;
        this.colors = new Color[basicRGBValues.length];
        this.createColors(properties);
        this.applyPasteFast(properties);
        this.kbMatrix = new int[8];
        Object object = new ArrayList();
        this.pio90 = new Z80PIO("Tastatur-PIO (E/A-Adressen 90-93)");
        this.pio88 = new Z80PIO("System-PIO (E/A-Adressen 88-8B)");
        this.ctc80 = new Z80CTC("System-CTC (E/A-Adressen 80-83)");
        object.add(this.pio90);
        object.add(this.pio88);
        object.add(this.ctc80);
        if (this.printerModule) {
            this.ctcA8 = new Z80CTC("Druckermodul-CTC (E/A-Adressen A8-AB)");
            this.sioB0 = new Z80SIO("Druckermodul-SIO (E/A-Adressen B0-B3)");
            object.add(this.ctcA8);
            object.add(this.sioB0);
        } else {
            this.ctcA8 = null;
            this.sioB0 = null;
        }
        if (this.kcNet != null) {
            object.add(this.kcNet);
        }
        if (this.vdip != null) {
            object.add(this.vdip);
        }
        Z80CPU z80CPU = emuThread.getZ80CPU();
        try {
            z80CPU.setInterruptSources(object.toArray(new Z80InterruptSource[object.size()]));
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
        this.ctc80.setTimerConnection(2, 3);
        this.ctc80.addCTCListener(this);
        if (this.sioB0 != null) {
            this.sioB0.addChannelListener(this, 0);
        }
        if (this.ctcA8 != null) {
            this.ctcA8.addCTCListener(this);
        }
        z80CPU.addMaxSpeedListener(this);
        z80CPU.addTStatesListener(this);
        this.checkAddPCListener(properties);
        this.ramPixel = null;
        this.graphType = this.getGraphicType(properties);
        if (this.graphType == 1) {
            this.ramPixel = new byte[6144];
        } else if (this.graphType == 2) {
            this.ramPixel = new byte[8192];
        }
        if (this.getColorMode(properties)) {
            this.ramColor = new byte[1024];
            this.ramColor2 = this.c80Enabled ? new byte[1024] : null;
            this.blinkTimer = new Timer(200, this);
            this.blinkTimer.start();
        } else {
            this.ramColor = null;
            this.ramColor2 = null;
            this.blinkTimer = null;
        }
        this.ramFont = (byte[])(this.emulatesProgrammableFont(properties) ? new byte[1024] : null);
        this.z80MaxSpeedChanged(z80CPU);
        if (!this.isReloadExtROMsOnPowerOnEnabled(properties)) {
            this.loadROMs(properties);
        }
    }

    public boolean emulatesGraphicsKRT() {
        return this.graphType == 2;
    }

    public static FloppyDiskInfo[] getAvailableFloppyDisks() {
        return availableFloppyDisks;
    }

    public static int getDefaultSpeedKHz() {
        return 2458;
    }

    public boolean getGraphicLED() {
        return this.graphicLED;
    }

    public static int toUnicode(int n) {
        int n2 = -1;
        if (n >= 0) {
            if (n < 32 || n == 127) {
                n2 = 9608;
            } else if (n >= 32 && n < 127) {
                n2 = n;
            } else {
                int n3 = n - 128;
                if (n3 >= 0 && n3 < char128ToUnicode.length) {
                    n2 = char128ToUnicode[n3];
                }
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updKeyboardMatrix(int[] nArray) {
        int[] nArray2 = this.kbMatrix;
        synchronized (this.kbMatrix) {
            int n;
            int n2 = Math.min(nArray.length, this.kbMatrix.length);
            for (n = 0; n < n2; ++n) {
                this.kbMatrix[n] = nArray[n];
            }
            while (n < this.kbMatrix.length) {
                this.kbMatrix[n] = 0;
                ++n;
            }
            this.putKeyboardMatrixValuesToPorts();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.blinkTimer && !this.emuThread.getZ80CPU().isPause()) {
            this.colorSwap = !this.colorSwap;
            this.screenFrm.setScreenDirty(true);
        }
    }

    @Override
    public FloppyDiskDrive getFloppyDiskDrive(int n) {
        FloppyDiskDrive floppyDiskDrive = null;
        if (this.floppyDiskDrives != null && n >= 0 && n < this.floppyDiskDrives.length) {
            floppyDiskDrive = this.floppyDiskDrives[n];
        }
        return floppyDiskDrive;
    }

    @Override
    public void z80CTCUpdate(Z80CTC z80CTC, int n) {
        if (z80CTC == this.ctc80 && n == 0) {
            this.tapeOutPhase = !this.tapeOutPhase;
            this.updLoudspeaker(this.pio88.fetchOutValuePortA(false));
        } else if (z80CTC == this.ctcA8 && n == 0 && this.sioB0 != null) {
            this.sioB0.clockPulseSenderA();
            this.sioB0.clockPulseReceiverA();
        }
    }

    @Override
    public void z80PCChanged(Z80CPU z80CPU, int n) {
        if (n == 5 && z80CPU.getRegC() == 5) {
            this.emuThread.getPrintMngr().putByte(z80CPU.getRegE());
            z80CPU.setFlagCarry(false);
            z80CPU.setRegPC(z80CPU.doPop());
        }
    }

    @Override
    public void z80SIOByteSent(Z80SIO z80SIO, int n, int n2) {
        if (this.printerModule && z80SIO == this.sioB0 && n == 0) {
            this.emuThread.getPrintMngr().putByte(n2);
            this.sioB0.setClearToSendA(false);
            this.sioB0.setClearToSendA(true);
        }
    }

    @Override
    public void appendStatusHTMLTo(StringBuilder stringBuilder, Z80CPU z80CPU) {
        stringBuilder.append("<h1>");
        EmuUtil.appendHTML(stringBuilder, this.getTitle());
        stringBuilder.append(" Speicherkonfiguration</h1>\n<table border=\"1\">\n<tr><td>F000h-FFFFh:</td><td>Betriebssystem-ROM</td></tr>\n<tr><td>EC00h-EFFFh:</td><td>");
        if (this.ramPixel != null && this.graphType == 2 && this.graphMode) {
            stringBuilder.append("KRT-Pixel-RAM, Segment ");
            stringBuilder.append(this.graphBank);
        } else {
            stringBuilder.append("Text-BWS");
            if (this.c80Enabled) {
                stringBuilder.append(" Segment ");
                stringBuilder.append(this.c80MemSwap ? "1" : "0");
            }
        }
        stringBuilder.append("</td></tr>\n<tr><td>E800h-EC00h:</td><td>");
        if (this.ramFontEnabled && this.ramFont != null) {
            stringBuilder.append("Zeichengenerator-RAM");
        } else if (this.ramColor != null) {
            stringBuilder.append("Farbattribut-RAM");
            if (this.c80Enabled) {
                stringBuilder.append(" Segment ");
                stringBuilder.append(this.c80MemSwap ? "1" : "0");
            }
        }
        stringBuilder.append("</td></tr>\n<tr><td>C000h-E7FFh:</td><td>");
        if (this.ram64k && this.ramC000Enabled) {
            stringBuilder.append("RAM");
        } else if (this.romModuleEnabled && this.romBoot != null) {
            stringBuilder.append("Boot-ROM");
        } else if (this.romModuleEnabled && this.romMega != null) {
            stringBuilder.append("Mega-ROM Segment ");
            stringBuilder.append(this.megaROMSeg);
        } else if (this.rom10kC000 != null) {
            stringBuilder.append("ROM-Modul");
        } else if (this.kc87 && this.romBasic != null) {
            stringBuilder.append("BASIC-ROM");
        }
        stringBuilder.append("</td></tr>\n");
        if (this.rom16k8000 != null || this.rom32k4000 != null) {
            stringBuilder.append("<tr><td>8000h-BFFFh:</td><td>ROM-Modul</td></tr>\n");
        } else if (this.ram16k8000 || this.ram64k) {
            stringBuilder.append("<tr><td>8000h-BFFFh:</td><td>RAM</td></tr>\n");
        } else if (this.printerModule && printerModBytes != null) {
            stringBuilder.append("<tr><td>B800h-BFFFh:</td><td>Druckermodul-ROM</td></tr>\n<tr><td>8000h-B7FFh:</td><td></td></tr>\n");
        } else {
            stringBuilder.append("<tr><td>8000h-BFFFh:</td><td></td></tr>\n");
        }
        stringBuilder.append("<tr><td>4000h-7FFFh:</td><td>");
        if (this.rom16k4000 != null || this.rom32k4000 != null) {
            stringBuilder.append("ROM-Modul");
        } else if (this.ram64k) {
            stringBuilder.append("RAM Segment ");
            stringBuilder.append(this.ram4000ExtEnabled && this.ramExt != null ? "1" : "0");
        }
        stringBuilder.append("</td></tr>\n<tr><td>0000h-3FFFh:</td><td>RAM</td></tr>\n</table>\n<br/><br/>\n<h1>");
        EmuUtil.appendHTML(stringBuilder, this.getTitle());
        stringBuilder.append(" Status</h1>\n<table border=\"1\">\n<tr><td>Bildausgabe:</td><td>");
        if (this.graphMode) {
            if (this.graphType == 1) {
                stringBuilder.append("ROBOTRON-Vollgrafikerweiterung");
            } else if (this.graphType == 2) {
                stringBuilder.append("KRT-Grafik");
            }
        } else {
            stringBuilder.append("Textmodus, ");
            if (this.c80Enabled) {
                stringBuilder.append(this.c80Active ? "8" : "4");
                stringBuilder.append("0x2");
                stringBuilder.append(this.mode20Rows ? "0" : "4");
            } else {
                stringBuilder.append(this.mode20Rows ? "20" : "24");
                stringBuilder.append(" Zeilen");
            }
        }
    }

    @Override
    public void applySettings(Properties properties) {
        super.applySettings(properties);
        boolean bl = this.isFixedScreenSize(properties);
        if (bl != this.fixedScreenSize) {
            this.fixedScreenSize = bl;
            this.screenFrm.fireScreenSizeChanged();
        }
        this.checkAddPCListener(properties);
        this.createColors(properties);
        this.loadFont(properties);
        this.applyPasteFast(properties);
        if (this.plotter != null) {
            this.plotter.applySettings(properties);
        }
        if (this.vdip != null) {
            this.vdip.applySettings(properties);
        }
    }

    @Override
    public boolean canApplySettings(Properties properties) {
        boolean bl = EmuUtil.getProperty(properties, "jkcemu.system").equals(this.sysName);
        if (bl && this.emulatesRAM16K4000(properties) != this.ram16k4000) {
            bl = false;
        }
        if (bl && this.emulatesRAM16K8000(properties) != this.ram16k8000) {
            bl = false;
        }
        if (bl && this.emulatesRAM64K(properties) != this.ram64k) {
            bl = false;
        }
        if (bl) {
            bl = TextUtil.equals(this.romOSFile, EmuUtil.getProperty(properties, this.propPrefix + "os.file"));
        }
        if (bl && this.kc87) {
            bl = TextUtil.equals(this.romBasicFile, EmuUtil.getProperty(properties, this.propPrefix + "basic." + "file"));
        }
        if (bl) {
            bl = Z9001.equalsROMModule(this.rom16k4000, this.romModuleFile, properties, this.propPrefix + PROP_ROM16K4000_ENABLED, this.propPrefix + PROP_ROM_MOD_PREFIX + "file");
        }
        if (bl) {
            bl = Z9001.equalsROMModule(this.rom32k4000, this.romModuleFile, properties, this.propPrefix + PROP_ROM32K4000_ENABLED, this.propPrefix + PROP_ROM_MOD_PREFIX + "file");
        }
        if (bl) {
            bl = Z9001.equalsROMModule(this.rom16k8000, this.romModuleFile, properties, this.propPrefix + PROP_ROM16K8000_ENABLED, this.propPrefix + PROP_ROM_MOD_PREFIX + "file");
        }
        if (bl) {
            bl = Z9001.equalsROMModule(this.rom10kC000, this.romModuleFile, properties, this.propPrefix + PROP_ROM10KC000_ENABLED, this.propPrefix + PROP_ROM_MOD_PREFIX + "file");
        }
        if (bl) {
            bl = Z9001.equalsROMModule(this.romBoot, this.romModuleFile, properties, this.propPrefix + PROP_ROMBOOT_ENABLED, this.propPrefix + PROP_ROM_MOD_PREFIX + "file");
        }
        if (bl) {
            bl = Z9001.equalsROMModule(this.romMega, this.romModuleFile, properties, this.propPrefix + "rom_mega.enabled", this.propPrefix + PROP_ROM_MOD_PREFIX + "file");
        }
        if (bl && this.emulatesFloppyDisk(properties) != (this.fdc != null)) {
            bl = false;
        }
        if (bl && this.emulatesPrinterModule(properties) != this.printerModule) {
            bl = false;
        }
        if (bl && this.emulatesPlotter(properties) != (this.plotter != null)) {
            bl = false;
        }
        if (bl && this.emulatesKCNet(properties) != (this.kcNet != null)) {
            bl = false;
        }
        if (bl && this.emulatesUSB(properties) != (this.vdip != null)) {
            bl = false;
        }
        if (bl && this.emulatesRTC(properties) != (this.rtc != null)) {
            bl = false;
        }
        if (bl) {
            bl = GIDE.complies(this.gide, properties, this.propPrefix);
        }
        if (bl) {
            bl = RAMFloppy.complies(this.ramFloppy1, this.sysName, RAMFloppy.RFType.ADW, properties, this.propPrefix + "ramfloppy.1.");
        }
        if (bl) {
            bl = RAMFloppy.complies(this.ramFloppy2, this.sysName, RAMFloppy.RFType.ADW, properties, this.propPrefix + "ramfloppy.2.");
        }
        if (bl && this.getColorMode(properties) != (this.ramColor != null)) {
            bl = false;
        }
        if (bl && this.getGraphicType(properties) != this.graphType) {
            bl = false;
        }
        if (bl && this.emulatesProgrammableFont(properties) != (this.ramFont != null)) {
            bl = false;
        }
        if (bl && this.emulates80CharsMode(properties) != this.c80Enabled) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean canExtractScreenText() {
        return !this.graphMode;
    }

    @Override
    public AbstractKeyboardFld createKeyboardFld() {
        this.keyboardFld = new Z9001KeyboardFld(this);
        return this.keyboardFld;
    }

    @Override
    public void die() {
        if (this.blinkTimer != null) {
            this.blinkTimer.stop();
        }
        if (this.sioB0 != null) {
            this.sioB0.removeChannelListener(this, 0);
        }
        this.ctc80.removeCTCListener(this);
        if (this.ctcA8 != null) {
            this.ctcA8.removeCTCListener(this);
        }
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        z80CPU.removeMaxSpeedListener(this);
        z80CPU.removeTStatesListener(this);
        z80CPU.setInterruptSources(null);
        if (this.pcListenerAdded) {
            z80CPU.removePCListener(this);
        }
        if (this.ramFloppy1 != null) {
            this.ramFloppy1.deinstall();
        }
        if (this.ramFloppy2 != null) {
            this.ramFloppy2.deinstall();
        }
        if (this.fdc != null) {
            this.fdc.die();
        }
        if (this.plotter != null) {
            this.plotter.die();
        }
        if (this.gide != null) {
            this.gide.die();
        }
        if (this.kcNet != null) {
            this.kcNet.die();
        }
        if (this.vdip != null) {
            this.vdip.die();
        }
    }

    @Override
    public int getBorderColorIndex() {
        return this.borderColorIdx;
    }

    @Override
    public Color getColor(int n) {
        Color color = Color.black;
        if (this.ramColor != null) {
            if (n >= 0 && n < this.colors.length) {
                color = this.colors[n];
            }
        } else if (n > 0) {
            color = Color.white;
        }
        return color;
    }

    @Override
    public int getColorCount() {
        return this.ramColor != null ? 8 : 2;
    }

    @Override
    public int getColorIndex(int n, int n2) {
        int n3 = 0;
        if (this.fixedScreenSize || this.screenFrm.isFullScreenMode()) {
            n2 /= 2;
        }
        if (this.graphMode && this.graphType == 1 && this.ramPixel != null) {
            int n4;
            int n5;
            boolean bl = false;
            if (this.fixedScreenSize || this.screenFrm.isFullScreenMode()) {
                n /= 2;
            }
            if ((n -= 32) >= 0 && n < 256 && (n5 = n2 * 32 + (n4 = n / 8)) >= 0 && n5 < this.ramPixel.length) {
                byte by;
                int n6 = 128;
                int n7 = n % 8;
                if (n7 > 0) {
                    n6 >>= n7;
                }
                n3 = ((by = this.ramPixel[n5]) & n6) != 0 ? this.graphFgColor : this.graphBgColor;
                bl = true;
            }
            if (!bl && this.graphBorder) {
                n3 = this.borderColorIdx;
            }
        } else {
            int n8 = 0;
            int n9 = n / 8;
            byte[] byArray = this.ramVideo;
            if (this.c80Active && this.ramVideo2 != null) {
                if ((n9 & 1) != 0) {
                    byArray = this.ramVideo2;
                }
                n9 /= 2;
            } else if (this.fixedScreenSize || this.screenFrm.isFullScreenMode()) {
                n /= 2;
                n9 /= 2;
            }
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            if (this.mode20Rows) {
                n10 = n2 / 9;
                n11 = n2 % 9;
                n12 = 20;
            } else {
                n10 = n2 / 8;
                n11 = n2 % 8;
                n12 = 24;
            }
            if (n11 < 8 && n10 < n12) {
                int n13;
                int n14;
                int n15 = n10 * 40 + n9;
                if (this.graphMode && this.graphType == 2 && this.ramPixel != null) {
                    n14 = n11 * 1024 + n15;
                    if (n14 >= 0 && n14 < this.ramPixel.length) {
                        n8 = this.ramPixel[n14];
                    }
                } else if (this.fontBytes != null && n15 >= 0 && n15 < byArray.length) {
                    n14 = byArray[n15] & 0xFF;
                    n13 = n14 * 8 + n11;
                    if (this.ramFontActive && this.ramFont != null && n14 >= 128) {
                        if ((n13 -= 1024) >= 0 && n13 < this.ramFont.length) {
                            n8 = this.ramFont[n13];
                        }
                    } else if ((n13 += this.fontOffs) >= 0 && n13 < this.fontBytes.length) {
                        n8 = this.fontBytes[n13];
                    }
                }
                n14 = 128;
                n13 = n % 8;
                if (n13 > 0) {
                    n14 >>= n13;
                }
                if ((n8 & n14) != 0) {
                    n3 = 1;
                }
                if (this.ramColor != null) {
                    byte[] byArray2 = this.ramColor;
                    if (this.ramColor2 != null && byArray == this.ramVideo2) {
                        byArray2 = this.ramColor2;
                    }
                    int n16 = 0;
                    if (n15 >= 0 && n15 < byArray2.length) {
                        n16 = byArray2[n15] & 0xFF;
                    }
                    if ((n16 & 0x80) != 0 && this.colorSwap) {
                        int n17 = n3 = n3 != 0 ? 0 : 1;
                    }
                    n3 = n3 != 0 ? n16 >> 4 & 7 : n16 & 7;
                }
            } else if (this.ramColor != null) {
                n3 = this.borderColorIdx;
            }
        }
        return n3;
    }

    @Override
    public CharRaster getCurScreenCharRaster() {
        CharRaster charRaster = null;
        if (!this.graphMode) {
            int n = this.c80Active ? 80 : 40;
            int n2 = this.mode20Rows ? 20 : 24;
            int n3 = this.mode20Rows ? 9 : 8;
            int n4 = 8;
            int n5 = 8;
            if (this.fixedScreenSize || this.screenFrm.isFullScreenMode()) {
                n4 *= 2;
                n3 *= 2;
                if (!this.c80Active) {
                    n5 *= 2;
                }
            }
            charRaster = new CharRaster(n, n2, n3, n4, n5, 0);
        }
        return charRaster;
    }

    @Override
    public FloppyDiskFormat getDefaultFloppyDiskFormat() {
        return FloppyDiskFormat.FMT_800K_I4;
    }

    @Override
    protected long getDelayMillisAfterPasteChar() {
        return this.pasteFast ? 0L : 100L;
    }

    @Override
    protected long getDelayMillisAfterPasteEnter() {
        return this.pasteFast ? 0L : 200L;
    }

    @Override
    protected long getHoldMillisPasteChar() {
        return this.pasteFast ? 0L : 60L;
    }

    @Override
    public String getHelpPage() {
        return "/help/z9001.htm";
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        return this.getMemByteInternal(n, false);
    }

    @Override
    public Plotter getPlotter() {
        return this.plotter;
    }

    @Override
    public int getResetStartAddress(EmuThread.ResetLevel resetLevel) {
        return 61440;
    }

    @Override
    protected int getScreenChar(CharRaster charRaster, int n, int n2) {
        int n3 = -1;
        if (!this.graphMode) {
            int n4;
            byte[] byArray = this.ramVideo;
            if (this.c80Active && this.ramVideo2 != null) {
                if ((n & 1) != 0) {
                    byArray = this.ramVideo2;
                }
                n /= 2;
            }
            if ((n4 = n2 * 40 + n) >= 0 && n4 < byArray.length) {
                int n5 = byArray[n4] & 0xFF;
                if (this.fontOffs > 0) {
                    switch (n5) {
                        case 11: {
                            n3 = 196;
                            break;
                        }
                        case 12: {
                            n3 = 214;
                            break;
                        }
                        case 13: {
                            n3 = 220;
                            break;
                        }
                        case 27: {
                            n3 = 228;
                            break;
                        }
                        case 28: {
                            n3 = 246;
                            break;
                        }
                        case 29: {
                            n3 = 252;
                            break;
                        }
                        case 30: {
                            n3 = 223;
                        }
                    }
                }
                if (n3 < 0) {
                    n3 = n5 >= 32 && n5 < 127 ? n5 : Z9001.toUnicode(n5);
                }
            }
        }
        return n3;
    }

    @Override
    public int getScreenHeight() {
        int n = 192;
        if (this.fixedScreenSize || this.screenFrm.isFullScreenMode()) {
            n *= 2;
        }
        return n;
    }

    @Override
    public int getScreenWidth() {
        int n = 320;
        if (this.fixedScreenSize || this.screenFrm.isFullScreenMode() || this.c80Active && !this.graphMode) {
            n *= 2;
        }
        return n;
    }

    @Override
    public FloppyDiskInfo[] getSuitableFloppyDisks() {
        return this.fdc != null ? availableFloppyDisks : null;
    }

    @Override
    public int getSupportedFloppyDiskDriveCount() {
        return this.floppyDiskDrives != null ? this.floppyDiskDrives.length : 0;
    }

    @Override
    public int getSupportedJoystickCount() {
        return 2;
    }

    @Override
    public boolean getSwapKeyCharCase() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.sysName.equals(SYSNAME_KC85_1) ? SYSTEXT_KC85_1 : this.sysName;
    }

    @Override
    public boolean hasKCBasicInROM() {
        return this.romBasic != null;
    }

    @Override
    protected VDIP getVDIP() {
        return this.vdip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int[] nArray = this.kbMatrix;
        synchronized (this.kbMatrix) {
            switch (n) {
                case 8: {
                    this.kbMatrix[0] = 64;
                    bl3 = true;
                    break;
                }
                case 37: {
                    if (bl) {
                        this.kbMatrix[3] = 32;
                    } else {
                        if (bl2) {
                            this.kbMatrix[0] = 128;
                        }
                        this.kbMatrix[0] = 64;
                    }
                    bl3 = true;
                    break;
                }
                case 39: {
                    if (bl) {
                        this.kbMatrix[3] = 32;
                        this.kbMatrix[0] = 128;
                    } else {
                        if (bl2) {
                            this.kbMatrix[0] = 128;
                        }
                        this.kbMatrix[1] = 64;
                    }
                    bl3 = true;
                    break;
                }
                case 40: {
                    if (bl2) {
                        this.kbMatrix[0] = 128;
                    }
                    this.kbMatrix[2] = 64;
                    bl3 = true;
                    break;
                }
                case 38: {
                    if (bl2) {
                        this.kbMatrix[0] = 128;
                    }
                    this.kbMatrix[3] = 64;
                    bl3 = true;
                    break;
                }
                case 27: {
                    if (bl2) {
                        this.kbMatrix[0] = 128;
                    }
                    this.kbMatrix[4] = 64;
                    bl3 = true;
                    break;
                }
                case 10: {
                    this.kbMatrix[5] = 64;
                    bl3 = true;
                    break;
                }
                case 32: {
                    this.kbMatrix[7] = 64;
                    bl3 = true;
                    break;
                }
                case 155: {
                    if (bl2) {
                        this.kbMatrix[0] = 128;
                    }
                    this.kbMatrix[5] = 32;
                    bl3 = true;
                    break;
                }
                case 127: {
                    this.kbMatrix[0] = 128;
                    this.kbMatrix[5] = 32;
                    bl3 = true;
                    break;
                }
                case 112: {
                    this.kbMatrix[4] = 128;
                    bl3 = true;
                    break;
                }
                case 113: {
                    this.kbMatrix[5] = 128;
                    bl3 = true;
                    break;
                }
                case 114: {
                    this.kbMatrix[6] = 64;
                    bl3 = true;
                    break;
                }
                case 19: 
                case 115: {
                    this.kbMatrix[4] = 32;
                    bl3 = true;
                    break;
                }
                case 116: {
                    this.kbMatrix[0] = 128;
                    this.kbMatrix[4] = 32;
                    bl3 = true;
                    break;
                }
                case 117: {
                    this.kbMatrix[0] = 128;
                    this.kbMatrix[4] = 64;
                    bl3 = true;
                    break;
                }
                case 118: {
                    this.kbMatrix[1] = 128;
                    bl3 = true;
                    break;
                }
                case 119: {
                    this.kbMatrix[3] = 128;
                    bl3 = true;
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (bl3) {
                this.putKeyboardMatrixValuesToPorts();
                this.updKeyboardFld();
            }
            return bl3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased() {
        int[] nArray = this.kbMatrix;
        synchronized (this.kbMatrix) {
            Arrays.fill(this.kbMatrix, 0);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.putKeyboardMatrixValuesToPorts();
            this.updKeyboardFld();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyTyped(char c) {
        boolean bl = false;
        int[] nArray = this.kbMatrix;
        synchronized (this.kbMatrix) {
            if (c >= '\u0001' && c <= ' ') {
                if (this.setCharInKBMatrix(c + 64, kbMatrixNormal)) {
                    this.kbMatrix[2] = this.kbMatrix[2] | 0x80;
                    bl = true;
                } else if (this.setCharInKBMatrix(c + 64, kbMatrixShift)) {
                    this.kbMatrix[2] = this.kbMatrix[2] | 0x80;
                    bl = true;
                }
            } else if (this.setCharInKBMatrix(c, kbMatrixNormal)) {
                bl = true;
            } else if (this.setCharInKBMatrix(c, kbMatrixShift)) {
                this.kbMatrix[0] = this.kbMatrix[0] | 0x80;
                bl = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (bl) {
                this.putKeyboardMatrixValuesToPorts();
                this.updKeyboardFld();
            }
            return bl;
        }
    }

    @Override
    public void openBasicProgram() {
        SourceUtil.openKCBasicProgram(this.screenFrm, this.kc87 ? 1025 : 11265, basicTokens);
    }

    @Override
    protected boolean pasteChar(char c) throws InterruptedException {
        boolean bl = false;
        if (this.pasteFast) {
            if (c > '\u0000' && c <= '\u00ff') {
                if (c == '\n') {
                    c = (char)13;
                }
                while (this.getMemByte(37, false) != 0) {
                    Thread.sleep(10L);
                }
                this.setMemByte(36, c);
                this.setMemByte(37, c);
                bl = true;
            }
        } else {
            bl = super.pasteChar(c);
        }
        return bl;
    }

    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 255;
        switch (n & 0xFF) {
            case 4: {
                this.ram4000ExtEnabled = false;
                break;
            }
            case 5: {
                if (this.ramExt == null) break;
                this.ram4000ExtEnabled = true;
                break;
            }
            case 6: {
                this.ramC000Enabled = false;
                break;
            }
            case 7: {
                if (this.ramExt == null) break;
                this.ramC000Enabled = true;
                break;
            }
            case 16: 
            case 152: 
            case 154: 
            case 156: 
            case 158: {
                if (this.fdc == null) break;
                n3 = this.fdc.readMainStatusReg();
                break;
            }
            case 17: 
            case 153: 
            case 155: 
            case 157: 
            case 159: {
                if (this.fdc == null) break;
                n3 = this.fdc.readData();
                break;
            }
            case 18: 
            case 19: {
                if (this.fdc == null) break;
                this.fdc.fireTC();
                break;
            }
            case 32: {
                if (this.ramFloppy1 == null) break;
                n3 = this.ramFloppy1.readByte(n);
                break;
            }
            case 36: {
                if (this.ramFloppy2 == null) break;
                n3 = this.ramFloppy2.readByte(n);
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: {
                n3 = this.ctc80.read(n & 3, n2);
                break;
            }
            case 136: 
            case 140: {
                n3 = this.pio88.readDataA();
                break;
            }
            case 137: 
            case 141: {
                n3 = this.pio88.readDataB();
                break;
            }
            case 138: 
            case 142: {
                n3 = this.pio88.readControlA();
                break;
            }
            case 139: 
            case 143: {
                n3 = this.pio88.readControlB();
                break;
            }
            case 144: 
            case 148: {
                n3 = this.pio90.readDataA();
                break;
            }
            case 145: 
            case 149: {
                n3 = this.pio90.readDataB();
                break;
            }
            case 146: 
            case 150: {
                n3 = this.pio90.readControlA();
                break;
            }
            case 147: 
            case 151: {
                n3 = this.pio90.readControlB();
                break;
            }
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: {
                if (this.ctcA8 == null) break;
                n3 = this.ctcA8.read(n & 3, n2);
                break;
            }
            case 176: 
            case 180: {
                if (this.sioB0 == null) break;
                n3 = this.sioB0.readDataA();
                break;
            }
            case 177: 
            case 181: {
                if (this.sioB0 == null) break;
                n3 = this.sioB0.readDataB();
                break;
            }
            case 178: 
            case 182: {
                if (this.sioB0 == null) break;
                n3 = this.sioB0.readControlA();
                break;
            }
            case 179: 
            case 183: {
                if (this.sioB0 == null) break;
                n3 = this.sioB0.readControlB();
                break;
            }
            case 184: {
                if (this.ramPixel == null) break;
                if (this.graphType == 1) {
                    n3 = this.graphBgColor | this.graphFgColor << 4;
                    if (this.graphMode) {
                        n3 |= 8;
                    }
                    if (!this.graphBorder) break;
                    n3 |= 0x40;
                    break;
                }
                if (this.graphType != 2) break;
                n3 = this.graphBank;
                if (!this.graphMode) break;
                n3 |= 8;
                break;
            }
            case 186: {
                int n4;
                if (this.ramPixel == null || this.graphType != 1 || (n4 = n & 0xFF00 | this.graphAddrL) < 0 || n4 >= this.ramPixel.length) break;
                n3 = this.ramPixel[n4] & 0xFF;
                break;
            }
            case 192: 
            case 193: 
            case 194: 
            case 195: {
                if (this.kcNet == null) break;
                n3 = this.kcNet.read(n);
                break;
            }
            case 220: 
            case 221: 
            case 222: 
            case 223: {
                if (this.vdip == null) break;
                n3 = this.vdip.read(n);
                break;
            }
            default: {
                if (this.gide != null && (n & 0xF0) == 80) {
                    int n5 = this.gide.read(n);
                    if (n5 < 0) break;
                    n3 = n5;
                    break;
                }
                if (this.rtc == null || (n & 0xF0) != 96) break;
                n3 = this.rtc.read(n);
            }
        }
        return n3;
    }

    @Override
    public int readMemByte(int n, boolean bl) {
        return this.getMemByteInternal(n, true);
    }

    @Override
    public int reassembleSysCall(Z80MemView z80MemView, int n, StringBuilder stringBuilder, boolean bl, int n2, int n3, int n4) {
        return this.reassSysCallTable(z80MemView, n, 61440, biosCallNames, stringBuilder, bl, n2, n3, n4);
    }

    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        int n;
        super.reset(resetLevel, properties);
        boolean bl = false;
        if (resetLevel == EmuThread.ResetLevel.POWER_ON) {
            bl = true;
            if (this.isReloadExtROMsOnPowerOnEnabled(properties)) {
                this.loadROMs(properties);
            }
            if (this.romBoot != null || this.romMega != null) {
                for (n = 0; n < 16384; ++n) {
                    this.emuThread.setRAMByte(n, (n & 1) != 0 ? 0 : 255);
                }
            }
            this.fillRandom(this.ramVideo);
            if (this.ramVideo2 != null) {
                this.fillRandom(this.ramVideo2);
            }
            if (this.ramColor != null) {
                this.fillRandom(this.ramColor);
            }
            if (this.ramColor2 != null) {
                this.fillRandom(this.ramColor2);
            }
            if (this.ramPixel != null) {
                this.fillRandom(this.ramPixel);
            }
        }
        if (resetLevel == EmuThread.ResetLevel.COLD_RESET) {
            bl = true;
        }
        this.ctc80.reset(bl);
        this.pio88.reset(bl);
        this.pio90.reset(bl);
        if (this.ctcA8 != null) {
            this.ctcA8.reset(bl);
        }
        if (this.sioB0 != null) {
            this.sioB0.reset(bl);
            this.sioB0.setClearToSendA(true);
            this.sioB0.setClearToSendB(true);
        }
        if (this.fdc != null) {
            this.fdc.reset(bl);
        }
        if (this.floppyDiskDrives != null) {
            for (n = 0; n < this.floppyDiskDrives.length; ++n) {
                FloppyDiskDrive floppyDiskDrive = this.floppyDiskDrives[n];
                if (floppyDiskDrive == null) continue;
                floppyDiskDrive.reset();
            }
        }
        if (this.blinkTimer != null) {
            this.blinkTimer.restart();
        }
        Arrays.fill(this.kbMatrix, 0);
        this.joy0ActionMask = 0;
        this.joy1ActionMask = 0;
        this.megaROMSeg = 0;
        this.fontOffs = 0;
        this.graphAddrL = 0;
        this.graphBgColor = 0;
        this.graphFgColor = 0;
        this.graphBorder = false;
        this.graphMode = false;
        this.c80MemSwap = false;
        this.plotterPenState = false;
        this.plotterMoveState = false;
        this.fdcReset = false;
        this.fdcTC = false;
        this.rf1ReadOnly = false;
        this.rf2ReadOnly = false;
        this.ram4000ExtEnabled = false;
        this.ramC000Enabled = false;
        this.ramFontActive = false;
        this.ramFontEnabled = false;
        boolean bl2 = this.romModuleEnabled = this.romBoot != null || this.romMega != null;
        if (this.plotter != null) {
            this.plotter.reset();
            this.pio88.putInValuePortB(0, 32);
        }
        if (this.gide != null) {
            this.gide.reset();
        }
        this.setGraphicLED(false);
        this.upd80CharsMode(false);
        this.updScreenConfig(0);
        this.screenFrm.fireUpdScreenTextActionsEnabled();
    }

    @Override
    public void saveBasicProgram() {
        SourceUtil.saveKCBasicProgram(this.screenFrm, this.kc87 ? 1025 : 11265);
    }

    @Override
    public void setFloppyDiskDrive(int n, FloppyDiskDrive floppyDiskDrive) {
        if (this.floppyDiskDrives != null && n >= 0 && n < this.floppyDiskDrives.length) {
            this.floppyDiskDrives[n] = floppyDiskDrive;
        }
    }

    @Override
    public void setJoystickAction(int n, int n2) {
        if (n == 0) {
            this.joy0ActionMask = n2;
        } else if (n == 1) {
            this.joy1ActionMask = n2;
        }
        this.putKeyboardMatrixValuesToPorts();
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        return this.setMemByteInternal(n, n2, false);
    }

    @Override
    public boolean shouldAskConvertScreenChar() {
        return this.fontBytes != z9001FontBytes && this.fontBytes != kc87FontBytes;
    }

    @Override
    public boolean supportsCopyToClipboard() {
        return true;
    }

    @Override
    public boolean supportsKeyboardFld() {
        return true;
    }

    @Override
    public boolean supportsOpenBasic() {
        return true;
    }

    @Override
    public boolean supportsPasteFromClipboard() {
        return true;
    }

    @Override
    public boolean supportsPrinter() {
        return this.printerModule || this.pcListenerAdded;
    }

    @Override
    public boolean supportsRAMFloppy1() {
        return this.ramFloppy1 != null;
    }

    @Override
    public boolean supportsRAMFloppy2() {
        return this.ramFloppy2 != null;
    }

    @Override
    public boolean supportsSaveBasic() {
        return true;
    }

    @Override
    public boolean supportsSoundOutMono() {
        return true;
    }

    @Override
    public boolean supportsTapeIn() {
        return true;
    }

    @Override
    public boolean supportsTapeOut() {
        return true;
    }

    @Override
    public void updSysCells(int n, int n2, FileFormat fileFormat, int n3) {
        SourceUtil.updKCBasicSysCells(this.emuThread, n, n2, fileFormat, n3);
    }

    @Override
    public void writeIOByte(int n, int n2, int n3) {
        switch (n & 0xFF) {
            case 4: {
                this.ram4000ExtEnabled = false;
                break;
            }
            case 5: {
                if (this.ramExt == null) break;
                this.ram4000ExtEnabled = true;
                break;
            }
            case 6: {
                this.ramC000Enabled = false;
                break;
            }
            case 7: {
                if (this.ramExt == null) break;
                this.ramC000Enabled = true;
                break;
            }
            case 17: 
            case 153: 
            case 155: 
            case 157: 
            case 159: {
                if (this.fdc == null) break;
                this.fdc.write(n2);
                break;
            }
            case 18: 
            case 19: {
                if (this.fdc == null) break;
                this.fdc.fireTC();
                break;
            }
            case 32: 
            case 33: {
                if (this.ramFloppy1 == null) break;
                this.ramFloppy1.writeByte(n, n2);
                break;
            }
            case 36: 
            case 37: {
                if (this.ramFloppy2 == null) break;
                this.ramFloppy2.writeByte(n, n2);
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: {
                this.ctc80.write(n & 3, n2, n3);
                break;
            }
            case 136: 
            case 140: {
                this.pio88.writeDataA(n2);
                int n4 = this.pio88.fetchOutValuePortA(false);
                this.updScreenConfig(n4);
                this.updLoudspeaker(n4);
                this.setGraphicLED((n4 & 0x40) != 0);
                break;
            }
            case 137: 
            case 141: {
                int n5;
                boolean bl;
                this.pio88.writeDataB(n2);
                if (this.plotter == null) break;
                int n6 = this.pio88.fetchOutValuePortB(false);
                boolean bl2 = (n6 & 0x80) != 0;
                boolean bl3 = bl = (n6 & 4) != 0;
                if (bl2 != this.plotterPenState) {
                    this.plotterPenState = bl2;
                    this.plotter.setPenState(bl2);
                }
                if (bl == this.plotterMoveState) break;
                this.plotterMoveState = bl;
                if (!bl) break;
                int n7 = n5 = (n6 & 1) != 0 ? 1 : -1;
                if ((n6 & 2) != 0) {
                    this.plotter.movePen(0, n5);
                    break;
                }
                this.plotter.movePen(n5, 0);
                break;
            }
            case 138: 
            case 142: {
                this.pio88.writeControlA(n2);
                break;
            }
            case 139: 
            case 143: {
                this.pio88.writeControlB(n2);
                break;
            }
            case 144: 
            case 148: {
                this.pio90.writeDataA(n2);
                this.pio90.putInValuePortB(this.getKeyboardRowValue(), 255);
                break;
            }
            case 145: 
            case 149: {
                this.pio90.writeDataB(n2);
                this.pio90.putInValuePortA(this.getKeyboardColValue(), 255);
                break;
            }
            case 146: 
            case 150: {
                this.pio90.writeControlA(n2);
                break;
            }
            case 147: 
            case 151: {
                this.pio90.writeControlB(n2);
                break;
            }
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: {
                if (this.fdc != null) {
                    boolean bl;
                    boolean bl4;
                    boolean bl5 = bl4 = (n2 & 0x10) != 0;
                    if (bl4 && bl4 != this.fdcTC) {
                        this.fdc.fireTC();
                    }
                    boolean bl6 = bl = (n2 & 0x20) != 0;
                    if (bl && bl != this.fdcReset) {
                        this.fdc.reset(false);
                    }
                    this.fdcTC = bl4;
                    this.fdcReset = bl;
                    break;
                }
                if (!this.c80Enabled || (n & 0xFE) != 160) break;
                this.c80MemSwap = (n & 1) != 0;
                break;
            }
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: {
                if (this.ctcA8 != null) {
                    this.ctcA8.write(n & 3, n2, n3);
                    break;
                }
                if (!this.c80Enabled || (n & 0xFE) != 168) break;
                this.upd80CharsMode((n & 1) != 0);
                break;
            }
            case 176: 
            case 180: {
                if (this.sioB0 == null) break;
                this.sioB0.writeDataA(n2);
                break;
            }
            case 177: 
            case 181: {
                if (this.sioB0 == null) break;
                this.sioB0.writeDataB(n2);
                break;
            }
            case 178: 
            case 182: {
                if (this.sioB0 == null) break;
                this.sioB0.writeControlA(n2);
                break;
            }
            case 179: 
            case 183: {
                if (this.sioB0 == null) break;
                this.sioB0.writeControlB(n2);
                break;
            }
            case 184: {
                if (this.ramPixel == null) break;
                boolean bl = this.graphMode;
                if (this.graphType == 1) {
                    this.graphBgColor = n2 & 7;
                    this.graphFgColor = n2 >> 4 & 7;
                    this.graphBorder = (n2 & 0x80) != 0;
                    bl = (n2 & 8) != 0;
                    this.screenFrm.setScreenDirty(true);
                } else if (this.graphType == 2) {
                    this.graphBank = n2 & 7;
                    bl = (n2 & 8) != 0;
                    this.screenFrm.setScreenDirty(true);
                }
                if (bl == this.graphMode) break;
                this.graphMode = bl;
                this.screenFrm.fireUpdScreenTextActionsEnabled();
                break;
            }
            case 185: {
                if (this.ramPixel == null || this.graphType != 1) break;
                this.graphAddrL = n2 & 0xFF;
                break;
            }
            case 186: {
                int n8;
                if (this.ramPixel == null || this.graphType != 1 || (n8 = n & 0xFF00 | this.graphAddrL) < 0 || n8 >= this.ramPixel.length) break;
                this.ramPixel[n8] = (byte)n2;
                this.screenFrm.setScreenDirty(true);
                break;
            }
            case 187: {
                if (this.fontBytes == null) break;
                if (this.fontOffs > 0) {
                    this.fontOffs = 0;
                    break;
                }
                if (this.fontBytes.length <= 2048) break;
                this.fontOffs = 2048;
                break;
            }
            case 188: {
                if (!this.c80Enabled) break;
                this.upd80CharsMode(false);
                break;
            }
            case 189: {
                if (!this.c80Enabled) break;
                this.upd80CharsMode(true);
                break;
            }
            case 190: {
                if (!this.c80Enabled) break;
                this.c80MemSwap = false;
                break;
            }
            case 191: {
                if (!this.c80Enabled) break;
                this.c80MemSwap = true;
                break;
            }
            case 192: 
            case 193: 
            case 194: 
            case 195: {
                if (this.kcNet == null) break;
                this.kcNet.write(n, n2);
                break;
            }
            case 220: 
            case 221: 
            case 222: 
            case 223: {
                if (this.vdip == null) break;
                this.vdip.write(n, n2);
                break;
            }
            case 255: {
                this.megaROMSeg = n2 & 0xFF;
                break;
            }
            default: {
                if (this.gide != null && (n & 0xF0) == 80) {
                    this.gide.write(n, n2);
                    break;
                }
                if (this.rtc == null || (n & 0xF0) != 96) break;
                this.rtc.write(n, n2);
            }
        }
    }

    @Override
    public void writeMemByte(int n, int n2) {
        if (this.ramFont != null) {
            switch (n) {
                case 60412: {
                    this.ramFontActive = false;
                    this.ramFontEnabled = true;
                    this.screenFrm.setScreenDirty(true);
                    break;
                }
                case 60414: {
                    this.ramFontActive = true;
                    this.ramFontEnabled = false;
                    this.screenFrm.setScreenDirty(true);
                    break;
                }
                case 60415: {
                    this.ramFontActive = false;
                    this.ramFontEnabled = false;
                    this.screenFrm.setScreenDirty(true);
                }
            }
        }
        if (n >= 63488) {
            this.romModuleEnabled = (n & 0x400) == 0;
        }
        this.setMemByteInternal(n, n2, true);
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        super.z80MaxSpeedChanged(z80CPU);
        int n = z80CPU.getMaxSpeedKHz();
        this.tStatesPerLine = n * 20 / 312;
        this.tStatesVisible = Math.round(this.tStatesPerLine / 2);
        if (this.fdc != null) {
            this.fdc.setTStatesPerMilli(n);
        }
        if (this.kcNet != null) {
            this.kcNet.z80MaxSpeedChanged(z80CPU);
        }
    }

    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        super.z80TStatesProcessed(z80CPU, n);
        this.ctc80.z80TStatesProcessed(z80CPU, n);
        if (this.ctcA8 != null) {
            this.ctcA8.z80TStatesProcessed(z80CPU, n);
        }
        if (this.fdc != null) {
            this.fdc.z80TStatesProcessed(z80CPU, n);
        }
        if (this.kcNet != null) {
            this.kcNet.z80TStatesProcessed(z80CPU, n);
        }
        if (this.emuThread.readTapeInPhase() != this.tapeInPhase) {
            this.tapeInPhase = !this.tapeInPhase;
            this.pio88.strobePortA();
        }
        if (this.tStatesPerLine > 0 && this.tStatesVisible > 0) {
            this.lineTStates += n;
            if (this.lineTStates >= this.tStatesPerLine) {
                this.lineTStates %= this.tStatesPerLine;
                this.lineNum = this.lineNum < 311 ? ++this.lineNum : 0;
            }
        }
    }

    private void adjustVideoRAMAccessTStates() {
        if (this.lineNum < 192 && this.tStatesPerLine > 0 && this.tStatesVisible > 0 && this.lineTStates < this.tStatesVisible) {
            this.emuThread.getZ80CPU().addWaitStates(this.tStatesVisible - this.lineTStates);
        }
    }

    private void applyPasteFast(Properties properties) {
        this.pasteFast = EmuUtil.getBooleanProperty(properties, this.propPrefix + "paste.fast", true);
    }

    private synchronized void checkAddPCListener(Properties properties) {
        boolean bl = EmuUtil.getBooleanProperty(properties, this.propPrefix + "catch_print_calls", true);
        if (bl != this.pcListenerAdded) {
            Z80CPU z80CPU = this.emuThread.getZ80CPU();
            if (bl) {
                z80CPU.addPCListener(this, 5);
            } else {
                z80CPU.removePCListener(this);
            }
            this.pcListenerAdded = bl;
        }
    }

    private void createColors(Properties properties) {
        float f = Z9001.getBrightness(properties);
        if (f >= 0.0f && f <= 1.0f) {
            for (int i = 0; i < this.colors.length; ++i) {
                this.colors[i] = new Color(Math.round((float)basicRGBValues[i][0] * f), Math.round((float)basicRGBValues[i][1] * f), Math.round((float)basicRGBValues[i][2] * f));
            }
        }
    }

    private boolean emulates80CharsMode(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_80CHARS_ENABLED, false);
    }

    private boolean emulatesPlotter(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_PLOTTER_ENABLED, false);
    }

    private boolean emulatesRAM16K4000(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_RAM16K4000_ENABLED, false);
    }

    private boolean emulatesRAM16K8000(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_RAM16K8000_ENABLED, false);
    }

    private boolean emulatesRAM64K(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_RAM64K_ENABLED, false);
    }

    private boolean emulatesROM16K4000(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_ROM16K4000_ENABLED, false);
    }

    private boolean emulatesROM32K4000(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_ROM32K4000_ENABLED, false);
    }

    private boolean emulatesROM16K8000(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_ROM16K8000_ENABLED, false);
    }

    private boolean emulatesROM10KC000(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_ROM10KC000_ENABLED, false);
    }

    private boolean emulatesBootROM(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_ROMBOOT_ENABLED, false);
    }

    private boolean emulatesFloppyDisk(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "fdc.enabled", false);
    }

    private boolean emulatesKCNet(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "kcnet.enabled", false);
    }

    private boolean emulatesMegaROM(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "rom_mega.enabled", false);
    }

    private boolean emulatesPrinterModule(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_PRINTER_MOD_ENABLED, false);
    }

    private boolean emulatesProgrammableFont(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_FONT_PROGRAMMABLE, false);
    }

    private boolean emulatesRTC(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "rtc.enabled", false);
    }

    private boolean emulatesUSB(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "vdip.enabled", false);
    }

    private static boolean equalsROMModule(byte[] byArray, String string, Properties properties, String string2, String string3) {
        boolean bl = false;
        if (EmuUtil.getBooleanProperty(properties, string2, false)) {
            if (byArray != null && TextUtil.equals(string, EmuUtil.getProperty(properties, string3))) {
                bl = true;
            }
        } else if (byArray == null) {
            bl = true;
        }
        return bl;
    }

    private boolean getColorMode(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "color", true);
    }

    private int getGraphicType(Properties properties) {
        int n = 0;
        String string = EmuUtil.getProperty(properties, this.propPrefix + PROP_GRAPHIC_TYPE).toLowerCase();
        if (string.equals(VALUE_GRAPHIC_ROBOTRON)) {
            n = 1;
        } else if (string.equals(VALUE_GRAPHIC_KRT)) {
            n = 2;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getKeyboardColValue() {
        int n = 0;
        int n2 = ~this.pio90.fetchOutValuePortB(false);
        int n3 = 1;
        int[] nArray = this.kbMatrix;
        synchronized (this.kbMatrix) {
            for (int i = 0; i < this.kbMatrix.length; ++i) {
                if ((n2 & this.kbMatrix[i]) != 0) {
                    n |= n3;
                }
                n3 <<= 1;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if ((n2 & 0x40) != 0) {
                if ((this.joy0ActionMask & 1) != 0) {
                    n |= 1;
                }
                if ((this.joy0ActionMask & 2) != 0) {
                    n |= 2;
                }
                if ((this.joy0ActionMask & 8) != 0) {
                    n |= 4;
                }
                if ((this.joy0ActionMask & 4) != 0) {
                    n |= 8;
                }
                if ((this.joy0ActionMask & 0x30) != 0) {
                    n |= 0x10;
                }
            }
            if ((n2 & 0x80) != 0) {
                if ((this.joy1ActionMask & 1) != 0) {
                    n |= 1;
                }
                if ((this.joy1ActionMask & 2) != 0) {
                    n |= 2;
                }
                if ((this.joy1ActionMask & 8) != 0) {
                    n |= 4;
                }
                if ((this.joy1ActionMask & 4) != 0) {
                    n |= 8;
                }
                if ((this.joy1ActionMask & 0x30) != 0) {
                    n |= 0x10;
                }
            }
            return ~n & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getKeyboardRowValue() {
        int n = ~this.pio90.fetchOutValuePortA(false);
        int n2 = 0;
        int n3 = 1;
        int[] nArray = this.kbMatrix;
        synchronized (this.kbMatrix) {
            for (int i = 0; i < this.kbMatrix.length; ++i) {
                if ((n & n3) != 0) {
                    n2 |= this.kbMatrix[i];
                }
                n3 <<= 1;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if ((n & 1) != 0) {
                if ((this.joy0ActionMask & 1) != 0) {
                    n2 |= 0x40;
                }
                if ((this.joy1ActionMask & 1) != 0) {
                    n2 |= 0x80;
                }
            }
            if ((n & 2) != 0) {
                if ((this.joy0ActionMask & 2) != 0) {
                    n2 |= 0x40;
                }
                if ((this.joy1ActionMask & 2) != 0) {
                    n2 |= 0x80;
                }
            }
            if ((n & 4) != 0) {
                if ((this.joy0ActionMask & 8) != 0) {
                    n2 |= 0x40;
                }
                if ((this.joy1ActionMask & 8) != 0) {
                    n2 |= 0x80;
                }
            }
            if ((n & 8) != 0) {
                if ((this.joy0ActionMask & 4) != 0) {
                    n2 |= 0x40;
                }
                if ((this.joy1ActionMask & 4) != 0) {
                    n2 |= 0x80;
                }
            }
            if ((n & 0x10) != 0) {
                if ((this.joy0ActionMask & 0x30) != 0) {
                    n2 |= 0x40;
                }
                if ((this.joy1ActionMask & 0x30) != 0) {
                    n2 |= 0x80;
                }
            }
            return ~n2 & 0xFF;
        }
    }

    private int getMemByteInternal(int n, boolean bl) {
        int n2;
        int n3 = 255;
        if ((n &= 0xFFFF) < 16384) {
            n3 = this.emuThread.getRAMByte(n);
        } else if (n >= 16384 && n < 32768) {
            if (this.rom16k4000 != null) {
                int n4 = n - 16384;
                if (n4 < this.rom16k4000.length) {
                    n3 = this.rom16k4000[n4] & 0xFF;
                }
            } else if (this.rom32k4000 != null) {
                int n5 = n - 16384;
                if (n5 < this.rom32k4000.length) {
                    n3 = this.rom32k4000[n5] & 0xFF;
                }
            } else if (this.ram64k) {
                if (this.ram4000ExtEnabled && this.ramExt != null) {
                    int n6 = n - 16384;
                    if (n6 < this.ramExt.length) {
                        n3 = this.ramExt[n6] & 0xFF;
                    }
                } else {
                    n3 = this.emuThread.getRAMByte(n);
                }
            } else if (this.ram16k4000) {
                n3 = this.emuThread.getRAMByte(n);
            }
        } else if (n >= 32768 && n < 49152) {
            int n7;
            if (this.rom32k4000 != null) {
                int n8 = n - 16384;
                if (n8 < this.rom32k4000.length) {
                    n3 = this.rom32k4000[n8] & 0xFF;
                }
            } else if (this.rom16k8000 != null) {
                int n9 = n - 32768;
                if (n9 < this.rom16k8000.length) {
                    n3 = this.rom16k8000[n9] & 0xFF;
                }
            } else if (this.ram16k8000 || this.ram64k) {
                n3 = this.emuThread.getRAMByte(n);
            } else if (this.printerModule && printerModBytes != null && (n7 = n - 47104) >= 0 && n7 < printerModBytes.length) {
                n3 = printerModBytes[n7] & 0xFF;
            }
        } else if (n >= 49152 && n < 59392) {
            int n10;
            if (this.ram64k && this.ramC000Enabled) {
                n3 = this.emuThread.getRAMByte(n);
            } else if (this.romModuleEnabled && this.romBoot != null) {
                int n11 = n - 49152;
                if (n11 < this.romBoot.length) {
                    n3 = this.romBoot[n11] & 0xFF;
                }
            } else if (this.romModuleEnabled && this.romMega != null) {
                int n12 = 0;
                n12 = n < 51200 ? n - 49152 + this.megaROMSeg * 2048 : (n < 53248 ? n - 51200 + (256 + this.megaROMSeg) * 2048 : (n < 55296 ? n - 53248 + (512 + this.megaROMSeg) * 2048 : (n < 57344 ? n - 55296 + (768 + this.megaROMSeg) * 2048 : n - 57344 + (1024 + this.megaROMSeg) * 2048)));
                if (n12 >= 0 && n12 < this.romMega.length) {
                    n3 = this.romMega[n12] & 0xFF;
                }
            } else if (this.rom10kC000 != null) {
                int n13 = n - 49152;
                if (n13 < this.rom10kC000.length) {
                    n3 = this.rom10kC000[n13] & 0xFF;
                }
            } else if (this.kc87 && this.romBasic != null && (n10 = n - 49152) < this.romBasic.length) {
                n3 = this.romBasic[n10] & 0xFF;
            }
        } else if (n >= 59392 && n < 60416) {
            if (this.ramFontEnabled && this.ramFont != null) {
                int n14 = n - 59392;
                if (n14 < this.ramFont.length) {
                    n3 = this.ramFont[n - 59392] & 0xFF;
                }
            } else if (this.ramColor != null) {
                n3 = this.c80MemSwap ? this.ramColor2[n - 59392] & 0xFF : this.ramColor[n - 59392] & 0xFF;
                if (bl) {
                    this.adjustVideoRAMAccessTStates();
                }
            }
        } else if (n >= 60416 && n < 61440) {
            int n15 = n - 60416;
            if (this.ramPixel != null && this.graphType == 2 && this.graphMode) {
                if ((n15 += this.graphBank * 1024) >= 0 && n15 < this.ramPixel.length) {
                    n3 = this.ramPixel[n15] & 0xFF;
                }
            } else {
                n3 = this.c80MemSwap ? this.ramVideo2[n15] & 0xFF : this.ramVideo[n15] & 0xFF;
            }
            if (bl) {
                this.adjustVideoRAMAccessTStates();
            }
        } else if (n >= 61440 && this.romOS != null && (n2 = n - 61440) < this.romOS.length) {
            n3 = this.romOS[n2] & 0xFF;
        }
        return n3;
    }

    private boolean isFixedScreenSize(Properties properties) {
        return this.c80Enabled && EmuUtil.getBooleanProperty(properties, this.propPrefix + "fixed_screen_size", false);
    }

    private void loadFont(Properties properties) {
        this.fontBytes = this.readFontByProperty(properties, this.propPrefix + "font.file", 4096);
        if (this.fontBytes == null) {
            if (this.sysName.equals(SYSNAME_KC87)) {
                if (kc87FontBytes == null) {
                    kc87FontBytes = this.readResource("/rom/z9001/kc87font.bin");
                }
                this.fontBytes = kc87FontBytes;
            } else {
                if (z9001FontBytes == null) {
                    z9001FontBytes = this.readResource("/rom/z9001/z9001font.bin");
                }
                this.fontBytes = z9001FontBytes;
            }
        }
    }

    private void loadROMs(Properties properties) {
        this.romOSFile = EmuUtil.getProperty(properties, this.propPrefix + "os.file");
        this.romOS = this.readROMFile(this.romOSFile, 4096, "Betriebssystem");
        if (this.romOS == null) {
            switch (this.sysName) {
                case "KC87": {
                    if (os13 == null) {
                        os13 = this.readResource("/rom/z9001/os13.bin");
                    }
                    this.romOS = os13;
                    break;
                }
                case "KC85_1": {
                    if (os12 == null) {
                        os12 = this.readResource("/rom/z9001/os12.bin");
                    }
                    this.romOS = os12;
                    break;
                }
                default: {
                    if (os11 == null) {
                        os11 = this.readResource("/rom/z9001/os11.bin");
                    }
                    this.romOS = os11;
                }
            }
        }
        if (this.kc87) {
            this.romBasicFile = EmuUtil.getProperty(properties, this.propPrefix + "basic." + "file");
            this.romBasic = this.readROMFile(this.romBasicFile, 10240, "BASIC");
            if (this.romBasic == null) {
                if (basic86 == null) {
                    basic86 = this.readResource("/rom/z9001/basic86.bin");
                }
                this.romBasic = basic86;
            }
        } else {
            this.romBasicFile = null;
            this.romBasic = null;
        }
        this.romModuleFile = properties.getProperty(this.propPrefix + PROP_ROM_MOD_PREFIX + "file");
        if (this.emulatesROM16K4000(properties)) {
            this.rom16k4000 = this.readROMFile(this.romModuleFile, 16384, "ROM-Modul 4000h-7FFFh");
        } else if (this.emulatesROM32K4000(properties)) {
            this.rom32k4000 = this.readROMFile(this.romModuleFile, 32768, "ROM-Modul 4000h-BFFFh");
        } else if (this.emulatesROM16K8000(properties)) {
            this.rom16k8000 = this.readROMFile(this.romModuleFile, 16384, "ROM-Modul 8000h-BFFFh");
        } else if (this.emulatesROM10KC000(properties)) {
            this.rom10kC000 = this.readROMFile(this.romModuleFile, 16384, "ROM-Modul C000h-E7FFh");
        } else if (this.emulatesBootROM(properties)) {
            this.romBoot = this.readROMFile(this.romModuleFile, 16384, "Boot-ROM-Modul");
            if (this.romBoot == null) {
                if (bootROMBytes == null) {
                    bootROMBytes = this.readResource("/rom/z9001/bootrom.bin");
                }
                this.romBoot = bootROMBytes;
            }
        } else if (this.emulatesMegaROM(properties)) {
            this.romMega = this.readROMFile(this.romModuleFile, 0x280000, "Mega-ROM-Modul");
            if (this.romMega == null) {
                if (megaROMBytes == null) {
                    megaROMBytes = this.readResource("/rom/z9001/megarom.bin.gz");
                }
                this.romMega = megaROMBytes;
            }
        }
        this.loadFont(properties);
    }

    private void putKeyboardMatrixValuesToPorts() {
        this.pio90.putInValuePortB(this.getKeyboardRowValue(), 255);
        this.pio90.putInValuePortA(this.getKeyboardColValue(), 255);
    }

    private boolean setCharInKBMatrix(int n, int[][] nArray) {
        boolean bl = false;
        int n2 = 1;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length && j < this.kbMatrix.length; ++j) {
                if (nArray[i][j] != n) continue;
                this.kbMatrix[j] = n2;
                bl = true;
                break;
            }
            n2 <<= 1;
        }
        return bl;
    }

    private void setGraphicLED(boolean bl) {
        if (bl != this.graphicLED) {
            this.graphicLED = bl;
            if (this.keyboardFld != null) {
                this.keyboardFld.repaint();
            }
        }
    }

    private boolean setMemByteInternal(int n, int n2, boolean bl) {
        boolean bl2 = false;
        if ((n &= 0xFFFF) < 16384) {
            this.emuThread.setRAMByte(n, n2);
            bl2 = true;
        } else if (n >= 16384 && n < 32768) {
            if (this.rom16k4000 == null && this.rom32k4000 == null) {
                if (this.ram64k) {
                    if (this.ram4000ExtEnabled && this.ramExt != null) {
                        int n3 = n - 16384;
                        if (n3 < this.ramExt.length) {
                            this.ramExt[n3] = (byte)n2;
                            bl2 = true;
                        }
                    } else {
                        this.emuThread.setRAMByte(n, n2);
                        bl2 = true;
                    }
                } else if (this.ram16k4000) {
                    this.emuThread.setRAMByte(n, n2);
                    bl2 = true;
                }
            }
        } else if (n >= 32768 && n < 49152) {
            if (this.rom32k4000 == null && this.rom16k8000 == null && (this.ram16k8000 || this.ram64k)) {
                this.emuThread.setRAMByte(n, n2);
                bl2 = true;
            }
        } else if (n >= 49152 && n < 59392) {
            if (this.ram64k && this.ramC000Enabled) {
                this.emuThread.setRAMByte(n, n2);
                bl2 = true;
            }
        } else if (n >= 59392 && n < 60416) {
            int n4 = n - 59392;
            if (this.ramFontEnabled && this.ramFont != null) {
                if (n4 < this.ramFont.length) {
                    this.ramFont[n4] = (byte)n2;
                    bl2 = true;
                }
            } else if (this.ramColor != null) {
                if (this.c80MemSwap) {
                    this.ramColor2[n4] = (byte)n2;
                } else {
                    this.ramColor[n4] = (byte)n2;
                }
                this.screenFrm.setScreenDirty(true);
                bl2 = true;
                if (bl) {
                    this.adjustVideoRAMAccessTStates();
                }
            }
        } else if (n >= 60416 && n < 61440) {
            int n5 = n - 60416;
            if (this.ramPixel != null && this.graphType == 2 && this.graphMode) {
                if ((n5 += this.graphBank * 1024) >= 0 && n5 < this.ramPixel.length) {
                    this.ramPixel[n5] = (byte)n2;
                    this.screenFrm.setScreenDirty(true);
                    bl2 = true;
                }
            } else {
                if (this.c80MemSwap) {
                    this.ramVideo2[n5] = (byte)n2;
                } else {
                    this.ramVideo[n5] = (byte)n2;
                }
                this.screenFrm.setScreenDirty(true);
                bl2 = true;
            }
            if (bl) {
                this.adjustVideoRAMAccessTStates();
            }
        }
        return bl2;
    }

    private void upd80CharsMode(boolean bl) {
        if (this.c80Active != bl) {
            this.c80Active = bl;
            this.screenFrm.setScreenDirty(true);
            if (!this.fixedScreenSize) {
                this.screenFrm.fireScreenSizeChanged();
            }
        }
    }

    private void updKeyboardFld() {
        if (this.keyboardFld != null) {
            this.keyboardFld.updKeySelection(this.kbMatrix);
        }
    }

    private void updLoudspeaker(int n) {
        this.soundOutPhase = this.tapeOutPhase || (n & 0x80) == 0;
    }

    private void updScreenConfig(int n) {
        boolean bl = (n & 4) != 0;
        int n2 = n >> 3 & 7;
        if (bl != this.mode20Rows || n2 != this.borderColorIdx) {
            this.mode20Rows = bl;
            this.borderColorIdx = n2;
            this.screenFrm.setScreenDirty(true);
        }
    }
}

