/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.Properties;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.emusys.etc.VCS80KeyboardFld;
import z80emu.Z80AddressListener;
import z80emu.Z80CPU;
import z80emu.Z80PIO;

public class VCS80
extends EmuSys
implements Z80AddressListener {
    public static final String SYSNAME = "VCS80";
    public static final String PROP_PREFIX = "jkcemu.vcs80.";
    private static final int[][] kbMatrix = new int[][]{{55, 54, 53, 52, 51, 50, 49, 48}, {70, 69, 68, 67, 66, 65, 57, 56}, {80, 83, 84, 71, 82, 77, 45, 43}};
    private static byte[] mon = null;
    private VCS80KeyboardFld keyboardFld;
    private int[] keyboardMatrix;
    private int[] digitValues;
    private byte[] ram;
    private int colValue;
    private boolean curDispCycleState;
    private long curDispTStates;
    private long dispHCycleTStates;
    private Z80PIO pio;

    public VCS80(EmuThread emuThread, Properties properties) {
        super(emuThread, properties, PROP_PREFIX);
        if (mon == null) {
            mon = this.readResource("/rom/vcs80/vcs80mon.bin");
        }
        this.ram = new byte[1024];
        this.curDispCycleState = false;
        this.curDispTStates = 0L;
        this.dispHCycleTStates = 0L;
        this.colValue = 0;
        this.keyboardFld = null;
        this.keyboardMatrix = new int[8];
        this.digitValues = new int[9];
        Z80CPU z80CPU = emuThread.getZ80CPU();
        this.pio = new Z80PIO("PIO");
        z80CPU.setInterruptSources(this.pio);
        z80CPU.addAddressListener(this);
        z80CPU.addMaxSpeedListener(this);
        z80CPU.addTStatesListener(this);
        this.z80MaxSpeedChanged(z80CPU);
    }

    public static int getDefaultSpeedKHz() {
        return 2500;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updKeyboardMatrix(int[] nArray) {
        int[] nArray2 = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            int n;
            int n2 = Math.min(nArray.length, this.keyboardMatrix.length);
            for (n = 0; n < n2; ++n) {
                this.keyboardMatrix[n] = nArray[n];
            }
            while (n < this.keyboardMatrix.length) {
                this.keyboardMatrix[n] = 0;
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void z80AddressChanged(int n) {
        this.pio.putInValuePortB(n << 7 & 0x80, 128);
    }

    @Override
    public boolean canApplySettings(Properties properties) {
        return EmuUtil.getProperty(properties, "jkcemu.system").equals(SYSNAME);
    }

    @Override
    public AbstractKeyboardFld createKeyboardFld() {
        this.keyboardFld = new VCS80KeyboardFld(this);
        return this.keyboardFld;
    }

    @Override
    public void die() {
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        z80CPU.removeTStatesListener(this);
        z80CPU.removeMaxSpeedListener(this);
        z80CPU.removeAddressListener(this);
        z80CPU.setInterruptSources(null);
    }

    @Override
    public int getAppStartStackInitValue() {
        return 2016;
    }

    @Override
    public Color getColor(int n) {
        Color color = Color.black;
        switch (n) {
            case 1: {
                color = this.colorRedDark;
                break;
            }
            case 2: {
                color = this.colorRedLight;
            }
        }
        return color;
    }

    @Override
    public int getColorCount() {
        return 3;
    }

    @Override
    public String getHelpPage() {
        return "/help/vcs80.htm";
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        int n2 = 255;
        if ((n &= 0xFFFF) < 1024 && mon != null) {
            if ((n &= 0x1FF) < mon.length) {
                n2 = mon[n] & 0xFF;
            }
        } else {
            int n3 = n - 1024;
            if (n3 >= 0 && n3 < this.ram.length) {
                n2 = this.ram[n3] & 0xFF;
            }
        }
        return n2;
    }

    @Override
    public int getScreenHeight() {
        return 85;
    }

    @Override
    public int getScreenWidth() {
        return this.digitValues.length * 65 - 15;
    }

    @Override
    public String getTitle() {
        return SYSNAME;
    }

    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (n == 27) {
            this.emuThread.fireReset(EmuThread.ResetLevel.WARM_RESET);
            bl3 = true;
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased() {
        int[] nArray = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            Arrays.fill(this.keyboardMatrix, 0);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.updKeyboardFld();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean keyTyped(char c) {
        boolean bl = false;
        if (c > '\u0000') {
            int[] nArray = this.keyboardMatrix;
            // MONITORENTER : this.keyboardMatrix
            char c2 = Character.toUpperCase(c);
            int n = 16;
            for (int i = 0; !bl && i < kbMatrix.length; n <<= 1, ++i) {
                for (int j = 0; !bl && j < kbMatrix[i].length; ++j) {
                    if (c2 != kbMatrix[i][j]) continue;
                    int n2 = j;
                    this.keyboardMatrix[n2] = this.keyboardMatrix[n2] | n;
                    bl = true;
                }
            }
            // MONITOREXIT : nArray
        }
        if (!bl) return bl;
        this.updKeyboardFld();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean paintScreen(Graphics graphics, int n, int n2, int n3) {
        int[] nArray = this.digitValues;
        synchronized (this.digitValues) {
            for (int i = this.digitValues.length - 1; i >= 0; --i) {
                VCS80.paint7SegDigit(graphics, n, n2, this.digitValues[i], this.colorRedDark, this.colorRedLight, n3);
                n += 65 * n3;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return true;
        }
    }

    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 255;
        switch (n & 7) {
            case 4: {
                n3 = this.pio.readControlB();
                break;
            }
            case 5: {
                n3 = this.pio.readControlA();
                break;
            }
            case 6: {
                n3 = this.pio.readDataB();
                break;
            }
            case 7: {
                n3 = this.pio.readDataA();
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        super.reset(resetLevel, properties);
        if (resetLevel == EmuThread.ResetLevel.POWER_ON) {
            this.initSRAM(this.ram, properties);
        }
        int[] nArray = this.digitValues;
        synchronized (this.digitValues) {
            Arrays.fill(this.digitValues, 0);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            nArray = this.keyboardMatrix;
            synchronized (this.keyboardMatrix) {
                Arrays.fill(this.keyboardMatrix, 0);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        int n3;
        boolean bl = false;
        if ((n &= 0xFFFF) >= 1024 && (n3 = n - 1024) < this.ram.length) {
            this.ram[n3] = (byte)n2;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean supportsKeyboardFld() {
        return true;
    }

    @Override
    public void writeIOByte(int n, int n2, int n3) {
        switch (n & 7) {
            case 4: {
                this.pio.writeControlB(n2);
                break;
            }
            case 5: {
                this.pio.writeControlA(n2);
                break;
            }
            case 6: {
                this.pio.writeDataB(n2);
                break;
            }
            case 7: {
                this.pio.writeDataA(n2);
            }
        }
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        super.z80MaxSpeedChanged(z80CPU);
        this.dispHCycleTStates = z80CPU.getMaxSpeedKHz() / 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        int n2;
        super.z80TStatesProcessed(z80CPU, n);
        long l = this.dispHCycleTStates;
        if (l <= 0L) return;
        this.curDispTStates += (long)n;
        if (this.curDispTStates <= l) return;
        this.curDispTStates = 0L;
        boolean bl = this.curDispCycleState = !this.curDispCycleState;
        if (this.curDispCycleState) {
            n2 = 0;
            int n3 = this.toDigitValue(this.pio.fetchOutValuePortB(false) & 0x7F);
            int[] nArray = this.digitValues;
            // MONITORENTER : this.digitValues
            int n4 = this.colValue;
            if (n4 >= 4) {
                ++n4;
            }
            if (n4 < this.digitValues.length && n3 != this.digitValues[n4]) {
                this.digitValues[n4] = n3;
                n2 = 1;
            }
            // MONITOREXIT : nArray
            if (n2 != 0) {
                this.screenFrm.setScreenDirty(true);
            }
            this.colValue = this.colValue + 1 & 7;
        }
        n2 = 0x70 | this.colValue;
        int[] nArray = this.keyboardMatrix;
        // MONITORENTER : this.keyboardMatrix
        int n5 = ~this.colValue & 7;
        if (n5 < this.keyboardMatrix.length) {
            n2 &= ~this.keyboardMatrix[n5];
        }
        // MONITOREXIT : nArray
        if (this.curDispCycleState) {
            n2 |= 0x80;
        }
        this.pio.putInValuePortA(n2, 255);
    }

    private int toDigitValue(int n) {
        int n2 = n & 0x1F;
        if ((n & 0x20) != 0) {
            n2 |= 0x40;
        }
        if ((n & 0x40) != 0) {
            n2 |= 0x20;
        }
        return n2;
    }

    private void updKeyboardFld() {
        if (this.keyboardFld != null) {
            this.keyboardFld.updKeySelection(this.keyboardMatrix);
        }
    }
}

