/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys;

import java.awt.Color;
import java.awt.Graphics;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.Properties;
import jkcemu.Main;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.AbstractScreenFrm;
import jkcemu.base.EmuMemView;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.SaveDlg;
import jkcemu.base.SourceUtil;
import jkcemu.emusys.llc1.LLC1AlphaScreenDevice;
import jkcemu.emusys.llc1.LLC1KeyboardFld;
import z80emu.Z80CPU;
import z80emu.Z80CTC;
import z80emu.Z80PIO;

public class LLC1
extends EmuSys {
    public static final String SYSNAME = "LLC1";
    public static final String PROP_PREFIX = "jkcemu.llc1.";
    public static final int DEFAULT_PROMPT_AFTER_RESET_MILLIS_MAX = 500;
    public static final boolean DEFAULT_SWAP_KEY_CHAR_CASE = true;
    private static final int DISPLAY_DISTANCE = 30;
    private static final int PASTE_READS_PER_CHAR = 10;
    private static byte[] rom0000 = null;
    private static byte[] rom0800 = null;
    private static byte[] romFont = null;
    private byte[] ramStatic;
    private byte[] ramVideo;
    private LLC1AlphaScreenDevice alphaScreenDevice;
    private LLC1KeyboardFld keyboardFld;
    private int[] keyboardMatrix;
    private int[] digitStatus;
    private int[] digitValues;
    private int digitIdx;
    private int keyChar;
    private volatile int pasteReadCharCounter;
    private volatile int pasteReadPauseCounter;
    private int alphaScreenEnableTStates;
    private boolean alphaScreenFired;
    private boolean pio1B7Value;
    private long curDisplayTStates;
    private long displayCheckTStates;
    private Z80CTC ctc;
    private Z80PIO pio1;
    private Z80PIO pio2;

    public LLC1(EmuThread emuThread, Properties properties) {
        super(emuThread, properties, PROP_PREFIX);
        if (rom0000 == null) {
            rom0000 = this.readResource("/rom/llc1/llc1mon.bin");
        }
        if (rom0800 == null) {
            rom0800 = this.readResource("/rom/llc1/tinybasic.bin");
        }
        if (romFont == null) {
            romFont = this.readResource("/rom/llc1/llc1font.bin");
        }
        this.ramStatic = new byte[2048];
        this.ramVideo = new byte[1024];
        this.pasteReadCharCounter = 0;
        this.pasteReadPauseCounter = 0;
        this.alphaScreenEnableTStates = 0;
        this.alphaScreenFired = false;
        this.alphaScreenDevice = null;
        this.keyboardFld = null;
        this.keyboardMatrix = new int[4];
        this.digitStatus = new int[8];
        this.digitValues = new int[8];
        this.digitIdx = 0;
        this.displayCheckTStates = 0L;
        this.curDisplayTStates = 0L;
        Z80CPU z80CPU = emuThread.getZ80CPU();
        this.ctc = new Z80CTC("CTC");
        this.pio1 = new Z80PIO("PIO 1");
        this.pio2 = new Z80PIO("PIO 2");
        z80CPU.setInterruptSources(this.ctc, this.pio2);
        z80CPU.addMaxSpeedListener(this);
        z80CPU.addTStatesListener(this);
        this.z80MaxSpeedChanged(z80CPU);
    }

    public void cancelPastingAlphaText() {
        this.pasteIter = null;
    }

    public byte[] getAlphaScreenFontBytes() {
        return romFont;
    }

    public static String getBasicProgram(EmuMemView emuMemView) {
        return SourceUtil.getTinyBasicProgram(emuMemView, 5454, emuMemView.getMemWord(5147));
    }

    public static int getDefaultSpeedKHz() {
        return 2000;
    }

    public void putAlphaKeyChar(int n) {
        this.keyChar = n;
    }

    public void startPastingAlphaText(String string) {
        if (string != null && !string.isEmpty()) {
            this.pasteIter = new StringCharacterIterator(string);
            this.pasteReadCharCounter = 0;
            this.pasteReadPauseCounter = 10;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updKeyboardMatrix(int[] nArray) {
        boolean bl = false;
        int[] nArray2 = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            int n;
            int n2 = Math.min(nArray.length, this.keyboardMatrix.length);
            for (n = 0; n < n2; ++n) {
                if ((~this.keyboardMatrix[n] & nArray[n]) != 0) {
                    bl = true;
                }
                this.keyboardMatrix[n] = nArray[n];
            }
            while (n < this.keyboardMatrix.length) {
                this.keyboardMatrix[n] = 0;
                ++n;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (bl) {
                this.ctc.externalUpdate(3, 1);
            }
            return;
        }
    }

    @Override
    public boolean canApplySettings(Properties properties) {
        return EmuUtil.getProperty(properties, "jkcemu.system").equals(SYSNAME);
    }

    @Override
    public AbstractKeyboardFld createKeyboardFld() {
        this.keyboardFld = new LLC1KeyboardFld(this);
        return this.keyboardFld;
    }

    @Override
    public void die() {
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        z80CPU.removeTStatesListener(this);
        z80CPU.removeMaxSpeedListener(this);
        z80CPU.setInterruptSources(null);
    }

    @Override
    public int getAppStartStackInitValue() {
        return 7168;
    }

    @Override
    public Color getColor(int n) {
        Color color = Color.black;
        switch (n) {
            case 1: {
                color = this.colorWhite;
                break;
            }
            case 2: {
                color = this.colorRedDark;
                break;
            }
            case 3: {
                color = this.colorRedLight;
            }
        }
        return color;
    }

    @Override
    public int getColorCount() {
        return 4;
    }

    @Override
    protected long getDelayMillisAfterPasteChar() {
        return 50L;
    }

    @Override
    protected long getDelayMillisAfterPasteEnter() {
        return 150L;
    }

    @Override
    protected long getHoldMillisPasteChar() {
        return 50L;
    }

    @Override
    public String getHelpPage() {
        return "/help/llc1.htm";
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        int n2;
        int n3 = 255;
        if ((n &= 0xFFFF) < 2048 && rom0000 != null) {
            if (n < rom0000.length) {
                n3 = rom0000[n] & 0xFF;
            }
        } else if (n >= 2048 && n < 5120 && rom0800 != null) {
            int n4 = n - 2048;
            if (n4 < rom0800.length) {
                n3 = rom0800[n4] & 0xFF;
            }
        } else if (n >= 5120 && n < 7168) {
            int n5 = n - 5120;
            if (n5 < this.ramStatic.length) {
                n3 = this.ramStatic[n5] & 0xFF;
            }
        } else if (n >= 7168 && n < 8192 && (n2 = n - 7168) < this.ramVideo.length) {
            n3 = this.ramVideo[n2] & 0xFF;
        }
        return n3;
    }

    @Override
    public int getResetStartAddress(EmuThread.ResetLevel resetLevel) {
        return 0;
    }

    @Override
    public int getScreenHeight() {
        return 85;
    }

    @Override
    public int getScreenWidth() {
        return this.digitValues.length * 65 - 15;
    }

    @Override
    public String getTitle() {
        return SYSNAME;
    }

    @Override
    public LLC1AlphaScreenDevice getSecondScreenDevice() {
        if (this.alphaScreenDevice == null) {
            this.alphaScreenDevice = new LLC1AlphaScreenDevice(this, Main.getProperties());
        }
        return this.alphaScreenDevice;
    }

    @Override
    public boolean getSwapKeyCharCase() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        switch (n) {
            case 10: {
                int[] nArray = this.keyboardMatrix;
                synchronized (this.keyboardMatrix) {
                    this.keyboardMatrix[2] = 130;
                    this.ctc.externalUpdate(3, 1);
                    this.updKeyboardFld();
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return true;
                }
            }
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased() {
        int[] nArray = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            Arrays.fill(this.keyboardMatrix, 0);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.updKeyboardFld();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyTyped(char c) {
        boolean bl = false;
        int[] nArray = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': {
                    this.keyboardMatrix[c - 48] = 1;
                    bl = true;
                    break;
                }
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    this.keyboardMatrix[c - 52] = 2;
                    bl = true;
                    break;
                }
                case '8': 
                case '9': {
                    this.keyboardMatrix[c - 56] = 4;
                    bl = true;
                    break;
                }
                case 'A': 
                case 'a': {
                    this.keyboardMatrix[2] = 4;
                    bl = true;
                    break;
                }
                case 'B': 
                case 'b': {
                    this.keyboardMatrix[3] = 4;
                    bl = true;
                    break;
                }
                case 'C': 
                case 'c': {
                    this.keyboardMatrix[0] = 129;
                    bl = true;
                    break;
                }
                case 'D': 
                case 'd': {
                    this.keyboardMatrix[1] = 129;
                    bl = true;
                    break;
                }
                case 'E': 
                case 'e': {
                    this.keyboardMatrix[2] = 129;
                    bl = true;
                    break;
                }
                case 'F': 
                case 'f': {
                    this.keyboardMatrix[3] = 129;
                    bl = true;
                    break;
                }
                case 'R': {
                    this.keyboardMatrix[0] = 130;
                    bl = true;
                    break;
                }
                case 'M': {
                    this.keyboardMatrix[1] = 130;
                    bl = true;
                    break;
                }
                case 'X': {
                    this.keyboardMatrix[2] = 130;
                    bl = true;
                    break;
                }
                case 'S': {
                    this.keyboardMatrix[0] = 132;
                    bl = true;
                    break;
                }
                case 'G': 
                case 'J': {
                    this.keyboardMatrix[1] = 132;
                    bl = true;
                    break;
                }
                case 'H': {
                    this.keyboardMatrix[2] = 132;
                    bl = true;
                }
            }
            if (bl) {
                this.ctc.externalUpdate(3, 1);
                this.updKeyboardFld();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return bl;
        }
    }

    @Override
    public void openBasicProgram() {
        String string = LLC1.getBasicProgram(this.emuThread);
        if (string != null) {
            this.screenFrm.openText(string);
        } else {
            this.showNoBasic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean paintScreen(Graphics graphics, int n, int n2, int n3) {
        int[] nArray = this.digitValues;
        synchronized (this.digitValues) {
            for (int i = 0; i < this.digitValues.length; ++i) {
                LLC1.paint7SegDigit(graphics, n, n2, this.digitStatus[i] > 0 ? this.digitValues[i] : 0, this.colorRedDark, this.colorRedLight, n3);
                n += 65 * n3;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 255;
        if ((n & 4) == 0) {
            n3 &= this.ctc.read(n & 3, n2);
        } else if ((n & 8) == 0) {
            switch (n & 3) {
                case 0: {
                    int[] nArray = this.keyboardMatrix;
                    synchronized (this.keyboardMatrix) {
                        this.pio1.putInValuePortA(this.getHexKeyMatrixValue(), 143);
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        n3 &= this.pio1.readDataA();
                        break;
                    }
                }
                case 1: {
                    n3 &= this.pio1.readDataB();
                    break;
                }
                case 2: {
                    n3 &= this.pio1.readControlA();
                    break;
                }
                case 3: {
                    n3 &= this.pio1.readControlB();
                }
            }
        } else if ((n & 0x10) == 0) {
            switch (n & 3) {
                case 0: {
                    n3 &= this.pio2.readDataA();
                    break;
                }
                case 1: {
                    CharacterIterator characterIterator;
                    int n4 = this.keyChar;
                    if (n4 == 0 && (characterIterator = this.pasteIter) != null) {
                        if (this.pasteReadPauseCounter > 0) {
                            --this.pasteReadPauseCounter;
                            if (this.pasteReadPauseCounter == 0) {
                                this.pasteReadCharCounter = 10;
                            }
                        } else {
                            n4 = characterIterator.current();
                            if (n4 == 65535) {
                                AbstractScreenFrm abstractScreenFrm;
                                this.pasteIter = null;
                                this.pasteReadCharCounter = 0;
                                this.pasteReadPauseCounter = 0;
                                if (this.alphaScreenDevice != null && (abstractScreenFrm = this.alphaScreenDevice.getScreenFrm()) != null) {
                                    abstractScreenFrm.firePastingTextFinished();
                                }
                                n4 = 0;
                            } else if (this.pasteReadCharCounter > 0) {
                                --this.pasteReadCharCounter;
                            } else {
                                characterIterator.next();
                                this.pasteReadPauseCounter = 10;
                            }
                        }
                    }
                    this.pio2.putInValuePortB(n4 > 0 ? LLC1.toLLC1Char(n4) : 255, false);
                    n3 &= this.pio2.readDataB();
                    break;
                }
                case 2: {
                    n3 &= this.pio2.readControlA();
                    break;
                }
                case 3: {
                    n3 &= this.pio2.readControlB();
                }
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        super.reset(resetLevel, properties);
        if (resetLevel == EmuThread.ResetLevel.POWER_ON) {
            this.initSRAM(this.ramStatic, properties);
            this.fillRandom(this.ramVideo);
        }
        if (resetLevel == EmuThread.ResetLevel.POWER_ON || resetLevel == EmuThread.ResetLevel.COLD_RESET) {
            this.ctc.reset(true);
            this.pio1.reset(true);
            this.pio2.reset(true);
        } else {
            this.ctc.reset(false);
            this.pio1.reset(false);
            this.pio2.reset(false);
        }
        int[] nArray = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            Arrays.fill(this.keyboardMatrix, 0);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            nArray = this.digitValues;
            synchronized (this.digitValues) {
                Arrays.fill(this.digitStatus, 0);
                Arrays.fill(this.digitValues, 0);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                this.keyChar = 0;
                this.alphaScreenEnableTStates = LLC1.getDefaultSpeedKHz() * 200;
                this.pio1B7Value = false;
                return;
            }
        }
    }

    @Override
    public void saveBasicProgram() {
        int n = this.emuThread.getMemWord(5147);
        if (n > 5454 && this.emuThread.getMemByte(n - 1, false) == 13) {
            new SaveDlg(this.screenFrm, 5120, n, "LLC1-BASIC-Programm speichern", SaveDlg.BasicType.TINYBASIC, null).setVisible(true);
        } else {
            this.showNoBasic();
        }
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        int n3;
        boolean bl = false;
        if ((n &= 0xFFFF) < 2048 && rom0000 != null) {
            if (n < rom0000.length) {
                bl = true;
            }
        } else if (n >= 2048 && n < 5120 && rom0800 != null) {
            int n4 = n - 2048;
            if (n4 < rom0800.length) {
                bl = true;
            }
        } else if (n >= 5120 && n < 7168) {
            int n5 = n - 5120;
            if (n5 < this.ramStatic.length) {
                this.ramStatic[n5] = (byte)n2;
                bl = true;
            }
        } else if (n >= 7168 && n < 8192 && (n3 = n - 7168) < this.ramVideo.length) {
            this.ramVideo[n3] = (byte)n2;
            if (this.alphaScreenDevice != null) {
                this.alphaScreenDevice.setScreenDirty(true);
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean supportsKeyboardFld() {
        return true;
    }

    @Override
    public boolean supportsOpenBasic() {
        return true;
    }

    @Override
    public boolean supportsSaveBasic() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeIOByte(int n, int n2, int n3) {
        if ((n & 4) == 0) {
            this.ctc.write(n & 3, n2, n3);
        } else if ((n & 8) == 0) {
            switch (n & 3) {
                case 0: {
                    this.pio1.writeDataA(n2);
                    break;
                }
                case 1: {
                    int n4;
                    boolean bl;
                    boolean bl2 = this.pio1.isReadyPortB();
                    this.pio1.writeDataB(n2);
                    if (!bl2 && this.pio1.isReadyPortB()) {
                        this.digitIdx = this.digitIdx + 1 & 7;
                    }
                    boolean bl3 = bl = ((n4 = this.pio1.fetchOutValuePortB(true)) & 0x80) != 0;
                    if (bl != this.pio1B7Value) {
                        if (bl) {
                            this.digitIdx = 0;
                        }
                        this.pio1B7Value = bl;
                    }
                    if ((n4 &= 0x7F) == 0) break;
                    int[] nArray = this.digitValues;
                    synchronized (this.digitValues) {
                        if (n4 != this.digitValues[this.digitIdx]) {
                            this.digitValues[this.digitIdx] = n4;
                            this.screenFrm.setScreenDirty(true);
                        }
                        this.digitStatus[this.digitIdx] = 2;
                        // ** MonitorExit[var7_7] (shouldn't be in output)
                        break;
                    }
                }
                case 2: {
                    this.pio1.writeControlA(n2);
                    break;
                }
                case 3: {
                    this.pio1.writeControlB(n2);
                }
            }
        } else if ((n & 0x10) == 0) {
            switch (n & 3) {
                case 0: {
                    this.pio2.writeDataA(n2);
                    break;
                }
                case 1: {
                    this.pio2.writeDataB(n2);
                    break;
                }
                case 2: {
                    this.pio2.writeControlA(n2);
                    break;
                }
                case 3: {
                    this.pio2.writeControlB(n2);
                }
            }
        }
    }

    @Override
    public void writeMemByte(int n, int n2) {
        this.setMemByte(n &= 0xFFFF, n2);
        if (!this.alphaScreenFired && this.alphaScreenEnableTStates <= 0 && n >= 7168 && n < 8192 && n2 != 0 && n2 != 32 && n2 != 64 && n2 != 255) {
            this.screenFrm.fireOpenSecondScreen();
            this.alphaScreenFired = true;
        }
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        super.z80MaxSpeedChanged(z80CPU);
        int n = z80CPU.getMaxSpeedKHz();
        this.displayCheckTStates = n * 50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        super.z80TStatesProcessed(z80CPU, n);
        this.ctc.z80TStatesProcessed(z80CPU, n);
        if (this.displayCheckTStates > 0L) {
            this.curDisplayTStates += (long)n;
            if (this.curDisplayTStates > this.displayCheckTStates) {
                boolean bl = false;
                int[] nArray = this.digitValues;
                // MONITORENTER : this.digitValues
                for (int i = 0; i < this.digitValues.length; ++i) {
                    if (this.digitStatus[i] > 0) {
                        int n2 = i;
                        this.digitStatus[n2] = this.digitStatus[n2] - 1;
                        continue;
                    }
                    if (this.digitValues[i] == 0) continue;
                    this.digitValues[i] = 0;
                    bl = true;
                }
                // MONITOREXIT : nArray
                if (bl) {
                    this.screenFrm.setScreenDirty(true);
                }
                this.curDisplayTStates = 0L;
            }
        }
        if (this.alphaScreenEnableTStates <= 0) return;
        this.alphaScreenEnableTStates -= n;
    }

    private int getHexKeyMatrixValue() {
        int n = 0;
        int n2 = ~this.pio1.fetchOutValuePortA(false) >> 4 & 7;
        int n3 = 1;
        for (int i = 0; i < this.keyboardMatrix.length; ++i) {
            if ((this.keyboardMatrix[i] & n2) != 0) {
                n |= n3 | this.keyboardMatrix[i] & 0x80;
            }
            n3 <<= 1;
        }
        return n;
    }

    private static int toLLC1Char(int n) {
        switch (n) {
            case 10: {
                n = 13;
                break;
            }
            case 183: {
                n = 224;
                break;
            }
            case 47: {
                n = 16;
                break;
            }
            case 59: {
                n = 17;
                break;
            }
            case 34: {
                n = 18;
                break;
            }
            case 61: {
                n = 19;
                break;
            }
            case 37: {
                n = 20;
                break;
            }
            case 38: {
                n = 21;
                break;
            }
            case 40: {
                n = 22;
                break;
            }
            case 41: {
                n = 23;
                break;
            }
            case 95: {
                n = 24;
                break;
            }
            case 64: 
            case 167: {
                n = 25;
                break;
            }
            case 58: {
                n = 26;
                break;
            }
            case 35: {
                n = 27;
                break;
            }
            case 42: {
                n = 28;
                break;
            }
            case 39: {
                n = 29;
                break;
            }
            case 33: {
                n = 30;
                break;
            }
            case 63: {
                n = 31;
                break;
            }
            case 172: {
                n = 58;
                break;
            }
            case 36: {
                n = 59;
                break;
            }
            case 43: {
                n = 60;
                break;
            }
            case 45: {
                n = 61;
                break;
            }
            case 46: {
                n = 62;
                break;
            }
            case 44: {
                n = 63;
                break;
            }
            case 32: {
                n = 64;
                break;
            }
            case 93: {
                n = 91;
                break;
            }
            case 91: {
                n = 92;
                break;
            }
            case 62: {
                n = 123;
                break;
            }
            case 60: {
                n = 124;
                break;
            }
            case 124: {
                n = 125;
                break;
            }
            case 94: {
                n = 126;
            }
        }
        return n;
    }

    private void updKeyboardFld() {
        if (this.keyboardFld != null) {
            this.keyboardFld.updKeySelection(this.keyboardMatrix);
        }
    }
}

