/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import jkcemu.base.CharRaster;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.disk.FDC8272;
import jkcemu.disk.FloppyDiskDrive;
import jkcemu.disk.GIDE;
import jkcemu.emusys.customsys.CustomSysROM;
import jkcemu.etc.VDIP;
import jkcemu.net.KCNet;
import jkcemu.text.CharConverter;
import z80emu.Z80CPU;
import z80emu.Z80CTC;
import z80emu.Z80CTCListener;
import z80emu.Z80InterruptSource;
import z80emu.Z80PIO;
import z80emu.Z80SIO;
import z80emu.Z80SIOChannelListener;

public class CustomSys
extends EmuSys
implements FDC8272.DriveSelector,
Z80CTCListener,
Z80SIOChannelListener {
    public static final String SYSNAME = "CUSTOMSYS";
    public static final String SYSTEXT = "Benutzerdefinierter Computer";
    public static final String PROP_PREFIX = "jkcemu.customsys.";
    public static final String PROP_TITLE = "title";
    public static final String PROP_BOOT = "boot";
    public static final String PROP_BEGADDR = "addr.begin";
    public static final String PROP_SIZE = "size";
    public static final String PROP_SWITCH_IOADDR = "switch.ioaddr";
    public static final String PROP_SWITCH_IOMASK = "switch.iomask";
    public static final String PROP_SWITCH_IOVALUE = "switch.iovalue";
    public static final String PROP_ENABLE_ON_RESET = "enable_on_reset";
    public static final String PROP_SCREEN_ENABLED = "screen.enabled";
    public static final String PROP_SCREEN_BEGADDR = "screen.addr.begin";
    public static final String PROP_SCREEN_COLS = "screen.cols";
    public static final String PROP_SCREEN_ROWS = "screen.rows";
    public static final String PROP_SPEED_KHZ = "speed.khz";
    public static final String PROP_KEYBOARD_HW = "keyboard.hardware";
    public static final String PROP_KEYBOARD_IOADDR = "keyboard.io_addr";
    public static final String PROP_SWAP_KEY_CHAR_CASE = "swap_key_char_case";
    public static final String PROP_PIO_ENABLED = "pio.enabled";
    public static final String PROP_SIO_ENABLED = "sio.enabled";
    public static final String PROP_CTC_ENABLED = "ctc.enabled";
    public static final String PROP_PIO_IOBASEADDR = "pio.io_base_addr";
    public static final String PROP_SIO_IOBASEADDR = "sio.io_base_addr";
    public static final String PROP_SIO_A_CLOCK = "sio.a.clock";
    public static final String PROP_SIO_A_OUT = "sio.a.out";
    public static final String PROP_SIO_B_CLOCK = "sio.b.clock";
    public static final String PROP_SIO_B_OUT = "sio.b.out";
    public static final String PROP_CTC_IOBASEADDR = "ctc.io_base_addr";
    public static final String PROP_KCNET_IOBASEADDR = "kcnet.io_base_addr";
    public static final String PROP_VDIP_IOBASEADDR = "vdip.io_base_addr";
    public static final String PROP_FDC_DATA_IOADDR = "fdc.data.ioaddr";
    public static final String PROP_FDC_STATUS_IOADDR = "fdc.status.ioaddr";
    public static final String PROP_FDC_TC_IOADDR = "fdc.tc.ioaddr";
    public static final String PROP_FDC_TC_IOMASK = "fdc.tc.iomask";
    public static final String PROP_FDC_TC_IOVALUE = "fdc.tc.iovalue";
    public static final String PROP_UNUSED_PORT_VALUE = "unused_port.value";
    public static final int DEFAULT_KEYBOARD_IOADDR = 0;
    public static final int DEFAULT_SCREEN_BEGADDR = 63488;
    public static final String VALUE_PRINTER = "printer";
    public static final String VALUE_KEYBOARD_PORT_RAW = "port.raw";
    public static final String VALUE_KEYBOARD_PIO_A_HS = "pio.a.handshake";
    public static final String VALUE_KEYBOARD_PIO_A_BIT7 = "pio.a.bit7";
    public static final String VALUE_KEYBOARD_PIO_B_HS = "pio.b.handshake";
    public static final String VALUE_KEYBOARD_PIO_B_BIT7 = "pio.b.bit7";
    public static final String VALUE_KEYBOARD_SIO_A = "sio.a";
    public static final String VALUE_KEYBOARD_SIO_B = "sio.b";
    public static final String TEXT_NO_SCREEN = "Keine Bildschirmausgabe verf\u00fcgbar";
    public static final int DEFAULT_GIDE_IOBASEADDR = 128;
    private static final String DEFAULT_TITLE = "Benutzerdefinierter Computer";
    private static final int DEFAULT_SPEED_KHZ = 2458;
    private static final int DEFAULT_PORT_VALUE = 255;
    private static final int DEFAULT_PIO_IOBASEADDR = 0;
    private static final int DEFAULT_SIO_IOBASEADDR = 4;
    private static final int DEFAULT_CTC_IOBASEADDR = 8;
    private static final int DEFAULT_FDC_DATA_IOADDR = 149;
    private static final int DEFAULT_FDC_STATUS_IOADDR = 148;
    private static final int DEFAULT_FDC_TC_IOADDR = 146;
    private static final int DEFAULT_KCNET_IOBASEADDR = 192;
    private static final int DEFAULT_VDIP_IOBASEADDR = 252;
    private static byte[] romFont = null;
    private static CharConverter cp437 = new CharConverter(CharConverter.Encoding.CP437);
    private String title;
    private CustomSysROM[] roms;
    private KeyboardHW keyboardHW;
    private int keyboardIOAddr;
    private int keyChar;
    private int screenCols;
    private int screenRows;
    private int screenBegAddr;
    private int screenEndAddr;
    private int unusedPortValue;
    private int ctcIOBaseAddr;
    private int pioIOBaseAddr;
    private int sioIOBaseAddr;
    private int sioAClock;
    private int sioBClock;
    private int fdcDataIOAddr;
    private int fdcStatusIOAddr;
    private int fdcTCIOAddr;
    private int fdcTCIOMask;
    private int fdcTCIOValue;
    private int lastTCIOValue;
    private int gideIOBaseAddr;
    private int kcNetIOBaseAddr;
    private int vdipIOBaseAddr;
    private byte[] fontBytes;
    private Z80CTC ctc;
    private Z80PIO pio;
    private Z80SIO sio;
    private SioOut sioAout;
    private SioOut sioBout;
    private KCNet kcNet;
    private VDIP vdip;
    private GIDE gide;
    private FDC8272 fdc;
    private FloppyDiskDrive[] floppyDiskDrives;
    private boolean keyboardUsed;
    private boolean swapKeyCharCase;

    public CustomSys(EmuThread emuThread, Properties properties) {
        super(emuThread, properties, PROP_PREFIX);
        if (CustomSys.emulatesScreen(properties)) {
            this.screenCols = CustomSys.getScreenCols(properties);
            this.screenRows = CustomSys.getScreenRows(properties);
            this.screenBegAddr = CustomSys.getScreenBegAddr(properties);
            this.screenEndAddr = this.screenBegAddr + this.screenCols * this.screenRows - 1;
        } else {
            this.screenCols = 0;
            this.screenRows = 0;
            this.screenBegAddr = -1;
            this.screenEndAddr = -1;
        }
        this.title = CustomSys.getTitle(properties);
        this.fontBytes = null;
        this.roms = CustomSys.getDeclaredROMs(properties);
        this.keyboardHW = CustomSys.getKeyboardHW(properties);
        this.keyboardIOAddr = CustomSys.getKeyboardIOAddr(properties);
        this.keyboardUsed = false;
        this.keyChar = 0;
        this.unusedPortValue = CustomSys.getUnusedPortValue(properties);
        ArrayList<Z80InterruptSource> arrayList = new ArrayList<Z80InterruptSource>();
        this.ctc = null;
        this.ctcIOBaseAddr = -1;
        if (CustomSys.emulatesCTC(properties)) {
            this.ctcIOBaseAddr = CustomSys.getCtcIOBaseAddr(properties);
            this.ctc = new Z80CTC(String.format("CTC (E/A-Adressen %02X-%02X)", this.ctcIOBaseAddr, this.ctcIOBaseAddr + 3));
            arrayList.add(this.ctc);
        }
        this.pio = null;
        this.pioIOBaseAddr = -1;
        if (CustomSys.emulatesPIO(properties)) {
            this.pioIOBaseAddr = CustomSys.getPioIOBaseAddr(properties);
            this.pio = new Z80PIO(String.format("PIO (E/A-Adressen %02X-%02X)", this.pioIOBaseAddr, this.pioIOBaseAddr + 3));
            arrayList.add(this.pio);
        }
        this.sio = null;
        this.sioIOBaseAddr = -1;
        this.sioAClock = EmuUtil.getIntProperty(properties, this.propPrefix + PROP_SIO_A_CLOCK, 0);
        this.sioBClock = EmuUtil.getIntProperty(properties, this.propPrefix + PROP_SIO_B_CLOCK, 0);
        if (CustomSys.emulatesSIO(properties)) {
            this.sioIOBaseAddr = CustomSys.getSioIOBaseAddr(properties);
            this.sio = new Z80SIO(String.format("SIO (E/A-Adressen %02X-%02X)", this.sioIOBaseAddr, this.sioIOBaseAddr + 3));
            arrayList.add(this.sio);
            if (this.ctc != null) {
                this.ctc.addCTCListener(this);
            }
            this.sioAout = CustomSys.getSioOut(properties, PROP_SIO_A_OUT);
            if (this.sioAout != SioOut.NONE) {
                this.sio.addChannelListener(this, 0);
            }
            this.sioBout = CustomSys.getSioOut(properties, PROP_SIO_B_OUT);
            if (this.sioAout != SioOut.NONE) {
                this.sio.addChannelListener(this, 1);
            }
        } else {
            this.sioAout = SioOut.NONE;
            this.sioBout = SioOut.NONE;
        }
        this.kcNet = null;
        this.kcNetIOBaseAddr = -1;
        if (CustomSys.emulatesKCNet(properties)) {
            this.kcNetIOBaseAddr = CustomSys.getKCNetIOBaseAddr(properties);
            this.kcNet = new KCNet(String.format("KCNet (E/A-Adressen %02X-%02X)", this.kcNetIOBaseAddr, this.kcNetIOBaseAddr + 3));
            arrayList.add(this.kcNet);
        }
        this.gide = GIDE.getGIDE(this.screenFrm, properties, this.propPrefix);
        this.gideIOBaseAddr = CustomSys.getGideIOBaseAddr(properties);
        this.floppyDiskDrives = null;
        this.fdc = null;
        if (CustomSys.emulatesFDC(properties)) {
            this.floppyDiskDrives = new FloppyDiskDrive[4];
            Arrays.fill(this.floppyDiskDrives, null);
            this.fdc = new FDC8272(this, 4);
        }
        this.fdcDataIOAddr = CustomSys.getFdcDataIOAddr(properties);
        this.fdcStatusIOAddr = CustomSys.getFdcStatusIOAddr(properties);
        this.fdcTCIOAddr = CustomSys.getFdcTCIOAddr(properties);
        this.vdip = null;
        this.vdipIOBaseAddr = -1;
        if (CustomSys.emulatesSIO(properties)) {
            this.vdipIOBaseAddr = CustomSys.getVdipIOBaseAddr(properties);
            this.vdip = new VDIP(this.emuThread.getFileTimesViewFactory(), String.format("USB-PIO (E/A-Adressen %02X-%02X)", this.vdipIOBaseAddr, this.vdipIOBaseAddr + 3));
            arrayList.add(this.vdip);
            this.vdip.applySettings(properties);
        }
        Z80CPU z80CPU = emuThread.getZ80CPU();
        if (!arrayList.isEmpty()) {
            try {
                z80CPU.setInterruptSources(arrayList.toArray(new Z80InterruptSource[arrayList.size()]));
            }
            catch (ArrayStoreException arrayStoreException) {
                // empty catch block
            }
        }
        z80CPU.addMaxSpeedListener(this);
        z80CPU.addTStatesListener(this);
        this.updSwapKeyCharCase(properties);
        if (!this.isReloadExtROMsOnPowerOnEnabled(properties)) {
            this.loadROMs(properties);
        }
    }

    public static boolean emulatesCTC(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, "jkcemu.customsys.ctc.enabled", false);
    }

    public static boolean emulatesFDC(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, "jkcemu.customsys.fdc.enabled", false);
    }

    public static boolean emulatesKCNet(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, "jkcemu.customsys.kcnet.enabled", false);
    }

    public static boolean emulatesPIO(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, "jkcemu.customsys.pio.enabled", false);
    }

    public static boolean emulatesScreen(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, "jkcemu.customsys.screen.enabled", false);
    }

    public static boolean emulatesSIO(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, "jkcemu.customsys.sio.enabled", false);
    }

    public static boolean emulatesVDIP(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, "jkcemu.customsys.vdip.enabled", false);
    }

    public static CustomSysROM[] getDeclaredROMs(Properties properties) {
        ArrayList<CustomSysROM> arrayList = new ArrayList<CustomSysROM>();
        int n = EmuUtil.getIntProperty(properties, "jkcemu.customsys.rom.count", 0);
        for (int i = 0; i < n; ++i) {
            String string = String.format("%s%s%d.", PROP_PREFIX, "rom.", i);
            int n2 = EmuUtil.getIntProperty(properties, string + PROP_BEGADDR, -1);
            int n3 = EmuUtil.getIntProperty(properties, string + PROP_SIZE, -1);
            if (n2 < 0 || n3 <= 0) continue;
            arrayList.add(new CustomSysROM(n2, n3, EmuUtil.getProperty(properties, string + "file"), EmuUtil.getIntProperty(properties, string + PROP_SWITCH_IOADDR, -1), EmuUtil.getIntProperty(properties, string + PROP_SWITCH_IOMASK, 0), EmuUtil.getIntProperty(properties, string + PROP_SWITCH_IOVALUE, 0), EmuUtil.getBooleanProperty(properties, string + PROP_ENABLE_ON_RESET, false), EmuUtil.getBooleanProperty(properties, string + PROP_BOOT, false)));
        }
        return arrayList.toArray(new CustomSysROM[arrayList.size()]);
    }

    public static int getDefaultSpeedKHz(Properties properties) {
        return EmuUtil.getIntProperty(properties, "jkcemu.customsys.speed.khz", 2458);
    }

    public static int getCtcIOBaseAddr(Properties properties) {
        return EmuUtil.getIntProperty(properties, "jkcemu.customsys.ctc.io_base_addr", 8) & 0xFF;
    }

    public static int getFdcDataIOAddr(Properties properties) {
        return EmuUtil.getIntProperty(properties, "jkcemu.customsys.fdc.data.ioaddr", 149) & 0xFF;
    }

    public static int getFdcStatusIOAddr(Properties properties) {
        return EmuUtil.getIntProperty(properties, "jkcemu.customsys.fdc.status.ioaddr", 148) & 0xFF;
    }

    public static int getFdcTCIOAddr(Properties properties) {
        return EmuUtil.getIntProperty(properties, "jkcemu.customsys.fdc.tc.ioaddr", 146) & 0xFF;
    }

    public static int getKeyboardIOAddr(Properties properties) {
        return EmuUtil.getIntProperty(properties, "jkcemu.customsys.keyboard.io_addr", 0) & 0xFF;
    }

    public static int getKCNetIOBaseAddr(Properties properties) {
        return EmuUtil.getIntProperty(properties, "jkcemu.customsys.kcnet.io_base_addr", 192) & 0xFF;
    }

    public static int getPioIOBaseAddr(Properties properties) {
        return EmuUtil.getIntProperty(properties, "jkcemu.customsys.pio.io_base_addr", 0) & 0xFF;
    }

    public static int getScreenBegAddr(Properties properties) {
        return EmuUtil.getIntProperty(properties, "jkcemu.customsys.screen.addr.begin", 63488);
    }

    public static int getScreenCols(Properties properties) {
        return EmuUtil.getIntProperty(properties, "jkcemu.customsys.screen.cols", 0);
    }

    public static int getScreenRows(Properties properties) {
        return EmuUtil.getIntProperty(properties, "jkcemu.customsys.screen.rows", 0);
    }

    public static int getSioIOBaseAddr(Properties properties) {
        return EmuUtil.getIntProperty(properties, "jkcemu.customsys.sio.io_base_addr", 4) & 0xFF;
    }

    public static String getTitle(Properties properties) {
        String string = EmuUtil.getProperty(properties, "jkcemu.customsys.title");
        string = string != null ? string.trim() : "";
        return string.isEmpty() ? "Benutzerdefinierter Computer" : string;
    }

    public static int getUnusedPortValue(Properties properties) {
        return EmuUtil.getIntProperty(properties, "jkcemu.customsys.unused_port.value", 255);
    }

    public static int getVdipIOBaseAddr(Properties properties) {
        return EmuUtil.getIntProperty(properties, "jkcemu.customsys.vdip.io_base_addr", 252) & 0xFF;
    }

    @Override
    public FloppyDiskDrive getFloppyDiskDrive(int n) {
        FloppyDiskDrive floppyDiskDrive = null;
        if (this.floppyDiskDrives != null && n >= 0 && n < this.floppyDiskDrives.length) {
            floppyDiskDrive = this.floppyDiskDrives[n];
        }
        return floppyDiskDrive;
    }

    @Override
    public void z80CTCUpdate(Z80CTC z80CTC, int n) {
        if (z80CTC == this.ctc) {
            if (n == this.sioAClock) {
                this.sio.clockPulseSenderA();
                this.sio.clockPulseReceiverA();
            }
            if (n == this.sioBClock) {
                this.sio.clockPulseSenderB();
                this.sio.clockPulseReceiverB();
            }
        }
    }

    @Override
    public void z80SIOByteSent(Z80SIO z80SIO, int n, int n2) {
        if (z80SIO == this.sio) {
            switch (n) {
                case 0: {
                    if (this.sioAout == SioOut.PRINTER) {
                        this.emuThread.getPrintMngr().putByte(n2);
                    }
                    this.sio.setClearToSendA(false);
                    this.sio.setClearToSendA(true);
                    break;
                }
                case 1: {
                    if (this.sioAout == SioOut.PRINTER) {
                        this.emuThread.getPrintMngr().putByte(n2);
                    }
                    this.sio.setClearToSendB(false);
                    this.sio.setClearToSendB(true);
                }
            }
        }
    }

    @Override
    public void appendStatusHTMLTo(StringBuilder stringBuilder, Z80CPU z80CPU) {
        stringBuilder.append("<h1>Benutzerdefinierter Computer</h1>\n<table border=\"1\">\n<tr><td>Bezeichnung:</td><td>");
        EmuUtil.appendHTML(stringBuilder, this.title);
        stringBuilder.append("</td></tr>\n");
        for (CustomSysROM customSysROM : this.roms) {
            stringBuilder.append("<tr><td nowrap=\"nowrap\">ROM&nbsp;");
            EmuUtil.appendHTML(stringBuilder, customSysROM.getAddressText());
            String string = customSysROM.getFileName();
            if (string != null && !string.isEmpty() && (string = new File(string).getName()) != null && !string.isEmpty()) {
                stringBuilder.append(", Datei:&nbsp;");
                EmuUtil.appendHTML(stringBuilder, string);
            }
            stringBuilder.append("</td><td>");
            EmuUtil.appendOnOffText(stringBuilder, customSysROM.isEnabled());
            stringBuilder.append("</td></tr>\n");
        }
        stringBuilder.append("</table>\n");
    }

    @Override
    public void applySettings(Properties properties) {
        super.applySettings(properties);
        this.title = CustomSys.getTitle(properties);
        this.loadFont(properties);
        this.updSwapKeyCharCase(properties);
        if (this.vdip != null) {
            this.vdip.applySettings(properties);
        }
    }

    @Override
    public boolean canApplySettings(Properties properties) {
        boolean bl = EmuUtil.getProperty(properties, "jkcemu.system").equals(SYSNAME);
        if (bl) {
            CustomSysROM[] customSysROMArray = CustomSys.getDeclaredROMs(properties);
            if (customSysROMArray.length == this.roms.length) {
                for (int i = 0; i < customSysROMArray.length; ++i) {
                    if (customSysROMArray[i].declaresSameROM(this.roms[i])) continue;
                    bl = false;
                    break;
                }
            } else {
                bl = false;
            }
        }
        if (bl) {
            boolean bl2 = CustomSys.emulatesScreen(properties);
            if (this.screenBegAddr >= 0 && this.screenCols > 0 && this.screenRows > 0) {
                if (!bl2 || this.screenBegAddr != CustomSys.getScreenBegAddr(properties) || this.screenCols != CustomSys.getScreenCols(properties) || this.screenRows != CustomSys.getScreenRows(properties)) {
                    bl = false;
                }
            } else if (bl2) {
                bl = false;
            }
        }
        if (bl) {
            if (CustomSys.getKeyboardHW(properties) == this.keyboardHW) {
                if (this.keyboardHW == KeyboardHW.PORT_RAW && CustomSys.getKeyboardIOAddr(properties) != this.keyboardIOAddr) {
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        if (bl) {
            boolean bl3;
            boolean bl4 = bl3 = this.ctc != null;
            if (CustomSys.emulatesCTC(properties) == bl3) {
                if (bl3 && CustomSys.getCtcIOBaseAddr(properties) != this.ctcIOBaseAddr) {
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        if (bl) {
            boolean bl5;
            boolean bl6 = bl5 = this.pio != null;
            if (CustomSys.emulatesPIO(properties) == bl5) {
                if (bl5 && CustomSys.getPioIOBaseAddr(properties) != this.pioIOBaseAddr) {
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        if (bl) {
            boolean bl7;
            boolean bl8 = bl7 = this.sio != null;
            if (CustomSys.emulatesSIO(properties) == bl7) {
                if (bl7 && (CustomSys.getSioIOBaseAddr(properties) != this.sioIOBaseAddr || CustomSys.getSioOut(properties, PROP_SIO_A_OUT) != this.sioAout || CustomSys.getSioOut(properties, PROP_SIO_B_OUT) != this.sioBout)) {
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        if (bl) {
            boolean bl9;
            boolean bl10 = bl9 = this.fdc != null;
            if (this.emulatesFdc(properties) == bl9) {
                if (bl9 && (CustomSys.getFdcDataIOAddr(properties) != this.fdcDataIOAddr || CustomSys.getFdcStatusIOAddr(properties) != this.fdcStatusIOAddr || CustomSys.getFdcTCIOAddr(properties) != this.fdcTCIOAddr)) {
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        if (bl) {
            bl = GIDE.complies(this.gide, properties, this.propPrefix);
        }
        if (bl && this.gide != null && CustomSys.getGideIOBaseAddr(properties) != this.gideIOBaseAddr) {
            bl = false;
        }
        if (bl) {
            boolean bl11;
            boolean bl12 = bl11 = this.kcNet != null;
            if (CustomSys.emulatesKCNet(properties) == bl11) {
                if (bl11 && CustomSys.getKCNetIOBaseAddr(properties) != this.kcNetIOBaseAddr) {
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        if (bl) {
            boolean bl13;
            boolean bl14 = bl13 = this.vdip != null;
            if (CustomSys.emulatesVDIP(properties) == bl13) {
                if (bl13 && CustomSys.getVdipIOBaseAddr(properties) != this.vdipIOBaseAddr) {
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean canExtractScreenText() {
        return this.screenBegAddr >= 0 && this.screenCols > 0 && this.screenRows > 0;
    }

    @Override
    public void die() {
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        z80CPU.removeTStatesListener(this);
        z80CPU.removeMaxSpeedListener(this);
        z80CPU.setInterruptSources(null);
        if (this.ctc != null) {
            this.ctc.removeCTCListener(this);
        }
        if (this.sio != null) {
            if (this.sioAout != SioOut.NONE) {
                this.sio.removeChannelListener(this, 0);
            }
            if (this.sioAout != SioOut.NONE) {
                this.sio.removeChannelListener(this, 1);
            }
        }
        if (this.fdc != null) {
            this.fdc.die();
        }
        if (this.gide != null) {
            this.gide.die();
        }
        if (this.kcNet != null) {
            this.kcNet.die();
        }
        if (this.vdip != null) {
            this.vdip.die();
        }
    }

    @Override
    public int getColorIndex(int n, int n2) {
        byte[] byArray;
        int n3 = 0;
        if (this.screenBegAddr >= 0 && this.screenCols > 0 && this.screenRows > 0 && (byArray = this.fontBytes) != null) {
            int n4;
            int n5 = n / 8;
            int n6 = n2 / 8;
            int n7 = n2 % 8;
            int n8 = this.screenBegAddr + n6 * this.screenCols + n5;
            if (n8 >= 0 && n8 < 65536 && (n4 = (this.emuThread.getRAMByte(n8) & 0xFF) * 8 + n7) >= 0 && n4 < byArray.length) {
                int n9 = 128;
                int n10 = n % 8;
                if (n10 > 0) {
                    n9 >>= n10;
                }
                if ((byArray[n4] & n9) != 0) {
                    n3 = 1;
                }
            }
        }
        return n3;
    }

    @Override
    protected boolean getConvertKeyCharToISO646DE() {
        return false;
    }

    @Override
    public CharRaster getCurScreenCharRaster() {
        CharRaster charRaster = null;
        if (this.screenBegAddr >= 0 && this.screenCols > 0 && this.screenRows > 0) {
            charRaster = new CharRaster(this.screenCols, this.screenRows, 8, 8, 8, 0);
        }
        return charRaster;
    }

    @Override
    public String getHelpPage() {
        return "/help/customsys.htm";
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        n &= 0xFFFF;
        int n2 = -1;
        boolean bl2 = false;
        for (CustomSysROM customSysROM : this.roms) {
            if (!customSysROM.isEnabled()) continue;
            n2 = customSysROM.getMemByte(n);
            break;
        }
        if (n2 < 0) {
            n2 = this.emuThread.getRAMByte(n);
        }
        return n2 & 0xFF;
    }

    @Override
    public int getResetStartAddress(EmuThread.ResetLevel resetLevel) {
        int n = 0;
        for (CustomSysROM customSysROM : this.roms) {
            if (!customSysROM.isBootROM()) continue;
            n = customSysROM.getBegAddr();
            break;
        }
        return n;
    }

    @Override
    protected int getScreenChar(CharRaster charRaster, int n, int n2) {
        int n3;
        int n4;
        int n5 = 32;
        if (this.screenBegAddr >= 0 && this.screenCols > 0 && this.screenRows > 0 && (n4 = this.screenBegAddr + n2 * this.screenCols + n) >= 0 && n4 < 65536 && (n3 = this.emuThread.getRAMByte(n4)) >= 32) {
            n5 = cp437.toUnicode(n3);
        }
        return n5;
    }

    @Override
    public int getScreenHeight() {
        int n = 100;
        if (this.screenBegAddr >= 0 && this.screenCols > 0 && this.screenRows > 0) {
            n = this.screenRows * 8;
        }
        return n;
    }

    @Override
    public int getScreenWidth() {
        int n = 300;
        if (this.screenBegAddr >= 0 && this.screenCols > 0 && this.screenRows > 0) {
            n = this.screenCols * 8;
        }
        return n;
    }

    @Override
    public int getSupportedFloppyDiskDriveCount() {
        return this.floppyDiskDrives != null ? this.floppyDiskDrives.length : 0;
    }

    @Override
    public boolean getSwapKeyCharCase() {
        return this.swapKeyCharCase;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    protected VDIP getVDIP() {
        return this.vdip;
    }

    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int n2 = 0;
        switch (n) {
            case 37: {
                n2 = 8;
                break;
            }
            case 39: {
                n2 = 9;
                break;
            }
            case 40: {
                n2 = 10;
                break;
            }
            case 38: {
                n2 = 11;
                break;
            }
            case 10: {
                n2 = 13;
                break;
            }
            case 32: {
                n2 = 32;
            }
        }
        if (n2 > 0) {
            bl3 = this.putKeyChar(n2);
        }
        return bl3;
    }

    @Override
    public void keyReleased() {
        this.putKeyChar(0);
    }

    @Override
    public boolean keyTyped(char c) {
        return this.putKeyChar(c);
    }

    @Override
    public boolean paintScreen(Graphics graphics, int n, int n2, int n3) {
        boolean bl = false;
        if (this.screenBegAddr < 0 || this.screenCols <= 0 || this.screenRows <= 0) {
            int n4 = n;
            int n5 = n2;
            int n6 = 12 * n3;
            graphics.setFont(new Font("SansSerif", 0, n6));
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (fontMetrics != null && (n4 = n + (this.getScreenWidth() - fontMetrics.stringWidth(TEXT_NO_SCREEN)) / 2) < 0) {
                n4 = 0;
            }
            if ((n5 = n2 + (this.getScreenHeight() + n6) / 2) < n6) {
                n5 = n6;
            }
            graphics.setColor(Color.GRAY);
            graphics.drawString(TEXT_NO_SCREEN, n4, n5);
            bl = true;
        }
        return bl;
    }

    @Override
    public int readIOByte(int n, int n2) {
        int n3;
        int n4 = 255;
        boolean bl = false;
        if (this.ctc != null && (n &= 0xFF) >= this.ctcIOBaseAddr && n < this.ctcIOBaseAddr + 4) {
            n4 &= this.ctc.read(n - this.ctcIOBaseAddr, n2);
            bl = true;
        }
        if (this.pio != null && n >= this.pioIOBaseAddr && n < this.pioIOBaseAddr + 4) {
            switch (n - this.pioIOBaseAddr) {
                case 0: {
                    if (!(this.keyboardHW != KeyboardHW.PIO_A_HS && this.keyboardHW != KeyboardHW.PIO_A_BIT7 || this.keyboardUsed)) {
                        this.pio.putInValuePortA(0, 255);
                        this.keyboardUsed = true;
                    }
                    n4 &= this.pio.readDataA();
                    bl = true;
                    break;
                }
                case 1: {
                    if (!(this.keyboardHW != KeyboardHW.PIO_B_HS && this.keyboardHW != KeyboardHW.PIO_B_BIT7 || this.keyboardUsed)) {
                        this.pio.putInValuePortB(0, 255);
                        this.keyboardUsed = true;
                    }
                    n4 &= this.pio.readDataB();
                    bl = true;
                    break;
                }
                case 2: {
                    n4 &= this.pio.readControlA();
                    bl = true;
                    break;
                }
                case 3: {
                    n4 &= this.pio.readControlB();
                    bl = true;
                }
            }
        }
        if (this.sio != null && n >= this.sioIOBaseAddr && n < this.sioIOBaseAddr + 4) {
            switch (n - this.sioIOBaseAddr) {
                case 0: {
                    n4 &= this.sio.readDataA();
                    bl = true;
                    break;
                }
                case 1: {
                    n4 &= this.sio.readDataB();
                    bl = true;
                    break;
                }
                case 2: {
                    n4 &= this.sio.readControlA();
                    bl = true;
                    break;
                }
                case 3: {
                    n4 &= this.sio.readControlB();
                    bl = true;
                }
            }
        }
        if (this.fdc != null) {
            if (n == this.fdcDataIOAddr) {
                n4 &= this.fdc.readData();
                bl = true;
            } else if (n == this.fdcStatusIOAddr) {
                n4 &= this.fdc.readMainStatusReg();
                bl = true;
            }
        }
        if (this.gide != null && (n3 = this.gide.read(n)) >= 0) {
            n4 = n3;
            bl = true;
        }
        if (this.kcNet != null && n >= this.kcNetIOBaseAddr && n < this.kcNetIOBaseAddr + 4) {
            n4 &= this.kcNet.read(n - this.kcNetIOBaseAddr);
        }
        if (this.vdip != null && n >= this.vdipIOBaseAddr && n < this.vdipIOBaseAddr + 4) {
            n4 &= this.vdip.read(n - this.vdipIOBaseAddr);
            bl = true;
        }
        if (this.keyboardHW == KeyboardHW.PORT_RAW && n == this.keyboardIOAddr) {
            n4 &= this.keyChar;
            bl = true;
        }
        return bl ? n4 : this.unusedPortValue;
    }

    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        boolean bl;
        super.reset(resetLevel, properties);
        this.keyChar = 0;
        this.keyboardUsed = false;
        this.lastTCIOValue = this.fdcTCIOValue;
        if (resetLevel == EmuThread.ResetLevel.POWER_ON && this.isReloadExtROMsOnPowerOnEnabled(properties)) {
            this.loadROMs(properties);
        }
        boolean bl2 = bl = resetLevel == EmuThread.ResetLevel.POWER_ON || resetLevel == EmuThread.ResetLevel.COLD_RESET;
        if (this.ctc != null) {
            this.ctc.reset(bl);
        }
        if (this.pio != null) {
            this.pio.reset(bl);
        }
        if (this.sio != null) {
            this.sio.reset(bl);
        }
        if (this.fdc != null) {
            this.fdc.reset(bl);
        }
        if (this.floppyDiskDrives != null) {
            for (int i = 0; i < this.floppyDiskDrives.length; ++i) {
                FloppyDiskDrive floppyDiskDrive = this.floppyDiskDrives[i];
                if (floppyDiskDrive == null) continue;
                floppyDiskDrive.reset();
            }
        }
        if (this.gide != null) {
            this.gide.reset();
        }
        if (this.kcNet != null) {
            this.kcNet.reset(bl);
        }
        if (this.vdip != null) {
            this.vdip.reset(bl);
        }
        for (CustomSysROM customSysROM : this.roms) {
            customSysROM.reset();
        }
    }

    @Override
    public void setFloppyDiskDrive(int n, FloppyDiskDrive floppyDiskDrive) {
        if (this.floppyDiskDrives != null && n >= 0 && n < this.floppyDiskDrives.length) {
            this.floppyDiskDrives[n] = floppyDiskDrive;
        }
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        this.emuThread.setRAMByte(n & 0xFFFF, n2);
        if (n >= this.screenBegAddr && n <= this.screenEndAddr) {
            this.screenFrm.setScreenDirty(true);
        }
        return true;
    }

    @Override
    public boolean supportsCopyToClipboard() {
        return this.screenBegAddr >= 0 && this.screenCols > 0 && this.screenRows > 0;
    }

    @Override
    public boolean supportsPasteFromClipboard() {
        return this.keyboardHW != KeyboardHW.NONE;
    }

    @Override
    public boolean supportsPrinter() {
        return this.sioAout == SioOut.PRINTER || this.sioBout == SioOut.PRINTER;
    }

    @Override
    public void writeIOByte(int n, int n2, int n3) {
        n &= 0xFF;
        for (CustomSysROM customSysROM : this.roms) {
            customSysROM.writeIOByte(n, n2);
        }
        if (this.ctc != null && n >= this.ctcIOBaseAddr && n < this.ctcIOBaseAddr + 4) {
            this.ctc.write(n - this.ctcIOBaseAddr, n2, n3);
        }
        if (this.pio != null && n >= this.pioIOBaseAddr && n < this.pioIOBaseAddr + 4) {
            switch (n - this.pioIOBaseAddr) {
                case 0: {
                    this.pio.writeDataA(n2);
                    break;
                }
                case 1: {
                    this.pio.writeDataB(n2);
                    break;
                }
                case 2: {
                    this.pio.writeControlA(n2);
                    break;
                }
                case 3: {
                    this.pio.writeControlB(n2);
                }
            }
        }
        if (this.sio != null && n >= this.sioIOBaseAddr && n < this.sioIOBaseAddr + 4) {
            switch (n - this.sioIOBaseAddr) {
                case 0: {
                    this.sio.writeDataA(n2);
                    break;
                }
                case 1: {
                    this.sio.writeDataB(n2);
                    break;
                }
                case 2: {
                    this.sio.writeControlA(n2);
                    break;
                }
                case 3: {
                    this.sio.writeControlA(n2);
                }
            }
        }
        if (this.fdc != null) {
            if (n == this.fdcDataIOAddr) {
                this.fdc.write(n2);
            } else if (n == this.fdcTCIOAddr) {
                if (this.fdcTCIOMask != 0) {
                    int n4 = this.lastTCIOValue & this.fdcTCIOMask;
                    if (n4 != this.lastTCIOValue && n4 == this.fdcTCIOValue) {
                        this.fdc.fireTC();
                    }
                    this.lastTCIOValue = n4;
                } else {
                    this.fdc.fireTC();
                }
            }
        }
        if (this.gide != null && n >= this.gideIOBaseAddr && n < this.gideIOBaseAddr + 16) {
            this.gide.write(n - this.gideIOBaseAddr, n2);
        }
        if (this.kcNet != null && n >= this.kcNetIOBaseAddr && n < this.kcNetIOBaseAddr + 4) {
            this.kcNet.write(n - this.kcNetIOBaseAddr, n2);
        }
        if (this.vdip != null && n >= this.vdipIOBaseAddr && n < this.vdipIOBaseAddr + 4) {
            this.vdip.write(n - this.vdipIOBaseAddr, n2);
        }
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        super.z80MaxSpeedChanged(z80CPU);
        if (this.fdc != null) {
            this.fdc.z80MaxSpeedChanged(z80CPU);
        }
        if (this.kcNet != null) {
            this.kcNet.z80MaxSpeedChanged(z80CPU);
        }
    }

    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        super.z80TStatesProcessed(z80CPU, n);
        if (this.fdc != null) {
            this.fdc.z80TStatesProcessed(z80CPU, n);
        }
        if (this.kcNet != null) {
            this.kcNet.z80TStatesProcessed(z80CPU, n);
        }
    }

    private boolean emulatesFdc(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "fdc.enabled", false);
    }

    private static int getGideIOBaseAddr(Properties properties) {
        return EmuUtil.getIntProperty(properties, "jkcemu.customsys.gide.io_base_addr", 128) & 0xFF;
    }

    private static KeyboardHW getKeyboardHW(Properties properties) {
        KeyboardHW keyboardHW = KeyboardHW.NONE;
        switch (EmuUtil.getProperty(properties, "jkcemu.customsys.keyboard.hardware")) {
            case "port.raw": {
                keyboardHW = KeyboardHW.PORT_RAW;
                break;
            }
            case "pio.a.handshake": {
                keyboardHW = KeyboardHW.PIO_A_HS;
                break;
            }
            case "pio.a.bit7": {
                keyboardHW = KeyboardHW.PIO_A_BIT7;
                break;
            }
            case "pio.b.handshake": {
                keyboardHW = KeyboardHW.PIO_B_HS;
                break;
            }
            case "pio.b.bit7": {
                keyboardHW = KeyboardHW.PIO_B_BIT7;
                break;
            }
            case "sio.a": {
                keyboardHW = KeyboardHW.SIO_A;
                break;
            }
            case "sio.b": {
                keyboardHW = KeyboardHW.SIO_B;
            }
        }
        return keyboardHW;
    }

    private static SioOut getSioOut(Properties properties, String string) {
        SioOut sioOut = SioOut.NONE;
        switch (EmuUtil.getProperty(properties, PROP_PREFIX + string)) {
            case "printer": {
                sioOut = SioOut.PRINTER;
            }
        }
        return sioOut;
    }

    private void loadFont(Properties properties) {
        this.fontBytes = this.readFontByProperty(properties, this.propPrefix + "font.file", 2048);
        if (this.fontBytes == null) {
            if (romFont == null) {
                romFont = this.readResource("/rom/customsys/cp437.bin");
            }
            this.fontBytes = romFont;
        }
    }

    private void loadROMs(Properties properties) {
        for (CustomSysROM customSysROM : this.roms) {
            customSysROM.load(this.emuThread.getScreenFrm());
        }
        this.loadFont(properties);
    }

    private boolean putKeyChar(int n) {
        boolean bl = false;
        if (n > 0) {
            n = cp437.toCharsetByte((char)n);
        }
        switch (this.keyboardHW) {
            case PORT_RAW: {
                if (n < 0 || n > 255) break;
                this.keyChar = n;
                bl = true;
                break;
            }
            case PIO_A_HS: {
                if (this.pio == null || n <= 0 || n > 255) break;
                this.pio.putInValuePortA(n, true);
                bl = true;
                break;
            }
            case PIO_A_BIT7: {
                if (this.pio == null) break;
                if (n == 0) {
                    this.pio.putInValuePortA(0, 255);
                    bl = true;
                    break;
                }
                if (n <= 0 || n > 127) break;
                this.pio.putInValuePortA(n | 0x80, 255);
                bl = true;
                break;
            }
            case PIO_B_HS: {
                if (this.pio == null || n <= 0 || n > 255) break;
                this.pio.putInValuePortB(n, true);
                bl = true;
                break;
            }
            case PIO_B_BIT7: {
                if (this.pio == null) break;
                if (n == 0) {
                    this.pio.putInValuePortB(0, 255);
                    bl = true;
                    break;
                }
                if (n <= 0 || n > 127) break;
                this.pio.putInValuePortB(n | 0x80, 255);
                bl = true;
                break;
            }
            case SIO_A: {
                if (this.sio == null || n <= 0 || n > 255) break;
                this.sio.putToReceiverA(n);
                bl = true;
                break;
            }
            case SIO_B: {
                if (this.sio == null || n <= 0 || n > 255) break;
                this.sio.putToReceiverB(n);
                bl = true;
            }
        }
        return bl;
    }

    private void updSwapKeyCharCase(Properties properties) {
        this.swapKeyCharCase = EmuUtil.getBooleanProperty(properties, this.propPrefix + PROP_SWAP_KEY_CHAR_CASE, false);
    }

    private static enum SioOut {
        NONE,
        PRINTER;

    }

    private static enum KeyboardHW {
        NONE,
        PORT_RAW,
        PIO_A_HS,
        PIO_A_BIT7,
        PIO_B_HS,
        PIO_B_BIT7,
        SIO_A,
        SIO_B;

    }
}

