/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys;

import java.awt.Color;
import java.awt.Graphics;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Properties;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.ByteIterator;
import jkcemu.base.CharRaster;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileFormat;
import jkcemu.base.RAMFloppy;
import jkcemu.base.SaveDlg;
import jkcemu.base.SourceUtil;
import jkcemu.disk.FDC8272;
import jkcemu.disk.FloppyDiskDrive;
import jkcemu.disk.FloppyDiskFormat;
import jkcemu.disk.FloppyDiskInfo;
import jkcemu.emusys.a5105.A5105KeyboardFld;
import jkcemu.emusys.a5105.VIS;
import jkcemu.etc.GDC82720;
import jkcemu.etc.PSG8910;
import jkcemu.etc.VDIP;
import jkcemu.net.KCNet;
import jkcemu.text.CharConverter;
import z80emu.Z80CPU;
import z80emu.Z80CTC;
import z80emu.Z80InterruptSource;
import z80emu.Z80PCListener;
import z80emu.Z80PIO;

public class A5105
extends EmuSys
implements FDC8272.DriveSelector,
PSG8910.Callback,
Z80PCListener {
    private static int lastAA = -1;
    public static final String SYSNAME = "A5105";
    public static final String SYSTEXT = "A5105 (BIC)";
    public static final String PROP_PREFIX = "jkcemu.a5105.";
    public static final int FUNCTION_KEY_COUNT = 5;
    public static final int DEFAULT_PROMPT_AFTER_RESET_MILLIS_MAX = 4000;
    private static FloppyDiskInfo rbasicPrgDisk = new FloppyDiskInfo("/disks/a5105/a5105rbasicprg.dump.gz", "BIC A5105 RBASIC Programmdiskette", 2, 2048, true);
    private static FloppyDiskInfo rbasicSysDisk = new FloppyDiskInfo("/disks/a5105/a5105rbasicsys.dump.gz", "BIC A5105 RBASIC Systemdiskette", 2, 2048, true);
    private static final FloppyDiskInfo[] availableFloppyDisks = new FloppyDiskInfo[]{rbasicPrgDisk, rbasicSysDisk, new FloppyDiskInfo("/disks/a5105/a5105scpxsys.dump.gz", "BIC A5105 SCPX Systemdiskette", 2, 2048, true)};
    private static final FloppyDiskInfo[] suitableFloppyDisks = new FloppyDiskInfo[]{rbasicPrgDisk, rbasicSysDisk};
    private static final float KEY_CLICK_HWAVE_MILLIS = 0.1f;
    private static final int OUT_AA_KEY_CLICK = 128;
    private static final int OUT_AA_TAPE_LED = 64;
    private static final int OUT_AA_TAPE_OUT = 32;
    private static final int BIOS_ADDR_CONIN = 64777;
    private static final int V24_TSTATES_PER_BIT = 390;
    private static byte[] romK1505 = null;
    private static byte[] romK5651 = null;
    private static CharConverter cp437 = new CharConverter(CharConverter.Encoding.CP437);
    private static int[][] kbMatrixNormal = new int[][]{{48, 49, 50, 51, 52, 53, 54, 55}, {56, 57, 60, 43, 246, 228, 252, 35}, {39, 63, 44, 46, 45, -1, 97, 98}, {99, 100, 101, 102, 103, 104, 105, 106}, {107, 108, 109, 110, 111, 112, 113, 114}, {115, 116, 117, 118, 119, 120, 121, 122}};
    private static int[][] kbMatrixShift = new int[][]{{61, 33, 34, 92, 36, 37, 38, 47}, {40, 41, 62, 42, 214, 196, 220, 94}, {96, 223, 59, 58, 95, 61, 65, 66}, {67, 68, 69, 70, 71, 72, 73, 74}, {75, 76, 77, 78, 79, 80, 81, 82}, {83, 84, 85, 86, 87, 88, 89, 90}};
    private static int[][] kbMatrixControl = new int[][]{{-1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, 1, 2}, {3, 4, 5, 6, 7, 8, 9, 10}, {11, 12, 13, 14, 15, 16, 17, 18}, {19, 20, 21, 22, 23, 24, 25, 26}};
    private Z80CTC ctc50;
    private Z80CTC ctc80;
    private Z80PIO pio90;
    private GDC82720 gdc;
    private VIS vis;
    private PSG8910 psg;
    private FDC8272 fdc;
    private FloppyDiskDrive[] floppyDiskDrives;
    private KCNet kcNet;
    private VDIP vdip;
    private RAMFloppy ramFloppy1;
    private RAMFloppy ramFloppy2;
    private boolean fdcReset;
    private boolean joyEnabled;
    private boolean joy1Selected;
    private int joy0ActionMask;
    private int joy1ActionMask;
    private boolean keyClickPhase;
    private boolean capsLockLED;
    private boolean tapeInPhase;
    private boolean tapeLED;
    private boolean v24BitOut;
    private int v24BitNum;
    private int v24ShiftBuf;
    private int v24TStateCounter;
    private int shiftTStateCounter;
    private int memConfig;
    private int ledValues;
    private int psgRegNum;
    private int outAA;
    private int coninRetAddr;
    private int[] keyboardMatrix;
    private A5105KeyboardFld keyboardFld;
    private volatile ByteIterator keyClickSamples;
    private volatile boolean pasteFast;

    public A5105(EmuThread emuThread, Properties properties) {
        super(emuThread, properties, PROP_PREFIX);
        if (romK1505 == null) {
            romK1505 = this.readResource("/rom/a5105/k1505_0000.bin");
        }
        this.pasteFast = false;
        this.keyClickPhase = false;
        this.capsLockLED = false;
        this.tapeLED = false;
        this.tapeInPhase = false;
        this.outAA = 255;
        this.keyboardFld = null;
        this.keyboardMatrix = new int[9];
        Arrays.fill(this.keyboardMatrix, 0);
        if (this.emulatesFloppyDisk(properties)) {
            if (romK5651 == null) {
                romK5651 = this.readResource("/rom/a5105/k5651_4000.bin");
            }
            this.fdc = new FDC8272(this, 4);
            this.floppyDiskDrives = new FloppyDiskDrive[3];
            Arrays.fill(this.floppyDiskDrives, null);
        } else {
            this.fdc = null;
            this.floppyDiskDrives = null;
        }
        this.gdc = new GDC82720();
        this.vis = new VIS(this.screenFrm, this.gdc);
        this.vis.setFixedScreenSize(this.isFixedScreenSize(properties));
        this.gdc.setVRAM(this.vis);
        this.gdc.setGDCListener(this.vis);
        this.createColors(properties);
        this.ramFloppy1 = RAMFloppy.prepare(this.emuThread.getRAMFloppy1(), SYSNAME, RAMFloppy.RFType.ADW, "RAM-Floppy an E/A-Adressen 20h/21h", properties, this.propPrefix + "ramfloppy.1.");
        this.ramFloppy2 = RAMFloppy.prepare(this.emuThread.getRAMFloppy2(), SYSNAME, RAMFloppy.RFType.ADW, "RAM-Floppy an E/A-Adressen 24h/25h", properties, this.propPrefix + "ramfloppy.2.");
        this.psg = new PSG8910(A5105.getDefaultSpeedKHz() * 1000 / 2, 220, this);
        this.psg.start();
        if (this.fdc != null) {
            this.ctc50 = new Z80CTC("CTC (E/A-Adressen 50h-53h)");
        }
        this.ctc80 = new Z80CTC("CTC (E/A-Adressen 80h-83h)");
        this.pio90 = new Z80PIO("PIO (E/A-Adressen 90h-93h)");
        this.kcNet = null;
        if (this.emulatesKCNet(properties)) {
            this.kcNet = new KCNet("Netzwerk-PIO (E/A-Adressen C0h-C3h)");
        }
        this.vdip = null;
        if (this.emulatesUSB(properties)) {
            this.vdip = new VDIP(this.emuThread.getFileTimesViewFactory(), "USB-PIO (E/A-Adressen FCh-FFh)");
        }
        ArrayList<Z80InterruptSource> arrayList = new ArrayList<Z80InterruptSource>();
        arrayList.add(this.ctc80);
        arrayList.add(this.pio90);
        if (this.ctc50 != null) {
            arrayList.add(this.ctc50);
        }
        if (this.kcNet != null) {
            arrayList.add(this.kcNet);
        }
        if (this.vdip != null) {
            arrayList.add(this.vdip);
        }
        Z80CPU z80CPU = emuThread.getZ80CPU();
        try {
            z80CPU.setInterruptSources(arrayList.toArray(new Z80InterruptSource[arrayList.size()]));
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
        z80CPU.addMaxSpeedListener(this);
        z80CPU.addTStatesListener(this);
        this.ctc80.setTimerConnection(0, 2);
        this.ctc80.setTimerConnection(2, 3);
        if (this.vdip != null) {
            this.vdip.applySettings(properties);
        }
        this.checkAddPCListener(properties);
        this.z80MaxSpeedChanged(z80CPU);
    }

    public static FloppyDiskInfo[] getAvailableFloppyDisks() {
        return availableFloppyDisks;
    }

    public boolean getCapsLockLED() {
        return this.capsLockLED;
    }

    public static int getDefaultSpeedKHz() {
        return 3750;
    }

    public boolean getTapeLED() {
        return this.tapeLED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updKeyboardMatrix(int[] nArray) {
        int[] nArray2 = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            int n;
            int n2 = Math.min(nArray.length, this.keyboardMatrix.length);
            for (n = 0; n < n2; ++n) {
                this.keyboardMatrix[n] = nArray[n];
            }
            while (n < this.keyboardMatrix.length) {
                this.keyboardMatrix[n] = 0;
                ++n;
            }
            this.shiftTStateCounter = 0;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public FloppyDiskDrive getFloppyDiskDrive(int n) {
        FloppyDiskDrive floppyDiskDrive = null;
        if (this.floppyDiskDrives != null && n >= 0 && n < this.floppyDiskDrives.length) {
            floppyDiskDrive = this.floppyDiskDrives[n];
        }
        return floppyDiskDrive;
    }

    @Override
    public int psgReadPort(PSG8910 pSG8910, int n) {
        return 255;
    }

    @Override
    public void psgWritePort(PSG8910 pSG8910, int n, int n2) {
    }

    @Override
    public void psgWriteFrame(PSG8910 pSG8910, int n, int n2, int n3) {
        int n4 = (n + n2 + n3) / 6;
        ByteIterator byteIterator = this.keyClickSamples;
        if (byteIterator != null) {
            if (byteIterator.hasNext()) {
                try {
                    if ((n4 += byteIterator.next() & 0xFF) > 255) {
                        n4 = 255;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.keyClickSamples = null;
                }
            } else {
                this.keyClickSamples = null;
            }
        }
        this.emuThread.writeSoundOutFrames(1, n4, n4, n4);
    }

    @Override
    public synchronized void z80PCChanged(Z80CPU z80CPU, int n) {
        CharacterIterator characterIterator;
        if (this.pasteFast && n == 64777 && (characterIterator = this.pasteIter) != null) {
            char c = characterIterator.next();
            if (c == '\uffff') {
                this.cancelPastingText();
            } else {
                z80CPU.setRegA(c == '\n' ? 13 : cp437.toCharsetByte(c));
                z80CPU.setRegPC(z80CPU.doPop());
            }
        }
    }

    @Override
    public void appendStatusHTMLTo(StringBuilder stringBuilder, Z80CPU z80CPU) {
        stringBuilder.append("<h1>A5105 Speicherkonfiguration</h1>\n<table border=\"2\">\n<tr><th>Adressbereich</th><th>Eingeblendeter Speicher</th></tr>\n<tr><td>C000h - FFFFh</td><td>");
        switch (this.memConfig & 0xC0) {
            case 0: {
                stringBuilder.append("ROM im Grundger&auml;t (bis 9FFFh)");
                break;
            }
            case 64: {
                stringBuilder.append("Modul in der Datenspeichereinheit (nicht emuliert)");
                break;
            }
            case 128: {
                stringBuilder.append("RAM");
                break;
            }
            case 192: {
                stringBuilder.append("Modul im Grundger&auml;t (nicht emuliert)");
            }
        }
        stringBuilder.append("</td></tr>\n<tr><td>8000h - BFFFh</td><td>");
        switch (this.memConfig & 0x30) {
            case 0: {
                stringBuilder.append("ROM im Grundger&auml;t (bis 9FFFh)");
                break;
            }
            case 16: {
                stringBuilder.append("Modul in der Datenspeichereinheit (nicht emuliert)");
                break;
            }
            case 32: {
                stringBuilder.append("RAM");
                break;
            }
            case 48: {
                stringBuilder.append("Modul im Grundger&auml;t (nicht emuliert)");
            }
        }
        stringBuilder.append("</td></tr>\n<tr><td>4000h - 7FFFh</td><td>");
        switch (this.memConfig & 0xC) {
            case 0: {
                stringBuilder.append("ROM im Grundger&auml;t");
                break;
            }
            case 4: {
                stringBuilder.append("ROM in der Datenspeichereinheit");
                break;
            }
            case 8: {
                stringBuilder.append("RAM");
                break;
            }
            case 12: {
                stringBuilder.append("Modul im Grundger&auml;t (nicht emuliert)");
            }
        }
        stringBuilder.append("</td></tr>\n<tr><td>0000h - 3FFFh</td><td>");
        switch (this.memConfig & 3) {
            case 0: {
                stringBuilder.append("ROM im Grundger&auml;t");
                break;
            }
            case 1: {
                stringBuilder.append("Modul in der Datenspeichereinheit (nicht emuliert)");
                break;
            }
            case 2: {
                stringBuilder.append("RAM");
                break;
            }
            case 3: {
                stringBuilder.append("Modul im Grundger&auml;t (nicht emuliert)");
            }
        }
        stringBuilder.append("</td></tr>\n</table>\n");
    }

    @Override
    public void applySettings(Properties properties) {
        super.applySettings(properties);
        boolean bl = this.isFixedScreenSize(properties);
        if (bl != this.vis.isFixedScreenSize()) {
            this.vis.setFixedScreenSize(bl);
            this.screenFrm.fireScreenSizeChanged();
        }
        this.createColors(properties);
        this.checkAddPCListener(properties);
        if (this.vdip != null) {
            this.vdip.applySettings(properties);
        }
    }

    @Override
    public boolean canApplySettings(Properties properties) {
        boolean bl = EmuUtil.getProperty(properties, "jkcemu.system").equals(SYSNAME);
        if (bl) {
            bl = RAMFloppy.complies(this.ramFloppy1, SYSNAME, RAMFloppy.RFType.ADW, properties, this.propPrefix + "ramfloppy.1.");
        }
        if (bl) {
            bl = RAMFloppy.complies(this.ramFloppy2, SYSNAME, RAMFloppy.RFType.ADW, properties, this.propPrefix + "ramfloppy.2.");
        }
        if (bl && this.emulatesFloppyDisk(properties) != (this.fdc != null)) {
            bl = false;
        }
        if (bl && this.emulatesKCNet(properties) != (this.kcNet != null)) {
            bl = false;
        }
        if (bl && this.emulatesUSB(properties) != (this.vdip != null)) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean canExtractScreenText() {
        return this.vis.canExtractScreenText();
    }

    @Override
    public AbstractKeyboardFld createKeyboardFld() {
        this.keyboardFld = new A5105KeyboardFld(this);
        return this.keyboardFld;
    }

    @Override
    public synchronized void die() {
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        z80CPU.removeTStatesListener(this);
        z80CPU.removeMaxSpeedListener(this);
        z80CPU.setInterruptSources(null);
        if (this.pasteFast) {
            z80CPU.removePCListener(this);
            this.pasteFast = false;
        }
        this.psg.die();
        this.gdc.setGDCListener(null);
        this.gdc.setVRAM(null);
        if (this.ramFloppy1 != null) {
            this.ramFloppy1.deinstall();
        }
        if (this.ramFloppy2 != null) {
            this.ramFloppy2.deinstall();
        }
        if (this.fdc != null) {
            this.fdc.die();
        }
        if (this.vdip != null) {
            this.vdip.die();
        }
    }

    @Override
    public int getBorderColorIndex() {
        return this.vis.getBorderColorIndex();
    }

    @Override
    public Color getColor(int n) {
        return this.vis.getColor(n);
    }

    @Override
    public int getColorCount() {
        return this.vis.getColorCount();
    }

    @Override
    protected boolean getConvertKeyCharToISO646DE() {
        return false;
    }

    @Override
    public CharRaster getCurScreenCharRaster() {
        CharRaster charRaster = null;
        if (this.canExtractScreenText()) {
            int n = Math.min(this.gdc.getCharRowHeight(), 8);
            int n2 = this.gdc.getCharRowHeight();
            if (this.vis.isFixedScreenSize() || this.screenFrm.isFullScreenMode()) {
                n *= 2;
                n2 *= 2;
            }
            charRaster = new CharRaster(this.vis.getCharColCount(), this.vis.getCharRowCount(), n2, n, this.vis.getCharWidth(), this.vis.getCharTopLine());
        }
        return charRaster;
    }

    @Override
    public FloppyDiskFormat getDefaultFloppyDiskFormat() {
        return FloppyDiskFormat.FMT_780K_I2;
    }

    @Override
    public int getDefaultPromptAfterResetMillisMax() {
        return 4000;
    }

    @Override
    public String getHelpPage() {
        return "/help/a5105.htm";
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        int n2;
        block18: {
            block19: {
                block17: {
                    n2 = 255;
                    if ((n &= 0xFFFF) < 0 || n >= 16384) break block17;
                    switch (this.memConfig & 3) {
                        case 0: {
                            if (romK1505 == null || n >= romK1505.length) break;
                            n2 = romK1505[n] & 0xFF;
                            break;
                        }
                        case 2: {
                            n2 = this.emuThread.getRAMByte(n);
                        }
                    }
                    break block18;
                }
                if (n < 16384 || n >= 32768) break block19;
                switch (this.memConfig & 0xC) {
                    case 0: {
                        if (romK1505 == null || n >= romK1505.length) break;
                        n2 = romK1505[n] & 0xFF;
                        break;
                    }
                    case 4: {
                        if (this.fdc == null || romK5651 == null) break;
                        int n3 = n - 16384;
                        if (n3 >= 0 && n3 < romK5651.length) {
                            n2 = romK5651[n3] & 0xFF;
                            break;
                        }
                        break block18;
                    }
                    case 8: {
                        n2 = this.emuThread.getRAMByte(n);
                    }
                }
                break block18;
            }
            if (n >= 32768 && n < 49152) {
                switch (this.memConfig & 0x30) {
                    case 0: {
                        if (romK1505 == null || n >= romK1505.length) break;
                        n2 = romK1505[n] & 0xFF;
                        break;
                    }
                    case 32: {
                        n2 = this.emuThread.getRAMByte(n);
                    }
                }
            } else if (n >= 49152 && (this.memConfig & 0xC0) == 128) {
                n2 = this.emuThread.getRAMByte(n);
            }
        }
        return n2;
    }

    @Override
    public int getResetStartAddress(EmuThread.ResetLevel resetLevel) {
        return 0;
    }

    @Override
    protected int getScreenChar(CharRaster charRaster, int n, int n2) {
        return cp437.toUnicode(this.gdc.getScreenChar(n, n2));
    }

    @Override
    public int getScreenHeight() {
        return this.vis.getScreenHeight();
    }

    @Override
    public int getScreenWidth() {
        return this.vis.getScreenWidth();
    }

    @Override
    public FloppyDiskInfo[] getSuitableFloppyDisks() {
        return this.fdc != null ? suitableFloppyDisks : null;
    }

    @Override
    public int getSupportedFloppyDiskDriveCount() {
        return this.floppyDiskDrives != null ? this.floppyDiskDrives.length : 0;
    }

    @Override
    public int getSupportedJoystickCount() {
        return 2;
    }

    @Override
    public String getTitle() {
        return SYSTEXT;
    }

    @Override
    protected VDIP getVDIP() {
        return this.vdip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int[] nArray = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            switch (n) {
                case 8: 
                case 37: {
                    this.keyboardMatrix[8] = this.keyboardMatrix[8] | 0x10;
                    bl3 = true;
                    break;
                }
                case 39: {
                    this.keyboardMatrix[8] = this.keyboardMatrix[8] | 0x80;
                    bl3 = true;
                    break;
                }
                case 38: {
                    this.keyboardMatrix[8] = this.keyboardMatrix[8] | 0x20;
                    bl3 = true;
                    break;
                }
                case 40: {
                    this.keyboardMatrix[8] = this.keyboardMatrix[8] | 0x40;
                    bl3 = true;
                    break;
                }
                case 32: {
                    this.keyboardMatrix[8] = this.keyboardMatrix[8] | 1;
                    bl3 = true;
                    break;
                }
                case 10: {
                    this.keyboardMatrix[7] = this.keyboardMatrix[7] | 0x80;
                    bl3 = true;
                    break;
                }
                case 27: {
                    this.keyboardMatrix[6] = this.keyboardMatrix[6] | 2;
                    bl3 = true;
                    break;
                }
                case 127: {
                    this.keyboardMatrix[8] = this.keyboardMatrix[8] | 8;
                    bl3 = true;
                    break;
                }
                case 155: {
                    this.keyboardMatrix[8] = this.keyboardMatrix[8] | 4;
                    bl3 = true;
                    break;
                }
                case 112: {
                    this.keyboardMatrix[7] = this.keyboardMatrix[7] | 2;
                    bl3 = true;
                    break;
                }
                case 113: {
                    this.keyboardMatrix[7] = this.keyboardMatrix[7] | 1;
                    bl3 = true;
                    break;
                }
                case 114: {
                    this.keyboardMatrix[6] = this.keyboardMatrix[6] | 0x80;
                    bl3 = true;
                    break;
                }
                case 115: {
                    this.keyboardMatrix[6] = this.keyboardMatrix[6] | 0x40;
                    bl3 = true;
                    break;
                }
                case 116: {
                    this.keyboardMatrix[6] = this.keyboardMatrix[6] | 0x20;
                    bl3 = true;
                    break;
                }
                case 36: 
                case 117: {
                    this.keyboardMatrix[8] = this.keyboardMatrix[8] | 2;
                    bl3 = true;
                    break;
                }
                case 118: {
                    this.keyboardMatrix[7] = this.keyboardMatrix[7] | 0x10;
                    bl3 = true;
                    break;
                }
                case 16: {
                    this.keyboardMatrix[6] = this.keyboardMatrix[6] | 1;
                    break;
                }
                case 17: {
                    this.keyboardMatrix[6] = this.keyboardMatrix[6] | 4;
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (bl3) {
                this.updKeyboardFld();
            }
            return bl3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased() {
        int[] nArray = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            Arrays.fill(this.keyboardMatrix, 0);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.updKeyboardFld();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean keyTyped(char c) {
        boolean bl = false;
        if (c <= '\u0000') return bl;
        int[] nArray = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            boolean bl2;
            boolean bl3 = (this.keyboardMatrix[6] & 4) != 0;
            boolean bl4 = (this.keyboardMatrix[6] & 1) != 0;
            Arrays.fill(this.keyboardMatrix, 0);
            switch (c) {
                case '@': {
                    this.keyboardMatrix[6] = 16;
                    this.keyboardMatrix[0] = 4;
                    bl = true;
                    break;
                }
                case '\u00a7': {
                    this.keyboardMatrix[6] = 16;
                    this.keyboardMatrix[0] = 8;
                    bl = true;
                    break;
                }
                case '|': {
                    this.keyboardMatrix[6] = 17;
                    this.keyboardMatrix[1] = 32;
                    bl = true;
                    break;
                }
                case '[': {
                    this.keyboardMatrix[6] = 16;
                    this.keyboardMatrix[1] = 1;
                    bl = true;
                    break;
                }
                case ']': {
                    this.keyboardMatrix[6] = 16;
                    this.keyboardMatrix[1] = 2;
                    bl = true;
                    break;
                }
                case '{': {
                    this.keyboardMatrix[6] = 17;
                    this.keyboardMatrix[1] = 1;
                    bl = true;
                    break;
                }
                case '}': {
                    this.keyboardMatrix[6] = 17;
                    this.keyboardMatrix[1] = 2;
                    bl = true;
                    break;
                }
                case '~': {
                    this.keyboardMatrix[7] = 4;
                    this.keyboardMatrix[6] = 1;
                    this.keyboardMatrix[1] = 128;
                    bl = true;
                    break;
                }
                case '\u00f1': {
                    this.keyboardMatrix[7] = this.keyboardMatrix[7] | 2;
                    bl = true;
                    break;
                }
                case '\u00f2': {
                    this.keyboardMatrix[7] = this.keyboardMatrix[7] | 1;
                    bl = true;
                    break;
                }
                case '\u00f3': {
                    this.keyboardMatrix[6] = this.keyboardMatrix[6] | 0x80;
                    bl = true;
                    break;
                }
                case '\u00f4': {
                    this.keyboardMatrix[6] = this.keyboardMatrix[6] | 0x40;
                    bl = true;
                    break;
                }
                case '\u00f5': {
                    this.keyboardMatrix[6] = this.keyboardMatrix[6] | 0x20;
                    bl = true;
                    break;
                }
                default: {
                    bl = this.setCharInKBMatrix(kbMatrixNormal, c);
                    if (bl) break;
                    bl = this.setCharInKBMatrix(kbMatrixShift, c);
                    if (bl) {
                        this.keyboardMatrix[6] = 1;
                        break;
                    }
                    bl = this.setCharInKBMatrix(kbMatrixControl, c);
                    if (!bl) break;
                    this.keyboardMatrix[6] = this.keyboardMatrix[6] | 4;
                }
            }
            boolean bl5 = (this.keyboardMatrix[6] & 4) != 0;
            boolean bl6 = bl2 = (this.keyboardMatrix[6] & 1) != 0;
            if (bl5 != bl3 || bl2 != bl4) {
                this.shiftTStateCounter = 100000;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (!bl) return bl;
            this.updKeyboardFld();
            return bl;
        }
    }

    @Override
    public void loadIntoMem(int n, byte[] byArray, int n2, int n3, FileFormat fileFormat, int n4) {
        if (byArray != null) {
            int n5 = n;
            for (int i = n3; n2 < byArray.length && n5 < 65536 && i > 0; --i) {
                this.emuThread.setRAMByte(n5++, byArray[n2++]);
            }
            this.updSysCells(n, n3, fileFormat, n4);
        }
    }

    @Override
    public boolean paintScreen(Graphics graphics, int n, int n2, int n3) {
        this.vis.paintScreen(graphics, n, n2, n3);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 255;
        switch (n & 0xFF) {
            case 32: {
                if (this.ramFloppy1 == null) break;
                n3 = this.ramFloppy1.readByte(n);
                break;
            }
            case 36: {
                if (this.ramFloppy2 == null) break;
                n3 = this.ramFloppy2.readByte(n);
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                if (this.vdip == null) break;
                n3 = this.vdip.read(n);
                break;
            }
            case 64: 
            case 66: 
            case 68: 
            case 70: {
                if (this.fdc == null) break;
                n3 = this.fdc.readMainStatusReg();
                break;
            }
            case 65: 
            case 67: 
            case 69: 
            case 71: {
                if (this.fdc == null) break;
                n3 = this.fdc.readData();
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                if (this.ctc50 == null) break;
                n3 = this.ctc50.read(n & 3, n2);
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                n3 = this.ctc80.read(n & 3, n2);
                break;
            }
            case 144: {
                n3 = this.pio90.readDataA();
                break;
            }
            case 145: {
                this.pio90.putInValuePortB(0, 16);
                n3 = this.pio90.readDataB();
                break;
            }
            case 146: {
                n3 = this.pio90.readControlA();
                break;
            }
            case 147: {
                n3 = this.pio90.readControlB();
                break;
            }
            case 152: {
                n3 = this.gdc.readStatus();
                break;
            }
            case 153: {
                n3 = this.gdc.readData();
                break;
            }
            case 156: {
                n3 = this.vis.readFontByte();
                break;
            }
            case 161: {
                if (this.psgRegNum == 7) {
                    n3 = ~this.psg.getRegister(this.psgRegNum) & 0xFF;
                    break;
                }
                if (this.psgRegNum > 13) break;
                n3 = this.psg.getRegister(this.psgRegNum);
                break;
            }
            case 168: {
                n3 = this.memConfig;
                break;
            }
            case 169: {
                if (this.joyEnabled) {
                    int n4;
                    n3 = 0;
                    int n5 = n4 = this.joy1Selected ? this.joy0ActionMask : this.joy1ActionMask;
                    if ((n4 & 1) != 0) {
                        n3 |= 8;
                    }
                    if ((n4 & 2) != 0) {
                        n3 |= 4;
                    }
                    if ((n4 & 8) != 0) {
                        n3 |= 2;
                    }
                    if ((n4 & 4) != 0) {
                        n3 |= 1;
                    }
                    if ((this.joy0ActionMask & 0x10) != 0) {
                        n3 |= 0x20;
                    }
                    if ((this.joy0ActionMask & 0x20) != 0) {
                        n3 |= 0x10;
                    }
                    if ((this.joy1ActionMask & 0x10) != 0) {
                        n3 |= 0x80;
                    }
                    if ((this.joy1ActionMask & 0x20) != 0) {
                        n3 |= 0x40;
                    }
                    n3 = ~n3 & 0xFF;
                    break;
                }
                int[] nArray = this.keyboardMatrix;
                synchronized (this.keyboardMatrix) {
                    int n6 = this.outAA & 0xF;
                    if (n6 >= 0 && n6 < this.keyboardMatrix.length) {
                        if (this.shiftTStateCounter > 0) {
                            if (n6 == 6) {
                                n3 = ~(this.keyboardMatrix[n6] & 5) & 0xFF;
                            }
                        } else {
                            n3 = ~this.keyboardMatrix[n6] & 0xFF;
                        }
                    }
                    // ** MonitorExit[var4_5] (shouldn't be in output)
                    break;
                }
            }
            case 170: {
                n3 = this.outAA | 0xF;
                break;
            }
            case 192: 
            case 193: 
            case 194: 
            case 195: {
                if (this.kcNet == null) break;
                n3 = this.kcNet.read(n);
            }
        }
        return n3;
    }

    @Override
    public int readMemByte(int n, boolean bl) {
        if (bl) {
            this.emuThread.getZ80CPU().addWaitStates(1);
        }
        return this.getMemByte(n, bl);
    }

    @Override
    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        super.reset(resetLevel, properties);
        if (resetLevel == EmuThread.ResetLevel.POWER_ON || resetLevel == EmuThread.ResetLevel.COLD_RESET) {
            this.ctc80.reset(true);
            this.pio90.reset(true);
        } else {
            this.ctc80.reset(false);
            this.pio90.reset(false);
        }
        this.vis.reset(resetLevel);
        if (this.fdc != null) {
            this.fdc.reset(resetLevel == EmuThread.ResetLevel.POWER_ON);
        }
        if (this.floppyDiskDrives != null) {
            for (int i = 0; i < this.floppyDiskDrives.length; ++i) {
                FloppyDiskDrive floppyDiskDrive = this.floppyDiskDrives[i];
                if (floppyDiskDrive == null) continue;
                floppyDiskDrive.reset();
            }
        }
        this.tapeInPhase = this.emuThread.readTapeInPhase();
        this.fdcReset = false;
        this.joyEnabled = false;
        this.joy1Selected = false;
        this.joy0ActionMask = 0;
        this.joy1ActionMask = 0;
        this.memConfig = 0;
        this.psgRegNum = 0;
        this.v24BitOut = true;
        this.v24BitNum = 0;
        this.v24ShiftBuf = 0;
        this.v24TStateCounter = 0;
        this.shiftTStateCounter = 0;
        this.setKeyClickPhase(false);
        this.setCapsLockLED(false);
        this.setTapeLED(false);
    }

    @Override
    public void saveBasicProgram() {
        int n = SourceUtil.getBasicEndAddr(this.emuThread, 32769);
        if (n >= 32769) {
            new SaveDlg(this.screenFrm, 32769, n, "RBASIC-Programm speichern", SaveDlg.BasicType.RBASIC, EmuUtil.getBasicFileFilter()).setVisible(true);
        } else {
            this.showNoBasic();
        }
    }

    @Override
    public void setFloppyDiskDrive(int n, FloppyDiskDrive floppyDiskDrive) {
        if (this.floppyDiskDrives != null && n >= 0 && n < this.floppyDiskDrives.length) {
            this.floppyDiskDrives[n] = floppyDiskDrive;
        }
    }

    @Override
    public void setJoystickAction(int n, int n2) {
        if (n == 0) {
            this.joy0ActionMask = n2;
        } else if (n == 1) {
            this.joy1ActionMask = n2;
        }
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        boolean bl = false;
        if ((n &= 0xFFFF) >= 0 && n < 16384 && (this.memConfig & 3) == 2 || n >= 16384 && n < 32768 && (this.memConfig & 0xC) == 8 || n >= 32768 && n < 49152 && (this.memConfig & 0x30) == 32 || n >= 49152 && (this.memConfig & 0xC0) == 128) {
            this.emuThread.setRAMByte(n, n2);
            bl = true;
        }
        return bl;
    }

    @Override
    public void soundOutFrameRateChanged(int n) {
        this.psg.setFrameRate(n);
    }

    @Override
    public synchronized void startPastingText(String string) {
        boolean bl;
        block9: {
            bl = false;
            if (string != null && !string.isEmpty()) {
                if (this.pasteFast) {
                    this.cancelPastingText();
                    StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
                    char c = stringCharacterIterator.first();
                    if (c != '\uffff') {
                        if (c == '\n') {
                            c = '\r';
                        }
                        try {
                            this.keyReleased();
                            Thread.sleep(100L);
                            if (this.keyTyped(c)) {
                                this.pasteIter = stringCharacterIterator;
                                bl = true;
                                break block9;
                            }
                            this.fireShowCharNotPasted(stringCharacterIterator);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else {
                    super.startPastingText(string);
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.screenFrm.firePastingTextFinished();
        }
    }

    @Override
    public boolean supportsCopyToClipboard() {
        return true;
    }

    @Override
    public boolean supportsKeyboardFld() {
        return true;
    }

    @Override
    public boolean supportsPasteFromClipboard() {
        return true;
    }

    @Override
    public boolean supportsPrinter() {
        return true;
    }

    @Override
    public boolean supportsRAMFloppy1() {
        return this.ramFloppy1 != null;
    }

    @Override
    public boolean supportsRAMFloppy2() {
        return this.ramFloppy2 != null;
    }

    @Override
    public boolean supportsSaveBasic() {
        return true;
    }

    @Override
    public boolean supportsSoundOut8Bit() {
        return true;
    }

    @Override
    public boolean supportsSoundOutMono() {
        return true;
    }

    @Override
    public boolean supportsTapeIn() {
        return true;
    }

    @Override
    public boolean supportsTapeOut() {
        return true;
    }

    @Override
    public void updSysCells(int n, int n2, FileFormat fileFormat, int n3) {
        int n4;
        if (n == 32769 && fileFormat != null && ((fileFormat.equals(FileFormat.RBASIC_PRG) || fileFormat.equals(FileFormat.BASIC_PRG)) && n == 32769 && n2 > 7 || fileFormat.equals(FileFormat.HEADERSAVE) && n3 == 66 && n <= 32769 && n + n2 > 32776) && (n4 = SourceUtil.getBasicEndAddr(this.emuThread, 32769)) > 32769) {
            this.emuThread.setMemByte(32768, 0);
            this.emuThread.setMemWord(62856, ++n4);
            this.emuThread.setMemWord(62858, n4);
            this.emuThread.setMemWord(62860, n4);
            this.emuThread.setMemWord(62862, 32768);
            this.emuThread.setMemWord(63099, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeIOByte(int n, int n2, int n3) {
        switch (n & 0xFF) {
            case 32: 
            case 33: {
                if (this.ramFloppy1 == null) break;
                this.ramFloppy1.writeByte(n, n2);
                break;
            }
            case 36: 
            case 37: {
                if (this.ramFloppy2 == null) break;
                this.ramFloppy2.writeByte(n, n2);
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                if (this.vdip == null) break;
                this.vdip.write(n, n2);
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                if (this.fdc == null) break;
                this.fdc.write(n2);
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                boolean bl;
                if (this.fdc == null) break;
                if ((n2 & 0x10) != 0) {
                    this.fdc.fireTC();
                }
                if ((bl = (n2 & 0x20) != 0) & !this.fdcReset) {
                    this.fdc.reset(false);
                }
                this.fdcReset = bl;
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                if (this.ctc50 == null) break;
                this.ctc50.write(n & 3, n2, n3);
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                this.ctc80.write(n & 3, n2, n3);
                break;
            }
            case 144: {
                this.pio90.writeDataA(n2);
                break;
            }
            case 145: {
                A5105 a5105 = this;
                synchronized (a5105) {
                    boolean bl;
                    this.pio90.writeDataB(n2);
                    int n4 = this.pio90.fetchOutValuePortB(false);
                    boolean bl2 = bl = (n4 & 2) != 0;
                    if (!bl && this.v24BitOut && this.v24BitNum == 0) {
                        this.v24ShiftBuf = 0;
                        this.v24TStateCounter = 585;
                        ++this.v24BitNum;
                    }
                    this.v24BitOut = bl;
                    this.joyEnabled = (n4 & 0x40) == 0;
                    this.joy1Selected = (n4 & 0x20) == 0;
                    break;
                }
            }
            case 146: {
                this.pio90.writeControlA(n2);
                break;
            }
            case 147: {
                this.pio90.writeControlB(n2);
                break;
            }
            case 152: {
                this.gdc.writeArg(n2);
                break;
            }
            case 153: {
                this.gdc.writeCmd(n2);
                break;
            }
            case 156: {
                this.vis.writeFontByte(n2);
                break;
            }
            case 157: {
                this.vis.writeMode(n2);
                break;
            }
            case 158: {
                this.vis.writeFontAddr(n2);
                break;
            }
            case 160: {
                this.psgRegNum = n2 & 0xF;
                break;
            }
            case 161: {
                if (this.psgRegNum > 13) break;
                if (this.psgRegNum == 7) {
                    this.psg.setRegister(this.psgRegNum, ~n2);
                    break;
                }
                this.psg.setRegister(this.psgRegNum, n2);
                break;
            }
            case 168: {
                this.memConfig = n2;
                break;
            }
            case 170: {
                this.outAA = n2;
                break;
            }
            case 171: {
                boolean bl = (n2 & 1) == 0;
                switch (n2 & 0xE) {
                    case 8: {
                        this.setTapeLED(bl && (this.outAA & 0x40) != 0);
                        break;
                    }
                    case 10: {
                        this.tapeOutPhase = bl && (this.outAA & 0x20) == 0;
                        break;
                    }
                    case 12: {
                        this.setCapsLockLED(bl);
                        break;
                    }
                    case 14: {
                        this.setKeyClickPhase(bl && (this.outAA & 0x80) == 0);
                    }
                }
                break;
            }
            case 192: 
            case 193: 
            case 194: 
            case 195: {
                if (this.kcNet == null) break;
                this.kcNet.write(n, n2);
            }
        }
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        super.z80MaxSpeedChanged(z80CPU);
        this.gdc.z80MaxSpeedChanged(z80CPU);
        if (this.fdc != null) {
            this.fdc.z80MaxSpeedChanged(z80CPU);
        }
        if (this.kcNet != null) {
            this.kcNet.z80MaxSpeedChanged(z80CPU);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        boolean bl;
        super.z80TStatesProcessed(z80CPU, n);
        this.ctc80.z80TStatesProcessed(z80CPU, n);
        if (this.ctc50 != null) {
            this.ctc50.z80TStatesProcessed(z80CPU, n);
        }
        this.gdc.z80TStatesProcessed(z80CPU, n);
        if (this.fdc != null) {
            this.fdc.z80TStatesProcessed(z80CPU, n);
        }
        if (this.kcNet != null) {
            this.kcNet.z80TStatesProcessed(z80CPU, n);
        }
        Object object = this.keyboardMatrix;
        // MONITORENTER : this.keyboardMatrix
        if (this.shiftTStateCounter > 0) {
            this.shiftTStateCounter -= n;
        }
        // MONITOREXIT : object
        if (this.v24BitNum > 0) {
            A5105 a5105 = this;
            object = a5105;
            // MONITORENTER : a5105
            this.v24TStateCounter -= n;
            if (this.v24TStateCounter < 0) {
                if (this.v24BitNum > 8) {
                    this.emuThread.getPrintMngr().putByte(this.v24ShiftBuf);
                    this.v24BitNum = 0;
                } else {
                    this.v24ShiftBuf >>= 1;
                    if (this.v24BitOut) {
                        this.v24ShiftBuf |= 0x80;
                    }
                    this.v24TStateCounter = 390;
                    ++this.v24BitNum;
                }
            }
            // MONITOREXIT : object
        }
        if ((bl = this.emuThread.readTapeInPhase()) == this.tapeInPhase) return;
        this.tapeInPhase = bl;
        this.pio90.putInValuePortB(this.tapeInPhase ? 128 : 0, 128);
    }

    private synchronized void checkAddPCListener(Properties properties) {
        boolean bl;
        Z80CPU z80CPU = this.emuThread.getZ80CPU();
        if (z80CPU != null && (bl = EmuUtil.getBooleanProperty(properties, this.propPrefix + "paste.fast", true)) != this.pasteFast) {
            this.pasteFast = bl;
            if (bl) {
                z80CPU.addPCListener(this, 64777);
            } else {
                z80CPU.removePCListener(this);
            }
        }
    }

    private void createColors(Properties properties) {
        float f = A5105.getBrightness(properties);
        if (f >= 0.0f && f <= 1.0f) {
            this.vis.createColors(f);
        }
    }

    private boolean emulatesFloppyDisk(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "fdc.enabled", true);
    }

    private boolean emulatesKCNet(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "kcnet.enabled", false);
    }

    private boolean emulatesUSB(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "vdip.enabled", false);
    }

    private boolean isFixedScreenSize(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, this.propPrefix + "fixed_screen_size", false);
    }

    private void setCapsLockLED(boolean bl) {
        if (bl != this.capsLockLED) {
            this.capsLockLED = bl;
            if (this.keyboardFld != null) {
                this.keyboardFld.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setCharInKBMatrix(int[][] nArray, char c) {
        boolean bl = false;
        int[] nArray2 = this.keyboardMatrix;
        synchronized (this.keyboardMatrix) {
            int n = Math.min(this.keyboardMatrix.length, nArray.length);
            block3: for (int i = 0; i < n; ++i) {
                int n2 = 1;
                int[] nArray3 = nArray[i];
                for (int j = 0; j < nArray3.length; ++j) {
                    if (c == nArray3[j]) {
                        int n3 = i;
                        this.keyboardMatrix[n3] = this.keyboardMatrix[n3] | n2;
                        bl = true;
                        continue block3;
                    }
                    n2 <<= 1;
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return bl;
        }
    }

    private void setKeyClickPhase(boolean bl) {
        int n;
        if (bl != this.keyClickPhase && this.keyClickSamples == null && (n = this.psg.getFrameRate()) > 0) {
            int n2 = Math.round((float)n * 0.1f / 1000.0f);
            if (n2 < 1) {
                n2 = 1;
            }
            byte[] byArray = new byte[5 * n2];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = i < n2 || i >= 4 * n2 ? -12 : (i >= 2 * n2 && i < 3 * n2 ? -18 : 0);
            }
            this.keyClickSamples = new ByteIterator(byArray);
        }
        this.keyClickPhase = bl;
    }

    private void setTapeLED(boolean bl) {
        if (bl != this.tapeLED && this.keyboardFld != null) {
            this.keyboardFld.repaint();
        }
        this.tapeLED = bl;
    }

    private void updKeyboardFld() {
        if (this.keyboardFld != null) {
            this.keyboardFld.updKeySelection(this.keyboardMatrix);
        }
    }
}

