/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.util.EventObject;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jkcemu.base.BaseDlg;
import jkcemu.disk.HardDiskInfo;
import jkcemu.text.TextUtil;

public class HardDiskDetailsDlg
extends BaseDlg {
    private HardDiskInfo approvedData = null;
    private JComboBox<String> comboProducer;
    private JTextField fldProducer;
    private JTextField fldModel;
    private JTextField fldCylinders;
    private JTextField fldHeads;
    private JTextField fldSectors;
    private JButton btnOK;
    private JButton btnCancel;

    public static HardDiskInfo showHardDiskDetailsDlg(Window window, String string, Set<String> set) {
        HardDiskDetailsDlg hardDiskDetailsDlg = new HardDiskDetailsDlg(window, set);
        hardDiskDetailsDlg.setTitle(string);
        hardDiskDetailsDlg.setVisible(true);
        return hardDiskDetailsDlg.approvedData;
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        Object object;
        boolean bl = false;
        if (eventObject != null && (object = eventObject.getSource()) != null) {
            if (object == this.btnOK || object == this.fldSectors) {
                bl = true;
                this.doApprove();
            } else if (object == this.btnCancel) {
                bl = true;
                this.doClose();
            } else if (object instanceof JTextField) {
                bl = true;
                ((JTextField)object).transferFocus();
            }
        }
        return bl;
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        if (this.comboProducer != null) {
            this.comboProducer.requestFocus();
        } else if (this.fldProducer != null) {
            this.fldProducer.requestFocus();
        }
    }

    private HardDiskDetailsDlg(Window window, Set<String> set) {
        super(window, "JKCEMU Festplattendetails");
        Object object;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.add((Component)new JLabel("Hersteller:"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Modell:"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Zylinder:"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("K\u00f6pfe:"), gridBagConstraints);
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Sektoren pro Spur:"), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.gridy = 0;
        ++gridBagConstraints.gridx;
        this.comboProducer = null;
        this.fldProducer = null;
        if (set != null && !set.isEmpty()) {
            this.comboProducer = new JComboBox();
            object = set.iterator();
            while (object.hasNext()) {
                String string = object.next();
                this.comboProducer.addItem(string);
            }
            this.comboProducer.setEditable(true);
            this.comboProducer.setSelectedItem("");
            this.add(this.comboProducer, gridBagConstraints);
        }
        if (this.comboProducer == null) {
            this.fldProducer = new JTextField();
            this.add((Component)this.fldProducer, gridBagConstraints);
        }
        this.fldModel = new JTextField();
        this.fldModel.addActionListener(this);
        ++gridBagConstraints.gridy;
        this.add((Component)this.fldModel, gridBagConstraints);
        this.fldCylinders = new JTextField();
        this.fldCylinders.addActionListener(this);
        ++gridBagConstraints.gridy;
        this.add((Component)this.fldCylinders, gridBagConstraints);
        this.fldHeads = new JTextField();
        this.fldHeads.addActionListener(this);
        ++gridBagConstraints.gridy;
        this.add((Component)this.fldHeads, gridBagConstraints);
        this.fldSectors = new JTextField();
        this.fldSectors.addActionListener(this);
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        this.add((Component)this.fldSectors, gridBagConstraints);
        if (this.comboProducer != null && (object = this.fldModel.getFont()) != null) {
            this.comboProducer.setFont((Font)object);
        }
        object = new JPanel(new GridLayout(1, 2, 5, 5));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)object, gridBagConstraints);
        this.btnOK = new JButton("OK");
        this.btnOK.addActionListener(this);
        ((Container)object).add(this.btnOK);
        this.btnCancel = new JButton("Abbrechen");
        this.btnCancel.addActionListener(this);
        ((Container)object).add(this.btnCancel);
        this.pack();
        this.setParentCentered();
        this.setResizable(true);
    }

    private void doApprove() {
        try {
            Object object;
            String string = null;
            if (this.comboProducer != null) {
                object = this.comboProducer.getSelectedItem();
                if (object != null) {
                    string = TextUtil.emptyToNull(object.toString());
                }
            } else if (this.fldProducer != null) {
                string = TextUtil.emptyToNull(this.fldProducer.getText());
            }
            object = TextUtil.emptyToNull(this.fldModel.getText());
            String string2 = TextUtil.emptyToNull(this.fldCylinders.getText());
            String string3 = TextUtil.emptyToNull(this.fldHeads.getText());
            String string4 = TextUtil.emptyToNull(this.fldSectors.getText());
            if (object != null && string2 != null && string3 != null && string4 != null) {
                this.approvedData = new HardDiskInfo(string, (String)object, this.parseInt(string2, "Zylinder"), this.parseInt(string3, "K\u00f6pfe"), this.parseInt(string4, "Sektoren pro Spur"));
                this.doClose();
            } else {
                BaseDlg.showErrorDlg((Component)this, "Mindestens eins der folgende Felder ist nicht ausgef\u00fcllt:\n  Modell\n  Zylinder\n  K\u00f6pfe\n  Sektoren pro Spur");
            }
        }
        catch (Exception exception) {
            BaseDlg.showErrorDlg((Component)this, exception);
        }
    }

    private int parseInt(String string, String string2) throws ParseException {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(string2 + ": Ung\u00fcltige Eingabe", 0);
        }
        return n;
    }
}

