/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import jkcemu.Main;
import jkcemu.base.EmuUtil;
import jkcemu.disk.HardDisk;
import jkcemu.etc.RTC7242X;

public class GIDE
implements Runnable {
    public static final String PROP_HARDDISK_PREFIX = "harddisk.";
    public static final String PROP_CYLINDERS = "cylinders";
    public static final String PROP_ENABLED = "gide.enabled";
    public static final String PROP_IOBASEADDR = "gide.io_base_addr";
    public static final String PROP_FILE = "file";
    public static final String PROP_HEADS = "heads";
    public static final String PROP_MODEL = "model";
    public static final String PROP_OFFSET = "offset";
    public static final String PROP_SECTORS_PER_TRACK = "sectors_per_track";
    private static final String SYSPROP_DEBUG = "jkcemu.debug.gide";
    private static final int STATUS_ERROR = 1;
    private static final int STATUS_DATA_REQUEST = 8;
    private static final int STATUS_SEEK_COMPLETE = 16;
    private static final int STATUS_WRITE_FAULT = 32;
    private static final int STATUS_DRIVE_READY = 64;
    private static final int STATUS_BUSY = 128;
    private static final int ERROR_TRACK0_NOT_FOUND = 2;
    private static final int ERROR_CMD_ABORTED = 4;
    private static final int ERROR_WRONG_SECTOR = 16;
    private static final int ERROR_UNCORRECTABLE_DATA = 64;
    private static final int SECTOR_SIZE = 512;
    private static final String[] propKeys = new String[]{"model", "cylinders", "heads", "sectors_per_track", "file"};
    private Component owner;
    private String propPrefix;
    private HardDisk[] disks;
    private RTC7242X rtc;
    private BlockingQueue<IOTask> ioTaskQueue;
    private volatile Command pendingCmd;
    private volatile boolean ioTaskEnabled;
    private volatile Thread ioTaskThread;
    private byte[] ioBuf;
    private int ioBufPos;
    private int ioByteCnt;
    private int debugLevel;
    private int sectorCnt;
    private int sectorNum;
    private int cylNum;
    private int sdhReg;
    private volatile int statusReg;
    private volatile int errorReg;
    private int powerMode;
    private volatile int curCmd;
    private volatile int curDiskIdx;
    private HardDisk curDisk;
    private int[] offsets;
    private int[] cylinders;
    private int[] heads;
    private int[] sectorsPerTrack;
    private long[] totalSectors;
    private boolean interruptEnabled;
    private volatile boolean interruptRequest;
    private boolean resetFlag;
    private boolean readMissingFileShown;
    private boolean readErrShown;
    private boolean writeErrShown;

    public static boolean complies(GIDE gIDE, Properties properties, String string) {
        boolean bl = false;
        if (GIDE.emulatesGIDE(properties, string)) {
            if (gIDE != null) {
                bl = gIDE.sameDisks(GIDE.getHardDisks(properties, string));
            }
        } else if (gIDE == null) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void die() {
        this.ioTaskEnabled = false;
        this.ioTaskThread.interrupt();
        Thread thread = this.ioTaskThread;
        synchronized (thread) {
            try {
                this.ioTaskThread.notify();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
    }

    public static GIDE getGIDE(Component component, Properties properties, String string) {
        return GIDE.emulatesGIDE(properties, string) ? new GIDE(component, string, GIDE.getHardDisks(properties, string)) : null;
    }

    public boolean isInterruptRequest() {
        return this.interruptRequest;
    }

    public synchronized int read(int n) {
        int n2 = -1;
        switch (n & 0xF) {
            case 5: {
                n2 = this.rtc.read(n >> 8);
                if (this.debugLevel <= 0) break;
                System.out.printf("GIDE: read rtc reg %d: %02X\n", n >> 8 & 0xFF, n2);
                break;
            }
            case 6: {
                n2 = this.statusReg;
                if (this.debugLevel <= 2) break;
                System.out.printf("GIDE: read alternate status: %02X\n", n2);
                break;
            }
            case 7: {
                n2 = this.sdhReg & 0x1F;
                if (this.debugLevel <= 0) break;
                System.out.printf("GIDE: read drive+head: %02X\n", n2);
                break;
            }
            case 8: {
                this.interruptRequest = false;
                n2 = this.readDataReg();
                if (this.debugLevel <= 1) break;
                System.out.printf("GIDE: read data: %02X\n", n2);
                break;
            }
            case 9: {
                n2 = this.errorReg;
                if (this.debugLevel <= 0) break;
                System.out.printf("GIDE: read error: %02X\n", n2);
                break;
            }
            case 10: {
                n2 = this.sectorCnt;
                if (this.debugLevel <= 0) break;
                System.out.printf("GIDE: read sector count: %02X\n", n2);
                break;
            }
            case 11: {
                n2 = this.sectorNum;
                if (this.debugLevel <= 0) break;
                System.out.printf("GIDE: read sector number: %02X\n", n2);
                break;
            }
            case 12: {
                n2 = this.cylNum & 0xFF;
                if (this.debugLevel <= 0) break;
                System.out.printf("GIDE: cyl number (low byte): %02X\n", n2);
                break;
            }
            case 13: {
                n2 = this.cylNum >> 8 & 0xFF;
                if (this.debugLevel <= 0) break;
                System.out.printf("GIDE: cyl number (high byte): %02X\n", n2);
                break;
            }
            case 14: {
                n2 = this.sdhReg;
                if (this.debugLevel <= 0) break;
                System.out.printf("GIDE: read sdh: %02X\n", n2);
                break;
            }
            case 15: {
                n2 = this.statusReg;
                this.interruptRequest = false;
                if (this.debugLevel <= 2) break;
                System.out.printf("GIDE: read status: %02X\n", n2);
            }
        }
        return n2;
    }

    public synchronized void reset() {
        if (this.debugLevel > 0) {
            System.out.println("GIDE: reset");
        }
        this.pendingCmd = Command.NONE;
        this.resetFlag = false;
        this.ioTaskThread.interrupt();
        if (this.disks != null) {
            int n;
            boolean bl = false;
            if (this.offsets != null && this.cylinders != null && this.heads != null && this.sectorsPerTrack != null && this.totalSectors != null && this.cylinders.length >= this.disks.length && this.heads.length >= this.disks.length && this.sectorsPerTrack.length >= this.disks.length && this.totalSectors.length >= this.disks.length) {
                bl = false;
            }
            if (!bl) {
                this.offsets = new int[this.disks.length];
                this.cylinders = new int[this.disks.length];
                this.heads = new int[this.disks.length];
                this.sectorsPerTrack = new int[this.disks.length];
                this.totalSectors = new long[this.disks.length];
            }
            int n2 = 0;
            for (n = 0; n < this.disks.length; ++n) {
                this.offsets[n] = this.disks[n].getOffset();
                this.cylinders[n] = this.disks[n].getCylinders();
                this.heads[n] = this.disks[n].getHeads();
                this.sectorsPerTrack[n] = this.disks[n].getSectorsPerTrack();
                this.totalSectors[n] = (long)this.cylinders[n] * (long)this.heads[n] * (long)this.sectorsPerTrack[n];
                if (this.sectorsPerTrack[n] <= n2) continue;
                n2 = this.sectorsPerTrack[n];
            }
            n = Math.max(n2, 1) * 512;
            if (this.ioBuf != null && this.ioBuf.length < n) {
                this.ioBuf = null;
            }
            if (this.ioBuf == null) {
                this.ioBuf = new byte[n];
            }
        }
        if (this.ioBuf != null) {
            Arrays.fill(this.ioBuf, (byte)0);
        }
        this.softReset();
    }

    public synchronized void write(int n, int n2) {
        n2 &= 0xFF;
        switch (n & 0xF) {
            case 5: {
                if (this.debugLevel > 0) {
                    System.out.printf("GIDE: write rtc reg %d: %02X\n", n >> 8 & 0xFF, n2);
                }
                this.rtc.write(n >> 8, n2);
                break;
            }
            case 6: {
                boolean bl;
                if (this.debugLevel > 0) {
                    System.out.printf("GIDE: write digital output: %02X\n", n2);
                }
                boolean bl2 = bl = (n2 & 4) != 0;
                if (bl && !this.resetFlag) {
                    if (this.debugLevel > 0) {
                        System.out.println("GIDE: soft reset");
                    }
                    this.softReset();
                }
                this.resetFlag = bl;
                this.interruptEnabled = (n2 & 2) != 0;
                this.fireInterrupt();
                break;
            }
            case 8: {
                if (this.debugLevel > 1) {
                    System.out.printf("GIDE: write data: %02X\n", n2);
                }
                this.writeDataReg(n2);
                break;
            }
            case 10: {
                if (this.debugLevel > 0) {
                    System.out.printf("GIDE: write sector count: %02X\n", n2);
                }
                this.sectorCnt = n2;
                break;
            }
            case 11: {
                if (this.debugLevel > 0) {
                    System.out.printf("GIDE: write sector number: %02X\n", n2);
                }
                this.sectorNum = n2;
                break;
            }
            case 12: {
                if (this.debugLevel > 0) {
                    System.out.printf("GIDE: write cyl number (low byte): %02X\n", n2);
                }
                this.cylNum = this.cylNum & 0xFF00 | n2;
                break;
            }
            case 13: {
                if (this.debugLevel > 0) {
                    System.out.printf("GIDE: write cyl number (high byte): %02X\n", n2);
                }
                this.cylNum = n2 << 8 & 0xFF00 | this.cylNum & 0xFF;
                break;
            }
            case 14: {
                if (this.debugLevel > 0) {
                    System.out.printf("GIDE: write sdh: %02X\n", n2);
                }
                this.sdhReg = n2;
                break;
            }
            case 15: {
                if (this.debugLevel > 0) {
                    System.out.printf("GIDE: write command: %02X\n", n2);
                }
                if ((this.statusReg & 0x80) == 0) {
                    this.execCmd(n2);
                    break;
                }
                if (this.debugLevel <= 0) break;
                System.out.printf("GIDE: command %02X ignored because busy\n", n2);
            }
        }
    }

    @Override
    public void run() {
        while (this.ioTaskEnabled) {
            try {
                IOTask iOTask = this.ioTaskQueue.take();
                if (!this.ioTaskEnabled) continue;
                switch (iOTask.cmd) {
                    case READ_SECTORS: {
                        this.execReadSectorsTask(iOTask);
                        break;
                    }
                    case WRITE_SECTORS: {
                        this.execWriteSectorsTask(iOTask);
                        break;
                    }
                    case FORMAT_TRACK: {
                        this.execFormatTrackTask(iOTask);
                    }
                }
                this.statusReg &= 0xFFFFFF7F;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private GIDE(Component component, String string, HardDisk[] hardDiskArray) {
        this.owner = component;
        this.propPrefix = string;
        this.disks = hardDiskArray;
        this.debugLevel = 0;
        this.rtc = new RTC7242X();
        this.offsets = null;
        this.cylinders = null;
        this.heads = null;
        this.sectorsPerTrack = null;
        this.totalSectors = null;
        this.ioBuf = null;
        this.ioTaskEnabled = true;
        this.ioTaskQueue = new ArrayBlockingQueue<IOTask>(1);
        this.ioTaskThread = new Thread(Main.getThreadGroup(), this, "JKCEMU GIDE");
        String string2 = System.getProperty(SYSPROP_DEBUG);
        if (string2 != null) {
            try {
                this.debugLevel = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.ioTaskThread.start();
        this.reset();
    }

    private long calcFilePos() {
        long l = -1L;
        if (this.curDiskIdx >= 0) {
            long l2;
            long l3 = this.sectorsPerTrack[this.curDiskIdx];
            long l4 = this.heads[this.curDiskIdx];
            long l5 = this.sdhReg & 0xF;
            if (this.cylNum >= 0 && l5 >= 0L && l5 < l4 && this.sectorNum >= 1 && (long)this.sectorNum <= l3 && (l2 = (long)this.cylNum * l4 * l3 + l5 * l3 + (long)(this.sectorNum - 1)) >= 0L && l2 <= this.totalSectors[this.curDiskIdx]) {
                l = (long)this.offsets[this.curDiskIdx] + l2 * 512L;
            }
            if (l < 0L && this.debugLevel > 3) {
                System.out.printf("GIDE calc file pos error: offs=%d cyl=%d head=%d sector=%d cyls=%d heads=%d sectors_per_track=%d\n", this.offsets[this.curDiskIdx], this.cylNum, l5, this.sectorNum, this.cylinders[this.curDiskIdx], l4, l3);
            }
        } else if (this.debugLevel > 3) {
            System.out.println("GIDE calc file pos error: curDiskIdx < 0");
        }
        return l;
    }

    private int countSector() {
        int n = 0;
        this.sectorCnt = this.sectorCnt - 1 & 0xFF;
        if (this.curDiskIdx >= 0) {
            int n2 = this.sectorNum + 1;
            if (n2 <= this.sectorsPerTrack[this.curDiskIdx]) {
                this.sectorNum = n2 & 0xFF;
            } else {
                int n3 = this.heads[this.curDiskIdx];
                int n4 = (this.sdhReg & 0xF) + 1;
                if (this.sectorCnt > 0) {
                    if (n4 <= n3) {
                        this.sdhReg = this.sdhReg & 0xF0 | n4 & 0xF;
                        this.sectorNum = 1;
                        n = 1;
                    } else {
                        this.pendingCmd = Command.NONE;
                        this.errorReg = 4;
                        this.statusReg = 1;
                        n = 0;
                    }
                } else {
                    if (n4 <= n3) {
                        this.sdhReg = this.sdhReg & 0xF0 | n4 & 0xF;
                    } else {
                        this.sdhReg &= 0xF0;
                        this.cylNum = this.cylNum < this.cylinders[this.curDiskIdx] ? ++this.cylNum : 0;
                    }
                    this.sectorNum = 1;
                    this.pendingCmd = Command.NONE;
                    this.errorReg = 0;
                    this.statusReg = 80;
                    n = 0;
                }
            }
        }
        return n;
    }

    private static boolean emulatesGIDE(Properties properties, String string) {
        boolean bl = true;
        String string2 = EmuUtil.getProperty(properties, string + PROP_ENABLED);
        if (string2.isEmpty()) {
            for (int i = 0; i < propKeys.length; ++i) {
                if (!EmuUtil.getProperty(properties, String.format("%s%s1.%s", string, PROP_HARDDISK_PREFIX, propKeys[i])).isEmpty()) continue;
                bl = false;
                break;
            }
        } else {
            bl = Boolean.parseBoolean(string2);
        }
        return bl;
    }

    private void execCmd(int n) {
        int n2;
        this.curCmd = n;
        this.errorReg = 0;
        this.curDiskIdx = -1;
        this.curDisk = null;
        if (this.disks != null && (n2 = this.sdhReg >> 4 & 1) < this.disks.length) {
            this.curDiskIdx = n2;
            this.curDisk = this.disks[n2];
        }
        this.statusReg = this.curDisk != null ? 80 : 0;
        switch (this.curCmd) {
            case 64: 
            case 65: {
                if (this.debugLevel > 0) {
                    System.out.println("  verify sectors");
                }
                this.execCmdVerifySectors();
                break;
            }
            case 80: {
                this.execCmdFormatTrack();
                if (this.debugLevel <= 0) break;
                System.out.println("  format track");
                break;
            }
            case 144: {
                if (this.debugLevel > 0) {
                    System.out.println("  diagnostics");
                }
                this.execCmdDiagnostics();
                break;
            }
            case 145: {
                if (this.debugLevel > 0) {
                    System.out.println("  set drive parameters");
                }
                this.execCmdSetDriveParameters();
                break;
            }
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 230: {
                if (this.debugLevel > 0) {
                    System.out.println("  set power mode");
                }
                this.execCmdSetPowerMode();
                break;
            }
            case 228: {
                if (this.debugLevel > 0) {
                    System.out.println("  read buffer");
                }
                this.execCmdReadBuffer();
                break;
            }
            case 229: {
                if (this.debugLevel > 0) {
                    System.out.println("  read power mode");
                }
                this.execCmdReadPowerMode();
                break;
            }
            case 232: {
                if (this.debugLevel > 0) {
                    System.out.println("  write buffer");
                }
                this.execCmdWriteBuffer();
                break;
            }
            case 236: {
                if (this.debugLevel > 0) {
                    System.out.println("  identify drive");
                }
                this.execCmdIdentifyDrive();
                break;
            }
            default: {
                if ((n & 0xF8) == 16) {
                    if (this.debugLevel > 0) {
                        System.out.println("  recalibrate");
                    }
                    this.execCmdRecalibrate();
                    break;
                }
                if ((n & 0xF8) == 32) {
                    if (this.debugLevel > 0) {
                        System.out.println("  read sectors");
                    }
                    this.execCmdReadSectors();
                    break;
                }
                if ((n & 0xF8) == 48) {
                    if (this.debugLevel > 0) {
                        System.out.println("  write sectors");
                    }
                    this.execCmdWriteSectors();
                    break;
                }
                if ((n & 0xF0) != 112) break;
                if (this.debugLevel > 0) {
                    System.out.println("  seek");
                }
                this.fireInterrupt();
            }
        }
    }

    private void execCmdDiagnostics() {
        if (this.curDisk != null) {
            this.errorReg = 1;
            if (this.curDiskIdx == 0 && this.disks.length < 2) {
                this.errorReg |= 0x80;
            }
        }
    }

    private void execCmdFormatTrack() {
        this.ioBufPos = 0;
        this.pendingCmd = Command.FORMAT_TRACK;
        this.statusReg |= 8;
    }

    private void execCmdIdentifyDrive() {
        if (this.curDisk != null) {
            Arrays.fill(this.ioBuf, 0, 512, (byte)0);
            this.setIOBufWord(0, 346);
            this.setIOBufWord(2, this.curDisk.getCylinders());
            this.setIOBufWord(6, this.curDisk.getHeads());
            this.setIOBufWord(8, this.curDisk.getSectorsPerTrack() * 512);
            this.setIOBufWord(10, 512);
            this.setIOBufWord(12, this.curDisk.getSectorsPerTrack());
            this.setIOBufASCII(20, "JKCEMU Version 0.9.7", 20);
            this.setIOBufWord(42, 1);
            this.setIOBufASCII(46, "JKCEMU", 8);
            String string = this.curDisk.getDiskModel();
            if (string != null && string.isEmpty()) {
                string = null;
            }
            if (string == null) {
                string = String.format("Sonstige (%dx%dx%d)", this.curDisk.getCylinders(), this.curDisk.getHeads(), this.curDisk.getSectorsPerTrack());
            }
            this.setIOBufASCII(54, string, 40);
            File file = this.curDisk.getFile();
            if (file != null && !file.canWrite()) {
                this.setIOBufWord(98, 1);
            }
            this.ioBufPos = 0;
            this.pendingCmd = Command.IDENTIFY_DISK;
            this.statusReg |= 8;
            this.fireInterrupt();
        }
    }

    private void execCmdReadBuffer() {
        this.ioBufPos = 0;
        this.pendingCmd = Command.READ_BUFFER;
        this.statusReg |= 8;
        this.fireInterrupt();
    }

    private void execCmdReadPowerMode() {
        this.sectorCnt = (this.powerMode & 1) != 0 ? 255 : 0;
    }

    private void execCmdReadSectors() {
        if ((this.curCmd & 6) != 0) {
            this.errorReg = 4;
            this.statusReg |= 1;
        } else {
            this.pendingCmd = Command.READ_SECTORS;
            this.fireFetchSectors();
        }
    }

    private void execCmdRecalibrate() {
        if (this.curDisk != null) {
            this.cylNum = 0;
            this.errorReg = 0;
            this.fireInterrupt();
        } else {
            this.errorReg = 2;
            this.statusReg |= 1;
        }
    }

    private void execCmdSetDriveParameters() {
        if (this.curDiskIdx >= 0) {
            this.cylinders[this.curDiskIdx] = this.cylNum;
            this.heads[this.curDiskIdx] = (this.sdhReg & 0xF) + 1;
            this.sectorsPerTrack[this.curDiskIdx] = this.sectorCnt;
        }
    }

    private void execCmdSetPowerMode() {
        int n = this.curCmd & 7;
        if (n != this.powerMode) {
            this.powerMode = n;
            this.fireInterrupt();
        }
    }

    private void execCmdVerifySectors() {
        if ((this.curCmd & 6) != 0) {
            this.errorReg = 4;
            this.statusReg |= 1;
        } else {
            do {
                this.countSector();
            } while (this.sectorCnt > 0);
            this.fireInterrupt();
        }
    }

    private void execCmdWriteBuffer() {
        this.ioBufPos = 0;
        this.pendingCmd = Command.WRITE_BUFFER;
        this.statusReg |= 8;
    }

    private void execCmdWriteSectors() {
        if ((this.curCmd & 6) != 0) {
            this.errorReg = 4;
            this.statusReg |= 1;
        } else {
            this.ioBufPos = 0;
            this.pendingCmd = Command.WRITE_SECTORS;
            this.statusReg |= 8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execFormatTrackTask(IOTask iOTask) {
        block7: {
            long l;
            if (iOTask.file == null || iOTask.filePos < 0L || l <= 0L) break block7;
            boolean bl = false;
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(iOTask.file, "rw");
                randomAccessFile.seek(iOTask.filePos);
                for (l = (long)iOTask.byteCnt; l > 0L; --l) {
                    randomAccessFile.write(0);
                }
                randomAccessFile.close();
                randomAccessFile = null;
            }
            catch (IOException iOException) {
                block6: {
                    try {
                        bl = true;
                        if (this.writeErrShown) break block6;
                        this.writeErrShown = true;
                        EmuUtil.fireShowError(this.owner, null, iOException);
                    }
                    catch (Throwable throwable) {
                        EmuUtil.closeSilent(randomAccessFile);
                        throw throwable;
                    }
                }
                EmuUtil.closeSilent(randomAccessFile);
            }
            EmuUtil.closeSilent(randomAccessFile);
            if (bl) {
                this.errorReg = 64;
                this.statusReg |= 1;
            }
            this.fireInterrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execReadSectorsTask(IOTask iOTask) {
        block10: {
            block9: {
                block11: {
                    RandomAccessFile randomAccessFile;
                    block7: {
                        if (this.debugLevel > 3) {
                            System.out.printf("GIDE io task: read track, pos=%d", iOTask.filePos);
                        }
                        int n = iOTask.byteCnt;
                        if (iOTask.file == null || iOTask.filePos < 0L || n <= 0) break block10;
                        if (!iOTask.file.exists()) break block11;
                        randomAccessFile = null;
                        try {
                            randomAccessFile = new RandomAccessFile(iOTask.file, "r");
                            randomAccessFile.seek(iOTask.filePos);
                            n = randomAccessFile.read(this.ioBuf, 0, n);
                            if (this.debugLevel <= 3) break block7;
                            System.out.printf("GIDE io task: read sector: %d read\n", n);
                        }
                        catch (IOException iOException) {
                            block8: {
                                try {
                                    if (this.debugLevel > 3) {
                                        System.out.println("GIDE io task: read sector: error");
                                    }
                                    if (this.readErrShown) break block8;
                                    this.readErrShown = true;
                                    EmuUtil.fireShowError(this.owner, "Die Festplattenabbilddatei kann nicht gelesen werden.\nGegen\u00fcber dem emulierten System wird jedoch kein Fehler signalisiert.", iOException);
                                }
                                catch (Throwable throwable) {
                                    EmuUtil.closeSilent(randomAccessFile);
                                    throw throwable;
                                }
                            }
                            EmuUtil.closeSilent(randomAccessFile);
                            break block9;
                        }
                    }
                    EmuUtil.closeSilent(randomAccessFile);
                    break block9;
                }
                if (!this.readMissingFileShown) {
                    this.readMissingFileShown = true;
                    EmuUtil.fireShowError(this.owner, "Die Festplattenabbilddatei existiert nicht und kann deshalb auch nicht gelesen werden.\nGegen\u00fcber dem emulierten System wird jedoch kein Fehler signalisiert.\nMit dem ersten Schreibzugriff auf das emulierte Laufwerk wird die Abbilddatei angelegt.", null);
                }
            }
            this.ioBufPos = 0;
            this.statusReg |= 8;
            this.fireInterrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execWriteSectorsTask(IOTask iOTask) {
        block12: {
            if (this.debugLevel > 3) {
                System.out.printf("GIDE io task: write sector, pos=%d", iOTask.filePos);
            }
            if (iOTask.file == null || iOTask.filePos < 0L) break block12;
            boolean bl = false;
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(iOTask.file, "rw");
                randomAccessFile.seek(iOTask.filePos);
                randomAccessFile.write(this.ioBuf, 0, 512);
                randomAccessFile.close();
                randomAccessFile = null;
            }
            catch (IOException iOException) {
                block11: {
                    try {
                        bl = true;
                        if (this.writeErrShown) break block11;
                        this.writeErrShown = true;
                        EmuUtil.fireShowError(this.owner, null, iOException);
                    }
                    catch (Throwable throwable) {
                        EmuUtil.closeSilent(randomAccessFile);
                        throw throwable;
                    }
                }
                EmuUtil.closeSilent(randomAccessFile);
            }
            EmuUtil.closeSilent(randomAccessFile);
            if (bl) {
                this.errorReg = 64;
                this.statusReg |= 1;
                if (this.debugLevel > 3) {
                    System.out.println("GIDE io task: write sector: error");
                }
            } else {
                this.ioBufPos = 0;
                this.countSector();
                if (this.sectorCnt > 0) {
                    this.fireInterrupt();
                } else {
                    this.statusReg = 80;
                }
                if (this.debugLevel > 3) {
                    System.out.println("GIDE io task: write sector: ok");
                }
            }
        }
    }

    private void fireFetchSectors() {
        if (this.curDisk != null && this.curDiskIdx >= 0) {
            long l = this.calcFilePos();
            if (l < 0L) {
                this.errorReg = 4;
                this.statusReg |= 1;
            } else {
                Arrays.fill(this.ioBuf, (byte)-27);
                File file = this.curDisk.getFile();
                if (file != null) {
                    int n = Math.min(this.sectorsPerTrack[this.curDiskIdx] - this.sectorNum + 1, this.sectorCnt);
                    this.startIOTask(file, l, n * 512);
                }
            }
        }
    }

    private void fireInterrupt() {
        if (this.interruptEnabled && !this.interruptRequest) {
            this.interruptRequest = true;
        }
    }

    private static HardDisk[] getHardDisks(Properties properties, String string) {
        HardDisk[] hardDiskArray = null;
        if (properties != null) {
            for (int i = 0; i < 2; ++i) {
                HardDisk hardDisk = null;
                String string2 = String.format("%s%s%d.", string, PROP_HARDDISK_PREFIX, i + 1);
                String string3 = EmuUtil.getProperty(properties, string2 + PROP_MODEL);
                String string4 = EmuUtil.getProperty(properties, string2 + PROP_FILE);
                if (!string3.isEmpty() && !string4.isEmpty()) {
                    int n = EmuUtil.getIntProperty(properties, string2 + PROP_CYLINDERS, 0);
                    int n2 = EmuUtil.getIntProperty(properties, string2 + PROP_HEADS, 0);
                    int n3 = EmuUtil.getIntProperty(properties, string2 + PROP_SECTORS_PER_TRACK, 0);
                    int n4 = EmuUtil.getIntProperty(properties, string2 + PROP_OFFSET, 0);
                    File file = new File(string4);
                    if (file.exists() && file.length() % 512L >= 256L) {
                        n4 = 256;
                    }
                    if (n > 0 && n2 > 0 && n3 > 0) {
                        hardDisk = new HardDisk(string3, n, n2, n3, string4, n4);
                    }
                }
                if (hardDisk == null) continue;
                if (hardDiskArray != null) {
                    HardDisk[] hardDiskArray2 = new HardDisk[hardDiskArray.length + 1];
                    System.arraycopy(hardDiskArray, 0, hardDiskArray2, 0, hardDiskArray.length);
                    hardDiskArray = hardDiskArray2;
                } else {
                    hardDiskArray = new HardDisk[1];
                }
                hardDiskArray[hardDiskArray.length - 1] = hardDisk;
            }
        }
        return hardDiskArray;
    }

    private int readDataReg() {
        int n = 0;
        if ((this.statusReg & 8) != 0) {
            switch (this.pendingCmd) {
                case IDENTIFY_DISK: 
                case READ_BUFFER: {
                    if (this.ioBufPos < 512) {
                        n = this.ioBuf[this.ioBufPos++] & 0xFF;
                    }
                    if (this.ioBufPos < 512) break;
                    this.pendingCmd = Command.NONE;
                    this.errorReg = 0;
                    this.statusReg = 80;
                    break;
                }
                case READ_SECTORS: {
                    if (this.ioBufPos >= 0 && this.ioBufPos < this.ioByteCnt && this.ioBufPos < this.ioBuf.length) {
                        n = this.ioBuf[this.ioBufPos] & 0xFF;
                    }
                    ++this.ioBufPos;
                    if (this.ioBufPos >= this.ioByteCnt) {
                        this.statusReg &= 0xFFFFFFF7;
                    }
                    if (this.ioBufPos % 512 != 0 || this.countSector() <= 0) break;
                    this.fireFetchSectors();
                }
            }
        }
        return n;
    }

    private boolean sameDisks(HardDisk[] hardDiskArray) {
        boolean bl = false;
        if (hardDiskArray != null && this.disks != null) {
            if (hardDiskArray.length == this.disks.length) {
                bl = true;
                for (int i = 0; i < hardDiskArray.length; ++i) {
                    if (hardDiskArray[i].isSameDisk(this.disks[i])) continue;
                    bl = false;
                    break;
                }
            }
        } else if (hardDiskArray == null && this.disks == null) {
            bl = true;
        }
        return bl;
    }

    private void setIOBufASCII(int n, String string, int n2) {
        if (n >= 0 && string != null) {
            int n3 = string.length();
            for (int i = 0; i < n3 && n + 1 < this.ioBuf.length && n2 > 1; i += 2, n2 -= 2) {
                this.ioBuf[n++] = i + 1 < n3 ? (int)string.charAt(i + 1) : 32;
                this.ioBuf[n++] = (byte)string.charAt(i);
            }
        }
    }

    private void setIOBufWord(int n, int n2) {
        if (n >= 0 && n < this.ioBuf.length - 1) {
            this.ioBuf[n++] = (byte)n2;
            this.ioBuf[n] = (byte)(n2 >> 8);
        }
    }

    private void softReset() {
        this.ioTaskQueue.clear();
        this.pendingCmd = Command.NONE;
        this.interruptEnabled = false;
        this.interruptRequest = false;
        this.readMissingFileShown = false;
        this.readErrShown = false;
        this.writeErrShown = false;
        this.ioBufPos = 0;
        this.ioByteCnt = 0;
        this.curCmd = -1;
        this.curDiskIdx = -1;
        this.curDisk = null;
        this.powerMode = 1;
        this.sectorCnt = 0;
        this.sectorNum = 0;
        this.cylNum = 0;
        this.sdhReg = 0;
        this.errorReg = 0;
        this.statusReg = 0;
        if (this.disks != null) {
            this.statusReg = 80;
        }
    }

    private void startIOTask(File file, long l, int n) {
        block2: {
            this.statusReg |= 0x80;
            try {
                this.ioByteCnt = n;
                this.ioTaskQueue.put(new IOTask(this.pendingCmd, file, l, n));
            }
            catch (Exception exception) {
                this.statusReg |= 1;
                this.statusReg &= 0xFFFFFF7F;
                if (this.debugLevel <= 0) break block2;
                exception.printStackTrace(System.out);
            }
        }
    }

    private void writeDataReg(int n) {
        if ((this.statusReg & 8) != 0) {
            switch (this.pendingCmd) {
                case FORMAT_TRACK: {
                    this.writeFormatByte(n);
                    break;
                }
                case WRITE_BUFFER: {
                    if (this.ioBufPos < 512) {
                        this.ioBuf[this.ioBufPos++] = (byte)n;
                    }
                    if (this.ioBufPos < this.ioBuf.length) break;
                    this.statusReg = 80;
                    break;
                }
                case WRITE_SECTORS: {
                    this.writeSectorByte(n);
                }
            }
        }
    }

    private void writeFormatByte(int n) {
        if (this.curDisk != null && this.curDiskIdx >= 0 && this.ioBufPos < 512) {
            this.ioBuf[this.ioBufPos++] = (byte)n;
            if (this.ioBufPos == this.ioBuf.length) {
                int n2;
                boolean bl = true;
                int n3 = this.sectorsPerTrack[this.curDiskIdx];
                boolean[] blArray = new boolean[n3];
                Arrays.fill(blArray, false);
                int n4 = 0;
                boolean bl2 = false;
                for (n2 = 0; !bl2 && n2 < blArray.length; ++n2) {
                    if (n4 + 1 < 512) {
                        int n5;
                        if (this.ioBuf[n4++] != 0) {
                            bl2 = true;
                        }
                        if ((n5 = this.ioBuf[n4++] & 0xFF) < blArray.length) {
                            if (blArray[n5]) {
                                bl2 = true;
                                continue;
                            }
                            blArray[n5] = true;
                            continue;
                        }
                        bl2 = true;
                        continue;
                    }
                    bl2 = true;
                }
                if (!bl2) {
                    for (n2 = 0; n2 < blArray.length; ++n2) {
                        if (blArray[n2]) continue;
                        bl2 = true;
                        break;
                    }
                }
                if (bl2) {
                    this.errorReg = 64;
                    this.statusReg |= 1;
                } else {
                    n2 = this.heads[this.curDiskIdx];
                    long l = this.sdhReg & 0xF;
                    if (this.cylNum >= 0 && this.cylNum < this.cylinders[this.curDiskIdx] && l >= 0L && l < (long)n2) {
                        long l2 = (long)(this.cylNum * n2 * n3) + l * (long)n3;
                        this.startIOTask(this.curDisk.getFile(), (long)this.offsets[this.curDiskIdx] + l2 * 512L, n3 * 512);
                        bl = false;
                    }
                }
                if (bl) {
                    this.fireInterrupt();
                }
            }
        }
    }

    private void writeSectorByte(int n) {
        if (this.curDisk != null && this.ioBufPos < this.ioBuf.length) {
            this.ioBuf[this.ioBufPos++] = (byte)n;
            if (this.ioBufPos >= this.ioBuf.length) {
                this.statusReg &= 0xFFFFFFF7;
            }
            if (this.ioBufPos == 512) {
                long l = this.calcFilePos();
                if (l >= 0L || this.sectorNum >= 1) {
                    this.startIOTask(this.curDisk.getFile(), l, 512);
                } else {
                    this.errorReg = 4;
                    this.statusReg |= 1;
                }
            }
        }
    }

    protected static class IOTask {
        public Command cmd;
        public File file;
        public long filePos;
        public int byteCnt;

        protected IOTask(Command command, File file, long l, int n) {
            this.cmd = command;
            this.file = file;
            this.filePos = l;
            this.byteCnt = n;
        }
    }

    private static enum Command {
        NONE,
        FORMAT_TRACK,
        IDENTIFY_DISK,
        READ_BUFFER,
        READ_SECTORS,
        WRITE_BUFFER,
        WRITE_SECTORS;

    }
}

