/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.BaseFrm;
import jkcemu.base.DeviceIO;
import jkcemu.base.DirSelectDlg;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.HelpFrm;
import jkcemu.base.NIOFileTimesViewFactory;
import jkcemu.base.OptionDlg;
import jkcemu.base.ScreenFrm;
import jkcemu.disk.AbstractFloppyDisk;
import jkcemu.disk.AnaDisk;
import jkcemu.disk.CPCDisk;
import jkcemu.disk.DirectoryFloppyDisk;
import jkcemu.disk.DiskUnpacker;
import jkcemu.disk.DiskUtil;
import jkcemu.disk.DriveSelectDlg;
import jkcemu.disk.FloppyDiskDrive;
import jkcemu.disk.FloppyDiskFormat;
import jkcemu.disk.FloppyDiskFormatDlg;
import jkcemu.disk.FloppyDiskInfo;
import jkcemu.disk.PlainDisk;
import jkcemu.emusys.A5105;
import jkcemu.emusys.KC85;
import jkcemu.emusys.KCcompact;
import jkcemu.emusys.NANOS;
import jkcemu.emusys.PCM;
import jkcemu.emusys.Z1013;
import jkcemu.emusys.Z9001;
import jkcemu.text.TextUtil;
import jkcemu.tools.fileconverter.FileConvertFrm;

public class FloppyDiskStationFrm
extends BaseFrm
implements ChangeListener,
DropTargetListener {
    private static final String ACTION_CLOSE = "close";
    private static final String ACTION_HELP = "help";
    private static final String ACTION_EXPORT_PREFIX = "disk.export.";
    private static final String ACTION_NEW_ANADISK_FILE = "file.anadsk.new";
    private static final String ACTION_NEW_CPCDISK_FILE = "file.cpcdsk.new";
    private static final String ACTION_NEW_PLAIN_FILE = "file.plain.new";
    private static final String ACTION_OPEN_SUITABLE_PREFIX = "disk.suitable.";
    private static final String ACTION_OPEN_ETC_PREFIX = "disk.etc.";
    private static final String ACTION_OPEN_DIRECTORY = "directory.open";
    private static final String ACTION_OPEN_DRIVE = "drive.open";
    private static final String ACTION_OPEN_FILE = "file.open";
    private static final String ACTION_REFRESH = "refresh";
    private static final String HELP_PAGE = "/help/floppydisk.htm";
    private static final String PROP_PREFIX = "jkcemu.floppydisk.";
    private static final String DRIVE_EMPTY_TEXT = "--- leer ---";
    private static final int MAX_DRIVE_COUNT = 4;
    private static FloppyDiskStationFrm instance = null;
    private ScreenFrm screenFrm;
    private EmuSys emuSys;
    private FloppyDiskInfo[] allDisks;
    private FloppyDiskInfo[] suitableDisks;
    private FloppyDiskInfo[] etcDisks;
    private FloppyDiskDrive[] drives;
    private FloppyDiskFormat lastFmt;
    private File lastDir;
    private volatile boolean diskErrorShown;
    private int[] driveAccessCounters;
    private int driveCnt;
    private boolean lastAutoRefresh;
    private boolean lastForceLowerCase;
    private boolean refreshInfoEnabled;
    private boolean ledState;
    private JComponent ledFld;
    private JTextArea[] textAreas;
    private JTabbedPane tabbedPane;
    private JButton btnOpen;
    private JPopupMenu mnuPopup;
    private JMenuItem mnuPopupRefresh;
    private JMenuItem mnuPopupRemove;

    public static void close() {
        if (instance != null) {
            instance.doClose();
        }
    }

    public static FloppyDiskStationFrm getSharedInstance(ScreenFrm screenFrm) {
        if (instance == null) {
            instance = new FloppyDiskStationFrm(screenFrm);
        }
        return instance;
    }

    public void fireShowDiskError(final AbstractFloppyDisk abstractFloppyDisk, final String string, final Exception exception) {
        if (!this.diskErrorShown) {
            this.diskErrorShown = true;
            final FloppyDiskStationFrm floppyDiskStationFrm = this;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FloppyDiskStationFrm.this.selectDiskTab(abstractFloppyDisk);
                    BaseDlg.showErrorDlg(floppyDiskStationFrm, string, exception);
                }
            });
        }
    }

    public void fireDiskFormatChanged(final AbstractFloppyDisk abstractFloppyDisk) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FloppyDiskStationFrm.this.diskFormatChanged(abstractFloppyDisk);
            }
        });
    }

    public void fireDriveAccess(FloppyDiskDrive floppyDiskDrive) {
        for (int i = 0; i < this.drives.length; ++i) {
            if (this.drives[i] != floppyDiskDrive) continue;
            this.driveAccessCounters[i] = 10;
        }
    }

    public FloppyDiskDrive getDrive(int n) {
        return n >= 0 && n < this.drives.length && n < this.driveCnt ? this.drives[n] : null;
    }

    public void openDisks(Properties properties) {
        for (int i = 0; i < 4; ++i) {
            if (this.openDisk(i, properties)) continue;
            this.removeDisk(i);
        }
    }

    public void setDriveCount(int n) {
        if (n != this.driveCnt) {
            this.driveCnt = n;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FloppyDiskStationFrm.this.rebuildTabbedPane();
                }
            });
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.tabbedPane) {
            this.checkDriveAccessState();
            this.updRefreshBtn();
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Component component;
        DropTargetContext dropTargetContext;
        File file = EmuUtil.fileDrop(this, dropTargetDropEvent);
        if (file != null && (dropTargetContext = dropTargetDropEvent.getDropTargetContext()) != null && (component = dropTargetContext.getComponent()) != null) {
            for (int i = 0; i < this.textAreas.length && i < this.drives.length; ++i) {
                if (component != this.textAreas[i]) continue;
                if (file.isDirectory()) {
                    this.openDirectory(i, file);
                    break;
                }
                if (!this.openFile(i, file, null, true, null, null)) break;
                this.setLastFile(file);
                break;
            }
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public boolean applySettings(Properties properties, boolean bl) {
        EmuSys emuSys = null;
        EmuThread emuThread = this.screenFrm.getEmuThread();
        if (emuThread != null) {
            emuSys = emuThread.getEmuSys();
        }
        boolean bl2 = true;
        boolean bl3 = false;
        Object[] objectArray = null;
        if (emuSys != null) {
            bl3 = emuSys.getDefaultFloppyDiskFormat() != null;
            objectArray = emuSys.getSuitableFloppyDisks();
        }
        if (objectArray != null && this.suitableDisks != null && objectArray.length > 0 && this.suitableDisks.length > 0 && Arrays.equals(objectArray, this.suitableDisks)) {
            bl2 = false;
        }
        this.emuSys = emuSys;
        this.suitableDisks = objectArray;
        if (bl2) {
            this.lastAutoRefresh = false;
            if (bl3) {
                this.lastFmt = null;
            }
            this.allDisks = null;
            this.etcDisks = null;
            try {
                TreeSet<FloppyDiskInfo> treeSet = new TreeSet<FloppyDiskInfo>();
                this.addFloppyDiskInfo(treeSet, A5105.getAvailableFloppyDisks());
                this.addFloppyDiskInfo(treeSet, KC85.getAvailableFloppyDisks());
                this.addFloppyDiskInfo(treeSet, KCcompact.getAvailableFloppyDisks());
                this.addFloppyDiskInfo(treeSet, NANOS.getAvailableFloppyDisks());
                this.addFloppyDiskInfo(treeSet, PCM.getAvailableFloppyDisks());
                this.addFloppyDiskInfo(treeSet, Z1013.getAvailableFloppyDisks());
                this.addFloppyDiskInfo(treeSet, Z9001.getAvailableFloppyDisks());
                int n = treeSet.size();
                if (n > 0) {
                    this.allDisks = treeSet.toArray(new FloppyDiskInfo[n]);
                }
                if (this.suitableDisks != null) {
                    for (int i = 0; i < this.suitableDisks.length; ++i) {
                        treeSet.remove(this.suitableDisks[i]);
                    }
                }
                if ((n = treeSet.size()) > 0) {
                    this.etcDisks = treeSet.toArray(new FloppyDiskInfo[n]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.createPopupMenu();
        }
        return super.applySettings(properties, bl);
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject != null) {
            String string;
            Object object = eventObject.getSource();
            if (object == this.btnOpen) {
                bl = true;
                this.showPopup();
            } else if (object == this.mnuPopupRemove) {
                bl = true;
                this.doDiskRemove();
            }
            if (!bl && eventObject instanceof ActionEvent && (string = ((ActionEvent)eventObject).getActionCommand()) != null) {
                if (string.equals(ACTION_CLOSE)) {
                    bl = true;
                    this.doClose();
                } else if (string.equals(ACTION_HELP)) {
                    bl = true;
                    HelpFrm.open(HELP_PAGE);
                } else if (string.startsWith(ACTION_OPEN_SUITABLE_PREFIX)) {
                    int n = ACTION_OPEN_SUITABLE_PREFIX.length();
                    if (string.length() > n) {
                        this.doDiskOpen(string.substring(n), this.suitableDisks);
                    }
                    bl = true;
                } else if (string.startsWith(ACTION_OPEN_ETC_PREFIX)) {
                    int n = ACTION_OPEN_ETC_PREFIX.length();
                    if (string.length() > n) {
                        this.doDiskOpen(string.substring(n), this.etcDisks);
                    }
                    bl = true;
                } else if (string.startsWith(ACTION_EXPORT_PREFIX)) {
                    int n = ACTION_EXPORT_PREFIX.length();
                    if (string.length() > n) {
                        this.doDiskExport(string.substring(n));
                    }
                    bl = true;
                } else if (string.equals(ACTION_REFRESH)) {
                    bl = true;
                    this.doDiskRefresh();
                } else if (string.equals(ACTION_OPEN_DRIVE)) {
                    bl = true;
                    this.doDriveOpen();
                } else if (string.equals(ACTION_OPEN_DIRECTORY)) {
                    bl = true;
                    this.doDirectoryOpen();
                } else if (string.equals(ACTION_NEW_ANADISK_FILE)) {
                    bl = true;
                    this.doFileAnaDiskNew();
                } else if (string.equals(ACTION_NEW_CPCDISK_FILE)) {
                    bl = true;
                    this.doFileCPCDskNew();
                } else if (string.equals(ACTION_NEW_PLAIN_FILE)) {
                    bl = true;
                    this.doFilePlainNew();
                } else if (string.equals(ACTION_OPEN_FILE)) {
                    bl = true;
                    this.doFileOpen();
                }
            }
        }
        return bl;
    }

    @Override
    public void lookAndFeelChanged() {
        if (this.mnuPopup != null) {
            SwingUtilities.updateComponentTreeUI(this.mnuPopup);
        }
    }

    @Override
    public void putSettingsTo(Properties properties) {
        super.putSettingsTo(properties);
        if (properties != null) {
            try {
                String[] stringArray;
                int n;
                Set<String> set = properties.stringPropertyNames();
                if (set != null && (n = set.size()) > 0 && (stringArray = set.toArray(new String[n])) != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!stringArray[i].startsWith(PROP_PREFIX)) continue;
                        properties.remove(stringArray[i]);
                    }
                }
            }
            catch (ArrayStoreException arrayStoreException) {
                // empty catch block
            }
            for (int i = 0; i < this.drives.length; ++i) {
                this.drives[i].putSettingsTo(properties, this.getFloppyDiskPropPrefix(i));
            }
        }
    }

    private void doDirectoryOpen() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n >= 0 && n < this.drives.length) {
            File file;
            File file2 = this.lastDir;
            AbstractFloppyDisk abstractFloppyDisk = this.drives[n].getDisk();
            if (abstractFloppyDisk != null && abstractFloppyDisk instanceof DirectoryFloppyDisk) {
                file2 = ((DirectoryFloppyDisk)abstractFloppyDisk).getDirFile();
            }
            if ((file = DirSelectDlg.selectDirectory(this, file2)) != null && file.isDirectory()) {
                this.openDirectory(n, file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDiskExport(String string) {
        block17: {
            if (string != null && this.allDisks != null && !string.isEmpty()) {
                try {
                    File file;
                    AbstractFloppyDisk abstractFloppyDisk;
                    int n;
                    File file2;
                    File file3;
                    FloppyDiskInfo floppyDiskInfo;
                    String string2;
                    int n2 = Integer.parseInt(string);
                    if (n2 < 0 || n2 >= this.allDisks.length || (string2 = (floppyDiskInfo = this.allDisks[n2]).getResource()) == null) break block17;
                    String string3 = "";
                    boolean bl = false;
                    int n3 = string2.lastIndexOf(47);
                    if (n3 >= 0) {
                        if (n3 + 1 < string2.length()) {
                            string3 = string2.substring(n3 + 1);
                        }
                    } else {
                        string3 = string2;
                    }
                    if (string3.endsWith(".gz")) {
                        string3 = string3.substring(0, string3.length() - 3);
                        bl = true;
                    }
                    if (string3.isEmpty() || (file3 = EmuUtil.showFileSaveDlg(this, "Diskette exportieren", file2 = (file2 = Main.getLastDirFile("disk")) != null ? new File(file2, string3) : new File(string3), EmuUtil.getAnaDiskFileFilter())) == null) break block17;
                    BufferedOutputStream bufferedOutputStream = null;
                    InputStream inputStream = null;
                    InputStream inputStream2 = null;
                    try {
                        inputStream = this.getClass().getResourceAsStream(string2);
                        if (inputStream != null) {
                            if (bl) {
                                inputStream2 = inputStream;
                                inputStream = new GZIPInputStream(inputStream);
                            }
                            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
                            n = inputStream.read();
                            while (n >= 0) {
                                ((OutputStream)bufferedOutputStream).write(n);
                                n = inputStream.read();
                            }
                            ((OutputStream)bufferedOutputStream).close();
                            bufferedOutputStream = null;
                        }
                    }
                    catch (Throwable throwable) {
                        EmuUtil.closeSilent(bufferedOutputStream);
                        EmuUtil.closeSilent(inputStream);
                        EmuUtil.closeSilent(inputStream2);
                        throw throwable;
                    }
                    EmuUtil.closeSilent(bufferedOutputStream);
                    EmuUtil.closeSilent(inputStream);
                    EmuUtil.closeSilent(inputStream2);
                    this.setLastFile(file3);
                    n = BaseDlg.showOptionDlg(this, "Die Diskettenabbilddatei wurde im AnaDisk-Format exportiert.\nSie k\u00f6nnen nun die Datei in ein anderes Format konvertieren\noder die in dem Diskettenabbild enthaltenen einzelnen Dateien entpacken.", "Export fertig", "Konvertieren", "Entpacken", "Schlie\u00dfen");
                    if (n == 0) {
                        FileConvertFrm.open(file3);
                    } else if (n == 1 && (abstractFloppyDisk = DiskUtil.readNonPlainDiskFile(this, file3, true)) != null && (file = EmuUtil.askForOutputDir(this, file3, "Entpacken nach:", floppyDiskInfo.toString() + " entpacken")) != null) {
                        FloppyDiskFormatDlg floppyDiskFormatDlg = new FloppyDiskFormatDlg((Window)this, null, FloppyDiskFormatDlg.Flag.APPLY_READONLY, FloppyDiskFormatDlg.Flag.FORCE_LOWERCASE);
                        floppyDiskFormatDlg.setTitle("Entpacken");
                        floppyDiskFormatDlg.setVisible(true);
                        if (floppyDiskFormatDlg.wasApproved()) {
                            DiskUnpacker.unpackDisk(this, abstractFloppyDisk, floppyDiskInfo.toString(), file, floppyDiskInfo.getSysTracks(), floppyDiskInfo.getBlockSize(), floppyDiskInfo.getBlockNum16Bit(), floppyDiskFormatDlg.getApplyReadOnly(), floppyDiskFormatDlg.getForceLowerCase());
                        }
                    }
                }
                catch (IOException iOException) {
                    BaseDlg.showErrorDlg((Component)this, iOException);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private void doDiskOpen(String string, FloppyDiskInfo[] floppyDiskInfoArray) {
        int n = this.tabbedPane.getSelectedIndex();
        if (n >= 0 && n < this.drives.length && string != null && floppyDiskInfoArray != null && !string.isEmpty()) {
            try {
                int n2 = Integer.parseInt(string);
                if (n2 >= 0 && n2 < floppyDiskInfoArray.length) {
                    this.openDisk(n, floppyDiskInfoArray[n2], Boolean.FALSE);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void doDriveOpen() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n >= 0 && n < this.drives.length) {
            DriveSelectDlg driveSelectDlg = new DriveSelectDlg((Window)this, true);
            driveSelectDlg.setVisible(true);
            String string = driveSelectDlg.getSelectedDriveFileName();
            if (string != null && this.openDrive(n, string, driveSelectDlg.isReadOnlySelected(), true, null, null)) {
                Main.setLastDriveFileName(string);
            }
        }
    }

    private void doFileOpen() {
        File file;
        int n = this.tabbedPane.getSelectedIndex();
        if (n >= 0 && n < this.drives.length && (file = EmuUtil.showFileOpenDlg(this, "Diskettenabbilddatei \u00f6ffnen", Main.getLastDirFile("disk"), EmuUtil.getPlainDiskFileFilter(), EmuUtil.getAnaDiskFileFilter(), EmuUtil.getCopyQMFileFilter(), EmuUtil.getDskFileFilter(), EmuUtil.getImageDiskFileFilter(), EmuUtil.getTeleDiskFileFilter())) != null && this.openFile(n, file, null, true, null, null)) {
            this.setLastFile(file);
        }
    }

    private void doFileAnaDiskNew() {
        File file;
        int n = this.tabbedPane.getSelectedIndex();
        if (n >= 0 && n < this.drives.length && (file = EmuUtil.showFileSaveDlg(this, "Neue AnaDisk-Datei anlegen", Main.getLastDirFile("disk"), EmuUtil.getAnaDiskFileFilter())) != null && DiskUtil.checkFileExt(this, file, new String[][]{DiskUtil.anaDiskFileExt}) && this.confirmNewFileNotFormatted()) {
            try {
                if (this.setDisk(n, "AnaDisk-Datei: " + file.getPath(), AnaDisk.newFile(this, file), null)) {
                    this.setLastFile(file);
                }
            }
            catch (IOException iOException) {
                this.showError(iOException);
            }
        }
    }

    private void doFileCPCDskNew() {
        File file;
        int n = this.tabbedPane.getSelectedIndex();
        if (n >= 0 && n < this.drives.length && (file = EmuUtil.showFileSaveDlg(this, "Neue CPC-Disk-Datei anlegen", Main.getLastDirFile("disk"), EmuUtil.getDskFileFilter())) != null && DiskUtil.checkFileExt(this, file, new String[][]{DiskUtil.dskFileExt}) && this.confirmNewFileNotFormatted()) {
            try {
                if (this.setDisk(n, "CPC-Disk-Datei: " + file.getPath(), CPCDisk.newFile(this, file), null)) {
                    this.setLastFile(file);
                }
            }
            catch (IOException iOException) {
                this.showError(iOException);
            }
        }
    }

    private void doFilePlainNew() {
        File file;
        int n = this.tabbedPane.getSelectedIndex();
        if (n >= 0 && n < this.drives.length && (file = EmuUtil.showFileSaveDlg(this, "Einfache Abbilddatei anlegen", Main.getLastDirFile("disk"), EmuUtil.getPlainDiskFileFilter())) != null && DiskUtil.checkFileExt(this, file, new String[][]{DiskUtil.plainDiskFileExt}) && this.confirmNewFileNotFormatted()) {
            try {
                if (this.setDisk(n, "Einfache Abbilddatei: " + file.getPath(), PlainDisk.newFile(this, file), null)) {
                    this.setLastFile(file);
                }
            }
            catch (IOException iOException) {
                this.showError(iOException);
            }
        }
    }

    private void doDiskRefresh() {
        AbstractFloppyDisk abstractFloppyDisk;
        int n = this.tabbedPane.getSelectedIndex();
        if (n >= 0 && n < this.drives.length && (abstractFloppyDisk = this.drives[n].getDisk()) != null && abstractFloppyDisk instanceof DirectoryFloppyDisk) {
            ((DirectoryFloppyDisk)abstractFloppyDisk).fireRefresh();
            if (this.refreshInfoEnabled) {
                this.showRefreshInfo();
            }
        }
    }

    private void doDiskRemove() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n >= 0 && n < this.drives.length && this.drives[n].getDisk() != null) {
            this.removeDisk(n);
        }
    }

    private FloppyDiskStationFrm(ScreenFrm screenFrm) {
        JComponent jComponent;
        this.screenFrm = screenFrm;
        this.emuSys = null;
        this.suitableDisks = null;
        this.etcDisks = null;
        this.lastDir = null;
        this.lastFmt = null;
        this.lastAutoRefresh = false;
        this.lastForceLowerCase = false;
        this.ledState = false;
        this.diskErrorShown = false;
        this.refreshInfoEnabled = true;
        this.setTitle("JKCEMU Diskettenstation");
        Main.updIcon(this);
        Font font = new Font("SansSerif", 0, 12);
        this.textAreas = new JTextArea[4];
        this.drives = new FloppyDiskDrive[4];
        for (int i = 0; i < 4; ++i) {
            jComponent = new JTextArea(5, 50);
            jComponent.setBorder(BorderFactory.createLoweredBevelBorder());
            ((JTextArea)jComponent).setFont(font);
            ((JTextComponent)jComponent).setEditable(false);
            ((JTextComponent)jComponent).setText(DRIVE_EMPTY_TEXT);
            new DropTarget(jComponent, this).setActive(true);
            this.textAreas[i] = jComponent;
            this.drives[i] = new FloppyDiskDrive(this);
        }
        this.driveAccessCounters = new int[this.drives.length];
        Arrays.fill(this.driveAccessCounters, 0);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        jComponent = new JMenu("Datei");
        ((AbstractButton)jComponent).setMnemonic(68);
        ((JMenu)jComponent).add(this.createJMenuItem("Schlie\u00dfen", ACTION_CLOSE));
        jMenuBar.add((JMenu)jComponent);
        JMenu jMenu = new JMenu("?");
        jMenu.add(this.createJMenuItem("Hilfe...", ACTION_HELP));
        jMenuBar.add(jMenu);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0);
        this.tabbedPane = new JTabbedPane(1);
        this.add((Component)this.tabbedPane, gridBagConstraints);
        Dimension dimension = new Dimension(30, 15);
        this.ledFld = new JPanel(){

            @Override
            public void paintComponent(Graphics graphics) {
                FloppyDiskStationFrm.this.paintLED(graphics, this.getWidth(), this.getHeight());
            }
        };
        this.ledFld.setBorder(BorderFactory.createLoweredBevelBorder());
        this.ledFld.setOpaque(true);
        this.ledFld.setPreferredSize(dimension);
        this.ledFld.setMinimumSize(dimension);
        this.ledFld.setMaximumSize(dimension);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.left = 50;
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        this.add((Component)this.ledFld, gridBagConstraints);
        this.btnOpen = this.createImageButton("/images/disk/eject.png", "\u00d6ffnen/Laden");
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 50;
        ++gridBagConstraints.gridx;
        this.add((Component)this.btnOpen, gridBagConstraints);
        this.driveCnt = 1;
        this.rebuildTabbedPane();
        this.setLocationByPlatform(true);
        if (!this.applySettings(Main.getProperties(), true)) {
            this.pack();
        }
        this.setResizable(true);
        for (int i = 0; i < this.textAreas.length; ++i) {
            this.textAreas[i].setPreferredSize(new Dimension(1, 1));
        }
        new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FloppyDiskStationFrm.this.checkDriveAccessState();
            }
        }).start();
        this.tabbedPane.addChangeListener(this);
        Runtime.getRuntime().addShutdownHook(new Thread(Main.getThreadGroup(), "JKCEMU disk closer"){

            @Override
            public void run() {
                FloppyDiskStationFrm.this.removeAllDisks();
            }
        });
    }

    private void addFloppyDiskInfo(Collection<FloppyDiskInfo> collection, FloppyDiskInfo[] floppyDiskInfoArray) {
        if (floppyDiskInfoArray != null) {
            for (int i = 0; i < floppyDiskInfoArray.length; ++i) {
                collection.add(floppyDiskInfoArray[i]);
            }
        }
    }

    private Boolean askOpenFileReadOnly() {
        Boolean bl = null;
        String[] stringArray = new String[]{"Nur Lesen", "Lesen & Schreiben", "Abbrechen"};
        switch (BaseDlg.showOptionDlg(this, "Soll die Datei nur zum Lesen oder auch zum\nLesen und Schreiben ge\u00f6ffnet werden?", "Abfrage Schreibschutz", stringArray)) {
            case 0: {
                bl = Boolean.TRUE;
                break;
            }
            case 1: {
                bl = Boolean.FALSE;
            }
        }
        return bl;
    }

    private void checkDriveAccessState() {
        boolean bl = false;
        int n = this.tabbedPane.getSelectedIndex();
        for (int i = 0; i < this.driveAccessCounters.length; ++i) {
            if (this.driveAccessCounters[i] <= 0) continue;
            int n2 = i;
            this.driveAccessCounters[n2] = this.driveAccessCounters[n2] - 1;
            if (i != n) continue;
            bl = true;
        }
        if (bl != this.ledState) {
            this.ledState = bl;
            this.ledFld.repaint();
        }
        if (!this.ledState) {
            this.diskErrorShown = false;
        }
    }

    private boolean confirmNewFileNotFormatted() {
        boolean bl = false;
        Object[] objectArray = new String[]{"Weiter", "Abbrechen"};
        JOptionPane jOptionPane = new JOptionPane("Es wird jetzt eine Datei ohne Inhalt angelegt.\nVergessen Sie bitte nicht, die emulierte Diskette\nvom emulierten System aus zu formatieren,\ndamit die neue Datei einen Inhalt bekommt\nund somit genutzt werden kann.", 1);
        jOptionPane.setOptions(objectArray);
        jOptionPane.setWantsInput(false);
        jOptionPane.createDialog(this, "Hinweis").setVisible(true);
        Object object = jOptionPane.getValue();
        if (object != null && object.equals(objectArray[0])) {
            bl = true;
        }
        return bl;
    }

    private String createDiskInfoText(AbstractFloppyDisk abstractFloppyDisk, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(256);
        String string = abstractFloppyDisk.getMediaText();
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        stringBuilder.append(abstractFloppyDisk.getFormatText());
        String string2 = abstractFloppyDisk.getRemark();
        if (string2 != null && !(string2 = string2.trim()).isEmpty()) {
            stringBuilder.append("\n\n");
            stringBuilder.append(string2);
        }
        if (bl) {
            stringBuilder.append("\n\nEmulation einer SD-Diskette in einem DD-Laufwerk\n(Umrechnung der Spurnummern)");
        }
        return stringBuilder.toString();
    }

    private JButton createOpenButton() {
        return this.createImageButton("/images/disk/eject.png", "\u00d6ffnen/Laden");
    }

    private void createPopupMenu() {
        int n;
        this.mnuPopup = new JPopupMenu();
        this.mnuPopup.add(this.createJMenuItem("Diskette \u00f6ffnen...", ACTION_OPEN_DRIVE));
        this.mnuPopup.add(this.createJMenuItem("Diskettenabbilddatei \u00f6ffnen...", ACTION_OPEN_FILE));
        this.mnuPopup.add(this.createJMenuItem("Verzeichnis \u00f6ffnen...", ACTION_OPEN_DIRECTORY));
        this.mnuPopupRefresh = this.createJMenuItem("Emulierte Diskette aktualisieren", ACTION_REFRESH);
        this.mnuPopup.add(this.mnuPopupRefresh);
        this.mnuPopup.addSeparator();
        this.mnuPopup.add(this.createJMenuItem("Neue einfache Abbilddatei anlegen...", ACTION_NEW_PLAIN_FILE));
        this.mnuPopup.add(this.createJMenuItem("Neue AnaDisk-Datei anlegen...", ACTION_NEW_ANADISK_FILE));
        this.mnuPopup.add(this.createJMenuItem("Neue CPC-Disk-Datei anlegen...", ACTION_NEW_CPCDISK_FILE));
        this.mnuPopup.addSeparator();
        boolean bl = false;
        if (this.suitableDisks != null) {
            for (int i = 0; i < this.suitableDisks.length; ++i) {
                this.mnuPopup.add(this.createJMenuItem(this.suitableDisks[i].toString() + " einlegen", String.format("%s%d", ACTION_OPEN_SUITABLE_PREFIX, i)));
                bl = true;
            }
        }
        if (this.etcDisks != null && this.etcDisks.length > 0) {
            JMenu jMenu = null;
            jMenu = bl ? new JMenu("Andere Diskette einlegen") : new JMenu("Diskette einlegen");
            for (n = 0; n < this.etcDisks.length; ++n) {
                jMenu.add(this.createJMenuItem(this.etcDisks[n].toString(), String.format("%s%d", ACTION_OPEN_ETC_PREFIX, n)));
            }
            this.mnuPopup.add(jMenu);
        }
        if (this.allDisks != null && this.allDisks.length > 0) {
            JMenu jMenu = new JMenu("Diskette exportieren");
            for (n = 0; n < this.allDisks.length; ++n) {
                jMenu.add(this.createJMenuItem(this.allDisks[n].toString(), String.format("%s%d", ACTION_EXPORT_PREFIX, n)));
            }
            this.mnuPopup.add(jMenu);
        }
        this.mnuPopup.addSeparator();
        this.mnuPopupRemove = this.createJMenuItem("Diskette/Abbilddatei schlie\u00dfen");
        this.mnuPopup.add(this.mnuPopupRemove);
        this.updRefreshBtn();
    }

    private void diskFormatChanged(AbstractFloppyDisk abstractFloppyDisk) {
        if (abstractFloppyDisk != null) {
            for (int i = 0; i < this.drives.length; ++i) {
                FloppyDiskDrive floppyDiskDrive = this.drives[i];
                if (abstractFloppyDisk != floppyDiskDrive.getDisk()) continue;
                this.textAreas[i].setText(this.createDiskInfoText(abstractFloppyDisk, floppyDiskDrive.getSkipOddCylinders()));
            }
        }
    }

    private String getFloppyDiskPropPrefix(int n) {
        return String.format("%s%d.", PROP_PREFIX, n);
    }

    private void openDirectory(int n, File file) {
        boolean bl = false;
        FloppyDiskFormat floppyDiskFormat = this.lastFmt;
        if (floppyDiskFormat == null && this.emuSys != null) {
            floppyDiskFormat = this.emuSys.getDefaultFloppyDiskFormat();
        }
        if (floppyDiskFormat == null) {
            floppyDiskFormat = FloppyDiskFormat.FMT_780K;
        }
        FloppyDiskFormatDlg floppyDiskFormatDlg = null;
        if (file.canWrite()) {
            floppyDiskFormatDlg = new FloppyDiskFormatDlg((Window)this, floppyDiskFormat, FloppyDiskFormatDlg.Flag.FULL_FORMAT, FloppyDiskFormatDlg.Flag.READONLY, FloppyDiskFormatDlg.Flag.AUTO_REFRESH, FloppyDiskFormatDlg.Flag.FORCE_LOWERCASE);
        } else {
            floppyDiskFormatDlg = new FloppyDiskFormatDlg((Window)this, floppyDiskFormat, FloppyDiskFormatDlg.Flag.FULL_FORMAT, FloppyDiskFormatDlg.Flag.AUTO_REFRESH, FloppyDiskFormatDlg.Flag.FORCE_LOWERCASE);
            bl = true;
        }
        floppyDiskFormatDlg.setAutoRefresh(this.lastAutoRefresh);
        floppyDiskFormatDlg.setForceLowerCase(this.lastForceLowerCase);
        floppyDiskFormatDlg.setVisible(true);
        FloppyDiskFormat floppyDiskFormat2 = floppyDiskFormatDlg.getFormat();
        if (floppyDiskFormat2 != null) {
            this.lastFmt = floppyDiskFormat2;
            this.lastAutoRefresh = floppyDiskFormatDlg.getAutoRefresh();
            this.lastForceLowerCase = floppyDiskFormatDlg.getForceLowerCase();
            if (!bl) {
                bl = floppyDiskFormatDlg.getReadOnly();
            }
            boolean bl2 = true;
            if (!bl && JOptionPane.showConfirmDialog(this, "Sie \u00f6ffnen das Verzeichnis ohne Schreibschutz.\nSchreibzugriffe auf die emulierte Diskette wirken sich somit direkt auf die Dateien in dem Verzeichnis aus.\n\nWenn die falsche Directory-Gr\u00f6\u00dfe eingestellt ist\noder die emulierte Diskette zu einem ung\u00fcnstigen Zeitpunkt aktualisiert wird\noder nach dem Aktualisieren im Emulator das erneute Einlesen des Directorys nicht veranlasst wird,\nkann es zum ungewollten L\u00f6schen oder \u00dcberschreiben der in dem Verzeichnis liegenden Dateien kommen!\n\nStellen Sie bitte sicher, dass die Dateien in dem Verzeichnis an einer anderen Stelle nochmals gesichert sind\nund lesen Sie in der Hilfe den Abschnitt \u00fcber die Emulation einer Diskette auf Basis eines Verzeichnisses!", "Warnung", 2, 2) != 0) {
                bl2 = false;
            }
            if (bl2) {
                this.setDisk(n, "Verzeichnis: " + file.getPath(), new DirectoryFloppyDisk(this, floppyDiskFormat2.getSides(), floppyDiskFormat2.getCylinders(), floppyDiskFormat2.getSectorsPerCylinder(), floppyDiskFormat2.getSectorSize(), floppyDiskFormat2.getSysTracks(), floppyDiskFormat2.getDirBlocks(), floppyDiskFormat2.getBlockSize(), floppyDiskFormat2.isBlockNum16Bit(), floppyDiskFormat2.isDateStamperEnabled(), new NIOFileTimesViewFactory(), file, this.lastAutoRefresh, bl, this.lastForceLowerCase), null);
                this.lastDir = file;
            }
        }
    }

    private boolean openDisk(int n, FloppyDiskInfo floppyDiskInfo, Boolean bl) {
        boolean bl2 = false;
        if (floppyDiskInfo != null) {
            try {
                AbstractFloppyDisk abstractFloppyDisk = floppyDiskInfo.openDisk(this);
                if (abstractFloppyDisk != null) {
                    bl2 = this.setDisk(n, floppyDiskInfo.toString(), abstractFloppyDisk, bl);
                }
            }
            catch (IOException iOException) {
                BaseDlg.showErrorDlg((Component)(this.isVisible() ? this : this.screenFrm), iOException);
            }
        }
        return bl2;
    }

    private boolean openDisk(int n, Properties properties) {
        boolean bl;
        block6: {
            Boolean bl2;
            String string;
            block9: {
                FloppyDiskFormat floppyDiskFormat;
                boolean bl3;
                String string2;
                block8: {
                    String string3;
                    block7: {
                        bl = false;
                        if (properties == null) break block6;
                        String string4 = this.getFloppyDiskPropPrefix(n);
                        String string5 = EmuUtil.getProperty(properties, string4 + "directory");
                        string3 = EmuUtil.getProperty(properties, string4 + "drive");
                        string2 = EmuUtil.getProperty(properties, string4 + "file");
                        string = EmuUtil.getProperty(properties, string4 + "resource");
                        if (string5.isEmpty() && string3.isEmpty() && string2.isEmpty() && string.isEmpty()) break block6;
                        bl3 = EmuUtil.getBooleanProperty(properties, string4 + "readonly", true);
                        bl2 = null;
                        String string6 = EmuUtil.getProperty(properties, string4 + "skip_odd_cylinders");
                        if (!string6.isEmpty()) {
                            bl2 = Boolean.valueOf(string6);
                        }
                        floppyDiskFormat = new FloppyDiskFormat(EmuUtil.getIntProperty(properties, string4 + "sides", 0), EmuUtil.getIntProperty(properties, string4 + "cylinders", 0), EmuUtil.getIntProperty(properties, string4 + "sectors_per_cylinder", 0), EmuUtil.getIntProperty(properties, string4 + "sectorsize", 0), 1, EmuUtil.getIntProperty(properties, string4 + "system_tracks", 0), EmuUtil.getIntProperty(properties, string4 + "dir_blocks", 2), EmuUtil.getIntProperty(properties, string4 + "block_size", 0), EmuUtil.getIntProperty(properties, string4 + "block_number_size", 16) == 16, EmuUtil.getBooleanProperty(properties, string4 + "datestamper", false), null);
                        if (string5.isEmpty() || floppyDiskFormat == null) break block7;
                        File file = new File(string5);
                        if (!file.isDirectory() || floppyDiskFormat == null) break block6;
                        this.lastAutoRefresh = EmuUtil.getBooleanProperty(properties, string4 + "auto_refresh", false);
                        this.lastForceLowerCase = EmuUtil.getBooleanProperty(properties, string4 + "force_lowercase", true);
                        this.lastFmt = floppyDiskFormat;
                        this.setDisk(n, "Verzeichnis: " + string5, new DirectoryFloppyDisk(this, floppyDiskFormat.getSides(), floppyDiskFormat.getCylinders(), floppyDiskFormat.getSectorsPerCylinder(), floppyDiskFormat.getSectorSize(), floppyDiskFormat.getSysTracks(), floppyDiskFormat.getDirBlocks(), floppyDiskFormat.getBlockSize(), floppyDiskFormat.isBlockNum16Bit(), floppyDiskFormat.isDateStamperEnabled(), new NIOFileTimesViewFactory(), file, this.lastAutoRefresh, bl3, this.lastForceLowerCase), bl2);
                        bl = true;
                        break block6;
                    }
                    if (string3.isEmpty()) break block8;
                    bl = this.openDrive(n, string3, bl3, false, floppyDiskFormat, bl2);
                    break block6;
                }
                if (string2.isEmpty()) break block9;
                File file = new File(string2);
                if (!file.isFile()) break block6;
                bl = this.openFile(n, file, bl3, false, floppyDiskFormat, bl2);
                break block6;
            }
            if (!string.isEmpty()) {
                int n2;
                boolean bl4 = false;
                if (this.suitableDisks != null) {
                    for (n2 = 0; n2 < this.suitableDisks.length; ++n2) {
                        if (!string.equals(this.suitableDisks[n2].getResource())) continue;
                        bl = this.openDisk(n, this.suitableDisks[n2], bl2);
                        bl4 = true;
                        break;
                    }
                }
                if (!bl4 && this.etcDisks != null) {
                    for (n2 = 0; n2 < this.etcDisks.length; ++n2) {
                        if (!string.equals(this.etcDisks[n2].getResource())) continue;
                        bl = this.openDisk(n, this.etcDisks[n2], bl2);
                        break;
                    }
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean openDrive(int n, String string, boolean bl, boolean bl2, FloppyDiskFormat floppyDiskFormat, Boolean bl3) {
        boolean bl4 = true;
        boolean bl5 = true;
        DeviceIO.RandomAccessDevice randomAccessDevice = null;
        String string2 = null;
        String string3 = string;
        if (string.startsWith("\\\\.\\") && string.length() > 4) {
            string3 = string.substring(4);
        }
        try {
            randomAccessDevice = DeviceIO.openDeviceForRandomAccess(string, bl);
            bl4 = true;
            int n2 = DiskUtil.readDiskSize(randomAccessDevice);
            boolean bl6 = false;
            if (floppyDiskFormat == null) {
                if (bl2) {
                    FloppyDiskFormatDlg floppyDiskFormatDlg = new FloppyDiskFormatDlg((Window)this, FloppyDiskFormat.getFormatByDiskSize(n2), FloppyDiskFormatDlg.Flag.PHYS_FORMAT);
                    floppyDiskFormatDlg.setVisible(true);
                    floppyDiskFormat = floppyDiskFormatDlg.getFormat();
                } else {
                    floppyDiskFormat = FloppyDiskFormat.getFormatByDiskSize(n2);
                }
            }
            if (floppyDiskFormat != null) {
                if (n2 > 0) {
                    bl6 = n2 == floppyDiskFormat.getDiskSize();
                } else {
                    int n3 = floppyDiskFormat.getDiskSize();
                    if (n3 != n2) {
                        bl6 = DiskUtil.equalsDiskSize(randomAccessDevice, floppyDiskFormat.getDiskSize());
                    }
                }
                if (!bl6) {
                    if (bl2) {
                        if (!BaseDlg.showYesNoWarningDlg(this, "Das ausgew\u00e4hlte Diskettenformat scheint nicht zu passen.\nM\u00f6chten Sie trotzdem fortsetzen?", "Diskettenformat")) {
                            floppyDiskFormat = null;
                        }
                    } else {
                        floppyDiskFormat = null;
                    }
                }
            }
            if (floppyDiskFormat != null && !bl && !bl6) {
                if (bl2) {
                    BaseDlg.showInfoDlg(this, "Da das ausgew\u00e4hlte Diskettenformat m\u00f6glicherweise falsch ist,\nwird das Laufwerk nur zum Lesen ge\u00f6ffnet.");
                }
                bl = true;
            }
            if (floppyDiskFormat != null && randomAccessDevice != null) {
                bl5 = this.setDisk(n, "Laufwerk: " + string3, PlainDisk.createForDrive(this, string, randomAccessDevice, bl, floppyDiskFormat), bl3);
            }
        }
        catch (IOException iOException) {
            String string4 = iOException.getMessage();
            string2 = string4 != null && string3.equals(string) ? string4 : String.format("Laufwerk %s kann nicht ge\u00f6ffnet werden.", string3);
        }
        finally {
            if (!bl5) {
                EmuUtil.closeSilent(randomAccessDevice);
            }
        }
        if (string2 != null) {
            BaseDlg.showErrorDlg((Component)this, string2);
        }
        return bl4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean openFile(int n, File file, Boolean bl, boolean bl2, FloppyDiskFormat floppyDiskFormat, Boolean bl3) {
        boolean bl4;
        block26: {
            bl4 = false;
            if (bl == null && !bl2 || !file.canWrite()) {
                bl = Boolean.TRUE;
            }
            try {
                long l;
                String string;
                block27: {
                    string = file.getName();
                    l = file.length();
                    if (!file.exists() || string == null || n < 0 || n >= 4) break block26;
                    if (TextUtil.endsWith(string = string.toLowerCase(), DiskUtil.plainDiskFileExt)) {
                        bl4 = this.openPlainDiskFile(n, file, l, bl, bl2, floppyDiskFormat, bl3);
                        break block26;
                    }
                    if (!TextUtil.endsWith(string, DiskUtil.gzPlainDiskFileExt)) break block27;
                    int n2 = 0;
                    byte[] byArray = null;
                    GZIPInputStream gZIPInputStream = null;
                    try {
                        gZIPInputStream = new GZIPInputStream(new FileInputStream(file));
                        byArray = new byte[FloppyDiskFormat.getMaxDiskSize()];
                        n2 = EmuUtil.read(gZIPInputStream, byArray);
                    }
                    catch (Throwable throwable) {
                        EmuUtil.closeSilent(gZIPInputStream);
                        throw throwable;
                    }
                    EmuUtil.closeSilent(gZIPInputStream);
                    if (n2 > 0) {
                        PlainDisk plainDisk;
                        Object object;
                        if (floppyDiskFormat == null) {
                            object = new FloppyDiskFormatDlg((Window)this, FloppyDiskFormat.getFormatByDiskSize(n2), FloppyDiskFormatDlg.Flag.PHYS_FORMAT);
                            ((Dialog)object).setVisible(true);
                            floppyDiskFormat = ((FloppyDiskFormatDlg)object).getFormat();
                        }
                        if (floppyDiskFormat != null && (plainDisk = PlainDisk.createForByteArray(this, (String)(object = file.getPath()), byArray, floppyDiskFormat)) != null) {
                            bl4 = this.setDisk(n, "Einfache Abbilddatei: " + (String)object, plainDisk, bl3);
                        }
                    }
                    break block26;
                }
                if (TextUtil.endsWith(string, DiskUtil.anaDiskFileExt)) {
                    if (bl2 && bl == null) {
                        bl = this.askOpenFileReadOnly();
                    }
                    if (bl != null) {
                        AnaDisk anaDisk = null;
                        anaDisk = bl != false ? AnaDisk.readFile(this, file) : (l > 0L ? AnaDisk.openFile(this, file) : AnaDisk.newFile(this, file));
                        if (anaDisk != null) {
                            bl4 = this.setDisk(n, "AnaDisk-Datei: " + file.getPath(), anaDisk, bl3);
                        }
                    }
                } else if (TextUtil.endsWith(string, DiskUtil.dskFileExt)) {
                    if (bl2 && bl == null) {
                        bl = this.askOpenFileReadOnly();
                    }
                    if (bl != null) {
                        CPCDisk cPCDisk = null;
                        cPCDisk = bl != false ? CPCDisk.readFile(this, file) : (l > 0L ? CPCDisk.openFile(this, file) : CPCDisk.newFile(this, file));
                        if (cPCDisk != null) {
                            bl4 = this.setDisk(n, "CPC-Disk-Datei: " + file.getPath(), cPCDisk, bl3);
                        }
                    }
                } else {
                    AbstractFloppyDisk abstractFloppyDisk = DiskUtil.readNonPlainDiskFile(this, file, true);
                    if (abstractFloppyDisk != null) {
                        String string2 = abstractFloppyDisk.getFileFormatText();
                        if (string2 == null) {
                            string2 = "Diskettenabbilddatei";
                        }
                        bl4 = this.setDisk(n, string2 + ": " + file.getPath(), abstractFloppyDisk, bl3);
                    } else {
                        boolean bl5 = true;
                        if (bl2 && !(bl5 = TextUtil.endsWith(string, DiskUtil.plainDiskFileExt))) {
                            StringBuilder stringBuilder = new StringBuilder(512);
                            int n3 = string.lastIndexOf(46);
                            if (n3 >= 0 && n3 < string.length() - 1) {
                                stringBuilder.append("Dateiendung '");
                                stringBuilder.append(string.substring(n3));
                                stringBuilder.append("': Unbekannter Dateityp\n\n");
                            }
                            stringBuilder.append("JKCEMU kann den Dateityp nicht erkennen,\nda die Dateiendung keiner der bei Diskettenabbilddateien\n\u00fcblicherweise verwendeten entspricht.\nDie Datei wird deshalb als einfache Abbilddatei ge\u00f6ffnet.");
                            if (JOptionPane.showConfirmDialog(this, stringBuilder.toString(), "Dateiformat", 2, 2) == 0) {
                                bl5 = true;
                            }
                        }
                        if (bl5) {
                            bl4 = this.openPlainDiskFile(n, file, l, bl, bl2, floppyDiskFormat, bl3);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                this.showError(iOException);
            }
        }
        return bl4;
    }

    private boolean openPlainDiskFile(int n, File file, long l, Boolean bl, boolean bl2, FloppyDiskFormat floppyDiskFormat, Boolean bl3) throws IOException {
        Object object;
        boolean bl4 = false;
        if (bl2 && floppyDiskFormat == null) {
            object = null;
            if (bl == null) {
                object = new FloppyDiskFormatDlg((Window)this, FloppyDiskFormat.getFormatByDiskSize(l), FloppyDiskFormatDlg.Flag.PHYS_FORMAT, FloppyDiskFormatDlg.Flag.READONLY);
                ((Dialog)object).setVisible(true);
                floppyDiskFormat = ((FloppyDiskFormatDlg)object).getFormat();
                bl = ((FloppyDiskFormatDlg)object).getReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            } else {
                object = new FloppyDiskFormatDlg((Window)this, FloppyDiskFormat.getFormatByDiskSize(l), FloppyDiskFormatDlg.Flag.PHYS_FORMAT);
                ((Dialog)object).setVisible(true);
                floppyDiskFormat = ((FloppyDiskFormatDlg)object).getFormat();
            }
        }
        if (floppyDiskFormat != null && bl != null && l >= 0L && l != (long)floppyDiskFormat.getDiskSize()) {
            object = new StringBuilder(512);
            ((StringBuilder)object).append("Das von Ihnen ausgew\u00e4hlte Diskettenformat scheint nicht zu passen.\n");
            if (!bl.booleanValue()) {
                ((StringBuilder)object).append("Sie k\u00f6nnen trotzdem fortsetzen,allerdings wird dann\ndie Datei nur mit Schreibschutz ge\u00f6ffnet.\n\nM\u00f6chten Sie fortsetzen?");
            } else {
                ((StringBuilder)object).append("M\u00f6chten Sie trotzdem fortsetzen?");
            }
            if (!BaseDlg.showYesNoWarningDlg(this, ((StringBuilder)object).toString(), "Diskettenformat")) {
                floppyDiskFormat = null;
            }
            bl = Boolean.TRUE;
        }
        if (bl != null) {
            object = null;
            if (!bl.booleanValue() && file.length() == 0L) {
                object = PlainDisk.newFile(this, file);
            } else if (floppyDiskFormat != null) {
                object = PlainDisk.openFile(this, file, bl, floppyDiskFormat);
            }
            if (object != null) {
                bl4 = this.setDisk(n, "Einfache Diskettenabbilddatei: " + file.getPath(), (AbstractFloppyDisk)object, bl3);
            }
        }
        return bl4;
    }

    private void paintLED(Graphics graphics, int n, int n2) {
        if (n > 0 && n2 > 0) {
            graphics.setColor(this.ledState ? Color.red : Color.gray);
            graphics.fillRect(0, 0, n, n2);
        }
    }

    private void rebuildTabbedPane() {
        this.tabbedPane.removeAll();
        int n = Math.min(this.textAreas.length, this.driveCnt);
        for (int i = 0; i < n; ++i) {
            this.tabbedPane.addTab(String.format("Laufwerk %d", i + 1), this.textAreas[i]);
        }
    }

    private void removeAllDisks() {
        for (int i = 0; i < this.drives.length; ++i) {
            this.removeDisk(i);
        }
    }

    private void removeDisk(int n) {
        AbstractFloppyDisk abstractFloppyDisk = this.drives[n].getDisk();
        if (abstractFloppyDisk != null) {
            abstractFloppyDisk.setOwner(null);
            this.drives[n].removeDisk();
        }
        this.textAreas[n].setText(DRIVE_EMPTY_TEXT);
        this.updRefreshBtn();
    }

    private void selectDiskTab(AbstractFloppyDisk abstractFloppyDisk) {
        if (abstractFloppyDisk != null) {
            int n = Math.min(this.drives.length, this.driveCnt);
            for (int i = 0; i < n; ++i) {
                if (this.drives[i] == null || this.drives[i].getDisk() != abstractFloppyDisk) continue;
                try {
                    this.tabbedPane.setSelectedIndex(i);
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean setDisk(int n, String string, AbstractFloppyDisk abstractFloppyDisk, Boolean bl) {
        boolean bl2 = false;
        if (abstractFloppyDisk != null) {
            if (DiskUtil.checkAndConfirmWarning(this, abstractFloppyDisk)) {
                if (bl == null) {
                    int n2 = abstractFloppyDisk.getCylinders();
                    if (n2 > 0 && n2 < 50) {
                        switch (OptionDlg.showOptionDlg(this, "Soll ein 40- oder 80-Spuren-Laufwerk emuliert werden?\n\nWenn die im Emulator laufende Software von einem 80-Spuren-Laufwerk ausgeht,\nwird sie bei einer Diskette mit einfacher Dichte pro Spurwechsel zwei Schrittimpulse senden.\nJKCEMU muss das wissen, um auf die richtige Spur schlie\u00dfen zu k\u00f6nnen.", "Laufwerkstyp", -1, "40-Spuren-Laufwerk (z.B. K5600.10 / MFS 1.2)", "80-Spuren-Laufwerk (z.B. K5600.20 / MFS 1.4, K5601 / MFS 1.6)")) {
                            case 0: {
                                bl = Boolean.FALSE;
                                break;
                            }
                            case 1: {
                                bl = Boolean.TRUE;
                            }
                        }
                    } else {
                        bl = Boolean.FALSE;
                    }
                }
            } else {
                bl = null;
            }
            if (bl != null) {
                this.removeDisk(n);
                abstractFloppyDisk.setMediaText(string);
                this.drives[n].setDisk(abstractFloppyDisk, bl);
                this.textAreas[n].setText(this.createDiskInfoText(abstractFloppyDisk, bl));
                bl2 = true;
            } else {
                abstractFloppyDisk.closeSilent();
            }
        } else {
            this.removeDisk(n);
            bl2 = true;
        }
        this.updRefreshBtn();
        return bl2;
    }

    private void setLastFile(File file) {
        Main.setLastFile(file, "disk");
    }

    private void showError(Exception exception) {
        BaseDlg.showErrorDlg((Component)(this.isVisible() ? this : this.screenFrm), exception);
    }

    private void showPopup() {
        if (this.mnuPopup != null) {
            if (this.mnuPopupRemove != null) {
                boolean bl = false;
                int n = this.tabbedPane.getSelectedIndex();
                if (n >= 0 && n < this.drives.length) {
                    bl = this.drives[n].getDisk() != null;
                }
                this.mnuPopupRemove.setEnabled(bl);
            }
            this.mnuPopup.show(this.btnOpen, 0, this.btnOpen.getHeight());
        }
    }

    private void showRefreshInfo() {
        String string = "Vergessen Sie bitte nicht, umgehend auch in dem im Emulator laufenden Programm bzw. Betriebssystem\ndie Diskette zu aktualisieren bzw. das erneute Einlesen des Directorys zu veranlassen!\n(bei CP/M-kompatiblen Betriebssystemen meistens mit CTRL-C bzw. Strg-C)\n\n";
        JCheckBox jCheckBox = new JCheckBox("Diese Meldung zuk\u00fcnftig nicht mehr anzeigen", false);
        JOptionPane.showMessageDialog(this, new Object[]{string, jCheckBox}, "Wichtiger Hinweis", 2);
        if (jCheckBox.isSelected()) {
            this.refreshInfoEnabled = false;
        }
    }

    private void updRefreshBtn() {
        AbstractFloppyDisk abstractFloppyDisk;
        boolean bl = false;
        int n = this.tabbedPane.getSelectedIndex();
        if (n >= 0 && n < this.drives.length && this.drives[n] != null && (abstractFloppyDisk = this.drives[n].getDisk()) != null && abstractFloppyDisk instanceof DirectoryFloppyDisk) {
            bl = true;
        }
        this.mnuPopupRefresh.setEnabled(bl);
    }
}

