/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.EventObject;
import java.util.zip.GZIPInputStream;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.DeviceIO;
import jkcemu.base.EmuUtil;
import jkcemu.disk.DiskUtil;
import jkcemu.disk.DriveSelectDlg;
import jkcemu.text.TextUtil;

public class DiskImgProcessDlg
extends BaseDlg
implements Runnable {
    private Direction direction;
    private String drvFileName;
    private File imgFile;
    private StringBuilder statusBuf;
    private char[] runningBuf;
    private int runningIdx;
    private JLabel labelMsg;
    private JLabel labelStatus;
    private JLabel labelRunning;
    private JButton btnCancel;
    private Timer timer;
    private volatile Thread thread;
    private volatile long nBytesProcessed;
    private long lastBytesProcessed;

    public static void createDiskImageFromDrive(Frame frame) {
        File file;
        String string = DriveSelectDlg.selectDriveFileName(frame);
        if (string != null && (file = EmuUtil.showFileSaveDlg(frame, "Einfache Abbilddatei speichern", Main.getLastDirFile("disk"), EmuUtil.getPlainDiskFileFilter(), EmuUtil.getISOFileFilter())) != null && DiskUtil.checkFileExt(frame, file, DiskUtil.plainDiskFileExt, DiskUtil.gzPlainDiskFileExt, DiskUtil.isoFileExt, DiskUtil.gzISOFileExt)) {
            new DiskImgProcessDlg(frame, String.format("Erzeuge Abbilddatei von %s...", DiskImgProcessDlg.getDriveName(string)), Direction.DISK_TO_FILE, string, file).setVisible(true);
        }
    }

    public static void writeDiskImageToDrive(Frame frame) {
        File file = EmuUtil.showFileOpenDlg(frame, "Einfache Abbilddatei \u00f6ffnen", Main.getLastDirFile("disk"), EmuUtil.getPlainDiskFileFilter());
        if (file != null) {
            if (file.exists() && file.length() == 0L) {
                DiskImgProcessDlg.showErrorDlg((Component)frame, "Die Datei ist leer.");
            } else {
                String string;
                String string2;
                boolean bl = false;
                String string3 = file.getName();
                if (string3 != null) {
                    string2 = string3.toLowerCase();
                    boolean bl2 = bl = TextUtil.endsWith(string2, DiskUtil.plainDiskFileExt) || TextUtil.endsWith(string2, DiskUtil.gzPlainDiskFileExt);
                }
                if (!bl) {
                    bl = DiskImgProcessDlg.showYesNoWarningDlg(frame, "JKCEMU kann nur einfache Abbilddateien auf einen Datentr\u00e4ger schreiben.\nLaut Dateiendung scheint die Datei jedoch keine einfache Abbilddatei zu sein.\nM\u00f6chten Sie trotzdem fortsetzen?", "Dateityp");
                }
                if (bl && (string2 = DriveSelectDlg.selectDriveFileName(frame)) != null && JOptionPane.showConfirmDialog(frame, String.format("Die Abbilddatei wird nun auf den Datentr\u00e4ger im Laufwerk %s geschrieben.\nDabei werden alle bisherigen Daten auf dem Datentr\u00e4ger gel\u00f6scht!", string = DiskImgProcessDlg.getDriveName(string2)), "Achtung", 2, 2) == 0) {
                    new DiskImgProcessDlg(frame, String.format("Schreibe Abbilddatei auf %s...", string), Direction.FILE_TO_DISK, string2, file).setVisible(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        var1_1 = null;
        switch (3.$SwitchMap$jkcemu$disk$DiskImgProcessDlg$Direction[this.direction.ordinal()]) {
            case 1: {
                try {
                    var2_2 = null;
                    var3_7 = null;
                    try {
                        var2_2 = DeviceIO.openDeviceForSequentialRead(this.drvFileName);
                        var3_7 = EmuUtil.createOptionalGZipOutputStream(this.imgFile);
                        Main.setLastDriveFileName(this.drvFileName);
                        Main.setLastFile(this.imgFile, "disk");
                        var4_9 = new byte[2048];
                        var5_11 = var2_2.read(var4_9);
                        while (var5_11 > 0) {
                            var3_7.write(var4_9, 0, var5_11);
                            this.nBytesProcessed += (long)var5_11;
                            if (this.thread == null) break;
                            var5_11 = var2_2.read(var4_9);
                        }
                        var3_7.close();
                        var3_7 = null;
                    }
                    catch (Throwable var6_12) {
                        EmuUtil.closeSilent(var3_7);
                        EmuUtil.closeSilent(var2_2);
                        throw var6_12;
                    }
                    EmuUtil.closeSilent(var3_7);
                    EmuUtil.closeSilent(var2_2);
                    if (this.thread != null) break;
                    this.imgFile.delete();
                }
                catch (EOFException var2_3) {
                }
                catch (Exception var2_4) {
                    var1_1 = var2_4;
                }
                break;
            }
            case 2: {
                try {
                    var2_5 = null;
                    var3_8 = null;
                    try {
                        var4_10 = this.imgFile.length();
                        var2_5 = new FileInputStream(this.imgFile);
                        if (EmuUtil.isGZipFile(this.imgFile)) {
                            var2_5 = new GZIPInputStream(var2_5);
                        }
                        if (var4_10 > 0x2D0000L && var4_10 % 512L >= 256L) {
                            for (var6_13 = 0; var6_13 < 256 && var2_5.read() >= 0; ++var6_13) {
                            }
                        }
                        var3_8 = DeviceIO.openDeviceForSequentialWrite(this.drvFileName);
                        Main.setLastDriveFileName(this.drvFileName);
                        Main.setLastFile(this.imgFile, "disk");
                        var6_14 = new byte[2048];
                        var7_15 = var2_5.read(var6_14);
                        while (var7_15 > 0) {
                            var3_8.write(var6_14, 0, var7_15);
                            this.nBytesProcessed += (long)var7_15;
                            if (this.thread == null) break;
                            var7_15 = var2_5.read(var6_14);
                        }
                        var3_8.close();
                        var3_8 = null;
                    }
                    catch (Throwable var8_16) {
                        EmuUtil.closeSilent(var3_8);
                        EmuUtil.closeSilent(var2_5);
                        throw var8_16;
lbl70:
                        // 1 sources

                        break;
                    }
                    EmuUtil.closeSilent(var3_8);
                    EmuUtil.closeSilent(var2_5);
                    ** break;
                }
                catch (Exception var2_6) {
                    var1_1 = var2_6;
                }
            }
        }
        this.fireThreadFinished(var1_1);
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        Object object;
        boolean bl = false;
        if (eventObject != null && (object = eventObject.getSource()) == this.btnCancel) {
            this.doCancel();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        boolean bl = false;
        if (this.thread != null && DiskImgProcessDlg.showYesNoDlg(this, "M\u00f6chten Sie den Vorgang abbrechen?")) {
            this.doCancel();
        }
        if (this.thread == null) {
            bl = super.doClose();
        }
        if (bl) {
            this.timer.stop();
        }
        return bl;
    }

    private DiskImgProcessDlg(Window window, String string, Direction direction, String string2, File file) {
        super(window, "Abbilddatei");
        this.direction = direction;
        this.drvFileName = string2;
        this.imgFile = file;
        this.statusBuf = new StringBuilder(80);
        this.runningBuf = new char[10];
        this.runningIdx = 0;
        this.nBytesProcessed = 0L;
        this.lastBytesProcessed = -1L;
        Arrays.fill(this.runningBuf, '*');
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.labelMsg = new JLabel(string);
        this.add((Component)this.labelMsg, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Bitte warten!"), gridBagConstraints);
        this.labelStatus = new JLabel();
        gridBagConstraints.insets.top = 10;
        ++gridBagConstraints.gridy;
        this.add((Component)this.labelStatus, gridBagConstraints);
        this.labelRunning = new JLabel();
        this.labelRunning.setFont(new Font("Monospaced", 1, 12));
        ++gridBagConstraints.gridy;
        this.add((Component)this.labelRunning, gridBagConstraints);
        this.btnCancel = new JButton("Abbrechen");
        this.btnCancel.addActionListener(this);
        this.btnCancel.addKeyListener(this);
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnCancel, gridBagConstraints);
        this.updStatusText();
        this.pack();
        this.setParentCentered();
        this.timer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiskImgProcessDlg.this.updStatusText();
            }
        });
        this.timer.start();
        this.thread = new Thread(Main.getThreadGroup(), this, direction == Direction.FILE_TO_DISK ? "JKCEMU disk image writer" : "JKCEMU disk image reader");
        this.thread.start();
    }

    private void doCancel() {
        this.thread = null;
        this.labelMsg.setText("Vorgang wird abgebrochen...");
        this.btnCancel.setEnabled(false);
    }

    private static String getDriveName(String string) {
        return string.startsWith("\\\\.\\") && string.length() > 4 ? string.substring(4) : string;
    }

    private void fireThreadFinished(final Exception exception) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DiskImgProcessDlg.this.threadFinished(exception);
            }
        });
    }

    private void threadFinished(Exception exception) {
        if (exception != null) {
            DiskImgProcessDlg.showErrorDlg((Component)this, exception);
        } else if (this.thread != null) {
            String string = "Fertig!";
            if (this.direction == Direction.DISK_TO_FILE && this.imgFile != null && this.imgFile.exists()) {
                string = "Die Abbilddatei wurde erfolgreich erzeugt:\n" + this.imgFile.getPath();
            }
            DiskImgProcessDlg.showInfoDlg(this, string);
        }
        this.thread = null;
        this.doClose();
    }

    private void updStatusText() {
        long l = this.nBytesProcessed;
        if (this.lastBytesProcessed < 0L || l != this.lastBytesProcessed) {
            this.statusBuf.setLength(0);
            EmuUtil.appendSizeText(this.statusBuf, l, true, false);
            switch (this.direction) {
                case DISK_TO_FILE: {
                    this.statusBuf.append(" gelesen");
                    break;
                }
                case FILE_TO_DISK: {
                    this.statusBuf.append(" geschrieben");
                }
            }
            this.labelStatus.setText(this.statusBuf.toString());
            this.lastBytesProcessed = l;
            if (this.runningBuf[this.runningIdx] == '*') {
                this.runningBuf[this.runningIdx] = 32;
                if (this.runningIdx == this.runningBuf.length - 1) {
                    this.runningIdx = 0;
                    this.runningBuf[this.runningIdx] = 42;
                }
            } else {
                this.runningBuf[this.runningIdx] = 42;
            }
            ++this.runningIdx;
            if (this.runningIdx >= this.runningBuf.length) {
                this.runningIdx = 0;
            }
            this.labelRunning.setText(new String(this.runningBuf));
        }
    }

    private static enum Direction {
        FILE_TO_DISK,
        DISK_TO_FILE;

    }
}

